/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.workflow.PackageManager;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowException;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.namespace.QName;

public class WorkflowBuilder {
    private final WorkflowService workflowService;
    private final PackageManager packageMgr;
    private final WorkflowDefinition definition;
    private final Map<QName, Serializable> params = new HashMap<QName, Serializable>();
    private NodeRef packageNode = null;

    public WorkflowBuilder(WorkflowDefinition definition, WorkflowService workflowService, NodeService nodeService, BehaviourFilter behaviourFilter) {
        this.workflowService = workflowService;
        this.packageMgr = new PackageManager(workflowService, nodeService, behaviourFilter, null);
        this.definition = definition;
    }

    public void addParameter(QName name, Serializable value) {
        this.params.put(name, value);
    }

    public void addAssociationParameter(QName name, List<NodeRef> values) {
        if (values instanceof Serializable) {
            this.params.put(name, (Serializable)((Object)values));
        }
    }

    public void setPackageNode(NodeRef packageNode) {
        this.packageNode = packageNode;
    }

    public void addPackageItems(List<NodeRef> items) {
        this.packageMgr.addItems(items);
    }

    public WorkflowInstance build() {
        NodeRef packageRef = this.packageMgr.create(this.packageNode);
        this.params.put(WorkflowModel.ASSOC_PACKAGE, (Serializable)packageRef);
        WorkflowPath path = this.workflowService.startWorkflow(this.definition.getId(), this.params);
        if (path.isActive()) {
            this.signalStartTask(path);
        }
        return path.getInstance();
    }

    private void signalStartTask(WorkflowPath path) {
        List<WorkflowTask> tasks = this.workflowService.getTasksForWorkflowPath(path.getId());
        if (tasks.size() != 1) {
            throw new WorkflowException("Start task not found! Expected 1 task but found: " + tasks.size());
        }
        WorkflowTask startTask = tasks.get(0);
        this.workflowService.endTask(startTask.getId(), null);
    }
}

