/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.heartbeat;

import com.sun.management.OperatingSystemMXBean;
import com.sun.management.UnixOperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.alfresco.heartbeat.SystemUsageDataCollector;
import org.alfresco.heartbeat.datasender.HBData;
import org.alfresco.heartbeat.jobs.HeartBeatJobScheduler;
import org.alfresco.repo.descriptor.DescriptorDAO;
import org.alfresco.service.cmr.repository.HBDataCollectorService;
import org.alfresco.service.descriptor.Descriptor;
import org.apache.commons.dbcp2.BasicDataSource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class SystemUsageDataCollectorTest {
    private SystemUsageDataCollector usageSystemCollector;
    private HBDataCollectorService mockCollectorService;
    private DescriptorDAO mockDescriptorDAO;
    private List<HBData> collectedData;
    private HeartBeatJobScheduler mockScheduler;
    private BasicDataSource mockDataSource;

    @Before
    public void setUp() {
        this.mockDescriptorDAO = (DescriptorDAO)Mockito.mock(DescriptorDAO.class);
        this.mockCollectorService = (HBDataCollectorService)Mockito.mock(HBDataCollectorService.class);
        this.mockScheduler = (HeartBeatJobScheduler)Mockito.mock(HeartBeatJobScheduler.class);
        this.mockDataSource = (BasicDataSource)Mockito.mock(BasicDataSource.class);
        Descriptor mockDescriptor = (Descriptor)Mockito.mock(Descriptor.class);
        Mockito.when((Object)mockDescriptor.getId()).thenReturn((Object)"mock_id");
        Mockito.when((Object)this.mockDescriptorDAO.getDescriptor()).thenReturn((Object)mockDescriptor);
        this.usageSystemCollector = new SystemUsageDataCollector("acs.repository.usage.system", "1.0", "0 0 0 ? * *", this.mockScheduler);
        this.usageSystemCollector.setHbDataCollectorService(this.mockCollectorService);
        this.usageSystemCollector.setDataSource((DataSource)this.mockDataSource);
        this.usageSystemCollector.setCurrentRepoDescriptorDAO(this.mockDescriptorDAO);
        this.collectedData = this.usageSystemCollector.collectData();
    }

    @Test
    public void testHBDataFields() {
        for (HBData data : this.collectedData) {
            Assert.assertNotNull((Object)data.getCollectorId());
            Assert.assertNotNull((Object)data.getCollectorVersion());
            Assert.assertNotNull((Object)data.getSchemaVersion());
            Assert.assertNotNull((Object)data.getSystemId());
            Assert.assertNotNull((Object)data.getTimestamp());
        }
    }

    @Test
    public void testSystemUsageDataIsCollected() {
        HBData systemUsage = this.grabDataByCollectorId(this.usageSystemCollector.getCollectorId());
        Assert.assertNotNull((String)"Repository usage data missing.", (Object)systemUsage);
        Map data = systemUsage.getData();
        Assert.assertTrue((boolean)data.containsKey("cpu"));
        Map cpu = (Map)data.get("cpu");
        Assert.assertTrue((boolean)cpu.containsKey("availableProcessors"));
        OperatingSystemMXBean osMBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
        if (osMBean != null) {
            if (osMBean instanceof UnixOperatingSystemMXBean) {
                Assert.assertTrue((boolean)data.containsKey("openFileDescriptorCount"));
            }
            Assert.assertTrue((boolean)cpu.containsKey("percentageProcessLoad"));
            Assert.assertTrue((boolean)cpu.containsKey("percentageSystemLoad"));
            Assert.assertTrue((boolean)cpu.containsKey("systemLoadAverage"));
        }
        Assert.assertTrue((boolean)data.containsKey("db"));
        Map db = (Map)data.get("db");
        Assert.assertTrue((boolean)db.containsKey("idleConnections"));
        Assert.assertTrue((boolean)db.containsKey("activeConnections"));
        Assert.assertTrue((boolean)data.containsKey("mem"));
        Map mem = (Map)data.get("mem");
        Assert.assertTrue((boolean)mem.containsKey("free"));
        Assert.assertTrue((boolean)mem.containsKey("total"));
        Assert.assertTrue((boolean)mem.containsKey("max"));
    }

    private HBData grabDataByCollectorId(String collectorId) {
        for (HBData d : this.collectedData) {
            if (d.getCollectorId() == null || !d.getCollectorId().equals(collectorId)) continue;
            return d;
        }
        return null;
    }
}

