/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.access;

import java.util.Properties;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.action.access.ActionAccessException;
import org.alfresco.repo.action.access.ActionAccessRestriction;
import org.alfresco.repo.action.access.ActionAccessRestrictionAbstractBase;
import org.alfresco.service.cmr.action.Action;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.lang.NonNull;

public class ActionAccessRestrictionAbstractBaseTest {
    private static final String GLOBAL_PROPERTIES_ACTION_EXPOSE_PREFIX = "org.alfresco.repo.action";
    private static final String GLOBAL_PROPERTIES_ACTION_EXPOSE_SUFFIX = ".exposed";
    private static final String CONTROLLED_CONTEXT = "v1";
    private static final String NONCONTROLLED_CONTEXT = "random321";
    private static final String MAIL_ACTION = "mail";
    private ActionAccessRestrictionAbstractBase accessRestriction;
    private Properties globalProperties;

    @Before
    public void setup() {
        this.globalProperties = new Properties();
        this.accessRestriction = new ActionAccessRestrictionAbstractBase(){

            protected void innerVerifyAccessRestriction(Action action) {
                throw new ActionAccessException("Executing verification");
            }
        };
        this.accessRestriction.setConfigProperties(this.globalProperties);
    }

    @Test
    public void skipVerificationForNullContext() {
        Action action = this.getActionWithContext(MAIL_ACTION, null);
        this.accessRestriction.verifyAccessRestriction(action);
    }

    @Test
    public void skipVerificationForNonControlledContext() {
        Action action = this.getActionWithContext(MAIL_ACTION, NONCONTROLLED_CONTEXT);
        this.accessRestriction.verifyAccessRestriction(action);
    }

    @Test
    public void callVerificationForControlledContext() {
        Action action = this.getActionWithContext(MAIL_ACTION, CONTROLLED_CONTEXT);
        Assert.assertThrows(ActionAccessException.class, () -> this.accessRestriction.verifyAccessRestriction(action));
    }

    @Test
    public void skipVerificationForExposedActionConfig() {
        this.setGlobalPropertiesActionExposed(MAIL_ACTION, null, true);
        Action action = this.getActionWithContext(MAIL_ACTION, CONTROLLED_CONTEXT);
        this.accessRestriction.verifyAccessRestriction(action);
    }

    @Test
    public void skipVerificationForExposedActionContextConfig() {
        this.setGlobalPropertiesActionExposed(MAIL_ACTION, CONTROLLED_CONTEXT, true);
        Action action = this.getActionWithContext(MAIL_ACTION, CONTROLLED_CONTEXT);
        this.accessRestriction.verifyAccessRestriction(action);
    }

    @Test
    public void callVerificationForNonExposedActionConfig() {
        this.setGlobalPropertiesActionExposed(MAIL_ACTION, null, false);
        Action action = this.getActionWithContext(MAIL_ACTION, CONTROLLED_CONTEXT);
        Assert.assertThrows(ActionAccessException.class, () -> this.accessRestriction.verifyAccessRestriction(action));
    }

    @Test
    public void callVerificationForNonExposedActionContextConfig() {
        this.setGlobalPropertiesActionExposed(MAIL_ACTION, CONTROLLED_CONTEXT, false);
        Action action = this.getActionWithContext(MAIL_ACTION, CONTROLLED_CONTEXT);
        Assert.assertThrows(ActionAccessException.class, () -> this.accessRestriction.verifyAccessRestriction(action));
    }

    private Action getActionWithContext(String actionName, String context) {
        ActionImpl action = new ActionImpl(null, "12345", actionName);
        ActionAccessRestriction.setActionContext((Action)action, (String)context);
        return action;
    }

    private void setGlobalPropertiesActionExposed(@NonNull String action, String context, boolean isExposed) {
        StringBuilder property = new StringBuilder(GLOBAL_PROPERTIES_ACTION_EXPOSE_PREFIX);
        property.append("." + action);
        if (context != null) {
            property.append("." + context);
        }
        property.append(GLOBAL_PROPERTIES_ACTION_EXPOSE_SUFFIX);
        this.globalProperties.setProperty(property.toString(), Boolean.toString(isExposed));
    }
}

