/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.caching.test;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.alfresco.repo.content.AbstractContentReader;
import org.alfresco.repo.content.AbstractContentStore;
import org.alfresco.repo.content.AbstractContentWriter;
import org.alfresco.repo.content.filestore.FileContentStore;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;

class SlowContentStore
extends AbstractContentStore {
    private ConcurrentMap<String, AtomicLong> urlHits = new ConcurrentHashMap<String, AtomicLong>();
    private int pauseMillis = 50;

    SlowContentStore() {
    }

    public boolean isWriteSupported() {
        return true;
    }

    public ContentReader getReader(String contentUrl) {
        return new SlowReader(contentUrl);
    }

    protected ContentWriter getWriterInternal(ContentReader existingContentReader, String newContentUrl) {
        if (newContentUrl == null) {
            newContentUrl = FileContentStore.createNewFileStoreUrl() + ".slow";
        }
        return new SlowWriter((String)newContentUrl, existingContentReader);
    }

    public boolean exists(String contentUrl) {
        return false;
    }

    public ConcurrentMap<String, AtomicLong> getUrlHits() {
        return this.urlHits;
    }

    public void setPauseMillis(int pauseMillis) {
        this.pauseMillis = pauseMillis;
    }

    private class SlowReader
    extends AbstractContentReader {
        protected SlowReader(String contentUrl) {
            super(contentUrl);
        }

        public boolean exists() {
            return true;
        }

        public long getLastModified() {
            return 0L;
        }

        public long getSize() {
            return 20L;
        }

        protected ContentReader createReader() throws ContentIOException {
            return new SlowReader(this.getContentUrl());
        }

        protected ReadableByteChannel getDirectReadableChannel() throws ContentIOException {
            return new ReadableByteChannel(){
                private final byte[] content = "This is the content for my slow ReadableByteChannel".getBytes();
                private int index = 0;
                private boolean closed = false;
                private boolean readCounted = false;

                private synchronized void registerReadAttempt() {
                    if (!this.readCounted) {
                        String url = SlowReader.this.getContentUrl();
                        ((SlowReader)SlowReader.this).SlowContentStore.this.urlHits.putIfAbsent(url, new AtomicLong(0L));
                        ((AtomicLong)((SlowReader)SlowReader.this).SlowContentStore.this.urlHits.get(url)).incrementAndGet();
                        this.readCounted = true;
                    }
                }

                @Override
                public boolean isOpen() {
                    return !this.closed;
                }

                @Override
                public void close() throws IOException {
                    this.closed = true;
                }

                @Override
                public int read(ByteBuffer dst) throws IOException {
                    this.registerReadAttempt();
                    if (this.index < this.content.length) {
                        try {
                            Thread.sleep(((SlowReader)SlowReader.this).SlowContentStore.this.pauseMillis);
                        }
                        catch (InterruptedException error) {
                            throw new RuntimeException(error);
                        }
                        dst.put(this.content[this.index++]);
                        return 1;
                    }
                    return -1;
                }
            };
        }
    }

    private class SlowWriter
    extends AbstractContentWriter {
        protected SlowWriter(String contentUrl, ContentReader existingContentReader) {
            super(contentUrl, existingContentReader);
        }

        public long getSize() {
            return 20L;
        }

        protected ContentReader createReader() throws ContentIOException {
            return new SlowReader(this.getContentUrl());
        }

        protected WritableByteChannel getDirectWritableChannel() throws ContentIOException {
            return new WritableByteChannel(){
                private boolean closed = false;
                private int left = 200;

                @Override
                public boolean isOpen() {
                    return !this.closed;
                }

                @Override
                public void close() throws IOException {
                    this.closed = true;
                }

                @Override
                public int write(ByteBuffer src) throws IOException {
                    try {
                        Thread.sleep(((SlowWriter)SlowWriter.this).SlowContentStore.this.pauseMillis);
                    }
                    catch (InterruptedException error) {
                        throw new RuntimeException(error);
                    }
                    if (this.left > 0) {
                        src.get();
                        --this.left;
                        return 1;
                    }
                    return 0;
                }
            };
        }
    }
}

