/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.lock;

import java.io.Serializable;
import java.time.Duration;
import java.util.HashMap;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.node.archive.NodeArchiveService;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.lock.NodeLockedException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.TestWithUserUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.awaitility.Awaitility;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.transaction.annotation.Transactional;

@Category(value={OwnJVMTestsCategory.class})
@Transactional
public class LockBehaviourImplTest
extends BaseSpringTest {
    private LockService lockService;
    private VersionService versionService;
    private NodeService nodeService;
    private CopyService copyService;
    private NodeArchiveService nodeArchiveService;
    private MutableAuthenticationService authenticationService;
    private PermissionService permissionService;
    private NodeRef nodeRef;
    private NodeRef noAspectNode;
    private NodeRef inSpaceStoreNode;
    private StoreRef storeRef;
    private static final String PWD = RandomStringUtils.secure().nextAlphabetic(10);
    private static final String GOOD_USER_NAME = "goodUser";
    private static final String BAD_USER_NAME = "badUser";
    private static final String BAD_USER_WITH_ALL_PERMS_NAME = "badUserOwns";
    NodeRef rootNodeRef;

    @Before
    public void before() throws Exception {
        this.nodeService = (NodeService)this.applicationContext.getBean("dbNodeService");
        this.lockService = (LockService)this.applicationContext.getBean("lockService");
        this.versionService = (VersionService)this.applicationContext.getBean("versionService");
        this.authenticationService = (MutableAuthenticationService)this.applicationContext.getBean("authenticationService");
        this.permissionService = (PermissionService)this.applicationContext.getBean("permissionService");
        this.copyService = (CopyService)this.applicationContext.getBean("copyService");
        this.nodeArchiveService = (NodeArchiveService)this.applicationContext.getBean("nodeArchiveService");
        AuthenticationComponent authComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        authComponent.setSystemUserAsCurrentUser();
        HashMap<QName, String> nodeProperties = new HashMap<QName, String>();
        nodeProperties.put(QName.createQName((String)"{test}property1"), "value1");
        this.storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.storeRef);
        this.nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{}ParentNode"), ContentModel.TYPE_FOLDER, nodeProperties).getChildRef();
        this.nodeService.addAspect(this.nodeRef, ContentModel.ASPECT_LOCKABLE, new HashMap());
        LockBehaviourImplTest.assertNotNull((Object)this.nodeRef);
        this.inSpaceStoreNode = this.nodeService.createNode(this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE), ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{}ParentNode"), ContentModel.TYPE_FOLDER, nodeProperties).getChildRef();
        this.nodeService.addAspect(this.inSpaceStoreNode, ContentModel.ASPECT_LOCKABLE, new HashMap());
        LockBehaviourImplTest.assertNotNull((Object)this.inSpaceStoreNode);
        this.noAspectNode = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{}noAspectNode"), ContentModel.TYPE_CONTAINER, nodeProperties).getChildRef();
        LockBehaviourImplTest.assertNotNull((Object)this.noAspectNode);
        TestWithUserUtils.createUser(GOOD_USER_NAME, PWD, this.rootNodeRef, this.nodeService, this.authenticationService);
        TestWithUserUtils.createUser(BAD_USER_NAME, PWD, this.rootNodeRef, this.nodeService, this.authenticationService);
        TestWithUserUtils.createUser(BAD_USER_WITH_ALL_PERMS_NAME, PWD, this.rootNodeRef, this.nodeService, this.authenticationService);
        TestWithUserUtils.authenticateUser(BAD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        TestWithUserUtils.authenticateUser(BAD_USER_WITH_ALL_PERMS_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        this.permissionService.setPermission(this.rootNodeRef, GOOD_USER_NAME, "All", true);
        this.permissionService.setPermission(this.rootNodeRef, BAD_USER_NAME, "Read", true);
        this.permissionService.setPermission(this.rootNodeRef, BAD_USER_WITH_ALL_PERMS_NAME, "All", true);
        this.permissionService.setPermission(this.inSpaceStoreNode, GOOD_USER_NAME, "All", true);
        this.permissionService.setPermission(this.inSpaceStoreNode, BAD_USER_WITH_ALL_PERMS_NAME, "All", true);
    }

    @Test
    public void testCheckForLockNoUser() {
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        this.lockService.checkForLock(this.nodeRef);
        LockBehaviourImplTest.assertFalse((boolean)this.lockService.isLocked(this.nodeRef));
        this.lockService.checkForLock(this.noAspectNode);
        LockBehaviourImplTest.assertFalse((boolean)this.lockService.isLocked(this.noAspectNode));
        this.lockService.lock(this.nodeRef, LockType.WRITE_LOCK);
        this.lockService.checkForLock(this.nodeRef);
        LockBehaviourImplTest.assertTrue((boolean)this.lockService.isLocked(this.nodeRef));
        LockBehaviourImplTest.assertFalse((boolean)this.lockService.isLockedAndReadOnly(this.nodeRef));
        this.lockService.unlock(this.nodeRef);
        LockBehaviourImplTest.assertFalse((boolean)this.lockService.isLocked(this.nodeRef));
        LockBehaviourImplTest.assertFalse((boolean)this.lockService.isLockedAndReadOnly(this.nodeRef));
        this.lockService.lock(this.nodeRef, LockType.READ_ONLY_LOCK);
        try {
            this.lockService.checkForLock(this.nodeRef);
            LockBehaviourImplTest.fail((String)"The node locked exception should have been raised");
        }
        catch (NodeLockedException nodeLockedException) {}
        LockBehaviourImplTest.assertTrue((boolean)this.lockService.isLocked(this.nodeRef));
        LockBehaviourImplTest.assertTrue((boolean)this.lockService.isLockedAndReadOnly(this.nodeRef));
        this.lockService.unlock(this.nodeRef);
        LockBehaviourImplTest.assertFalse((boolean)this.lockService.isLocked(this.nodeRef));
        LockBehaviourImplTest.assertFalse((boolean)this.lockService.isLockedAndReadOnly(this.nodeRef));
        TestWithUserUtils.authenticateUser(BAD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        this.lockService.lock(this.nodeRef, LockType.WRITE_LOCK);
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        try {
            this.lockService.checkForLock(this.nodeRef);
            LockBehaviourImplTest.fail((String)"The node locked exception should have been raised");
        }
        catch (NodeLockedException nodeLockedException) {}
        LockBehaviourImplTest.assertTrue((boolean)this.lockService.isLocked(this.nodeRef));
        LockBehaviourImplTest.assertTrue((boolean)this.lockService.isLockedAndReadOnly(this.nodeRef));
        TestWithUserUtils.authenticateUser(BAD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        this.lockService.unlock(this.nodeRef);
        LockBehaviourImplTest.assertFalse((boolean)this.lockService.isLocked(this.nodeRef));
        LockBehaviourImplTest.assertFalse((boolean)this.lockService.isLockedAndReadOnly(this.nodeRef));
        this.lockService.lock(this.nodeRef, LockType.READ_ONLY_LOCK);
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        try {
            this.lockService.checkForLock(this.nodeRef);
            LockBehaviourImplTest.fail((String)"The node locked exception should have been raised");
        }
        catch (NodeLockedException nodeLockedException) {}
        LockBehaviourImplTest.assertTrue((boolean)this.lockService.isLocked(this.nodeRef));
        LockBehaviourImplTest.assertTrue((boolean)this.lockService.isLockedAndReadOnly(this.nodeRef));
    }

    @Test
    public void testCheckForLockWhenExpired() {
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        this.lockService.lock(this.nodeRef, LockType.READ_ONLY_LOCK, 1);
        try {
            this.lockService.checkForLock(this.nodeRef);
            LockBehaviourImplTest.fail((String)"Should be locked.");
        }
        catch (NodeLockedException nodeLockedException) {}
        LockBehaviourImplTest.assertTrue((boolean)this.lockService.isLocked(this.nodeRef));
        LockBehaviourImplTest.assertTrue((boolean)this.lockService.isLockedAndReadOnly(this.nodeRef));
        Awaitility.await().pollInSameThread().pollDelay(Duration.ofMillis(500L)).atMost(BaseSpringTest.MAX_ASYNC_TIMEOUT).until(() -> !this.lockService.isLocked(this.nodeRef));
        this.lockService.checkForLock(this.nodeRef);
        LockBehaviourImplTest.assertFalse((boolean)this.lockService.isLocked(this.nodeRef));
        LockBehaviourImplTest.assertFalse((boolean)this.lockService.isLockedAndReadOnly(this.nodeRef));
    }

    @Test
    public void testVersionServiceLockBehaviour01() {
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        this.nodeService.addAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE, null);
        try {
            this.versionService.createVersion(this.nodeRef, new HashMap());
        }
        catch (NodeLockedException nodeLockedException) {
            LockBehaviourImplTest.fail((String)"There is no lock so this should have worked.");
        }
        this.lockService.lock(this.nodeRef, LockType.WRITE_LOCK);
        try {
            this.versionService.createVersion(this.nodeRef, new HashMap());
        }
        catch (NodeLockedException nodeLockedException) {
            LockBehaviourImplTest.fail((String)"Tried to version as the lock owner so should work.");
        }
        this.lockService.unlock(this.nodeRef);
        this.lockService.lock(this.nodeRef, LockType.READ_ONLY_LOCK);
        try {
            this.versionService.createVersion(this.nodeRef, new HashMap());
        }
        catch (NodeLockedException nodeLockedException) {
            LockBehaviourImplTest.fail((String)"Should have passed, as we should be able to create a version. See ALF-16540");
        }
        this.lockService.unlock(this.nodeRef);
    }

    @Test
    public void testVersionServiceLockBehaviour02() {
        this.nodeService.addAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE, null);
        this.lockService.lock(this.nodeRef, LockType.WRITE_LOCK);
        try {
            TestWithUserUtils.authenticateUser(BAD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
            this.versionService.createVersion(this.nodeRef, new HashMap());
            LockBehaviourImplTest.fail((String)"Should have failed since this node has been locked by another user with a write lock.");
        }
        catch (AccessDeniedException accessDeniedException) {}
    }

    public void testNodeServiceLockBehaviour() {
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        ChildAssociationRef childAssocRef = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}nodeServiceLockTest"), ContentModel.TYPE_CONTAINER);
        childAssocRef.getChildRef();
        this.lockService.lock(this.nodeRef, LockType.WRITE_LOCK);
        this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}nodeServiceLockTest"), ContentModel.TYPE_CONTAINER);
        childAssocRef.getChildRef();
        this.nodeService.setProperty(this.nodeRef, QName.createQName((String)"{test}prop1"), (Serializable)((Object)"value1"));
        HashMap<QName, String> propMap = new HashMap<QName, String>();
        propMap.put(QName.createQName((String)"{test}prop2"), "value2");
        this.nodeService.setProperties(this.nodeRef, propMap);
        this.nodeService.removeAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE);
        this.lockService.unlock(this.nodeRef);
        TestWithUserUtils.authenticateUser(BAD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        this.lockService.lock(this.nodeRef, LockType.WRITE_LOCK);
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        try {
            this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}nodeServiceLockTest"), ContentModel.TYPE_CONTAINER);
            LockBehaviourImplTest.fail((String)"The parent is locked so a new child should not have been created.");
        }
        catch (NodeLockedException nodeLockedException) {}
    }

    @Test
    public void testCannotMoveNodeWhenLocked() {
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        NodeRef parentNode = this.nodeRef;
        ChildAssociationRef childAssocRef = this.nodeService.createNode(parentNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}nodeServiceLockTest"), ContentModel.TYPE_CONTENT);
        NodeRef nodeRef = childAssocRef.getChildRef();
        this.lockService.lock(nodeRef, LockType.WRITE_LOCK);
        NodeRef newParentRef = this.nodeService.createNode(parentNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}nodeServiceLockTest"), ContentModel.TYPE_CONTAINER).getChildRef();
        TestWithUserUtils.authenticateUser(BAD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        try {
            this.nodeService.moveNode(nodeRef, newParentRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}nodeServiceLockTest"));
            LockBehaviourImplTest.fail((String)"Shouldn't have been able to move locked node.");
        }
        catch (NodeLockedException nodeLockedException) {}
    }

    @Test
    public void testCanMoveCopyDeleteWithLockOwner() {
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        NodeRef parentNode = this.nodeRef;
        ChildAssociationRef childAssocRef = this.nodeService.createNode(parentNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}nodeServiceLockTest"), ContentModel.TYPE_CONTENT);
        NodeRef nodeRef = childAssocRef.getChildRef();
        this.lockService.lock(nodeRef, LockType.WRITE_LOCK);
        NodeRef archivingBehaviorNodeRef = this.nodeService.createNode(this.inSpaceStoreNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}nodeServiceLockTest"), ContentModel.TYPE_CONTENT).getChildRef();
        this.lockService.lock(archivingBehaviorNodeRef, LockType.WRITE_LOCK);
        NodeRef newParentRefToMove = this.nodeService.createNode(parentNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}nodeServiceLockTest"), ContentModel.TYPE_CONTAINER).getChildRef();
        NodeRef newParentRefToCopy = this.nodeService.createNode(parentNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}nodeServiceLockTest"), ContentModel.TYPE_CONTAINER).getChildRef();
        try {
            this.nodeService.moveNode(nodeRef, newParentRefToMove, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}nodeServiceLockTest"));
            this.copyService.copy(nodeRef, newParentRefToCopy, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}nodeServiceLockTest"));
            this.nodeService.deleteNode(nodeRef);
        }
        catch (NodeLockedException nodeLockedException) {
            LockBehaviourImplTest.fail((String)"Should be moved, copied an deleted.");
        }
        childAssocRef = this.nodeService.createNode(parentNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}nodeServiceLockTest"), ContentModel.TYPE_CONTENT);
        nodeRef = childAssocRef.getChildRef();
        newParentRefToCopy = this.nodeService.createNode(parentNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}nodeServiceLockTest"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.lockService.lock(nodeRef, LockType.WRITE_LOCK);
        TestWithUserUtils.authenticateUser(BAD_USER_WITH_ALL_PERMS_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        try {
            this.copyService.copy(nodeRef, newParentRefToCopy, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}nodeServiceLockTest"));
        }
        catch (NodeLockedException nodeLockedException) {
            LockBehaviourImplTest.fail((String)"Should be copied.");
        }
        try {
            this.nodeService.deleteNode(newParentRefToCopy);
        }
        catch (NodeLockedException nodeLockedException) {
            LockBehaviourImplTest.fail((String)"Should not have any locks.");
        }
        try {
            this.nodeService.deleteNode(nodeRef);
            LockBehaviourImplTest.fail((String)"Should not be deleted.");
        }
        catch (NodeLockedException nodeLockedException) {}
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        this.nodeService.deleteNode(archivingBehaviorNodeRef);
        NodeRef archivedNode = this.nodeArchiveService.getArchivedNode(archivingBehaviorNodeRef);
        this.checkForLockForBadAndGoodUsers(archivedNode);
        TestWithUserUtils.authenticateUser(BAD_USER_WITH_ALL_PERMS_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        try {
            archivingBehaviorNodeRef = this.nodeService.restoreNode(archivedNode, this.inSpaceStoreNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}nodeServiceLockTest"));
        }
        catch (Exception exception) {
            LockBehaviourImplTest.fail((String)"Should not be any Exceptons.");
        }
        this.checkForLockForBadAndGoodUsers(archivingBehaviorNodeRef);
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        this.nodeService.deleteNode(archivingBehaviorNodeRef);
        try {
            archivingBehaviorNodeRef = this.nodeService.restoreNode(archivedNode, this.inSpaceStoreNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}nodeServiceLockTest"));
        }
        catch (Exception exception) {
            LockBehaviourImplTest.fail((String)"Should not be any Exceptons.");
        }
        this.checkForLockForBadAndGoodUsers(archivingBehaviorNodeRef);
    }

    private void checkForLockForBadAndGoodUsers(NodeRef nodeToCheck) {
        String currentUserName = TestWithUserUtils.getCurrentUser((AuthenticationService)this.authenticationService);
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        try {
            this.lockService.checkForLock(nodeToCheck);
        }
        catch (NodeLockedException nodeLockedException) {
            LockBehaviourImplTest.fail((String)("Should not be locked for GoodUser : " + String.valueOf(nodeToCheck)));
        }
        LockBehaviourImplTest.assertTrue((boolean)this.lockService.isLocked(nodeToCheck));
        LockBehaviourImplTest.assertFalse((boolean)this.lockService.isLockedAndReadOnly(nodeToCheck));
        TestWithUserUtils.authenticateUser(BAD_USER_WITH_ALL_PERMS_NAME, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
        try {
            this.lockService.checkForLock(nodeToCheck);
            LockBehaviourImplTest.fail((String)("Should be locked for BadUser : " + String.valueOf(nodeToCheck)));
        }
        catch (NodeLockedException nodeLockedException) {}
        LockBehaviourImplTest.assertTrue((boolean)this.lockService.isLocked(nodeToCheck));
        LockBehaviourImplTest.assertTrue((boolean)this.lockService.isLockedAndReadOnly(nodeToCheck));
        TestWithUserUtils.authenticateUser(currentUserName, PWD, this.rootNodeRef, (AuthenticationService)this.authenticationService);
    }
}

