/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.lock.mem;

import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.lock.mem.Lifetime;
import org.alfresco.repo.lock.mem.LockState;
import org.alfresco.repo.lock.mem.LockStore;
import org.alfresco.repo.lock.mem.LockableAspectInterceptor;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;

public class LockableAspectInterceptorTest {
    private ApplicationContext appCtx;
    private TransactionService transactionService;
    private NodeService nodeService;
    private NodeService rawNodeService;
    private LockStore lockStore;
    private NodeRef rootNode;
    private String userName;
    private String lockOwner;
    private LockableAspectInterceptor interceptor;
    private LockService lockService;
    private FileFolderService fileFolderService;
    private ActionService actionService;

    @Before
    public void setUp() {
        this.appCtx = ApplicationContextHelper.getApplicationContext();
        this.lockOwner = "jbloggs";
        this.userName = AuthenticationUtil.getAdminUserName();
        AuthenticationUtil.setFullyAuthenticatedUser((String)this.userName);
        this.transactionService = (TransactionService)this.appCtx.getBean("TransactionService");
        this.nodeService = (NodeService)this.appCtx.getBean("NodeService");
        this.rawNodeService = (NodeService)this.appCtx.getBean("dbNodeService");
        this.lockStore = (LockStore)this.appCtx.getBean("lockStore");
        this.rootNode = this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        this.interceptor = (LockableAspectInterceptor)this.appCtx.getBean("lockableAspectInterceptor");
        this.lockService = (LockService)this.appCtx.getBean("lockService");
        this.fileFolderService = (FileFolderService)this.appCtx.getBean("FileFolderService");
        this.actionService = (ActionService)this.appCtx.getBean("ActionService");
    }

    @Test
    public void testHasAspectEphemeralLock() {
        QName nodeName = QName.createQName((String)("http://www.alfresco.org/test/" + this.getClass().getSimpleName()), (String)"testNode");
        NodeRef nodeRef = this.nodeService.createNode(this.rootNode, ContentModel.ASSOC_CHILDREN, nodeName, ContentModel.TYPE_BASE).getChildRef();
        Assert.assertFalse((String)"Node should not be reported as lockable", (boolean)this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE));
        this.lockStore.set(nodeRef, LockState.createLock((NodeRef)nodeRef, (LockType)LockType.WRITE_LOCK, (String)this.lockOwner, null, (Lifetime)Lifetime.EPHEMERAL, null));
        Assert.assertTrue((String)"Node should be reported as lockable", (boolean)this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE));
    }

    @Test
    public void testHasAspectPersistentLock() {
        QName nodeName = QName.createQName((String)("http://www.alfresco.org/test/" + this.getClass().getSimpleName()), (String)"testNode");
        NodeRef nodeRef = this.nodeService.createNode(this.rootNode, ContentModel.ASSOC_CHILDREN, nodeName, ContentModel.TYPE_BASE).getChildRef();
        Assert.assertFalse((String)"Node should not be reported as lockable", (boolean)this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE));
        this.lockStore.set(nodeRef, LockState.createLock((NodeRef)nodeRef, (LockType)LockType.WRITE_LOCK, (String)this.lockOwner, null, (Lifetime)Lifetime.PERSISTENT, null));
        Assert.assertFalse((String)"Node should not be reported as lockable", (boolean)this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE));
        this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_LOCKABLE, new HashMap(0));
        Assert.assertTrue((String)"Node should be reported as lockable", (boolean)this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE));
    }

    @Test
    public void testGetAspectsEphemeralLock() {
        QName nodeName = QName.createQName((String)("http://www.alfresco.org/test/" + this.getClass().getSimpleName()), (String)"testNode");
        NodeRef nodeRef = this.nodeService.createNode(this.rootNode, ContentModel.ASSOC_CHILDREN, nodeName, ContentModel.TYPE_BASE).getChildRef();
        this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_AUDITABLE, new HashMap());
        Set aspects = this.nodeService.getAspects(nodeRef);
        Assert.assertFalse((String)"Node should not have lockable aspect", (boolean)aspects.contains(ContentModel.ASPECT_LOCKABLE));
        Assert.assertTrue((String)"Node should have auditable aspect", (boolean)aspects.contains(ContentModel.ASPECT_AUDITABLE));
        this.lockStore.set(nodeRef, LockState.createLock((NodeRef)nodeRef, (LockType)LockType.WRITE_LOCK, (String)this.lockOwner, null, (Lifetime)Lifetime.EPHEMERAL, null));
        aspects = this.nodeService.getAspects(nodeRef);
        Assert.assertTrue((String)"Node should have lockable aspect", (boolean)aspects.contains(ContentModel.ASPECT_LOCKABLE));
        Assert.assertTrue((String)"Node should have auditable aspect", (boolean)aspects.contains(ContentModel.ASPECT_AUDITABLE));
    }

    @Test
    public void testGetAspectsPersistentLock() {
        QName nodeName = QName.createQName((String)("http://www.alfresco.org/test/" + this.getClass().getSimpleName()), (String)"testNode");
        NodeRef nodeRef = this.nodeService.createNode(this.rootNode, ContentModel.ASSOC_CHILDREN, nodeName, ContentModel.TYPE_BASE).getChildRef();
        this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_AUDITABLE, new HashMap());
        Set aspects = this.nodeService.getAspects(nodeRef);
        Assert.assertFalse((String)"Node should not have lockable aspect", (boolean)aspects.contains(ContentModel.ASPECT_LOCKABLE));
        Assert.assertTrue((String)"Node should have auditable aspect", (boolean)aspects.contains(ContentModel.ASPECT_AUDITABLE));
        this.lockStore.set(nodeRef, LockState.createLock((NodeRef)nodeRef, (LockType)LockType.WRITE_LOCK, (String)this.lockOwner, null, (Lifetime)Lifetime.PERSISTENT, null));
        aspects = this.nodeService.getAspects(nodeRef);
        Assert.assertFalse((String)"Node should not have lockable aspect", (boolean)aspects.contains(ContentModel.ASPECT_LOCKABLE));
        Assert.assertTrue((String)"Node should have auditable aspect", (boolean)aspects.contains(ContentModel.ASPECT_AUDITABLE));
    }

    @Test
    public void testGetPropertiesPersistentLock() {
        QName nodeName = QName.createQName((String)("http://www.alfresco.org/test/" + this.getClass().getSimpleName()), (String)"testNode");
        NodeRef nodeRef = this.nodeService.createNode(this.rootNode, ContentModel.ASSOC_CHILDREN, nodeName, ContentModel.TYPE_BASE).getChildRef();
        this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_AUDITABLE, new HashMap());
        Date now = new Date();
        HashMap<QName, Object> lockProps = new HashMap<QName, Object>();
        lockProps.put(ContentModel.PROP_LOCK_OWNER, "jbloggs");
        lockProps.put(ContentModel.PROP_LOCK_TYPE, LockType.READ_ONLY_LOCK.toString());
        lockProps.put(ContentModel.PROP_EXPIRY_DATE, now);
        lockProps.put(ContentModel.PROP_LOCK_ADDITIONAL_INFO, "{ \"fieldName\": \"extra lock info\" }");
        this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_LOCKABLE, lockProps);
        Map readProps = this.nodeService.getProperties(nodeRef);
        Assert.assertEquals((Object)"jbloggs", readProps.get(ContentModel.PROP_LOCK_OWNER));
        Assert.assertEquals((Object)LockType.READ_ONLY_LOCK.toString(), readProps.get(ContentModel.PROP_LOCK_TYPE));
        Assert.assertEquals((Object)now, readProps.get(ContentModel.PROP_EXPIRY_DATE));
        Assert.assertEquals((Object)Lifetime.PERSISTENT.toString(), readProps.get(ContentModel.PROP_LOCK_LIFETIME));
        this.ensurePropertyNotPresent(nodeRef, ContentModel.PROP_LOCK_LIFETIME);
        Assert.assertEquals((Object)"{ \"fieldName\": \"extra lock info\" }", readProps.get(ContentModel.PROP_LOCK_ADDITIONAL_INFO));
    }

    private void ensurePropertyNotPresent(final NodeRef nodeRef, final QName propQName) {
        RetryingTransactionHelper.RetryingTransactionCallback<Boolean> check = new RetryingTransactionHelper.RetryingTransactionCallback<Boolean>(){

            public Boolean execute() throws Throwable {
                return LockableAspectInterceptorTest.this.rawNodeService.getProperties(nodeRef).containsKey(propQName);
            }
        };
        Assert.assertFalse((String)("Node should not have the " + String.valueOf(propQName) + " property present."), (boolean)((Boolean)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)check)));
    }

    @Test
    public void testGetPropertiesEphemeralLock() {
        QName nodeName = QName.createQName((String)("http://www.alfresco.org/test/" + this.getClass().getSimpleName()), (String)"testNode");
        NodeRef nodeRef = this.nodeService.createNode(this.rootNode, ContentModel.ASSOC_CHILDREN, nodeName, ContentModel.TYPE_BASE).getChildRef();
        this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_AUDITABLE, new HashMap());
        Map properties = this.nodeService.getProperties(nodeRef);
        Assert.assertFalse((String)"Node should not have lockOwner property", (boolean)properties.containsKey(ContentModel.PROP_LOCK_OWNER));
        Assert.assertTrue((String)"Node should have created property", (boolean)properties.containsKey(ContentModel.PROP_CREATED));
        Date expire = this.makeExpiryDate(2);
        this.lockStore.set(nodeRef, LockState.createLock((NodeRef)nodeRef, (LockType)LockType.WRITE_LOCK, (String)this.lockOwner, (Date)expire, (Lifetime)Lifetime.EPHEMERAL, null));
        properties = this.nodeService.getProperties(nodeRef);
        Assert.assertEquals((Object)this.lockOwner, properties.get(ContentModel.PROP_LOCK_OWNER));
        Assert.assertEquals((Object)LockType.WRITE_LOCK.toString(), properties.get(ContentModel.PROP_LOCK_TYPE));
        Assert.assertEquals((Object)expire, properties.get(ContentModel.PROP_EXPIRY_DATE));
        Assert.assertEquals((Object)Lifetime.EPHEMERAL.toString(), properties.get(ContentModel.PROP_LOCK_LIFETIME));
        Assert.assertTrue((String)"Node should have created property", (boolean)properties.containsKey(ContentModel.PROP_CREATED));
    }

    @Test
    public void testGetPropertyEphemeralLock() {
        QName nodeName = QName.createQName((String)("http://www.alfresco.org/test/" + this.getClass().getSimpleName()), (String)"testNode");
        NodeRef nodeRef = this.nodeService.createNode(this.rootNode, ContentModel.ASSOC_CHILDREN, nodeName, ContentModel.TYPE_BASE).getChildRef();
        Assert.assertEquals(null, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_LOCK_OWNER));
        Assert.assertEquals(null, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_LOCK_TYPE));
        Assert.assertEquals(null, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_EXPIRY_DATE));
        Assert.assertEquals(null, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_LOCK_LIFETIME));
        Date expire = this.makeExpiryDate(2);
        this.lockStore.set(nodeRef, LockState.createLock((NodeRef)nodeRef, (LockType)LockType.WRITE_LOCK, (String)this.lockOwner, (Date)expire, (Lifetime)Lifetime.EPHEMERAL, null));
        Assert.assertEquals((Object)this.lockOwner, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_LOCK_OWNER));
        Assert.assertEquals((Object)LockType.WRITE_LOCK.toString(), (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_LOCK_TYPE));
        Assert.assertEquals((Object)expire, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_EXPIRY_DATE));
        Assert.assertEquals((Object)Lifetime.EPHEMERAL.toString(), (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_LOCK_LIFETIME));
    }

    @Test
    public void testGetPropertyPersistentLock() {
        QName nodeName = QName.createQName((String)("http://www.alfresco.org/test/" + this.getClass().getSimpleName()), (String)"testNode");
        NodeRef nodeRef = this.nodeService.createNode(this.rootNode, ContentModel.ASSOC_CHILDREN, nodeName, ContentModel.TYPE_BASE).getChildRef();
        Assert.assertEquals(null, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_LOCK_OWNER));
        Assert.assertEquals(null, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_LOCK_TYPE));
        Assert.assertEquals(null, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_EXPIRY_DATE));
        Date now = new Date();
        HashMap<QName, Object> lockProps = new HashMap<QName, Object>();
        lockProps.put(ContentModel.PROP_LOCK_OWNER, "another");
        lockProps.put(ContentModel.PROP_LOCK_TYPE, LockType.WRITE_LOCK.toString());
        lockProps.put(ContentModel.PROP_EXPIRY_DATE, now);
        this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_LOCKABLE, lockProps);
        Assert.assertEquals((Object)"another", (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_LOCK_OWNER));
        Assert.assertEquals((Object)LockType.WRITE_LOCK.toString(), (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_LOCK_TYPE));
        Assert.assertEquals((Object)now, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_EXPIRY_DATE));
        Assert.assertEquals((Object)Lifetime.PERSISTENT.toString(), (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_LOCK_LIFETIME));
        this.ensurePropertyNotPresent(nodeRef, ContentModel.PROP_LOCK_LIFETIME);
    }

    @Test
    public void testEnableDisableForThread() throws InterruptedException, ExecutionException {
        QName nodeName = QName.createQName((String)("http://www.alfresco.org/test/" + this.getClass().getSimpleName()), (String)"testNode");
        final NodeRef nodeRef = this.nodeService.createNode(this.rootNode, ContentModel.ASSOC_CHILDREN, nodeName, ContentModel.TYPE_BASE).getChildRef();
        Assert.assertFalse((String)"Node should not be reported as lockable", (boolean)this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE));
        this.lockStore.set(nodeRef, LockState.createLock((NodeRef)nodeRef, (LockType)LockType.WRITE_LOCK, (String)this.lockOwner, null, (Lifetime)Lifetime.EPHEMERAL, null));
        Assert.assertTrue((String)"Node should be reported as lockable", (boolean)this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE));
        this.interceptor.disableForThread();
        Assert.assertFalse((String)"Node should NOT be reported as lockable", (boolean)this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE));
        this.interceptor.enableForThread();
        Assert.assertTrue((String)"Node should be reported as lockable", (boolean)this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE));
        Callable<Boolean> callable = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
                LockableAspectInterceptorTest.this.interceptor.disableForThread();
                return LockableAspectInterceptorTest.this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE);
            }
        };
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Boolean> future = executor.submit(callable);
        Assert.assertFalse((String)"Node should be reported as lockable (new thread)", (boolean)future.get());
        Assert.assertTrue((String)"Node should be reported as lockable (main thread)", (boolean)this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE));
        executor.shutdown();
    }

    @Test
    public void testSetPropertiesPersistentLock() {
        QName nodeName = QName.createQName((String)("http://www.alfresco.org/test/" + this.getClass().getSimpleName()), (String)"testNode");
        NodeRef nodeRef = this.nodeService.createNode(this.rootNode, ContentModel.ASSOC_CHILDREN, nodeName, ContentModel.TYPE_BASE).getChildRef();
        Map properties = this.nodeService.getProperties(nodeRef);
        properties.put(ContentModel.PROP_AUTHOR, "Joe Bloggs");
        properties.put(ContentModel.PROP_NAME, "A Name");
        properties.put(ContentModel.PROP_LOCK_TYPE, LockType.NODE_LOCK);
        properties.put(ContentModel.PROP_LOCK_LIFETIME, Lifetime.PERSISTENT);
        properties.put(ContentModel.PROP_LOCK_OWNER, "Alison Bloggs");
        Date expiryDate = new Date();
        properties.put(ContentModel.PROP_EXPIRY_DATE, expiryDate);
        this.nodeService.setProperties(nodeRef, properties);
        properties = this.nodeService.getProperties(nodeRef);
        Assert.assertEquals((Object)"Joe Bloggs", properties.get(ContentModel.PROP_AUTHOR));
        Assert.assertEquals((Object)"A Name", properties.get(ContentModel.PROP_NAME));
        Assert.assertEquals((Object)LockType.NODE_LOCK.toString(), properties.get(ContentModel.PROP_LOCK_TYPE));
        Assert.assertEquals((Object)"Alison Bloggs", properties.get(ContentModel.PROP_LOCK_OWNER));
        Assert.assertEquals((Object)expiryDate, properties.get(ContentModel.PROP_EXPIRY_DATE));
        this.ensurePropertyNotPresent(nodeRef, ContentModel.PROP_LOCK_LIFETIME);
    }

    @Test
    public void testSetPropertiesEphemeralLock() {
        QName nodeName = QName.createQName((String)("http://www.alfresco.org/test/" + this.getClass().getSimpleName()), (String)"testNode");
        NodeRef nodeRef = this.nodeService.createNode(this.rootNode, ContentModel.ASSOC_CHILDREN, nodeName, ContentModel.TYPE_BASE).getChildRef();
        Map properties = this.nodeService.getProperties(nodeRef);
        properties.put(ContentModel.PROP_AUTHOR, "Joe Bloggs");
        properties.put(ContentModel.PROP_NAME, "A Name");
        properties.put(ContentModel.PROP_LOCK_TYPE, LockType.NODE_LOCK);
        properties.put(ContentModel.PROP_LOCK_LIFETIME, Lifetime.EPHEMERAL.toString());
        properties.put(ContentModel.PROP_LOCK_OWNER, "Alison Bloggs");
        Date expiryDate = new Date();
        properties.put(ContentModel.PROP_EXPIRY_DATE, expiryDate);
        this.nodeService.setProperties(nodeRef, properties);
        properties = this.nodeService.getProperties(nodeRef);
        Assert.assertEquals((Object)"Joe Bloggs", properties.get(ContentModel.PROP_AUTHOR));
        Assert.assertEquals((Object)"A Name", properties.get(ContentModel.PROP_NAME));
        Assert.assertNull(properties.get(ContentModel.PROP_LOCK_TYPE));
        Assert.assertNull(properties.get(ContentModel.PROP_LOCK_LIFETIME));
        Assert.assertNull(properties.get(ContentModel.PROP_LOCK_OWNER));
        Assert.assertNull(properties.get(ContentModel.PROP_EXPIRY_DATE));
    }

    @Test
    public void testEphemeralLock() {
        String fName = GUID.generate() + ".doc";
        QName nodeName = QName.createQName((String)("http://www.alfresco.org/test/" + this.getClass().getSimpleName()), (String)fName);
        final NodeRef nodeRef = this.nodeService.createNode(this.rootNode, ContentModel.ASSOC_CHILDREN, nodeName, ContentModel.TYPE_CONTENT).getChildRef();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> lockExecuteImplCallBack = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                LockableAspectInterceptorTest.this.lockService.lock(nodeRef, LockType.WRITE_LOCK, 3600, Lifetime.EPHEMERAL, "someInfo");
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)lockExecuteImplCallBack);
        this.writeData(fName, nodeRef);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> unlockExecuteImplCallBack = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                LockableAspectInterceptorTest.this.lockService.unlock(nodeRef);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)unlockExecuteImplCallBack);
        Map properties = this.nodeService.getProperties(nodeRef);
        Assert.assertNull(properties.get(ContentModel.PROP_LOCK_TYPE));
        Assert.assertNull(properties.get(ContentModel.PROP_LOCK_LIFETIME));
    }

    private void writeData(String fileName, final NodeRef fileNodeRef) {
        this.nodeService.addAspect(fileNodeRef, ContentModel.ASPECT_NO_CONTENT, null);
        ContentWriter writer = this.fileFolderService.getWriter(fileNodeRef);
        writer.guessMimetype(fileName);
        writer.guessEncoding();
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("farmers_markets_list_2003.doc");
        writer.putContent(is);
        AuthenticationUtil.pushAuthentication();
        AuthenticationUtil.setFullyAuthenticatedUser((String)"System");
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Action action = LockableAspectInterceptorTest.this.actionService.createAction("extract-metadata");
                try {
                    LockableAspectInterceptorTest.this.actionService.executeAction(action, fileNodeRef);
                }
                catch (Throwable throwable) {}
                return null;
            }
        });
        AuthenticationUtil.popAuthentication();
    }

    private Date makeExpiryDate(int timeToExpireInSeconds) {
        Date expiryDate = null;
        if (timeToExpireInSeconds > 0) {
            expiryDate = new Date();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(expiryDate);
            calendar.add(13, timeToExpireInSeconds);
            expiryDate = calendar.getTime();
        }
        return expiryDate;
    }
}

