/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.module;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.admin.registry.RegistryService;
import org.alfresco.repo.module.AbstractModuleComponent;
import org.alfresco.repo.module.ModuleComponent;
import org.alfresco.repo.module.ModuleComponentHelper;
import org.alfresco.repo.module.ModuleDetailsImpl;
import org.alfresco.repo.module.ModuleVersionNumber;
import org.alfresco.repo.module.tool.ModuleManagementToolException;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.service.cmr.module.ModuleDetails;
import org.alfresco.service.cmr.module.ModuleService;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.util.BaseAlfrescoTestCase;
import org.alfresco.util.GUID;
import org.alfresco.util.VersionNumber;

public class ModuleComponentHelperTest
extends BaseAlfrescoTestCase {
    private final String SOME_GUID = GUID.generate();
    private final String[] MODULE_IDS = new String[]{"M0 @ " + this.SOME_GUID, "M1 @ " + this.SOME_GUID, "M2 @ " + this.SOME_GUID};
    private final String[] COMPONENT_NAMES = new String[]{"C0 @ " + this.SOME_GUID, "C1 @ " + this.SOME_GUID, "C2 @ " + this.SOME_GUID};
    private final VersionNumber[] VERSIONS = new VersionNumber[]{new VersionNumber("0"), new VersionNumber("1"), new VersionNumber("2"), new VersionNumber("3")};
    private static final Map<ModuleVersionNumber, Integer> EXECUTION_COUNT_BY_VERSION = new HashMap<ModuleVersionNumber, Integer>(13);
    private RegistryService registryService;
    private TenantAdminService tenantAdminService;
    private DescriptorService descriptorService;
    private DummyModuleService moduleService;
    private ModuleComponentHelper helper;
    private DummyModuleComponent[][] components;
    private volatile int executed = 0;

    static {
        EXECUTION_COUNT_BY_VERSION.put(new ModuleVersionNumber("0.0"), 3);
        EXECUTION_COUNT_BY_VERSION.put(new ModuleVersionNumber("0.5"), 3);
        EXECUTION_COUNT_BY_VERSION.put(new ModuleVersionNumber("1.0"), 6);
        EXECUTION_COUNT_BY_VERSION.put(new ModuleVersionNumber("1.5"), 3);
        EXECUTION_COUNT_BY_VERSION.put(new ModuleVersionNumber("2.0"), 6);
        EXECUTION_COUNT_BY_VERSION.put(new ModuleVersionNumber("2.5"), 3);
        EXECUTION_COUNT_BY_VERSION.put(new ModuleVersionNumber("3.0"), 3);
        EXECUTION_COUNT_BY_VERSION.put(new ModuleVersionNumber("3.5"), 0);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.registryService = (RegistryService)this.ctx.getBean("RegistryService");
        this.tenantAdminService = (TenantAdminService)this.ctx.getBean("tenantAdminService");
        this.descriptorService = this.serviceRegistry.getDescriptorService();
        this.moduleService = new DummyModuleService();
        this.helper = new ModuleComponentHelper();
        this.helper.setModuleService((ModuleService)this.moduleService);
        this.helper.setRegistryService(this.registryService);
        this.helper.setServiceRegistry(this.serviceRegistry);
        this.helper.setDescriptorService(this.descriptorService);
        this.helper.setTenantAdminService(this.tenantAdminService);
        this.components = new DummyModuleComponent[3][3];
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                DummyModuleComponent component = new DummyModuleComponent(this.MODULE_IDS[i], this.COMPONENT_NAMES[j], this.VERSIONS[j], this.VERSIONS[j + 1]);
                component.setServiceRegistry(this.serviceRegistry);
                component.setAuthenticationComponent(this.authenticationComponent);
                component.setModuleService(this.moduleService);
                component.setTenantAdminService(this.tenantAdminService);
                this.helper.registerComponent((ModuleComponent)component);
                this.components[i][j] = component;
                ++j;
            }
            ++i;
        }
        this.components[1][1].setDependsOn(Collections.singletonList(this.components[0][1]));
    }

    public void testSetup() throws Exception {
    }

    private void startComponents(ModuleVersionNumber moduleVersion) {
        int expectedCount = EXECUTION_COUNT_BY_VERSION.get(moduleVersion);
        this.moduleService.setCurrentVersion(moduleVersion);
        this.helper.startModules();
        ModuleComponentHelperTest.assertEquals((String)("Incorrent number of executions (version " + String.valueOf(moduleVersion) + ")"), (int)expectedCount, (int)this.executed);
    }

    public void testStartComponentsV00() {
        ModuleVersionNumber moduleVersion = new ModuleVersionNumber("0.0");
        this.startComponents(moduleVersion);
    }

    public void testStartComponentsV05() {
        ModuleVersionNumber moduleVersion = new ModuleVersionNumber("0.5");
        this.startComponents(moduleVersion);
    }

    public void testStartComponentsV10() {
        ModuleVersionNumber moduleVersion = new ModuleVersionNumber("1.0");
        this.startComponents(moduleVersion);
    }

    public void testStartComponentsV15() {
        ModuleVersionNumber moduleVersion = new ModuleVersionNumber("1.5");
        this.startComponents(moduleVersion);
    }

    public void testStartComponentsV30() {
        ModuleVersionNumber moduleVersion = new ModuleVersionNumber("3.0");
        this.startComponents(moduleVersion);
    }

    public void testStartComponentsV35() {
        ModuleVersionNumber moduleVersion = new ModuleVersionNumber("3.5");
        this.startComponents(moduleVersion);
    }

    public void testgetModuleVersionNumber() {
        ModuleVersionNumber moduleVersion = new ModuleVersionNumber("3.5");
        VersionNumber versNumber = new VersionNumber("3.5");
        ModuleComponentHelperTest.assertEquals((Object)moduleVersion, (Object)this.helper.getModuleVersionNumber((Serializable)moduleVersion));
        ModuleComponentHelperTest.assertEquals((Object)moduleVersion, (Object)this.helper.getModuleVersionNumber((Serializable)versNumber));
        try {
            this.helper.getModuleVersionNumber(null);
            ModuleComponentHelperTest.assertTrue((boolean)false);
        }
        catch (ModuleManagementToolException moduleManagementToolException) {}
    }

    private class DummyModuleComponent
    extends AbstractModuleComponent {
        private DummyModuleComponent(String moduleId, String name, VersionNumber from, VersionNumber to) {
            super.setServiceRegistry(this.serviceRegistry);
            super.setAuthenticationComponent(this.authenticationComponent);
            super.setModuleService(this.moduleService);
            super.setTenantAdminService(ModuleComponentHelperTest.this.tenantAdminService);
            super.setModuleId(moduleId);
            super.setName(name);
            super.setAppliesFromVersion(from.toString());
            super.setAppliesToVersion(to.toString());
            super.setSinceVersion("10.1.2");
            super.setDescription("A dummy module component");
        }

        protected void executeInternal() throws Throwable {
            ++ModuleComponentHelperTest.this.executed;
        }
    }

    private class DummyModuleService
    implements ModuleService {
        private ModuleVersionNumber currentVersion;

        private DummyModuleService() {
        }

        public void setCurrentVersion(ModuleVersionNumber currentVersion) {
            this.currentVersion = currentVersion;
        }

        public void registerComponent(ModuleComponent component) {
            throw new UnsupportedOperationException();
        }

        public List<ModuleDetails> getAllModules() {
            ModuleComponentHelperTest.this.executed = 0;
            ArrayList<ModuleDetails> details = new ArrayList<ModuleDetails>(3);
            int i = 0;
            while (i < 3) {
                ModuleDetailsImpl moduleDetails = new ModuleDetailsImpl(ModuleComponentHelperTest.this.MODULE_IDS[i], this.currentVersion, "Module-" + i, "Description-" + i);
                details.add((ModuleDetails)moduleDetails);
                ++i;
            }
            return details;
        }

        public ModuleDetails getModule(String moduleId) {
            int i = 0;
            while (i < ModuleComponentHelperTest.this.MODULE_IDS.length) {
                if (ModuleComponentHelperTest.this.MODULE_IDS[i].equals(moduleId)) {
                    new ModuleDetailsImpl(ModuleComponentHelperTest.this.MODULE_IDS[i], this.currentVersion, "Module-" + i, "Description-" + i);
                }
                ++i;
            }
            return null;
        }

        public void startModules() {
            throw new UnsupportedOperationException();
        }

        public List<ModuleDetails> getMissingModules() {
            ArrayList<ModuleDetails> details = new ArrayList<ModuleDetails>(3);
            int i = 0;
            while (i < 3) {
                ModuleDetailsImpl moduleDetails = new ModuleDetailsImpl(ModuleComponentHelperTest.this.MODULE_IDS[i], this.currentVersion, "", "");
                details.add((ModuleDetails)moduleDetails);
                ++i;
            }
            return details;
        }

        public void shutdownModules() {
            throw new UnsupportedOperationException();
        }
    }

    public static class NoopModuleComponent
    extends AbstractModuleComponent {
        protected void executeInternal() throws Throwable {
        }
    }
}

