/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.person;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.util.PropertyMap;

public class TestPersonManager {
    private static final String ORGANISATION_SUFFIX = "Organisation";
    private static final String JOB_SUFFIX = "JobTitle";
    private static final String EMAIL_SUFFIX = "@email.com";
    private static final String LAST_NAME_SUFFIX = "LastName";
    private static final String FIRST_NAME_SUFFIX = "FirstName";
    private final MutableAuthenticationService authenticationService;
    private final PersonService personService;
    private final NodeService nodeService;
    private final Map<String, NodeRef> people = new HashMap<String, NodeRef>();

    public TestPersonManager(MutableAuthenticationService authenticationService, PersonService personService, NodeService nodeService) {
        this.authenticationService = authenticationService;
        this.personService = personService;
        this.nodeService = nodeService;
    }

    public NodeRef createPerson(final String userName) {
        return (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                if (!TestPersonManager.this.authenticationService.authenticationExists(userName)) {
                    TestPersonManager.this.authenticationService.createAuthentication(userName, "password".toCharArray());
                    return TestPersonManager.this.makePersonNode(userName);
                }
                NodeRef personRef = TestPersonManager.this.personService.getPerson(userName);
                if (personRef != null) {
                    TestPersonManager.this.people.put(userName, personRef);
                }
                return personRef;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    public void deletePerson(final String userName) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                TestPersonManager.this.personService.deletePerson(userName);
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        this.people.remove(userName);
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    private NodeRef makePersonNode(String userName) {
        PropertyMap personProps = TestPersonManager.makePersonProperties(userName);
        NodeRef person = this.personService.createPerson((Map)personProps);
        this.people.put(userName, person);
        return person;
    }

    public static PropertyMap makePersonProperties(String userName) {
        PropertyMap personProps = new PropertyMap();
        personProps.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
        personProps.put((Object)ContentModel.PROP_FIRSTNAME, (Object)(userName + FIRST_NAME_SUFFIX));
        personProps.put((Object)ContentModel.PROP_LASTNAME, (Object)(userName + LAST_NAME_SUFFIX));
        personProps.put((Object)ContentModel.PROP_EMAIL, (Object)(userName + EMAIL_SUFFIX));
        personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)(userName + JOB_SUFFIX));
        personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)(userName + ORGANISATION_SUFFIX));
        return personProps;
    }

    public NodeRef get(String userName) {
        NodeRef person = this.people.get(userName);
        if (person != null) {
            return person;
        }
        throw new IllegalArgumentException("Cannot get user as unregistered person:" + userName);
    }

    public void setUser(String userName) {
        if (!this.people.containsKey(userName)) {
            throw new IllegalArgumentException("Cannot set user as unregistered person: " + userName);
        }
        AuthenticationUtil.setFullyAuthenticatedUser((String)userName);
    }

    public void clearPeople() {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                for (String user : TestPersonManager.this.people.keySet()) {
                    TestPersonManager.this.personService.deletePerson(user);
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    public String getFirstName(String userName) {
        NodeRef person = this.get(userName);
        return (String)((Object)this.nodeService.getProperty(person, ContentModel.PROP_FIRSTNAME));
    }

    public String getLastName(String userName) {
        NodeRef person = this.get(userName);
        return (String)((Object)this.nodeService.getProperty(person, ContentModel.PROP_LASTNAME));
    }
}

