/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.tagging;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.event2.EventGenerator;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.tagging.TaggingServiceImpl;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.DuplicateChildNodeNameException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.CategoryService;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TaggingServiceImplUnitTest {
    private static final String TAG_ID = "tag-node-id";
    private static final String TAG_NAME = "tag-dummy-name";
    private static final NodeRef TAG_NODE_REF = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "tag-node-id");
    private static final NodeRef CONTENT_NODE_REF = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "content-id");
    @Mock
    private NodeService nodeServiceMock;
    @Mock
    private CategoryService categoryServiceMock;
    @Mock
    private PolicyComponent policyComponentMock;
    @Mock
    private SearchService searchServiceMock;
    @Mock
    private ResultSet resultSetMock;
    @Mock(extraInterfaces={List.class})
    private Serializable currentTagsMock;
    @Mock
    private EventGenerator eventGenerator;
    @InjectMocks
    private TaggingServiceImpl taggingService;

    @Before
    public void setUp() throws Exception {
        AlfrescoTransactionSupport.bindResource((Object)"tagUpdates", new HashMap());
        this.taggingService.init();
    }

    @Test
    public void testCreateTags() {
        ChildAssociationRef tagAssociationMock = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        BDDMockito.given((Object)this.categoryServiceMock.getRootCategories((StoreRef)ArgumentMatchers.any(), (QName)ArgumentMatchers.any(), (String)ArgumentMatchers.any(String.class), ArgumentMatchers.eq((boolean)true))).willReturn(List.of(tagAssociationMock));
        BDDMockito.given((Object)tagAssociationMock.getChildRef()).willReturn((Object)TAG_NODE_REF);
        List actualTagPairs = this.taggingService.createTags(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, List.of(TAG_NAME));
        ((CategoryService)BDDMockito.then((Object)this.categoryServiceMock).should()).getRootCategories(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, ContentModel.ASPECT_TAGGABLE, TAG_NAME, false);
        ((CategoryService)BDDMockito.then((Object)this.categoryServiceMock).should()).getRootCategories(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, ContentModel.ASPECT_TAGGABLE, TAG_NAME, true);
        BDDMockito.then((Object)this.categoryServiceMock).shouldHaveNoMoreInteractions();
        List<Pair> expectedTagPairs = List.of(new Pair((Object)TAG_NAME, (Object)TAG_NODE_REF));
        ((ListAssert)Assertions.assertThat((List)actualTagPairs).isNotNull()).isEqualTo(expectedTagPairs);
    }

    @Test
    public void testCreateTags_whileTagAlreadyExists() {
        BDDMockito.given((Object)this.categoryServiceMock.getRootCategories((StoreRef)ArgumentMatchers.any(), (QName)ArgumentMatchers.any(), (String)ArgumentMatchers.any(String.class), ArgumentMatchers.eq((boolean)false))).willThrow(new Throwable[]{new DuplicateChildNodeNameException(null, null, null, null)});
        Throwable actualException = Assertions.catchThrowable(() -> {
            List list = this.taggingService.createTags(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, List.of(TAG_NAME));
        });
        ((CategoryService)BDDMockito.then((Object)this.categoryServiceMock).should()).getRootCategories(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, ContentModel.ASPECT_TAGGABLE, TAG_NAME, false);
        BDDMockito.then((Object)this.categoryServiceMock).shouldHaveNoMoreInteractions();
        Assertions.assertThat((Throwable)actualException).isInstanceOf(DuplicateChildNodeNameException.class);
    }

    @Test
    public void testChangeTag() {
        BDDMockito.given((Object)this.categoryServiceMock.getRootCategories(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, ContentModel.ASPECT_TAGGABLE, TAG_NAME, false)).willReturn(TaggingServiceImplUnitTest.childAssociationsOf(TAG_NODE_REF));
        BDDMockito.given((Object)this.searchServiceMock.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "lucene", "+PATH:\"/cm:taggable/cm:tag-dummy-name/member\"")).willReturn((Object)this.resultSetMock);
        BDDMockito.given((Object)this.resultSetMock.getNodeRefs()).willReturn(List.of(CONTENT_NODE_REF));
        this.taggingService.changeTag(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, TAG_NAME, "new-tag-name");
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).setProperty(TAG_NODE_REF, ContentModel.PROP_NAME, (Serializable)((Object)"new-tag-name"));
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).moveNode(TAG_NODE_REF, TaggingService.TAG_ROOT_NODE_REF, ContentModel.ASSOC_SUBCATEGORIES, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"new-tag-name"));
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getProperties(CONTENT_NODE_REF);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).hasAspect(CONTENT_NODE_REF, ContentModel.ASPECT_TAGSCOPE);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getPrimaryParent(CONTENT_NODE_REF);
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoMoreInteractions();
        ((EventGenerator)BDDMockito.then((Object)this.eventGenerator).should()).onUpdateProperties((NodeRef)ArgumentMatchers.eq((Object)CONTENT_NODE_REF), (Map)ArgumentMatchers.eq(Collections.emptyMap()), (Map)ArgumentMatchers.any());
        BDDMockito.then((Object)this.eventGenerator).shouldHaveNoMoreInteractions();
    }

    private static List<ChildAssociationRef> childAssociationsOf(NodeRef ... childNodeRefs) {
        return Arrays.stream(childNodeRefs).map(childNodeRef -> new ChildAssociationRef(null, null, null, childNodeRef)).collect(Collectors.toList());
    }
}

