/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.activities.post.cleanup;

import java.sql.SQLException;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.domain.activities.ActivityPostDAO;
import org.alfresco.repo.domain.activities.ActivityPostEntity;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.VmShutdownListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobExecutionException;

public class PostCleaner {
    private static Log logger = LogFactory.getLog(PostCleaner.class);
    private static VmShutdownListener vmShutdownListener = new VmShutdownListener(PostCleaner.class.getName());
    private int maxAgeMins = 0;
    private ActivityPostDAO postDAO;
    private JobLockService jobLockService;
    private static final long LOCK_TTL = 60000L;
    private static final QName LOCK_QNAME = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"org.alfresco.repo.activities.post.cleanup.PostCleaner");

    public void setPostDAO(ActivityPostDAO postDAO) {
        this.postDAO = postDAO;
    }

    public void setMaxAgeMins(int mins) {
        this.maxAgeMins = mins;
    }

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    public void init() {
        this.checkProperties();
    }

    private void checkProperties() {
        PropertyCheck.mandatory((Object)this, (String)"postDAO", (Object)this.postDAO);
        PropertyCheck.mandatory((Object)this, (String)"jobLockService", (Object)this.jobLockService);
        if (this.maxAgeMins <= 0) {
            throw new AlfrescoRuntimeException("Property 'maxAgeMins' must be greater than 0");
        }
    }

    public void execute() throws JobExecutionException {
        final AtomicBoolean keepGoing = new AtomicBoolean(true);
        String lockToken = null;
        try {
            try {
                lockToken = this.jobLockService.getLock(LOCK_QNAME, 60000L);
                JobLockService.JobLockRefreshCallback callback = new JobLockService.JobLockRefreshCallback(){

                    @Override
                    public void lockReleased() {
                        keepGoing.set(false);
                    }

                    @Override
                    public boolean isActive() {
                        return keepGoing.get();
                    }
                };
                this.jobLockService.refreshLock(lockToken, LOCK_QNAME, 60000L, callback);
                this.executeWithLock();
            }
            catch (LockAcquisitionException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Skipping post cleaning.  " + e.getMessage()));
                }
                keepGoing.set(false);
                if (lockToken != null) {
                    this.jobLockService.releaseLock(lockToken, LOCK_QNAME);
                }
            }
        }
        finally {
            keepGoing.set(false);
            if (lockToken != null) {
                this.jobLockService.releaseLock(lockToken, LOCK_QNAME);
            }
        }
    }

    public void executeWithLock() throws JobExecutionException {
        block4: {
            this.checkProperties();
            try {
                long nowTimeOffset = new Date().getTime();
                long keepTimeOffset = nowTimeOffset - (long)(this.maxAgeMins * 60 * 1000);
                Date keepDate = new Date(keepTimeOffset);
                int deletedCount = this.postDAO.deletePosts(keepDate, ActivityPostEntity.STATUS.PROCESSED);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Cleaned " + deletedCount + " entries (upto " + String.valueOf(keepDate) + ", max age " + this.maxAgeMins + " mins)"));
                }
            }
            catch (SQLException e) {
                logger.error((Object)"Exception during cleanup of posts", (Throwable)e);
                throw new JobExecutionException((Throwable)e);
            }
            catch (Throwable e) {
                if (vmShutdownListener.isVmShuttingDown()) break block4;
                logger.error((Object)"Exception during cleanup of posts", e);
            }
        }
    }
}

