/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.alfresco.repo.dictionary.CompiledModelsCache;
import org.alfresco.repo.dictionary.DictionaryBootstrap;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.DictionaryDAOImpl;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.MultiTServiceImpl;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.util.DynamicallySizedThreadPoolExecutor;
import org.alfresco.util.TraceableThreadFactory;
import org.alfresco.util.cache.AsynchronouslyRefreshedCacheRegistry;
import org.alfresco.util.cache.DefaultAsynchronouslyRefreshedCacheRegistry;
import org.alfresco.util.testing.category.NeverRunsTests;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.extensions.surf.util.I18NUtil;

@Category(value={NeverRunsTests.class})
public class DictionaryLoadDAOTest {
    public static final String TEST_RESOURCE_MESSAGES = "alfresco/messages/dictionary-messages";
    private DictionaryDAOImpl dictionaryDAO;

    @Before
    public void setUp() throws Exception {
        I18NUtil.registerResourceBundle((String)TEST_RESOURCE_MESSAGES);
        MultiTServiceImpl tenantService = new MultiTServiceImpl();
        this.dictionaryDAO = new DictionaryDAOImpl();
        this.dictionaryDAO.setTenantService((TenantService)tenantService);
        this.initDictionaryCaches(this.dictionaryDAO, (TenantService)tenantService);
        new AuthenticationUtil().afterPropertiesSet();
        DictionaryBootstrap bootstrap = new DictionaryBootstrap();
        ArrayList<String> bootstrapModels = new ArrayList<String>();
        bootstrapModels.add("alfresco/model/dictionaryModel.xml");
        bootstrapModels.add("alfresco/model/systemModel.xml");
        bootstrapModels.add("alfresco/model/contentModel.xml");
        bootstrapModels.add("org/alfresco/repo/security/authentication/userModel.xml");
        bootstrapModels.add("alfresco/model/bpmModel.xml");
        bootstrapModels.add("alfresco/model/wcmModel.xml");
        bootstrapModels.add("alfresco/model/forumModel.xml");
        bootstrapModels.add("alfresco/model/imapModel.xml");
        bootstrapModels.add("alfresco/model/transferModel.xml");
        bootstrapModels.add("alfresco/model/applicationModel.xml");
        bootstrapModels.add("alfresco/model/wcmAppModel.xml");
        bootstrapModels.add("org/alfresco/repo/action/actionModel.xml");
        bootstrapModels.add("org/alfresco/repo/rule/ruleModel.xml");
        bootstrapModels.add("org/alfresco/repo/version/version_model.xml");
        bootstrapModels.add("org/alfresco/repo/version/version2_model.xml");
        bootstrapModels.add("alfresco/model/emailServerModel.xml");
        bootstrapModels.add("alfresco/model/calendarModel.xml");
        bootstrapModels.add("alfresco/model/deprecated/blogIntegrationModel.xml");
        bootstrapModels.add("alfresco/model/linksModel.xml");
        bootstrapModels.add("alfresco/model/remoteCredentialsModel.xml");
        bootstrapModels.add("alfresco/model/datalistModel.xml");
        bootstrapModels.add("alfresco/model/quickShareModel.xml");
        bootstrapModels.add("alfresco/model/surfModel.xml");
        bootstrapModels.add("alfresco/model/siteModel.xml");
        ArrayList labels = new ArrayList();
        bootstrap.setModels(bootstrapModels);
        bootstrap.setLabels(labels);
        bootstrap.setDictionaryDAO((DictionaryDAO)this.dictionaryDAO);
        bootstrap.setTenantService((TenantService)tenantService);
        bootstrap.bootstrap();
    }

    private void initDictionaryCaches(DictionaryDAOImpl dictionaryDAO, TenantService tenantService) throws Exception {
        CompiledModelsCache compiledModelsCache = new CompiledModelsCache();
        compiledModelsCache.setDictionaryDAO(dictionaryDAO);
        compiledModelsCache.setTenantService(tenantService);
        compiledModelsCache.setRegistry((AsynchronouslyRefreshedCacheRegistry)new DefaultAsynchronouslyRefreshedCacheRegistry());
        TraceableThreadFactory threadFactory = new TraceableThreadFactory();
        threadFactory.setThreadDaemon(true);
        threadFactory.setThreadPriority(5);
        DynamicallySizedThreadPoolExecutor threadPoolExecutor = new DynamicallySizedThreadPoolExecutor(20, 20, 90L, TimeUnit.SECONDS, new LinkedBlockingQueue(), (ThreadFactory)threadFactory, (RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        compiledModelsCache.setThreadPoolExecutor((ThreadPoolExecutor)threadPoolExecutor);
        dictionaryDAO.setDictionaryRegistryCache(compiledModelsCache);
        dictionaryDAO.init();
    }

    @Test
    public void test1() {
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                DictionaryLoadDAOTest.this.dictionaryDAO.init();
                return null;
            }
        }, (String)"user1", (String)"tenant1");
    }
}

