/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.jscript.ScriptFacetResult;
import org.alfresco.repo.jscript.Search;
import org.alfresco.repo.search.impl.solr.facet.SolrFacetHelper;
import org.alfresco.repo.search.impl.solr.facet.handler.AbstractFacetLabelDisplayHandler;
import org.alfresco.repo.search.impl.solr.facet.handler.FacetLabel;
import org.alfresco.repo.search.impl.solr.facet.handler.FacetLabelDisplayHandlerRegistry;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.search.QueryConsistency;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.util.Pair;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ScriptSearchTest {
    private Search SEARCH_SCRIPT;
    private String fieldFacet1;
    private String fieldFacet2;
    private String mimetype1;
    private String mimetype2;
    private String modifier;
    private String TXT_LABEL = "TXT";
    private String PDF_LABEL = "PDF";

    @Before
    public void init() {
        this.fieldFacet1 = "mimetype";
        this.fieldFacet2 = "modifier";
        this.mimetype1 = "pdf";
        this.mimetype2 = "txt";
        this.modifier = "administrator";
        this.SEARCH_SCRIPT = new Search();
        this.SEARCH_SCRIPT.setServiceRegistry(this.mockServiceRegistry());
    }

    private ServiceRegistry mockServiceRegistry() {
        SearchService searchService = (SearchService)Mockito.mock(SearchService.class);
        ResultSet results = (ResultSet)Mockito.mock(ResultSet.class);
        ArrayList<Pair> fieldFacets1 = new ArrayList<Pair>();
        fieldFacets1.add(new Pair((Object)this.mimetype1, (Object)1));
        fieldFacets1.add(new Pair((Object)this.mimetype2, (Object)2));
        ArrayList<Pair> fieldFacets2 = new ArrayList<Pair>();
        fieldFacets2.add(new Pair((Object)this.modifier, (Object)1));
        Mockito.when((Object)results.getFieldFacet(this.fieldFacet1)).thenReturn(fieldFacets1);
        Mockito.when((Object)results.getFieldFacet(this.fieldFacet2)).thenReturn(fieldFacets2);
        Mockito.when((Object)results.getFacetQueries()).thenReturn(new HashMap());
        Mockito.when((Object)searchService.query((SearchParameters)ArgumentMatchers.any())).thenReturn((Object)results);
        FacetLabelDisplayHandlerRegistry displayHandlerRegistry = (FacetLabelDisplayHandlerRegistry)Mockito.mock(FacetLabelDisplayHandlerRegistry.class);
        ServiceRegistry services = (ServiceRegistry)Mockito.mock(ServiceRegistry.class);
        Mockito.when((Object)services.getSearchService()).thenReturn((Object)searchService);
        Mockito.when((Object)displayHandlerRegistry.getDisplayHandler(this.fieldFacet1)).thenReturn((Object)new MimetypeOrderDisplayHandler());
        Mockito.when((Object)displayHandlerRegistry.getDisplayHandler(this.fieldFacet2)).thenReturn(null);
        SolrFacetHelper solrFacetHelper = (SolrFacetHelper)Mockito.mock(SolrFacetHelper.class);
        Mockito.when((Object)solrFacetHelper.getBucketedFieldFacets()).thenReturn(new HashSet());
        Mockito.when((Object)services.getSolrFacetHelper()).thenReturn((Object)solrFacetHelper);
        Mockito.when((Object)services.getFacetLabelDisplayHandlerRegistry()).thenReturn((Object)displayHandlerRegistry);
        return services;
    }

    @Test
    public void testSearchFacetDisplayHandlerCustom() throws Exception {
        SearchParameters sp = new SearchParameters();
        sp.setLanguage("afts");
        sp.setQueryConsistency(QueryConsistency.EVENTUAL);
        sp.addFieldFacet(new SearchParameters.FieldFacet(this.fieldFacet1));
        sp.addFieldFacet(new SearchParameters.FieldFacet(this.fieldFacet2));
        Pair results = this.SEARCH_SCRIPT.queryResultMeta(sp, false);
        Map facets = (Map)((Map)results.getSecond()).get("facets");
        List mimetypes = (List)facets.get(this.fieldFacet1);
        List modifiers = (List)facets.get(this.fieldFacet2);
        assert (mimetypes.size() == 2);
        assert (modifiers.size() == 1);
        ScriptFacetResult pdf = (ScriptFacetResult)mimetypes.get(0);
        ScriptFacetResult txt = (ScriptFacetResult)mimetypes.get(1);
        ScriptFacetResult admin = (ScriptFacetResult)modifiers.get(0);
        assert (txt.getFacetLabelIndex() == 1);
        assert (txt.getFacetLabel().equals(this.TXT_LABEL));
        assert (pdf.getFacetLabelIndex() == 3);
        assert (pdf.getFacetLabel().equals(this.PDF_LABEL));
        assert (admin.getFacetLabelIndex() == -1);
        assert (admin.getFacetLabel() == this.modifier);
    }

    private class MimetypeOrderDisplayHandler
    extends AbstractFacetLabelDisplayHandler {
        private MimetypeOrderDisplayHandler() {
        }

        public FacetLabel getDisplayLabel(String value) {
            Integer order;
            return new FacetLabel(value, switch (value) {
                case "txt" -> {
                    order = 1;
                    yield ScriptSearchTest.this.TXT_LABEL;
                }
                case "pdf" -> {
                    order = 3;
                    yield ScriptSearchTest.this.PDF_LABEL;
                }
                default -> {
                    order = 100;
                    yield value;
                }
            }, order.intValue());
        }
    }
}

