/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.version.common.versionlabel;

import java.util.HashMap;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.version.common.VersionImpl;
import org.alfresco.repo.version.common.versionlabel.SerialVersionLabelPolicy;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionType;

public class SerialVersionLabelPolicyTest
extends TestCase {
    public void testGetVersionLabelValue() {
        SerialVersionLabelPolicy policy = new SerialVersionLabelPolicy();
        NodeRef dummyNodeRef = new NodeRef(new StoreRef("", ""), "");
        HashMap<String, VersionType> versionProp1 = new HashMap<String, VersionType>();
        versionProp1.put("versionType", VersionType.MINOR);
        String initialVersion = policy.calculateVersionLabel(ContentModel.TYPE_CMOBJECT, null, 0, versionProp1);
        SerialVersionLabelPolicyTest.assertEquals((String)"Minor initial version not 0.1", (String)"0.1", (String)initialVersion);
        HashMap<String, String> versionProp2 = new HashMap<String, String>();
        versionProp2.put("versionLabel", "1.0");
        VersionImpl version1 = new VersionImpl(versionProp2, dummyNodeRef);
        String verisonLabel1 = policy.calculateVersionLabel(ContentModel.TYPE_CMOBJECT, (Version)version1, 1, versionProp1);
        SerialVersionLabelPolicyTest.assertEquals((String)"Minor update from 1.0 not correct", (String)"1.1", (String)verisonLabel1);
        HashMap<String, String> versionProp3 = new HashMap<String, String>();
        versionProp3.put("versionLabel", "1.1");
        VersionImpl version2 = new VersionImpl(versionProp3, dummyNodeRef);
        HashMap<String, VersionType> versionProp4 = new HashMap<String, VersionType>();
        versionProp4.put("versionType", VersionType.MAJOR);
        String verisonLabel2 = policy.calculateVersionLabel(ContentModel.TYPE_CMOBJECT, (Version)version2, 1, versionProp4);
        SerialVersionLabelPolicyTest.assertEquals((String)"major version update not correct", (String)"2.0", (String)verisonLabel2);
    }
}

