/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp.validator;

import java.util.ArrayList;
import java.util.regex.Pattern;
import org.alfresco.repo.domain.dialect.Dialect;
import org.alfresco.repo.domain.dialect.Oracle9Dialect;
import org.alfresco.util.schemacomp.DiffContext;
import org.alfresco.util.schemacomp.Results;
import org.alfresco.util.schemacomp.ValidationResult;
import org.alfresco.util.schemacomp.model.DbObject;
import org.alfresco.util.schemacomp.model.Index;
import org.alfresco.util.schemacomp.validator.NameValidator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NameValidatorTest {
    private NameValidator validator;
    private DiffContext ctx;
    private Results validationResults;

    @Before
    public void setUp() throws Exception {
        this.validator = new NameValidator();
        this.validationResults = new Results();
        this.ctx = new DiffContext((Dialect)new Oracle9Dialect(), this.validationResults, null, null);
    }

    @Test
    public void canSpecifyDefaultRequiredPattern() {
        this.validator.setPattern(Pattern.compile("SYS_[A-Z_]+"));
        this.validator.validate(null, this.indexForName("SYS_MYINDEX"), this.ctx);
        this.validator.validate(null, this.indexForName("SYS_"), this.ctx);
        this.validator.validate(null, this.indexForName("SYS_MY_INDEX"), this.ctx);
        this.validator.validate(null, this.indexForName("MY_INDEX"), this.ctx);
        Assert.assertEquals((long)2L, (long)this.validationResults.size());
        Assert.assertEquals((Object)"SYS_", (Object)((ValidationResult)this.validationResults.get(0)).getValue());
        Assert.assertEquals((Object)"MY_INDEX", (Object)((ValidationResult)this.validationResults.get(1)).getValue());
    }

    @Test
    public void canValidateAgainstPatternForDialect() {
        this.validator.setPattern(Pattern.compile("ORA_[A-Z_]+"));
        this.validator.validate(null, this.indexForName("ORA_MYINDEX"), this.ctx);
        this.validator.validate(null, this.indexForName("SYS_MYINDEX"), this.ctx);
        Assert.assertEquals((long)1L, (long)this.validationResults.size());
        Assert.assertEquals((Object)"SYS_MYINDEX", (Object)((ValidationResult)this.validationResults.get(0)).getValue());
    }

    @Test
    public void canSetPatternUsingProperties() {
        this.validator.setProperty("pattern", "ORA_[A-Z_]+");
        Assert.assertEquals((Object)"ORA_[A-Z_]+", (Object)this.validator.getPattern().toString());
    }

    private DbObject indexForName(String name) {
        return new Index(null, name, new ArrayList());
    }
}

