/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.audit.model;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.ValidationEvent;
import jakarta.xml.bind.ValidationEventHandler;
import jakarta.xml.bind.ValidationEventLocator;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.error.ExceptionStackUtil;
import org.alfresco.repo.audit.model.AuditApplication;
import org.alfresco.repo.audit.model.AuditModelException;
import org.alfresco.repo.audit.model.AuditModelRegistry;
import org.alfresco.repo.audit.model._3.Application;
import org.alfresco.repo.audit.model._3.Audit;
import org.alfresco.repo.audit.model._3.DataExtractor;
import org.alfresco.repo.audit.model._3.DataExtractors;
import org.alfresco.repo.audit.model._3.DataGenerator;
import org.alfresco.repo.audit.model._3.DataGenerators;
import org.alfresco.repo.audit.model._3.ObjectFactory;
import org.alfresco.repo.audit.model._3.PathMap;
import org.alfresco.repo.audit.model._3.PathMappings;
import org.alfresco.repo.domain.audit.AuditDAO;
import org.alfresco.repo.management.subsystems.AbstractPropertyBackedBean;
import org.alfresco.repo.management.subsystems.PropertyBackedBeanState;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.PathMapper;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.ResourceFinder;
import org.alfresco.util.registry.NamedObjectRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.ResourceUtils;
import org.xml.sax.SAXParseException;

public class AuditModelRegistryImpl
extends AbstractPropertyBackedBean
implements AuditModelRegistry {
    public static final String PROPERTY_AUDIT_ENABLED = "audit.enabled";
    private static final String AUDITING_TO_DATABASE = ".auditingToDatabase";
    private static final String AUDITING_TO_AUDIT_STORAGE = ".auditingToAuditStorage";
    public static final String PROPERTY_AUDIT_CONFIG_STRICT = "audit.config.strict";
    private static final String AUDIT_SCHEMA_LOCATION = "classpath:alfresco/audit/alfresco-audit-3.2.xsd";
    private static final Log logger = LogFactory.getLog(AuditModelRegistryImpl.class);
    private String[] searchPath;
    private TransactionService transactionService;
    private AuditDAO auditDAO;
    private NamedObjectRegistry<org.alfresco.repo.audit.extractor.DataExtractor> dataExtractors;
    private NamedObjectRegistry<org.alfresco.repo.audit.generator.DataGenerator> dataGenerators;
    private final ObjectFactory objectFactory = new ObjectFactory();

    public void setSearchPath(String[] searchPath) {
        this.searchPath = searchPath;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setAuditDAO(AuditDAO auditDAO) {
        this.auditDAO = auditDAO;
    }

    public void setDataExtractors(NamedObjectRegistry<org.alfresco.repo.audit.extractor.DataExtractor> dataExtractors) {
        this.dataExtractors = dataExtractors;
    }

    public void setDataGenerators(NamedObjectRegistry<org.alfresco.repo.audit.generator.DataGenerator> dataGenerators) {
        this.dataGenerators = dataGenerators;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"searchPath", (Object)this.searchPath);
        PropertyCheck.mandatory((Object)this, (String)"transactionService", (Object)this.transactionService);
        PropertyCheck.mandatory((Object)this, (String)"auditDAO", (Object)this.auditDAO);
        PropertyCheck.mandatory((Object)this, (String)"dataExtractors", this.dataExtractors);
        PropertyCheck.mandatory((Object)this, (String)"dataGenerators", this.dataGenerators);
        super.afterPropertiesSet();
    }

    @Override
    public Map<String, AuditApplication> getAuditApplications() {
        this.lock.readLock().lock();
        try {
            Map<String, AuditApplication> map = ((AuditModelRegistryState)this.getState(true)).getAuditApplications();
            return map;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public AuditApplication getAuditApplicationByKey(String key) {
        this.lock.readLock().lock();
        try {
            AuditApplication auditApplication = ((AuditModelRegistryState)this.getState(true)).getAuditApplicationByKey(key);
            return auditApplication;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public AuditApplication getAuditApplicationByName(String applicationName) {
        this.lock.readLock().lock();
        try {
            AuditApplication auditApplication = ((AuditModelRegistryState)this.getState(true)).getAuditApplicationByName(applicationName);
            return auditApplication;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public PathMapper getAuditPathMapper() {
        this.lock.readLock().lock();
        try {
            PathMapper pathMapper = ((AuditModelRegistryState)this.getState(true)).getAuditPathMapper();
            return pathMapper;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void loadAuditModels() {
        this.stop();
        this.start();
    }

    @Override
    public boolean isAuditEnabled() {
        String value = this.getProperty(PROPERTY_AUDIT_ENABLED);
        return value != null && value.equalsIgnoreCase("true");
    }

    @Override
    public boolean isAuditingToDatabaseEnabled() {
        String value = this.getProperty("audit.enabled.auditingToDatabase");
        return value == null || value.equalsIgnoreCase("true");
    }

    @Override
    public boolean isAuditingToAuditStorageEnabled() {
        String value = this.getProperty("audit.enabled.auditingToAuditStorage");
        return value != null && value.equalsIgnoreCase("true");
    }

    public void registerModel(URL auditModelUrl) {
        this.lock.writeLock().lock();
        try {
            this.stop();
            this.setProperty(PROPERTY_AUDIT_ENABLED, "true");
            ((AuditModelRegistryState)this.getState(false)).registerModel(auditModelUrl);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    protected PropertyBackedBeanState createInitialState() throws IOException {
        return new AuditModelRegistryState();
    }

    public static Audit unmarshallModel(URL configUrl) {
        try {
            BufferedInputStream is = new BufferedInputStream(configUrl.openStream());
            return AuditModelRegistryImpl.unmarshallModel(is, configUrl.toString());
        }
        catch (IOException e) {
            throw new AlfrescoRuntimeException("The Audit model XML failed to load: " + String.valueOf(configUrl), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Audit unmarshallModel(InputStream is, final String source) {
        Audit audit2;
        Unmarshaller jaxbUnmarshaller;
        try {
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = sf.newSchema(ResourceUtils.getURL((String)AUDIT_SCHEMA_LOCATION));
            JAXBContext jaxbCtx = JAXBContext.newInstance((String)"org.alfresco.repo.audit.model._3");
            jaxbUnmarshaller = jaxbCtx.createUnmarshaller();
            jaxbUnmarshaller.setSchema(schema);
            jaxbUnmarshaller.setEventHandler(new ValidationEventHandler(){

                public boolean handleEvent(ValidationEvent ve) {
                    if (ve.getSeverity() == 2 || ve.getSeverity() == 1) {
                        ValidationEventLocator locator = ve.getLocator();
                        logger.error((Object)("Invalid Audit XML: \n   Source:   " + source + "\n   Location: Line " + locator.getLineNumber() + " column " + locator.getColumnNumber() + "\n   Error:    " + ve.getMessage()));
                    }
                    return false;
                }
            });
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("Failed to load Alfresco Audit Schema from classpath:alfresco/audit/alfresco-audit-3.2.xsd", e);
        }
        try {
            Audit audit;
            JAXBElement auditElement = (JAXBElement)jaxbUnmarshaller.unmarshal(is);
            audit2 = audit = (Audit)auditElement.getValue();
        }
        catch (Throwable e) {
            try {
                Throwable saxError = ExceptionStackUtil.getCause((Throwable)e, (Class[])new Class[]{SAXParseException.class});
                if (saxError == null) throw new AuditModelException("Failed to read Audit model XML: \n   Source: " + source + "\n   Error:  " + e.getMessage());
                e = saxError;
                throw new AuditModelException("Failed to read Audit model XML: \n   Source: " + source + "\n   Error:  " + e.getMessage());
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            is.close();
            return audit2;
        }
        catch (IOException iOException) {}
        return audit2;
    }

    public class AuditModelRegistryState
    implements PropertyBackedBeanState {
        private final Map<URL, Audit> auditModels = new LinkedHashMap<URL, Audit>(7);
        private PathMapper auditPathMapper;
        private Map<String, AuditApplication> auditApplicationsByKey;
        private Map<String, AuditApplication> auditApplicationsByName;
        private final Map<String, Boolean> properties = new HashMap<String, Boolean>(7);

        public AuditModelRegistryState() {
            this.properties.put(AuditModelRegistryImpl.PROPERTY_AUDIT_ENABLED, false);
            this.properties.put("audit.enabled.auditingToDatabase", true);
            this.properties.put("audit.enabled.auditingToAuditStorage", false);
            ResourceFinder resourceFinder = new ResourceFinder((ResourceLoader)AuditModelRegistryImpl.this.getParent());
            try {
                Resource[] resourceArray = resourceFinder.getResources(AuditModelRegistryImpl.this.searchPath);
                int n = resourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Resource resource = resourceArray[n2];
                    this.registerModel(resource.getURL());
                    ++n2;
                }
            }
            catch (IOException e) {
                throw new AlfrescoRuntimeException("Failed to find audit resources", (Throwable)e);
            }
        }

        public void registerModel(URL auditModelUrl) {
            try {
                if (this.auditModels.containsKey(auditModelUrl)) {
                    logger.warn((Object)("An audit model has already been registered at URL " + String.valueOf(auditModelUrl)));
                }
                Audit audit = AuditModelRegistryImpl.unmarshallModel(auditModelUrl);
                this.auditModels.put(auditModelUrl, audit);
                List<Application> applications = audit.getApplication();
                for (Application application : applications) {
                    this.properties.put(this.getEnabledProperty(application.getKey()), true);
                }
            }
            catch (Throwable e) {
                throw new AuditModelException("Failed to load audit model: " + String.valueOf(auditModelUrl), e);
            }
        }

        private String getEnabledProperty(String key) {
            return "audit." + key.toLowerCase() + ".enabled";
        }

        private boolean isApplicationEnabled(String key) {
            Boolean enabled = this.properties.get(this.getEnabledProperty(key));
            return enabled != null && enabled != false;
        }

        @Override
        public String getProperty(String name) {
            return String.valueOf(this.properties.get(name));
        }

        @Override
        public Set<String> getPropertyNames() {
            return this.properties.keySet();
        }

        @Override
        public void setProperty(String name, String value) {
            this.properties.put(name, Boolean.parseBoolean(value));
        }

        @Override
        public void removeProperty(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void start() {
            this.auditApplicationsByKey = new TreeMap<String, AuditApplication>();
            this.auditApplicationsByName = new TreeMap<String, AuditApplication>();
            this.auditPathMapper = new PathMapper();
            Boolean enabled = this.properties.get(AuditModelRegistryImpl.PROPERTY_AUDIT_ENABLED);
            if (enabled != null && enabled.booleanValue()) {
                final RetryingTransactionHelper.RetryingTransactionCallback<Void> loadModelsCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                    @Override
                    public Void execute() throws Throwable {
                        for (Map.Entry<URL, Audit> entry : AuditModelRegistryState.this.auditModels.entrySet()) {
                            URL auditModelUrl = entry.getKey();
                            Audit audit = entry.getValue();
                            try {
                                Long auditModelId = (Long)((AuditModelRegistryState)AuditModelRegistryState.this).AuditModelRegistryImpl.this.auditDAO.getOrCreateAuditModel(auditModelUrl).getFirst();
                                AuditModelRegistryState.this.cacheAuditElements(auditModelId, audit);
                            }
                            catch (Throwable e) {
                                String strictPropStr = AuditModelRegistryState.this.getProperty(AuditModelRegistryImpl.PROPERTY_AUDIT_CONFIG_STRICT);
                                if (Boolean.parseBoolean(strictPropStr)) {
                                    throw new AuditModelException("Failed to load audit model: " + String.valueOf(auditModelUrl), e);
                                }
                                logger.error((Object)("Failed to load audit model: " + String.valueOf(auditModelUrl)), e);
                            }
                        }
                        return null;
                    }
                };
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        ((AuditModelRegistryState)AuditModelRegistryState.this).AuditModelRegistryImpl.this.transactionService.getRetryingTransactionHelper().doInTransaction(loadModelsCallback, ((AuditModelRegistryState)AuditModelRegistryState.this).AuditModelRegistryImpl.this.transactionService.isReadOnly(), true);
                        return null;
                    }
                }, (String)AuthenticationUtil.getSystemUserName());
            }
            this.auditPathMapper.lock();
        }

        @Override
        public void stop() {
            this.auditPathMapper = null;
        }

        public Map<String, AuditApplication> getAuditApplications() {
            return this.auditApplicationsByName;
        }

        public AuditApplication getAuditApplicationByKey(String key) {
            return this.auditApplicationsByKey.get(key);
        }

        public AuditApplication getAuditApplicationByName(String applicationName) {
            return this.auditApplicationsByName.get(applicationName);
        }

        public PathMapper getAuditPathMapper() {
            return this.auditPathMapper;
        }

        private void cacheAuditElements(Long auditModelId, Audit audit) {
            HashMap<String, org.alfresco.repo.audit.extractor.DataExtractor> dataExtractorsByName = new HashMap<String, org.alfresco.repo.audit.extractor.DataExtractor>(13);
            HashMap<String, org.alfresco.repo.audit.generator.DataGenerator> dataGeneratorsByName = new HashMap<String, org.alfresco.repo.audit.generator.DataGenerator>(13);
            DataExtractors extractorsElement = audit.getDataExtractors();
            if (extractorsElement == null) {
                extractorsElement = AuditModelRegistryImpl.this.objectFactory.createDataExtractors();
            }
            List<DataExtractor> extractorElements = extractorsElement.getDataExtractor();
            for (DataExtractor extractorElement : extractorElements) {
                Object dataExtractor;
                String name = extractorElement.getName();
                if (dataExtractorsByName.containsKey(name)) {
                    throw new AuditModelException("Audit data extractor '" + name + "' has already been defined.");
                }
                if (extractorElement.getClazz() != null) {
                    try {
                        Class<?> dataExtractorClazz = Class.forName(extractorElement.getClazz());
                        dataExtractor = (org.alfresco.repo.audit.extractor.DataExtractor)dataExtractorClazz.newInstance();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new AuditModelException("Audit data extractor '" + name + "' class not found: " + extractorElement.getClazz());
                    }
                    catch (Exception exception) {
                        throw new AuditModelException("Audit data extractor '" + name + "' could not be constructed: " + extractorElement.getClazz());
                    }
                } else if (extractorElement.getRegisteredName() != null) {
                    String registeredName = extractorElement.getRegisteredName();
                    dataExtractor = (org.alfresco.repo.audit.extractor.DataExtractor)AuditModelRegistryImpl.this.dataExtractors.getNamedObject(registeredName);
                    if (dataExtractor == null) {
                        throw new AuditModelException("No registered audit data extractor exists for '" + registeredName + "'.");
                    }
                } else {
                    throw new AuditModelException("Audit data extractor has no class or registered name: " + name);
                }
                dataExtractorsByName.put(name, (org.alfresco.repo.audit.extractor.DataExtractor)dataExtractor);
            }
            DataGenerators generatorsElement = audit.getDataGenerators();
            if (generatorsElement == null) {
                generatorsElement = AuditModelRegistryImpl.this.objectFactory.createDataGenerators();
            }
            List<DataGenerator> generatorElements = generatorsElement.getDataGenerator();
            for (DataGenerator generatorElement : generatorElements) {
                org.alfresco.repo.audit.generator.DataGenerator dataGenerator;
                String name = generatorElement.getName();
                if (dataGeneratorsByName.containsKey(name)) {
                    throw new AuditModelException("Audit data generator '" + name + "' has already been defined.");
                }
                if (generatorElement.getClazz() != null) {
                    try {
                        Class<?> dataGeneratorClazz = Class.forName(generatorElement.getClazz());
                        dataGenerator = (org.alfresco.repo.audit.generator.DataGenerator)dataGeneratorClazz.newInstance();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new AuditModelException("Audit data generator '" + name + "' class not found: " + generatorElement.getClazz());
                    }
                    catch (Exception exception) {
                        throw new AuditModelException("Audit data generator '" + name + "' could not be constructed: " + generatorElement.getClazz());
                    }
                } else if (generatorElement.getRegisteredName() != null) {
                    String registeredName = generatorElement.getRegisteredName();
                    dataGenerator = (org.alfresco.repo.audit.generator.DataGenerator)AuditModelRegistryImpl.this.dataGenerators.getNamedObject(registeredName);
                    if (dataGenerator == null) {
                        throw new AuditModelException("No registered audit data generator exists for '" + registeredName + "'.");
                    }
                } else {
                    throw new AuditModelException("Audit data generator has no class or registered name: " + name);
                }
                dataGeneratorsByName.put(name, dataGenerator);
            }
            List<Application> applications = audit.getApplication();
            for (Application application : applications) {
                String key = application.getKey();
                if (!this.isApplicationEnabled(key)) continue;
                if (this.auditApplicationsByKey.containsKey(key)) {
                    throw new AuditModelException("Audit application key '" + key + "' is used by: " + String.valueOf(this.auditApplicationsByKey.get(key)));
                }
                String name = application.getName();
                if (this.auditApplicationsByName.containsKey(name)) {
                    throw new AuditModelException("Audit application '" + name + "' is used by: " + String.valueOf(this.auditApplicationsByName.get(name)));
                }
                AuditDAO.AuditApplicationInfo appInfo = AuditModelRegistryImpl.this.auditDAO.getAuditApplication(name);
                if (appInfo == null) {
                    appInfo = AuditModelRegistryImpl.this.auditDAO.createAuditApplication(name, auditModelId);
                } else {
                    AuditModelRegistryImpl.this.auditDAO.updateAuditApplicationModel(appInfo.getId(), auditModelId);
                }
                AuditApplication wrapperApp = new AuditApplication(dataExtractorsByName, dataGeneratorsByName, application, appInfo.getId(), appInfo.getDisabledPathsId());
                this.auditApplicationsByName.put(name, wrapperApp);
                this.auditApplicationsByKey.put(key, wrapperApp);
            }
            this.buildAuditPathMap(audit);
        }

        private void buildAuditPathMap(Audit audit) {
            PathMappings pathMappings = audit.getPathMappings();
            if (pathMappings == null) {
                pathMappings = AuditModelRegistryImpl.this.objectFactory.createPathMappings();
            }
            for (PathMap pathMap : pathMappings.getPathMap()) {
                String key;
                String sourcePath = pathMap.getSource();
                String targetPath = pathMap.getTarget();
                int keyStart = targetPath.charAt(0) == '/' ? 1 : 0;
                int keyEnd = targetPath.indexOf(47, keyStart);
                String string = key = keyEnd == -1 ? targetPath.substring(keyStart) : targetPath.substring(keyStart, keyEnd);
                if (!this.isApplicationEnabled(key)) continue;
                this.auditPathMapper.addPathMap(sourcePath, targetPath);
            }
        }
    }
}

