/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.nodelocator;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.nodelocator.NodeLocator;
import org.alfresco.repo.nodelocator.NodeLocatorService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NodeLocatorServiceImpl
implements NodeLocatorService {
    private static Log logger = LogFactory.getLog(NodeLocatorServiceImpl.class);
    private final Map<String, NodeLocator> locators = new HashMap<String, NodeLocator>();

    @Override
    public NodeRef getNode(String locatorName, NodeRef source, Map<String, Serializable> params) {
        NodeLocator locator = this.locators.get(locatorName);
        if (locator == null) {
            String msg = "No NodeLocator is registered with name: " + locatorName;
            throw new IllegalArgumentException(msg);
        }
        NodeRef node = locator.getNode(source, params);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Node locator named '" + locatorName + "' found node: " + String.valueOf(node)));
        }
        return node;
    }

    @Override
    public void register(String locatorName, NodeLocator locator) {
        ParameterCheck.mandatory((String)"locatorName", (Object)locatorName);
        ParameterCheck.mandatory((String)"locator", (Object)locator);
        if (this.locators.containsKey(locatorName)) {
            String msg = "Locator with name '" + locatorName + "' is already registered!";
            throw new IllegalArgumentException(msg);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registered node locator: " + locatorName));
        }
        this.locators.put(locatorName, locator);
    }
}

