/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition2;

import java.util.Map;
import java.util.Objects;
import org.alfresco.repo.rendition2.RenditionDefinition2;
import org.alfresco.repo.rendition2.RenditionDefinitionRegistry2Impl;

public class RenditionDefinition2Impl
implements RenditionDefinition2 {
    private final String renditionName;
    private final String targetMimetype;
    private final Map<String, String> transformOptions;
    private final boolean dynamicallyLoaded;

    public RenditionDefinition2Impl(String renditionName, String targetMimetype, Map<String, String> transformOptions, RenditionDefinitionRegistry2Impl registry) {
        this(renditionName, targetMimetype, transformOptions, false, registry);
    }

    public RenditionDefinition2Impl(String renditionName, String targetMimetype, Map<String, String> transformOptions, boolean dynamicallyLoaded, RenditionDefinitionRegistry2Impl registry) {
        this.renditionName = renditionName;
        this.targetMimetype = targetMimetype;
        this.transformOptions = transformOptions;
        this.dynamicallyLoaded = dynamicallyLoaded;
        if (registry != null) {
            registry.register(this);
        }
    }

    public boolean isDynamicallyLoaded() {
        return this.dynamicallyLoaded;
    }

    @Override
    public String getRenditionName() {
        return this.renditionName;
    }

    @Override
    public String getTargetMimetype() {
        return this.targetMimetype;
    }

    @Override
    public Map<String, String> getTransformOptions() {
        return this.transformOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RenditionDefinition2Impl)) {
            return false;
        }
        RenditionDefinition2Impl that = (RenditionDefinition2Impl)o;
        return Objects.equals(this.renditionName, that.renditionName);
    }

    public int hashCode() {
        return Objects.hash(this.renditionName);
    }
}

