/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.activities;

import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionListener;
import org.alfresco.service.cmr.activities.ActivityInfo;
import org.alfresco.service.cmr.activities.ActivityPoster;
import org.alfresco.sync.repo.Client;

public class ActivitiesTransactionListener
implements TransactionListener {
    private final String activityType;
    private final ActivityInfo activityInfo;
    private final ActivityPoster poster;
    private final RetryingTransactionHelper retryingTransactionHelper;
    private final String appTool;
    private final Client client;
    private final String tenantDomain;

    public ActivitiesTransactionListener(String activityType, ActivityInfo activityInfo, String tenantDomain, String appTool, Client client, ActivityPoster poster, RetryingTransactionHelper retryingTransactionHelper) {
        this.activityType = activityType;
        this.activityInfo = activityInfo;
        this.appTool = appTool;
        this.client = client;
        this.tenantDomain = tenantDomain;
        this.poster = poster;
        this.retryingTransactionHelper = retryingTransactionHelper;
    }

    @Override
    public void afterCommit() {
        this.retryingTransactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                if (ActivitiesTransactionListener.this.activityType != null && ActivitiesTransactionListener.this.activityInfo != null) {
                    ActivitiesTransactionListener.this.poster.postFileFolderActivity(ActivitiesTransactionListener.this.activityType, null, ActivitiesTransactionListener.this.tenantDomain, ActivitiesTransactionListener.this.activityInfo.getSiteId(), ActivitiesTransactionListener.this.activityInfo.getParentNodeRef(), ActivitiesTransactionListener.this.activityInfo.getNodeRef(), ActivitiesTransactionListener.this.activityInfo.getFileName(), ActivitiesTransactionListener.this.appTool, ActivitiesTransactionListener.this.client, ActivitiesTransactionListener.this.activityInfo.getFileInfo());
                }
                return null;
            }
        }, false, true);
    }

    @Override
    public void flush() {
    }

    @Override
    public void beforeCommit(boolean readOnly) {
    }

    @Override
    public void beforeCompletion() {
    }

    @Override
    public void afterRollback() {
    }
}

