/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor.workflow;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.forms.Form;
import org.alfresco.repo.forms.FormData;
import org.alfresco.repo.forms.FormNotFoundException;
import org.alfresco.repo.forms.Item;
import org.alfresco.repo.forms.processor.node.DefaultFieldProcessor;
import org.alfresco.repo.forms.processor.node.MockClassAttributeDefinition;
import org.alfresco.repo.forms.processor.node.MockFieldProcessorRegistry;
import org.alfresco.repo.forms.processor.workflow.AbstractWorkflowFormProcessor;
import org.alfresco.repo.forms.processor.workflow.FormProcessorTest;
import org.alfresco.repo.forms.processor.workflow.WorkflowFormProcessor;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowNode;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskDefinition;
import org.alfresco.service.cmr.workflow.WorkflowTransition;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.NamespaceServiceMemoryImpl;
import org.alfresco.service.namespace.QName;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class WorkflowFormProcessorTest
extends FormProcessorTest {
    private static final String WF_DEF_NAME = "foo$wf:bar";
    private static final QName PRIORITY_NAME = WorkflowModel.PROP_WORKFLOW_PRIORITY;
    private WorkflowInstance newInstance;
    private WorkflowDefinition definition;
    private Map<QName, Serializable> actualProperties = null;

    public void testGetTypedItem() throws Exception {
        try {
            this.processor.getTypedItem(null);
            WorkflowFormProcessorTest.fail((String)"Should have thrown an Exception here!");
        }
        catch (FormNotFoundException formNotFoundException) {}
        try {
            this.processor.getTypedItem(new Item("task", "bad id"));
            WorkflowFormProcessorTest.fail((String)"Should have thrown an Exception here!");
        }
        catch (FormNotFoundException formNotFoundException) {}
        WorkflowDefinition result = (WorkflowDefinition)((WorkflowFormProcessor)this.processor).getTypedItem(this.item);
        WorkflowFormProcessorTest.assertNotNull((Object)result);
        WorkflowFormProcessorTest.assertEquals((String)WF_DEF_NAME, (String)result.getName());
    }

    public void testPersistPropertyComment() throws Exception {
        super.testPersistPropertyComment(this.item.getId());
    }

    public void testGenerateSetsItemAndUrl() throws Exception {
        Form form = ((WorkflowFormProcessor)this.processor).generate(this.item, null, null, null);
        Item formItem = form.getItem();
        WorkflowFormProcessorTest.assertEquals((String)this.item.getId(), (String)formItem.getId());
        WorkflowFormProcessorTest.assertEquals((String)this.item.getKind(), (String)formItem.getKind());
        WorkflowFormProcessorTest.assertEquals((String)WF_DEF_NAME, (String)formItem.getType());
        WorkflowFormProcessorTest.assertEquals((String)("api/workflow-definitions/" + this.definition.getId()), (String)formItem.getUrl());
    }

    public void testGenerateSingleProperty() {
        String fieldName = PRIORITY_NAME.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        List<String> fields = Arrays.asList(fieldName);
        Form form = this.processForm(fields);
        this.checkSingleProperty(form, fieldName, Integer.valueOf(2));
        String fullPropertyName = "prop:" + fieldName;
        fields = Arrays.asList(fullPropertyName);
        form = this.processForm(fields);
        this.checkSingleProperty(form, fieldName, Integer.valueOf(2));
        this.checkPackageActionGroups(form.getFormData());
    }

    public void testGenerateSingleAssociation() {
        Serializable values = (Serializable)((Object)Collections.emptyList());
        String fieldName = FormProcessorTest.ASSIGNEE_NAME.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        List<String> fields = Arrays.asList(fieldName);
        Form form = this.processForm(fields);
        this.checkSingleAssociation(form, fieldName, values);
        String fullAssociationName = "assoc:" + fieldName;
        fields = Arrays.asList(fullAssociationName);
        form = this.processForm(fields);
        this.checkSingleAssociation(form, fieldName, values);
        this.checkPackageActionGroups(form.getFormData());
    }

    public void testIgnoresUnknownFields() throws Exception {
        String fakeFieldName = "bpm:Fake Field";
        String priorityField = PRIORITY_NAME.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        List<String> fields = Arrays.asList(fakeFieldName, priorityField);
        Form form = this.processForm(fields);
        this.checkSingleProperty(form, priorityField, Integer.valueOf(2));
        this.checkPackageActionGroups(form.getFormData());
    }

    public void testGenerateDefaultForm() throws Exception {
        Form form = this.processForm(new String[0]);
        List fieldDefs = form.getFieldDefinitionNames();
        WorkflowFormProcessorTest.assertTrue((boolean)fieldDefs.contains(FormProcessorTest.ASSIGNEE_NAME.toPrefixString((NamespacePrefixResolver)this.namespaceService)));
        WorkflowFormProcessorTest.assertTrue((boolean)fieldDefs.contains(PRIORITY_NAME.toPrefixString((NamespacePrefixResolver)this.namespaceService)));
        WorkflowFormProcessorTest.assertTrue((boolean)fieldDefs.contains("packageItems"));
        WorkflowFormProcessorTest.assertFalse((boolean)fieldDefs.contains(FormProcessorTest.ACTORS_NAME.toPrefixString((NamespacePrefixResolver)this.namespaceService)));
        WorkflowFormProcessorTest.assertFalse((boolean)fieldDefs.contains(WorkflowModel.PROP_PACKAGE_ACTION_GROUP.toPrefixString((NamespacePrefixResolver)this.namespaceService)));
        WorkflowFormProcessorTest.assertFalse((boolean)fieldDefs.contains(WorkflowModel.PROP_PACKAGE_ITEM_ACTION_GROUP.toPrefixString((NamespacePrefixResolver)this.namespaceService)));
        WorkflowFormProcessorTest.assertFalse((boolean)fieldDefs.contains(WorkflowModel.PROP_DESCRIPTION.toPrefixString((NamespacePrefixResolver)this.namespaceService)));
        WorkflowFormProcessorTest.assertFalse((boolean)fieldDefs.contains(WorkflowModel.PROP_DUE_DATE.toPrefixString((NamespacePrefixResolver)this.namespaceService)));
        WorkflowFormProcessorTest.assertFalse((boolean)fieldDefs.contains(WorkflowModel.PROP_PRIORITY.toPrefixString((NamespacePrefixResolver)this.namespaceService)));
        WorkflowFormProcessorTest.assertFalse((boolean)fieldDefs.contains(WorkflowModel.PROP_TASK_ID.toPrefixString((NamespacePrefixResolver)this.namespaceService)));
        Serializable fieldData = (Serializable)((Object)Collections.emptyList());
        FormData formData = form.getFormData();
        WorkflowFormProcessorTest.assertEquals((Object)fieldData, (Object)formData.getFieldData("assoc_bpm_assignee").getValue());
        this.checkPackageActionGroups(formData);
        WorkflowFormProcessorTest.assertEquals((Object)2, (Object)formData.getFieldData("prop_bpm_workflowPriority").getValue());
    }

    public void testGeneratePackageItems() throws Exception {
        String fieldName = "packageItems";
        Form form = this.processForm(fieldName);
        Serializable packageItems = (Serializable)((Object)Collections.emptyList());
        this.checkSingleAssociation(form, fieldName, packageItems);
    }

    public void testPersistPropertyChanged() throws Exception {
        String fieldName = FormProcessorTest.DESC_NAME.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        String dataKey = this.makeDataKeyName(fieldName);
        String value = "New Description";
        this.processPersist(dataKey, value);
        WorkflowFormProcessorTest.assertEquals((int)2, (int)this.actualProperties.size());
        WorkflowFormProcessorTest.assertEquals((Object)value, (Object)this.actualProperties.get(FormProcessorTest.DESC_NAME));
        WorkflowFormProcessorTest.assertEquals((Object)FormProcessorTest.PCKG_NODE, (Object)this.actualProperties.get(WorkflowModel.ASSOC_PACKAGE));
    }

    public void testPersistPropertyWith_() throws Exception {
        String fieldName = FormProcessorTest.PROP_WITH_.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        String dataKey = this.makeDataKeyName(fieldName);
        String value = "New _ Value";
        this.processPersist(dataKey, value);
        WorkflowFormProcessorTest.assertEquals((int)2, (int)this.actualProperties.size());
        WorkflowFormProcessorTest.assertEquals((Object)value, (Object)this.actualProperties.get(FormProcessorTest.PROP_WITH_));
    }

    public void testPersistAssociationAdded() throws Exception {
        String fieldName = FormProcessorTest.ACTORS_NAME.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        String dataKey = this.makeDataKeyName(fieldName, true);
        String value = String.valueOf(FormProcessorTest.FAKE_NODE) + ", " + String.valueOf(FormProcessorTest.FAKE_NODE2);
        this.processPersist(dataKey, value);
        WorkflowFormProcessorTest.assertEquals((int)2, (int)this.actualProperties.size());
        List nodeRefs = (List)((Object)this.actualProperties.get(FormProcessorTest.ACTORS_NAME));
        WorkflowFormProcessorTest.assertNotNull((Object)nodeRefs);
        WorkflowFormProcessorTest.assertEquals((int)2, (int)nodeRefs.size());
        WorkflowFormProcessorTest.assertTrue((boolean)nodeRefs.contains(FormProcessorTest.FAKE_NODE));
        WorkflowFormProcessorTest.assertTrue((boolean)nodeRefs.contains(FormProcessorTest.FAKE_NODE2));
    }

    public void testIgnoreAssociationsRemoved() throws Exception {
        String fieldName = FormProcessorTest.ASSIGNEE_NAME.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        String dataKey = this.makeDataKeyName(fieldName, false);
        String value = FormProcessorTest.FAKE_NODE.toString();
        this.processPersist(dataKey, value);
        WorkflowFormProcessorTest.assertEquals((int)1, (int)this.actualProperties.size());
        Serializable nodeRefs = this.actualProperties.get(FormProcessorTest.ASSIGNEE_NAME);
        WorkflowFormProcessorTest.assertNull((Object)nodeRefs);
    }

    public void testPersistAssociationAddedWith_() throws Exception {
        String fieldName = FormProcessorTest.ASSOC_WITH_.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        String dataKey = this.makeDataKeyName(fieldName, true);
        String value = String.valueOf(FormProcessorTest.FAKE_NODE) + ", " + String.valueOf(FormProcessorTest.FAKE_NODE2);
        this.processPersist(dataKey, value);
        WorkflowFormProcessorTest.assertEquals((int)2, (int)this.actualProperties.size());
        List nodeRefs = (List)((Object)this.actualProperties.get(FormProcessorTest.ASSOC_WITH_));
        WorkflowFormProcessorTest.assertNotNull((Object)nodeRefs);
        WorkflowFormProcessorTest.assertEquals((int)2, (int)nodeRefs.size());
        WorkflowFormProcessorTest.assertTrue((boolean)nodeRefs.contains(FormProcessorTest.FAKE_NODE));
        WorkflowFormProcessorTest.assertTrue((boolean)nodeRefs.contains(FormProcessorTest.FAKE_NODE2));
    }

    public void testPersistPackageItemsAdded() throws Exception {
        this.mockPackageItems(FormProcessorTest.FAKE_NODE3);
        String dataKey = this.makeDataKeyName("packageItems", true);
        String value = String.valueOf(FormProcessorTest.FAKE_NODE) + ", " + String.valueOf(FormProcessorTest.FAKE_NODE2);
        this.processPersist(dataKey, value);
        this.checkAddPackageItem(FormProcessorTest.FAKE_NODE, true);
        this.checkAddPackageItem(FormProcessorTest.FAKE_NODE2, true);
        this.checkAddPackageItem(FormProcessorTest.FAKE_NODE3, false);
    }

    public void testPersistPackageItemsRemovedIgnored() throws Exception {
        this.mockPackageItems(FormProcessorTest.FAKE_NODE, FormProcessorTest.FAKE_NODE2);
        String dataKey = this.makeDataKeyName("packageItems", false);
        String value = String.valueOf(FormProcessorTest.FAKE_NODE) + ", " + String.valueOf(FormProcessorTest.FAKE_NODE2) + "," + String.valueOf(FormProcessorTest.FAKE_NODE3);
        this.processPersist(dataKey, value);
        this.checkRemovedPackageItem(FormProcessorTest.FAKE_NODE, false);
        this.checkRemovedPackageItem(FormProcessorTest.FAKE_NODE2, false);
        this.checkRemovedPackageItem(FormProcessorTest.FAKE_NODE3, false);
    }

    private void processPersist(String dataKey, String value) {
        FormData data = new FormData();
        data.addFieldData(dataKey, (Object)value);
        WorkflowInstance persistedItem = (WorkflowInstance)this.processor.persist(this.item, data);
        WorkflowFormProcessorTest.assertEquals((Object)this.newInstance, (Object)persistedItem);
    }

    private Form processForm(String ... fields) {
        return this.processForm(Arrays.asList(fields));
    }

    private Form processForm(List<String> fields) {
        return ((WorkflowFormProcessor)this.processor).generate(this.item, fields, null, null);
    }

    private void checkPackageActionGroups(FormData formData) {
        FormData.FieldData pckgActionData = formData.getFieldData("prop_bpm_packageActionGroup");
        WorkflowFormProcessorTest.assertNotNull((Object)pckgActionData);
        WorkflowFormProcessorTest.assertEquals((Object)"add_package_item_actions", (Object)pckgActionData.getValue());
        FormData.FieldData pckgItemActionData = formData.getFieldData("prop_bpm_packageItemActionGroup");
        WorkflowFormProcessorTest.assertNotNull((Object)pckgItemActionData);
        WorkflowFormProcessorTest.assertEquals((Object)"start_package_item_actions", (Object)pckgItemActionData.getValue());
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.item = new Item("workflow", WF_DEF_NAME);
        this.definition = this.makeWorkflowDefinition();
        this.workflowService = this.makeWorkflowService();
        this.nodeService = this.makeNodeService();
        DictionaryService dictionaryService = this.makeDictionaryService();
        this.namespaceService = this.makeNamespaceService();
        MockFieldProcessorRegistry fieldProcessorRegistry = new MockFieldProcessorRegistry(this.namespaceService, dictionaryService);
        DefaultFieldProcessor defaultProcessor = super.makeDefaultFieldProcessor(dictionaryService);
        this.processor = this.makeWorkflowFormProcessor(dictionaryService, fieldProcessorRegistry, defaultProcessor);
    }

    private WorkflowFormProcessor makeWorkflowFormProcessor(DictionaryService dictionaryService, MockFieldProcessorRegistry fieldProcessorRegistry, DefaultFieldProcessor defaultProcessor) {
        WorkflowFormProcessor processor1 = new WorkflowFormProcessor();
        processor1 = (WorkflowFormProcessor)super.makeTaskFormProcessor((AbstractWorkflowFormProcessor)processor1, dictionaryService, fieldProcessorRegistry, defaultProcessor);
        return processor1;
    }

    private WorkflowDefinition makeWorkflowDefinition() {
        String id = "foo$workflowDefId";
        String name = WF_DEF_NAME;
        String version = "1.0";
        String title = "Foo Bar Title";
        String description = "Foo Bar Description";
        WorkflowTaskDefinition startTaskDefinition = this.makeTaskDefinition();
        return new WorkflowDefinition(id, name, version, title, description, startTaskDefinition);
    }

    private WorkflowTaskDefinition makeTaskDefinition() {
        String id = "foo$startTaskDefId";
        TypeDefinition metadata = this.makeTypeDef();
        WorkflowNode node = new WorkflowNode("", "", "", "", false, new WorkflowTransition[0]);
        return new WorkflowTaskDefinition(id, node, metadata);
    }

    private TypeDefinition makeTypeDef() {
        TypeDefinition typeDef = (TypeDefinition)Mockito.mock(TypeDefinition.class);
        QName name = QName.createQName((String)"http://www.alfresco.org/model/bpm/1.0", (String)"TaskDef");
        Mockito.when((Object)typeDef.getName()).thenReturn((Object)name);
        Map<QName, PropertyDefinition> propertyDefs = this.makeTaskPropertyDefs();
        Mockito.when((Object)typeDef.getProperties()).thenReturn(propertyDefs);
        Map<QName, AssociationDefinition> associationDefs = this.makeTaskAssociationDefs();
        Mockito.when((Object)typeDef.getAssociations()).thenReturn(associationDefs);
        return typeDef;
    }

    private Map<QName, PropertyDefinition> makeTaskPropertyDefs() {
        HashMap<QName, PropertyDefinition> properties = new HashMap<QName, PropertyDefinition>();
        QName intType = DataTypeDefinition.INT;
        MockClassAttributeDefinition priorityDef = MockClassAttributeDefinition.mockPropertyDefinition(PRIORITY_NAME, intType, "2");
        properties.put(PRIORITY_NAME, priorityDef);
        QName textType = DataTypeDefinition.TEXT;
        MockClassAttributeDefinition descValue = MockClassAttributeDefinition.mockPropertyDefinition(FormProcessorTest.DESC_NAME, textType);
        properties.put(FormProcessorTest.DESC_NAME, descValue);
        MockClassAttributeDefinition titleValue = MockClassAttributeDefinition.mockPropertyDefinition(FormProcessorTest.STATUS_NAME, textType);
        properties.put(FormProcessorTest.STATUS_NAME, titleValue);
        MockClassAttributeDefinition with_ = MockClassAttributeDefinition.mockPropertyDefinition(FormProcessorTest.PROP_WITH_, textType);
        properties.put(FormProcessorTest.PROP_WITH_, with_);
        QName pckgActionGroup = WorkflowModel.PROP_PACKAGE_ACTION_GROUP;
        MockClassAttributeDefinition pckgAction = MockClassAttributeDefinition.mockPropertyDefinition(pckgActionGroup, textType, "add_package_item_actions");
        properties.put(pckgActionGroup, pckgAction);
        QName pckgItemActionGroup = WorkflowModel.PROP_PACKAGE_ITEM_ACTION_GROUP;
        MockClassAttributeDefinition pckgItemAction = MockClassAttributeDefinition.mockPropertyDefinition(pckgItemActionGroup, textType, "start_package_item_actions");
        properties.put(pckgItemActionGroup, pckgItemAction);
        return properties;
    }

    private NamespaceService makeNamespaceService() {
        NamespaceServiceMemoryImpl nsService = new NamespaceServiceMemoryImpl();
        nsService.registerNamespace("sys", "http://www.alfresco.org/model/system/1.0");
        nsService.registerNamespace("rn", "http://www.alfresco.org/model/rendition/1.0");
        nsService.registerNamespace("bpm", "http://www.alfresco.org/model/bpm/1.0");
        nsService.registerNamespace("wf", "http://www.alfresco.org/model/workflow/1.0");
        return nsService;
    }

    private DictionaryService makeDictionaryService() {
        DictionaryService mock = (DictionaryService)Mockito.mock(DictionaryService.class);
        TypeDefinition taskTypeDef = this.definition.getStartTaskDefinition().getMetadata();
        Mockito.when((Object)mock.getAnonymousType((QName)ArgumentMatchers.any(), (Collection)ArgumentMatchers.any())).thenReturn((Object)taskTypeDef);
        return mock;
    }

    private WorkflowService makeWorkflowService() {
        WorkflowService service = (WorkflowService)Mockito.mock(WorkflowService.class);
        Mockito.when((Object)service.getDefinitionByName(WF_DEF_NAME)).thenReturn((Object)this.definition);
        String instanceId = "foo$instanceId";
        this.newInstance = new WorkflowInstance(instanceId, this.definition, null, null, null, null, true, null, null);
        WorkflowTask startTask = new WorkflowTask("foo$taskId", null, null, null, null, null, null, null);
        String pathId = "foo$pathId";
        final WorkflowPath path = new WorkflowPath(pathId, this.newInstance, null, true);
        Mockito.when((Object)service.startWorkflow((String)ArgumentMatchers.eq((Object)this.definition.getId()), ArgumentMatchers.anyMap())).thenAnswer((Answer)new Answer<WorkflowPath>(){

            public WorkflowPath answer(InvocationOnMock invocation) throws Throwable {
                Object[] arguments = invocation.getArguments();
                WorkflowFormProcessorTest.this.actualProperties = (Map)arguments[1];
                return path;
            }
        });
        Mockito.when((Object)service.getTasksForWorkflowPath(path.getId())).thenReturn(Collections.singletonList(startTask));
        Mockito.when((Object)service.createPackage(null)).thenReturn((Object)FormProcessorTest.PCKG_NODE);
        return service;
    }

    private NodeService makeNodeService() {
        NodeService service = (NodeService)Mockito.mock(NodeService.class);
        Mockito.when((Object)service.hasAspect(FormProcessorTest.PCKG_NODE, WorkflowModel.ASPECT_WORKFLOW_PACKAGE)).thenReturn((Object)true);
        return service;
    }
}

