/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.download.cannedquery;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.alfresco.query.CannedQueryParameters;
import org.alfresco.repo.domain.query.CannedQueryDAO;
import org.alfresco.repo.download.cannedquery.DownloadEntity;
import org.alfresco.repo.download.cannedquery.GetDownloadsCannedQueryParams;
import org.alfresco.repo.security.permissions.impl.acegi.AbstractCannedQueryPermissions;
import org.alfresco.repo.security.permissions.impl.acegi.MethodSecurityBean;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;

public class GetDownloadsCannedQuery
extends AbstractCannedQueryPermissions<DownloadEntity> {
    private static final String QUERY_NAMESPACE = "alfresco.query.downloads";
    private static final String QUERY_SELECT_GET_DOWNLOADS = "select_GetDownloadsBeforeQuery";
    private final CannedQueryDAO cannedQueryDAO;

    public GetDownloadsCannedQuery(CannedQueryDAO cannedQueryDAO, MethodSecurityBean<DownloadEntity> methodSecurity, CannedQueryParameters params) {
        super(params, methodSecurity);
        this.cannedQueryDAO = cannedQueryDAO;
    }

    protected List<DownloadEntity> queryAndFilter(CannedQueryParameters parameters) {
        Object paramBeanObj = parameters.getParameterBean();
        if (paramBeanObj == null) {
            throw new NullPointerException("Null GetDownloadss query params");
        }
        GetDownloadsCannedQueryParams paramsBean = (GetDownloadsCannedQueryParams)paramBeanObj;
        List results = this.cannedQueryDAO.executeQuery(QUERY_NAMESPACE, QUERY_SELECT_GET_DOWNLOADS, paramBeanObj, 0, Integer.MAX_VALUE);
        ArrayList<DownloadEntity> filteredResults = new ArrayList<DownloadEntity>();
        for (DownloadEntity entity : results) {
            Date createdDate = (Date)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)entity.getCreatedDate());
            Date modifiedDate = (Date)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)entity.getModifiedDate());
            if (modifiedDate == null) {
                modifiedDate = createdDate;
            }
            if (!modifiedDate.before(paramsBean.getBefore())) break;
            filteredResults.add(entity);
        }
        return filteredResults;
    }

    protected boolean isApplyPostQuerySorting() {
        return false;
    }
}

