/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rating;

import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.rating.AbstractRatingRollupAlgorithm;
import org.alfresco.service.cmr.rating.Rating;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;

public class RatingCountRollupAlgorithm
extends AbstractRatingRollupAlgorithm {
    public static final String ROLLUP_NAME = "Count";

    public RatingCountRollupAlgorithm() {
        super(ROLLUP_NAME);
    }

    @Override
    public Integer recalculate(NodeRef ratedNode) {
        int result = 0;
        if (this.nodeService.hasAspect(ratedNode, ContentModel.ASPECT_RATEABLE)) {
            List<ChildAssociationRef> ratingsNodes = this.ratingServiceImpl.getRatingNodeChildren(ratedNode, this.ratingSchemeName, null);
            for (ChildAssociationRef chAssRef : ratingsNodes) {
                NodeRef nextRatingNode = chAssRef.getChildRef();
                Rating rating = this.ratingServiceImpl.getRatingFrom(nextRatingNode);
                if (!this.ratingSchemeName.equals(rating.getScheme().getName())) continue;
                ++result;
            }
        }
        return result;
    }
}

