/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.identityservice;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.source.JWKSetBasedJWKSource;
import com.nimbusds.jose.jwk.source.JWKSetSource;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.jwk.source.JWKSourceBuilder;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.proc.DefaultJOSEObjectTypeVerifier;
import com.nimbusds.jose.proc.JOSEObjectTypeVerifier;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.as.AuthorizationServerEndpointMetadata;
import com.nimbusds.oauth2.sdk.as.AuthorizationServerMetadata;
import com.nimbusds.oauth2.sdk.id.Identifier;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.interfaces.RSAPublicKey;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceConfig;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceException;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceFacade;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceMetadataKey;
import org.alfresco.repo.security.authentication.identityservice.SpringBasedIdentityServiceFacade;
import org.alfresco.repo.security.authentication.identityservice.user.DecodedTokenUser;
import org.alfresco.repo.security.authentication.identityservice.user.UserInfoAttrMapping;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactoryBuilder;
import org.apache.hc.client5.http.ssl.TrustAllStrategy;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.security.converter.RsaKeyConverters;
import org.springframework.security.oauth2.client.http.OAuth2ErrorResponseErrorHandler;
import org.springframework.security.oauth2.client.oidc.authentication.OidcIdTokenDecoderFactory;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.core.converter.ClaimTypeConverter;
import org.springframework.security.oauth2.core.http.converter.OAuth2AccessTokenResponseHttpMessageConverter;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtClaimValidator;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtTimestampValidator;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class IdentityServiceFacadeFactoryBean
implements FactoryBean<IdentityServiceFacade> {
    private static final Log LOGGER = LogFactory.getLog(IdentityServiceFacadeFactoryBean.class);
    private static final JOSEObjectType AT_JWT = new JOSEObjectType("at+jwt");
    private static final String DEFAULT_ISSUER_ATTR = "issuer";
    private boolean enabled;
    private SpringBasedIdentityServiceFacadeFactory factory;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setIdentityServiceConfig(IdentityServiceConfig identityServiceConfig) {
        this.factory = new SpringBasedIdentityServiceFacadeFactory(() -> HttpClientProvider.access$0(new HttpClientProvider(identityServiceConfig)), new ClientRegistrationProvider(identityServiceConfig)::createClientRegistration, new JwtDecoderProvider(identityServiceConfig)::createJwtDecoder);
    }

    public IdentityServiceFacade getObject() throws Exception {
        if (!this.enabled) {
            return null;
        }
        return new LazyInstantiatingIdentityServiceFacade(() -> SpringBasedIdentityServiceFacadeFactory.access$0(this.factory));
    }

    public Class<?> getObjectType() {
        return IdentityServiceFacade.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private static IdentityServiceFacade.IdentityServiceFacadeException authorizationServerCantBeUsedException(RuntimeException cause) {
        return new IdentityServiceFacade.IdentityServiceFacadeException("Unable to use the Authorization Server.", cause);
    }

    private static Optional<String> getMetadataIssuer(OIDCProviderMetadata metadata, IdentityServiceConfig config) {
        return DEFAULT_ISSUER_ATTR.equals(config.getIssuerAttribute()) ? Optional.of(metadata).map(AuthorizationServerMetadata::getIssuer).map(Identifier::getValue) : Optional.of(metadata).map(AuthorizationServerMetadata::getCustomParameters).map(map -> map.get((Object)config.getIssuerAttribute())).filter(String.class::isInstance).map(String.class::cast);
    }

    private static boolean isDefined(String value) {
        return value != null && !value.isBlank();
    }

    static class ClientRegistrationProvider {
        private final IdentityServiceConfig config;

        ClientRegistrationProvider(IdentityServiceConfig config) {
            this.config = Objects.requireNonNull(config);
        }

        public ClientRegistration createClientRegistration(RestOperations rest) {
            return this.possibleMetadataURIs().stream().map(u -> this.extractMetadata(rest, (URI)u)).filter(Optional::isPresent).map(Optional::get).findFirst().map(this::validateDiscoveryDocument).map(this::createBuilder).map(this::configureClientAuthentication).map(ClientRegistration.Builder::build).orElseThrow(() -> new IllegalStateException("Failed to create ClientRegistration."));
        }

        private OIDCProviderMetadata validateDiscoveryDocument(OIDCProviderMetadata metadata) {
            block4: {
                this.validateOIDCEndpoint(metadata.getTokenEndpointURI(), "Token");
                this.validateOIDCEndpoint(metadata.getAuthorizationEndpointURI(), "Authorization");
                this.validateOIDCEndpoint(metadata.getUserInfoEndpointURI(), "User Info");
                this.validateOIDCEndpoint(metadata.getJWKSetURI(), "JWK Set");
                if (metadata.getIssuer() != null) {
                    try {
                        URI metadataIssuerURI = new URI(metadata.getIssuer().getValue());
                        this.validateOIDCEndpoint(metadataIssuerURI, "Issuer");
                        if (StringUtils.isNotBlank((CharSequence)this.config.getIssuerUrl()) && !metadataIssuerURI.equals(URI.create(this.config.getIssuerUrl()))) {
                            throw new IdentityServiceException("Failed to create ClientRegistration. " + "The Issuer value from the OIDC Discovery Endpoint does not align with the provided Issuer. Expected `%s` but found `%s`".formatted(this.config.getIssuerUrl(), metadata.getIssuer().getValue()));
                        }
                        break block4;
                    }
                    catch (URISyntaxException e) {
                        throw new IdentityServiceException("The provided Issuer value could not be parsed as a URI reference.", e);
                    }
                }
                throw new IdentityServiceException("The Issuer retrieved from the OIDC Discovery Endpoint cannot be null.");
            }
            return metadata;
        }

        private void validateOIDCEndpoint(URI value, String endpointName) {
            if (value == null || value.toASCIIString().isBlank()) {
                throw new IdentityServiceException("The `%s` Endpoint retrieved from the OIDC Discovery Endpoint cannot be empty.".formatted(endpointName));
            }
        }

        private ClientRegistration.Builder createBuilder(OIDCProviderMetadata metadata) {
            String authUri = Optional.of(metadata).map(AuthorizationServerEndpointMetadata::getAuthorizationEndpointURI).map(URI::toASCIIString).orElse(null);
            Optional<String> metadataIssuer = IdentityServiceFacadeFactoryBean.getMetadataIssuer(metadata, this.config);
            String issuerUri = metadataIssuer.orElseGet(() -> StringUtils.isNotBlank((CharSequence)this.config.getRealm()) && StringUtils.isBlank((CharSequence)this.config.getIssuerUrl()) ? this.config.getAuthServerUrl() : this.config.getIssuerUrl());
            String usernameAttribute = StringUtils.isNotBlank((CharSequence)this.config.getPrincipalAttribute()) ? this.config.getPrincipalAttribute() : "preferred_username";
            return ClientRegistration.withRegistrationId((String)"ids").authorizationUri(authUri).tokenUri(metadata.getTokenEndpointURI().toASCIIString()).jwkSetUri(metadata.getJWKSetURI().toASCIIString()).issuerUri(issuerUri).userInfoUri(metadata.getUserInfoEndpointURI().toASCIIString()).userNameAttributeName(usernameAttribute).scope(this.getSupportedScopes(metadata.getScopes())).providerConfigurationMetadata(this.createMetadata(metadata)).authorizationGrantType(AuthorizationGrantType.TOKEN_EXCHANGE);
        }

        private Map<String, Object> createMetadata(OIDCProviderMetadata metadata) {
            LinkedHashMap<String, Object> configurationMetadata = new LinkedHashMap<String, Object>();
            if (metadata.getScopes() != null) {
                configurationMetadata.put(IdentityServiceMetadataKey.SCOPES_SUPPORTED.getValue(), metadata.getScopes());
            }
            if (StringUtils.isNotBlank((CharSequence)this.config.getAudience())) {
                configurationMetadata.put(IdentityServiceMetadataKey.AUDIENCE.getValue(), this.config.getAudience());
            }
            return configurationMetadata;
        }

        private ClientRegistration.Builder configureClientAuthentication(ClientRegistration.Builder builder) {
            builder.clientId(this.config.getResource());
            if (this.config.isPublicClient()) {
                return builder.clientSecret(null).clientAuthenticationMethod(ClientAuthenticationMethod.CLIENT_SECRET_POST);
            }
            return builder.clientSecret(this.config.getClientSecret()).clientAuthenticationMethod(ClientAuthenticationMethod.CLIENT_SECRET_BASIC);
        }

        private Set<String> getSupportedScopes(Scope scopes) {
            return scopes.stream().filter(this::hasPasswordGrantScope).map(Identifier::getValue).collect(Collectors.toSet());
        }

        private boolean hasPasswordGrantScope(Scope.Value scope) {
            return this.config.getPasswordGrantScopes().contains(scope.getValue());
        }

        private Optional<OIDCProviderMetadata> extractMetadata(RestOperations rest, URI metadataUri) {
            String response;
            try {
                ResponseEntity r = rest.exchange(RequestEntity.get((URI)metadataUri).build(), String.class);
                if (r.getStatusCode() != HttpStatus.OK || !r.hasBody()) {
                    LOGGER.warn((Object)("Unexpected response from " + String.valueOf(metadataUri) + ". Status code: " + String.valueOf(r.getStatusCode()) + ", has body: " + r.hasBody() + "."));
                    return Optional.empty();
                }
                response = (String)r.getBody();
            }
            catch (Exception e) {
                LOGGER.warn((Object)("Failed to get response from " + String.valueOf(metadataUri) + ". " + e.getMessage()), (Throwable)e);
                return Optional.empty();
            }
            try {
                return Optional.of(OIDCProviderMetadata.parse((String)response));
            }
            catch (Exception e) {
                LOGGER.warn((Object)("Failed to parse metadata. " + e.getMessage()), (Throwable)e);
                return Optional.empty();
            }
        }

        private Collection<URI> possibleMetadataURIs() {
            if (StringUtils.isBlank((CharSequence)this.config.getAuthServerUrl()) && StringUtils.isBlank((CharSequence)this.config.getIssuerUrl())) {
                throw new IdentityServiceException("Failed to create ClientRegistration. The values of issuer url and auth server url cannot both be empty.");
            }
            String baseUrl = StringUtils.isNotBlank((CharSequence)this.config.getAuthServerUrl()) ? this.config.getAuthServerUrl() : this.config.getIssuerUrl();
            return List.of(UriComponentsBuilder.fromUriString((String)baseUrl).pathSegment(new String[]{".well-known", "openid-configuration"}).build().toUri());
        }
    }

    static class CustomClientHttpRequestFactory
    extends HttpComponentsClientHttpRequestFactory {
        CustomClientHttpRequestFactory(HttpClient httpClient) {
            super(httpClient);
        }

        public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
            ClientHttpRequest request = super.createRequest(uri, httpMethod);
            request.getHeaders().add("Accept-Encoding", "gzip, deflate");
            return request;
        }
    }

    static class CustomJOSEObjectTypeVerifier
    extends DefaultJOSEObjectTypeVerifier<SecurityContext> {
        public CustomJOSEObjectTypeVerifier(JOSEObjectType ... allowedTypes) {
            super(Set.of(allowedTypes));
        }

        public void verify(JOSEObjectType type, SecurityContext context) throws BadJOSEException {
            super.verify(type, context);
        }
    }

    private static class HttpClientProvider {
        private final IdentityServiceConfig config;

        private HttpClientProvider(IdentityServiceConfig config) {
            this.config = Objects.requireNonNull(config);
        }

        private HttpClient createHttpClient() {
            try {
                HttpClientBuilder clientBuilder = HttpClients.custom();
                this.applyConfiguration(clientBuilder);
                return clientBuilder.build();
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to create ClientHttpRequestFactory. " + e.getMessage(), e);
            }
        }

        private void applyConfiguration(HttpClientBuilder builder) throws Exception {
            PoolingHttpClientConnectionManagerBuilder connectionManagerBuilder = PoolingHttpClientConnectionManagerBuilder.create();
            this.applyConnectionConfiguration(connectionManagerBuilder);
            this.applySSLConfiguration(connectionManagerBuilder);
            builder.setConnectionManager((HttpClientConnectionManager)connectionManagerBuilder.build());
        }

        private void applyConnectionConfiguration(PoolingHttpClientConnectionManagerBuilder connectionManagerBuilder) {
            ConnectionConfig connectionConfig = ConnectionConfig.custom().setConnectTimeout((long)this.config.getClientConnectionTimeout(), TimeUnit.MILLISECONDS).setSocketTimeout(this.config.getClientSocketTimeout(), TimeUnit.MILLISECONDS).build();
            connectionManagerBuilder.setMaxConnTotal(this.config.getConnectionPoolSize());
            connectionManagerBuilder.setDefaultConnectionConfig(connectionConfig);
        }

        private void applySSLConfiguration(PoolingHttpClientConnectionManagerBuilder connectionManagerBuilder) throws Exception {
            SSLContextBuilder sslContextBuilder = null;
            if (this.config.isDisableTrustManager()) {
                sslContextBuilder = SSLContexts.custom().loadTrustMaterial((TrustStrategy)TrustAllStrategy.INSTANCE);
            } else if (IdentityServiceFacadeFactoryBean.isDefined(this.config.getTruststore())) {
                char[] truststorePassword = this.asCharArray(this.config.getTruststorePassword(), null);
                sslContextBuilder = SSLContexts.custom().loadTrustMaterial(new File(this.config.getTruststore()), truststorePassword);
            }
            if (IdentityServiceFacadeFactoryBean.isDefined(this.config.getClientKeystore())) {
                if (sslContextBuilder == null) {
                    sslContextBuilder = SSLContexts.custom();
                }
                char[] keystorePassword = this.asCharArray(this.config.getClientKeystorePassword(), null);
                char[] keyPassword = this.asCharArray(this.config.getClientKeyPassword(), keystorePassword);
                sslContextBuilder.loadKeyMaterial(new File(this.config.getClientKeystore()), keystorePassword, keyPassword);
            }
            SSLConnectionSocketFactoryBuilder sslConnectionSocketFactoryBuilder = SSLConnectionSocketFactoryBuilder.create();
            if (sslContextBuilder != null) {
                sslConnectionSocketFactoryBuilder.setSslContext(sslContextBuilder.build());
            }
            if (this.config.isDisableTrustManager() || this.config.isAllowAnyHostname()) {
                sslConnectionSocketFactoryBuilder.setHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            }
            SSLConnectionSocketFactory sslConnectionSocketFactory = sslConnectionSocketFactoryBuilder.build();
            connectionManagerBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory);
        }

        private char[] asCharArray(String value, char ... nullValue) {
            return Optional.ofNullable(value).filter(Predicate.not(String::isBlank)).map(String::toCharArray).orElse(nullValue);
        }

        static /* synthetic */ HttpClient access$0(HttpClientProvider httpClientProvider) {
            return httpClientProvider.createHttpClient();
        }
    }

    static class JwtAudienceValidator
    implements OAuth2TokenValidator<Jwt> {
        private final String configuredAudience;

        public JwtAudienceValidator(String configuredAudience) {
            this.configuredAudience = configuredAudience;
        }

        public OAuth2TokenValidatorResult validate(Jwt token) {
            Objects.requireNonNull(token, "token cannot be null");
            Object audience = token.getClaim("aud");
            if (audience != null) {
                if (audience instanceof List && ((List)audience).contains(this.configuredAudience)) {
                    return OAuth2TokenValidatorResult.success();
                }
                if (audience instanceof String && audience.equals(this.configuredAudience)) {
                    return OAuth2TokenValidatorResult.success();
                }
            }
            OAuth2Error error = new OAuth2Error("invalid_token", "The aud claim is not valid. Expected configured audience `%s` not found.".formatted(this.configuredAudience), "https://tools.ietf.org/html/rfc6750#section-3.1");
            return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{error});
        }
    }

    static class JwtDecoderProvider {
        private static final SignatureAlgorithm DEFAULT_SIGNATURE_ALGORITHM = SignatureAlgorithm.RS256;
        private final IdentityServiceConfig config;
        private final Set<SignatureAlgorithm> signatureAlgorithms;

        JwtDecoderProvider(IdentityServiceConfig config) {
            this.config = Objects.requireNonNull(config);
            this.signatureAlgorithms = Optional.ofNullable(config.getSignatureAlgorithms()).filter(Predicate.not(Set::isEmpty)).orElseGet(() -> {
                LOGGER.warn((Object)("Unable to find any valid signature algorithms in the configuration. Using the default signature algorithm: " + DEFAULT_SIGNATURE_ALGORITHM.getName() + "."));
                return Set.of(DEFAULT_SIGNATURE_ALGORITHM);
            });
        }

        public JwtDecoder createJwtDecoder(RestOperations rest, ClientRegistration.ProviderDetails providerDetails) {
            try {
                NimbusJwtDecoder decoder = this.buildJwtDecoder(rest, providerDetails);
                decoder.setJwtValidator(this.createJwtTokenValidator(providerDetails));
                decoder.setClaimSetConverter((Converter)new ClaimTypeConverter(OidcIdTokenDecoderFactory.createDefaultClaimTypeConverters()));
                return decoder;
            }
            catch (RuntimeException e) {
                LOGGER.warn((Object)"Failed to create JwtDecoder.", (Throwable)e);
                throw IdentityServiceFacadeFactoryBean.authorizationServerCantBeUsedException(e);
            }
        }

        private NimbusJwtDecoder buildJwtDecoder(RestOperations rest, ClientRegistration.ProviderDetails providerDetails) {
            if (IdentityServiceFacadeFactoryBean.isDefined(this.config.getRealmKey())) {
                RSAPublicKey publicKey = this.parsePublicKey(this.config.getRealmKey());
                return NimbusJwtDecoder.withPublicKey((RSAPublicKey)publicKey).signatureAlgorithm(DEFAULT_SIGNATURE_ALGORITHM).build();
            }
            String jwkSetUri = this.requireValidJwkSetUri(providerDetails);
            NimbusJwtDecoder.JwkSetUriJwtDecoderBuilder decoderBuilder = NimbusJwtDecoder.withJwkSetUri((String)jwkSetUri);
            this.signatureAlgorithms.forEach(arg_0 -> ((NimbusJwtDecoder.JwkSetUriJwtDecoderBuilder)decoderBuilder).jwsAlgorithm(arg_0));
            return decoderBuilder.restOperations(rest).jwtProcessorCustomizer(this::reconfigureJWKSCache).build();
        }

        /*
         * WARNING - void declaration
         */
        private void reconfigureJWKSCache(ConfigurableJWTProcessor<SecurityContext> jwtProcessor) {
            void jwkSetBasedSource;
            void selector;
            if (jwtProcessor == null) {
                LOGGER.warn((Object)"Not able to reconfigure the JWK Cache. Missing JWT processor.");
                return;
            }
            JWSKeySelector jWSKeySelector = jwtProcessor.getJWSKeySelector();
            if (!(jWSKeySelector instanceof JWSVerificationKeySelector)) {
                LOGGER.warn((Object)"Not able to reconfigure the JWK Cache. Unexpected JWKSource.");
                return;
            }
            JWSVerificationKeySelector jWSVerificationKeySelector = (JWSVerificationKeySelector)jWSKeySelector;
            JWKSource jWKSource = selector.getJWKSource();
            if (!(jWKSource instanceof JWKSetBasedJWKSource)) {
                LOGGER.warn((Object)"Not able to reconfigure the JWK Cache. Unexpected JWKSource.");
                return;
            }
            JWKSetBasedJWKSource jWKSetBasedJWKSource = (JWKSetBasedJWKSource)jWKSource;
            JWKSetSource jwkSetSource = jwkSetBasedSource.getJWKSetSource();
            if (jwkSetSource == null) {
                LOGGER.warn((Object)"Not able to reconfigure the JWK Cache. Missing JWKSetSource.");
                return;
            }
            JWKSource newJWKSCache = JWKSourceBuilder.create((JWKSetSource)jwkSetSource).cache((long)this.config.getPublicKeyCacheTtl() * 1000L, -1L).rateLimited(false).refreshAheadCache(false).retrying(true).build();
            jwtProcessor.setJWSKeySelector((JWSKeySelector)new JWSVerificationKeySelector(this.signatureAlgorithms.stream().map(signatureAlgorithm -> JWSAlgorithm.parse((String)signatureAlgorithm.getName())).collect(Collectors.toSet()), newJWKSCache));
            jwtProcessor.setJWSTypeVerifier((JOSEObjectTypeVerifier)new CustomJOSEObjectTypeVerifier(JOSEObjectType.JWT, AT_JWT));
        }

        private OAuth2TokenValidator<Jwt> createJwtTokenValidator(ClientRegistration.ProviderDetails providerDetails) {
            ArrayList<Object> validators = new ArrayList<Object>();
            validators.add(new JwtTimestampValidator(Duration.of(this.config.getJwtClockSkewMs(), ChronoUnit.MILLIS)));
            validators.add(new JwtIssuerValidator(providerDetails.getIssuerUri()));
            if (!this.config.isClientIdValidationDisabled()) {
                validators.add(new JwtClaimValidator("azp", this.config.getResource()::equals));
            }
            if (StringUtils.isNotBlank((CharSequence)this.config.getAudience())) {
                validators.add(new JwtAudienceValidator(this.config.getAudience()));
            }
            return new DelegatingOAuth2TokenValidator(validators);
        }

        private RSAPublicKey parsePublicKey(String pem) {
            try {
                return this.tryToParsePublicKey(pem);
            }
            catch (Exception e) {
                if (this.isPemFormatException(e)) {
                    return this.tryToParsePublicKey("-----BEGIN PUBLIC KEY-----\n" + pem + "\n-----END PUBLIC KEY-----");
                }
                throw e;
            }
        }

        private RSAPublicKey tryToParsePublicKey(String pem) {
            ByteArrayInputStream pemStream = new ByteArrayInputStream(pem.getBytes(StandardCharsets.UTF_8));
            return (RSAPublicKey)RsaKeyConverters.x509().convert((Object)pemStream);
        }

        private boolean isPemFormatException(Exception e) {
            return e.getMessage() != null && e.getMessage().contains("-----BEGIN PUBLIC KEY-----");
        }

        private String requireValidJwkSetUri(ClientRegistration.ProviderDetails providerDetails) {
            String uri = providerDetails.getJwkSetUri();
            if (!IdentityServiceFacadeFactoryBean.isDefined(uri)) {
                OAuth2Error oauth2Error = new OAuth2Error("missing_signature_verifier", "Failed to find a Signature Verifier for: '" + providerDetails.getIssuerUri() + "'. Check to ensure you have configured the JwkSet URI.", null);
                throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString());
            }
            return uri;
        }
    }

    static class JwtIssuerValidator
    implements OAuth2TokenValidator<Jwt> {
        private final String requiredIssuer;

        public JwtIssuerValidator(String issuer) {
            this.requiredIssuer = Objects.requireNonNull(issuer, "issuer cannot be null");
        }

        public OAuth2TokenValidatorResult validate(Jwt token) {
            Objects.requireNonNull(token, "token cannot be null");
            Object issuer = token.getClaim("iss");
            if (issuer != null && this.requiredIssuer.equals(issuer.toString())) {
                return OAuth2TokenValidatorResult.success();
            }
            OAuth2Error error = new OAuth2Error("invalid_token", "The iss claim is not valid. Expected `%s` but got `%s`.".formatted(this.requiredIssuer, issuer), "https://tools.ietf.org/html/rfc6750#section-3.1");
            return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{error});
        }
    }

    static class LazyInstantiatingIdentityServiceFacade
    implements IdentityServiceFacade {
        private final AtomicReference<IdentityServiceFacade> targetFacade = new AtomicReference();
        private final Supplier<IdentityServiceFacade> targetFacadeCreator;

        LazyInstantiatingIdentityServiceFacade(Supplier<IdentityServiceFacade> targetFacadeCreator) {
            this.targetFacadeCreator = Objects.requireNonNull(targetFacadeCreator);
        }

        @Override
        public IdentityServiceFacade.AccessTokenAuthorization authorize(IdentityServiceFacade.AuthorizationGrant grant) throws IdentityServiceFacade.AuthorizationException {
            return this.getTargetFacade().authorize(grant);
        }

        @Override
        public IdentityServiceFacade.DecodedAccessToken decodeToken(String token) throws IdentityServiceFacade.TokenDecodingException {
            return this.getTargetFacade().decodeToken(token);
        }

        @Override
        public Optional<DecodedTokenUser> getUserInfo(String token, UserInfoAttrMapping userInfoAttrMapping) {
            return this.getTargetFacade().getUserInfo(token, userInfoAttrMapping);
        }

        @Override
        public ClientRegistration getClientRegistration() {
            return this.getTargetFacade().getClientRegistration();
        }

        private IdentityServiceFacade getTargetFacade() {
            return Optional.ofNullable(this.targetFacade.get()).orElseGet(() -> this.targetFacade.updateAndGet(prev -> Optional.ofNullable(prev).orElseGet(this::createTargetFacade)));
        }

        private IdentityServiceFacade createTargetFacade() {
            try {
                return this.targetFacadeCreator.get();
            }
            catch (IdentityServiceFacade.IdentityServiceFacadeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                LOGGER.warn((Object)"Failed to instantiate IdentityServiceFacade.", (Throwable)e);
                throw IdentityServiceFacadeFactoryBean.authorizationServerCantBeUsedException(e);
            }
        }
    }

    private static class SpringBasedIdentityServiceFacadeFactory {
        private final Supplier<HttpClient> httpClientProvider;
        private final Function<RestOperations, ClientRegistration> clientRegistrationProvider;
        private final BiFunction<RestOperations, ClientRegistration.ProviderDetails, JwtDecoder> jwtDecoderProvider;

        SpringBasedIdentityServiceFacadeFactory(Supplier<HttpClient> httpClientProvider, Function<RestOperations, ClientRegistration> clientRegistrationProvider, BiFunction<RestOperations, ClientRegistration.ProviderDetails, JwtDecoder> jwtDecoderProvider) {
            this.httpClientProvider = Objects.requireNonNull(httpClientProvider);
            this.clientRegistrationProvider = Objects.requireNonNull(clientRegistrationProvider);
            this.jwtDecoderProvider = Objects.requireNonNull(jwtDecoderProvider);
        }

        private IdentityServiceFacade createIdentityServiceFacade() {
            CustomClientHttpRequestFactory httpRequestFactory = new CustomClientHttpRequestFactory(this.httpClientProvider.get());
            RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)httpRequestFactory);
            ClientRegistration clientRegistration = this.clientRegistrationProvider.apply((RestOperations)restTemplate);
            JwtDecoder jwtDecoder = this.jwtDecoderProvider.apply((RestOperations)restTemplate, clientRegistration.getProviderDetails());
            return new SpringBasedIdentityServiceFacade(this.createOAuth2RestTemplate((ClientHttpRequestFactory)httpRequestFactory), clientRegistration, jwtDecoder);
        }

        private RestTemplate createOAuth2RestTemplate(ClientHttpRequestFactory requestFactory) {
            RestTemplate restTemplate = new RestTemplate(Arrays.asList(new FormHttpMessageConverter(), new OAuth2AccessTokenResponseHttpMessageConverter(), new MappingJackson2HttpMessageConverter()));
            restTemplate.setRequestFactory(requestFactory);
            restTemplate.setErrorHandler((ResponseErrorHandler)new OAuth2ErrorResponseErrorHandler());
            return restTemplate;
        }

        static /* synthetic */ IdentityServiceFacade access$0(SpringBasedIdentityServiceFacadeFactory springBasedIdentityServiceFacadeFactory) {
            return springBasedIdentityServiceFacadeFactory.createIdentityServiceFacade();
        }
    }
}

