/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.attributes;

import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.attributes.PropTablesCleaner;
import org.alfresco.repo.attributes.PropTablesCleanupJob;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@RunWith(value=MockitoJUnitRunner.class)
public class PropTablesCleanupJobTest {
    private PropTablesCleanupJob cleanupJob;
    @Mock
    private JobExecutionContext jobCtx;
    @Mock
    private PropTablesCleaner propTablesCleaner;
    private JobDetail jobDetail;

    @Before
    public void setUp() throws Exception {
        this.jobDetail = JobBuilder.newJob().withIdentity("propTablesCleanupJob").ofType(PropTablesCleanupJob.class).build();
        this.jobDetail.getJobDataMap().put("propTablesCleaner", (Object)this.propTablesCleaner);
        this.cleanupJob = new PropTablesCleanupJob();
        Mockito.when((Object)this.jobCtx.getJobDetail()).thenReturn((Object)this.jobDetail);
    }

    @Test
    public void testExecute() throws JobExecutionException {
        this.cleanupJob.execute(this.jobCtx);
        ((PropTablesCleaner)Mockito.verify((Object)this.propTablesCleaner)).execute();
    }

    @Test(expected=AlfrescoRuntimeException.class)
    public void testMissingPropTablesCleaner() throws JobExecutionException {
        this.jobDetail.getJobDataMap().put("propTablesCleaner", null);
        this.cleanupJob.execute(this.jobCtx);
    }

    @Test(expected=AlfrescoRuntimeException.class)
    public void testWrongTypeForPropTablesCleaner() throws JobExecutionException {
        this.jobDetail.getJobDataMap().put("propTablesCleaner", "This is not a PropTablesCleaner");
        this.cleanupJob.execute(this.jobCtx);
    }
}

