/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.tagging;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.alfresco.model.ContentModel;
import org.alfresco.query.EmptyPagingResults;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.audit.AuditComponent;
import org.alfresco.repo.coci.CheckOutCheckInServicePolicies;
import org.alfresco.repo.copy.CopyServicePolicies;
import org.alfresco.repo.event2.EventGenerator;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tagging.NonExistentTagException;
import org.alfresco.repo.tagging.TagDetailsImpl;
import org.alfresco.repo.tagging.TagExistsException;
import org.alfresco.repo.tagging.TagScopeImpl;
import org.alfresco.repo.tagging.TaggingException;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.TransactionListener;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.DuplicateChildNodeNameException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.CategoryService;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.tagging.TagDetails;
import org.alfresco.service.cmr.tagging.TagScope;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ISO9075;
import org.alfresco.util.Pair;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TaggingServiceImpl
implements TaggingService,
TransactionListener,
NodeServicePolicies.BeforeDeleteNodePolicy,
NodeServicePolicies.OnMoveNodePolicy,
CopyServicePolicies.OnCopyCompletePolicy,
CopyServicePolicies.BeforeCopyPolicy {
    protected static final String TAGGING_AUDIT_APPLICATION_NAME = "Alfresco Tagging Service";
    protected static final String TAGGING_AUDIT_ROOT_PATH = "/tagging";
    protected static final String TAGGING_AUDIT_KEY_NODEREF = "node";
    protected static final String TAGGING_AUDIT_KEY_TAGS = "tags";
    private static Log logger = LogFactory.getLog(TaggingServiceImpl.class);
    private static Collator collator = Collator.getInstance();
    private NodeService nodeService;
    private NodeService nodeServiceInternal;
    private CategoryService categoryService;
    private SearchService searchService;
    private ActionService actionService;
    private ContentService contentService;
    private NamespaceService namespaceService;
    private PolicyComponent policyComponent;
    private AuditComponent auditComponent;
    private EventGenerator eventGenerator;
    private static final String TAG_DETAILS_DELIMITER = "|";
    private static final String NEXT_TAG_DELIMITER = "\n";
    private static final String PARAM_INCLUDE_COUNT = "count";
    private static Set<String> FORBIDDEN_TAGS_SEQUENCES = new HashSet<String>(Arrays.asList("\n", "|"));
    private JavaBehaviour updateTagBehaviour;
    private JavaBehaviour createTagBehaviour;
    public static final String TAG_UPDATES = "tagUpdates";

    public void setCategoryService(CategoryService categoryService) {
        this.categoryService = categoryService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setNodeServiceInternal(NodeService nodeServiceInternal) {
        this.nodeServiceInternal = nodeServiceInternal;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setAuditComponent(AuditComponent auditComponent) {
        this.auditComponent = auditComponent;
    }

    public void setEventGenerator(EventGenerator eventGenerator) {
        this.eventGenerator = eventGenerator;
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"beforeDeleteNode"), ContentModel.ASPECT_TAGGABLE, (Behaviour)new JavaBehaviour(this, "beforeDeleteNode", Behaviour.NotificationFrequency.EVERY_EVENT));
        this.createTagBehaviour = new JavaBehaviour(this, "createTags", Behaviour.NotificationFrequency.FIRST_EVENT);
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnCreateNodePolicy.QNAME, ContentModel.ASPECT_TAGGABLE, (Behaviour)this.createTagBehaviour);
        this.updateTagBehaviour = new JavaBehaviour(this, "updateTags", Behaviour.NotificationFrequency.EVERY_EVENT);
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnUpdatePropertiesPolicy.QNAME, ContentModel.TYPE_CONTENT, (Behaviour)this.updateTagBehaviour);
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnUpdatePropertiesPolicy.QNAME, ContentModel.TYPE_FOLDER, (Behaviour)this.updateTagBehaviour);
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnMoveNodePolicy.QNAME, ContentModel.ASPECT_TAGGABLE, (Behaviour)new JavaBehaviour(this, "onMoveNode", Behaviour.NotificationFrequency.EVERY_EVENT));
        this.policyComponent.bindClassBehaviour(CopyServicePolicies.BeforeCopyPolicy.QNAME, ContentModel.ASPECT_TAGGABLE, (Behaviour)new JavaBehaviour(this, "beforeCopy", Behaviour.NotificationFrequency.EVERY_EVENT));
        this.policyComponent.bindClassBehaviour(CopyServicePolicies.OnCopyCompletePolicy.QNAME, ContentModel.ASPECT_TAGGABLE, (Behaviour)new JavaBehaviour(this, "onCopyComplete", Behaviour.NotificationFrequency.EVERY_EVENT));
        this.policyComponent.bindClassBehaviour(CheckOutCheckInServicePolicies.OnCheckOut.QNAME, ContentModel.ASPECT_TAGGABLE, (Behaviour)new JavaBehaviour(this, "afterCheckOut", Behaviour.NotificationFrequency.EVERY_EVENT));
    }

    private void updateAllScopeTags(NodeRef nodeRef, Boolean isAdd) {
        ChildAssociationRef assocRef = this.nodeService.getPrimaryParent(nodeRef);
        if (assocRef != null) {
            this.updateAllScopeTags(nodeRef, assocRef.getParentRef(), isAdd);
        }
    }

    private void updateAllScopeTags(NodeRef nodeRef, NodeRef parentNodeRef, Boolean isAdd) {
        if (parentNodeRef != null) {
            Map allQueuedUpdates = (Map)AlfrescoTransactionSupport.getResource((Object)TAG_UPDATES);
            Map nodeQueuedUpdates = null;
            if (allQueuedUpdates != null) {
                nodeQueuedUpdates = (Map)allQueuedUpdates.get(nodeRef);
            }
            List<String> tags = this.getTags(nodeRef);
            HashMap<String, Boolean> tagUpdates = new HashMap<String, Boolean>(tags.size());
            for (String tag : tags) {
                Boolean queuedOp;
                tagUpdates.put(tag, isAdd);
                if (nodeQueuedUpdates == null || (queuedOp = (Boolean)nodeQueuedUpdates.get(tag)) == null || queuedOp.booleanValue() != isAdd.booleanValue()) continue;
                nodeQueuedUpdates.remove(tag);
            }
            this.updateTagScope(parentNodeRef, tagUpdates);
        }
    }

    @Override
    public void beforeDeleteNode(NodeRef nodeRef) {
        if (this.nodeService.exists(nodeRef) && this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_TAGGABLE) && !this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_WORKING_COPY)) {
            this.updateAllScopeTags(nodeRef, Boolean.FALSE);
        }
    }

    @Override
    public void beforeCopy(QName classRef, NodeRef sourceNodeRef, NodeRef targetNodeRef) {
        if (this.nodeService.hasAspect(targetNodeRef, ContentModel.ASPECT_TAGGABLE)) {
            this.updateAllScopeTags(targetNodeRef, Boolean.FALSE);
        }
    }

    @Override
    public void onCopyComplete(QName classRef, NodeRef sourceNodeRef, NodeRef targetNodeRef, boolean copyToNewNode, Map<NodeRef, NodeRef> copyMap) {
        if (this.nodeService.hasAspect(targetNodeRef, ContentModel.ASPECT_TAGGABLE)) {
            this.updateAllScopeTags(targetNodeRef, Boolean.TRUE);
        }
    }

    @Override
    public void onMoveNode(ChildAssociationRef oldChildAssocRef, ChildAssociationRef newChildAssocRef) {
        ChildAssociationRef scopeParent;
        NodeRef oldRef = oldChildAssocRef.getChildRef();
        NodeRef oldParent = oldChildAssocRef.getParentRef();
        NodeRef newRef = newChildAssocRef.getChildRef();
        NodeRef newParent = newChildAssocRef.getParentRef();
        if (oldParent.equals((Object)newParent)) {
            return;
        }
        if (this.nodeService.hasAspect(oldRef, ContentModel.ASPECT_TAGGABLE) && (scopeParent = oldChildAssocRef.isPrimary() ? oldChildAssocRef : this.nodeService.getPrimaryParent(oldParent)) != null) {
            this.updateAllScopeTags(oldRef, scopeParent.getParentRef(), Boolean.FALSE);
        }
        if (this.nodeService.hasAspect(newRef, ContentModel.ASPECT_TAGGABLE)) {
            this.updateAllScopeTags(newRef, Boolean.TRUE);
        }
    }

    public void createTags(ChildAssociationRef childAssocRef) {
        NodeRef nodeRef = childAssocRef.getChildRef();
        HashMap<QName, Serializable> before = new HashMap<QName, Serializable>(0);
        Map after = this.nodeService.getProperties(nodeRef);
        this.updateTags(nodeRef, before, after);
    }

    public void updateTags(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        block6: {
            String tagName;
            ArrayList afterNodeRefs;
            List beforeNodeRefs;
            block7: {
                block5: {
                    beforeNodeRefs = (List)((Object)before.get(ContentModel.PROP_TAGS));
                    afterNodeRefs = (ArrayList)after.get(ContentModel.PROP_TAGS);
                    if (beforeNodeRefs != null || afterNodeRefs == null) break block5;
                    for (NodeRef afterNodeRef : afterNodeRefs) {
                        String tagName2 = this.getTagName(afterNodeRef);
                        this.queueTagUpdate(nodeRef, tagName2, true);
                    }
                    break block6;
                }
                if (afterNodeRefs != null || beforeNodeRefs == null) break block7;
                for (NodeRef beforeNodeRef : beforeNodeRefs) {
                    if (!this.nodeService.exists(beforeNodeRef)) continue;
                    String tagName3 = this.getTagName(beforeNodeRef);
                    this.queueTagUpdate(nodeRef, tagName3, false);
                }
                break block6;
            }
            if (afterNodeRefs == null || beforeNodeRefs == null) break block6;
            afterNodeRefs = new ArrayList(afterNodeRefs);
            for (NodeRef beforeNodeRef : beforeNodeRefs) {
                if (afterNodeRefs.contains(beforeNodeRef)) {
                    afterNodeRefs.remove(beforeNodeRef);
                    continue;
                }
                if (!this.nodeService.exists(beforeNodeRef)) continue;
                tagName = this.getTagName(beforeNodeRef);
                this.queueTagUpdate(nodeRef, tagName, false);
            }
            for (NodeRef afterNodeRef : afterNodeRefs) {
                tagName = this.getTagName(afterNodeRef);
                this.queueTagUpdate(nodeRef, tagName, true);
            }
        }
    }

    @Override
    public String getTagName(NodeRef nodeRef) {
        return (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
    }

    @Override
    public boolean isTag(StoreRef storeRef, String tag) {
        return this.getTagNodeRef(storeRef, tag.toLowerCase()) != null;
    }

    @Override
    public NodeRef createTag(StoreRef storeRef, String tag) {
        tag = tag.toLowerCase();
        return this.getTagNodeRef(storeRef, tag, true);
    }

    @Override
    public void deleteTag(StoreRef storeRef, String tag) {
        tag = tag.toLowerCase();
        List<NodeRef> taggedNodes = this.findTaggedNodes(storeRef, tag);
        for (NodeRef taggedNode : taggedNodes) {
            this.removeTag(taggedNode, tag);
        }
        NodeRef tagNodeRef = this.getTagNodeRef(storeRef, tag);
        if (tagNodeRef != null) {
            this.categoryService.deleteCategory(tagNodeRef);
        }
    }

    @Override
    public NodeRef changeTag(StoreRef storeRef, String existingTag, String newTag) {
        if (existingTag == null) {
            throw new TaggingException("Existing tag cannot be null");
        }
        if (newTag == null || StringUtils.isBlank((CharSequence)newTag)) {
            throw new TaggingException("New tag cannot be blank");
        }
        if ((existingTag = existingTag.toLowerCase()).equals(newTag = newTag.toLowerCase())) {
            throw new TaggingException("New and existing tags are the same");
        }
        if (this.getTagNodeRef(storeRef, existingTag) == null) {
            throw new NonExistentTagException("Tag " + existingTag + " not found");
        }
        if (this.getTagNodeRef(storeRef, newTag) != null) {
            throw new TagExistsException("Tag " + newTag + " already exists");
        }
        NodeRef tagNodeRef = this.getTagNodeRef(storeRef, existingTag);
        this.nodeService.setProperty(tagNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)newTag));
        this.nodeService.moveNode(tagNodeRef, TaggingService.TAG_ROOT_NODE_REF, ContentModel.ASSOC_SUBCATEGORIES, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)newTag));
        List<NodeRef> taggedNodes = this.findTaggedNodes(storeRef, existingTag);
        for (NodeRef nodeRef : taggedNodes) {
            this.eventGenerator.onUpdateProperties(nodeRef, Collections.emptyMap(), this.nodeService.getProperties(nodeRef));
            this.updateTagScope(nodeRef, Map.of(existingTag, false, newTag, true));
        }
        return tagNodeRef;
    }

    @Override
    public List<String> getTags(StoreRef storeRef) {
        ParameterCheck.mandatory((String)"storeRef", (Object)storeRef);
        Collection<ChildAssociationRef> rootCategories = this.categoryService.getRootCategories(storeRef, ContentModel.ASPECT_TAGGABLE);
        ArrayList<String> result = new ArrayList<String>(rootCategories.size());
        for (ChildAssociationRef rootCategory : rootCategories) {
            String name = (String)((Object)this.nodeService.getProperty(rootCategory.getChildRef(), ContentModel.PROP_NAME));
            result.add(name);
        }
        return result;
    }

    @Override
    public Pair<List<String>, Integer> getPagedTags(StoreRef storeRef, int fromTag, int pageSize) {
        ParameterCheck.mandatory((String)"storeRef", (Object)storeRef);
        ParameterCheck.mandatory((String)"fromTag", (Object)fromTag);
        ParameterCheck.mandatory((String)"pageSize", (Object)pageSize);
        Collection<ChildAssociationRef> rootCategories = this.categoryService.getRootCategories(storeRef, ContentModel.ASPECT_TAGGABLE);
        int totalCount = rootCategories.size();
        int startIndex = Math.max(fromTag, 0);
        int endIndex = Math.min(fromTag + pageSize, totalCount);
        ArrayList<String> result = new ArrayList<String>(pageSize);
        int index = 0;
        for (ChildAssociationRef rootCategory : rootCategories) {
            if (startIndex > index++) continue;
            String name = (String)((Object)this.nodeService.getProperty(rootCategory.getChildRef(), ContentModel.PROP_NAME));
            result.add(name);
            if (index == endIndex) break;
        }
        return new Pair(result, (Object)totalCount);
    }

    @Override
    public List<String> getTags(StoreRef storeRef, String filter) {
        ParameterCheck.mandatory((String)"storeRef", (Object)storeRef);
        List<String> result = null;
        if (filter == null || filter.length() == 0) {
            result = this.getTags(storeRef);
        } else {
            Collection<ChildAssociationRef> rootCategories = this.categoryService.getRootCategories(storeRef, ContentModel.ASPECT_TAGGABLE);
            result = new ArrayList<String>(rootCategories.size());
            for (ChildAssociationRef rootCategory : rootCategories) {
                String name = (String)((Object)this.nodeService.getProperty(rootCategory.getChildRef(), ContentModel.PROP_NAME));
                if (!name.contains(filter.toLowerCase())) continue;
                result.add(name);
            }
        }
        return result;
    }

    @Override
    public Pair<List<String>, Integer> getPagedTags(StoreRef storeRef, String filter, int fromTag, int pageSize) {
        ParameterCheck.mandatory((String)"storeRef", (Object)storeRef);
        ParameterCheck.mandatory((String)"fromTag", (Object)fromTag);
        ParameterCheck.mandatory((String)"pageSize", (Object)pageSize);
        if (filter == null || filter.length() == 0) {
            return this.getPagedTags(storeRef, fromTag, pageSize);
        }
        Collection<ChildAssociationRef> rootCategories = this.categoryService.getRootCategories(storeRef, ContentModel.ASPECT_TAGGABLE, filter);
        int totalCount = rootCategories.size();
        int startIndex = Math.max(fromTag, 0);
        int endIndex = Math.min(fromTag + pageSize, totalCount);
        ArrayList<String> result = new ArrayList<String>(pageSize);
        int index = 0;
        for (ChildAssociationRef rootCategory : rootCategories) {
            if (startIndex > index++) continue;
            String name = (String)((Object)this.nodeService.getProperty(rootCategory.getChildRef(), ContentModel.PROP_NAME));
            result.add(name);
            if (index == endIndex) break;
        }
        return new Pair(result, (Object)totalCount);
    }

    @Override
    public Map<String, Long> calculateCount(StoreRef storeRef) {
        List<Pair<String, Integer>> tagsByCount = this.findTaggedNodesAndCountByTagName(storeRef);
        HashMap<String, Long> tagsByCountMap = new HashMap<String, Long>();
        if (tagsByCount != null) {
            for (Pair<String, Integer> tagByCountElem : tagsByCount) {
                tagsByCountMap.put((String)tagByCountElem.getFirst(), (long)((Integer)tagByCountElem.getSecond()));
            }
        }
        return tagsByCountMap;
    }

    @Override
    public boolean hasTag(NodeRef nodeRef, String tag) {
        List<String> tags = this.getTags(nodeRef);
        return tags.contains(tag.toLowerCase());
    }

    @Override
    public NodeRef addTag(NodeRef nodeRef, String tagName) {
        NodeRef newTagNodeRef = null;
        if (tagName == null) {
            throw new IllegalArgumentException("Must provide a non-null tag");
        }
        this.updateTagBehaviour.disable();
        this.createTagBehaviour.disable();
        try {
            String tag = tagName.toLowerCase();
            newTagNodeRef = this.getTagNodeRef(nodeRef.getStoreRef(), tag, true);
            List<NodeRef> tagNodeRefs = new ArrayList(5);
            if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_TAGGABLE)) {
                this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_TAGGABLE, null);
            } else {
                List currentTagNodes = (List)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_TAGS));
                if (currentTagNodes != null) {
                    tagNodeRefs = currentTagNodes;
                }
            }
            if (!tagNodeRefs.contains(newTagNodeRef)) {
                tagNodeRefs.add(newTagNodeRef);
                this.nodeService.setProperty(nodeRef, ContentModel.PROP_TAGS, (Serializable)((Object)tagNodeRefs));
                this.queueTagUpdate(nodeRef, tag, true);
            }
        }
        finally {
            this.updateTagBehaviour.enable();
            this.createTagBehaviour.enable();
        }
        return newTagNodeRef;
    }

    @Override
    public List<Pair<String, NodeRef>> addTags(NodeRef nodeRef, List<String> tags) {
        ArrayList<Pair<String, NodeRef>> ret = new ArrayList<Pair<String, NodeRef>>();
        for (String tag : tags) {
            NodeRef tagNodeRef = this.addTag(nodeRef, tag);
            ret.add((Pair<String, NodeRef>)new Pair((Object)tag, (Object)tagNodeRef));
        }
        return ret;
    }

    @Override
    public NodeRef getTagNodeRef(StoreRef storeRef, String tag) {
        return this.getTagNodeRef(storeRef, tag, false);
    }

    private NodeRef getTagNodeRef(StoreRef storeRef, String tag, boolean create) {
        for (String forbiddenSequence : FORBIDDEN_TAGS_SEQUENCES) {
            if (!create || !tag.contains(forbiddenSequence)) continue;
            throw new IllegalArgumentException("Tag name must not contain " + StringEscapeUtils.escapeJava((String)forbiddenSequence) + " char sequence");
        }
        NodeRef tagNodeRef = null;
        Collection<ChildAssociationRef> results = this.categoryService.getRootCategories(storeRef, ContentModel.ASPECT_TAGGABLE, tag, create);
        if (!results.isEmpty()) {
            tagNodeRef = results.iterator().next().getChildRef();
        }
        return tagNodeRef;
    }

    @Override
    public void removeTag(NodeRef nodeRef, String tag) {
        this.updateTagBehaviour.disable();
        this.createTagBehaviour.disable();
        try {
            List currentTagNodes;
            NodeRef newTagNodeRef;
            tag = tag.toLowerCase();
            if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_TAGGABLE) && (newTagNodeRef = this.getTagNodeRef(nodeRef.getStoreRef(), tag)) != null && (currentTagNodes = (List)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_TAGS))) != null && currentTagNodes.size() != 0 && currentTagNodes.contains(newTagNodeRef)) {
                currentTagNodes.remove(newTagNodeRef);
                this.nodeService.setProperty(nodeRef, ContentModel.PROP_TAGS, (Serializable)((Object)currentTagNodes));
                this.queueTagUpdate(nodeRef, tag, false);
            }
        }
        finally {
            this.updateTagBehaviour.enable();
            this.createTagBehaviour.enable();
        }
    }

    @Override
    public void removeTags(NodeRef nodeRef, List<String> tags) {
        for (String tag : tags) {
            this.removeTag(nodeRef, tag);
        }
    }

    @Override
    public PagingResults<Pair<NodeRef, String>> getTags(NodeRef nodeRef, PagingRequest pagingRequest) {
        List currentTagNodes;
        if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_TAGGABLE) && (currentTagNodes = (List)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_TAGS))) != null) {
            final int totalItems = currentTagNodes.size();
            int skipCount = pagingRequest.getSkipCount();
            int maxItems = pagingRequest.getMaxItems();
            int end = maxItems == Integer.MAX_VALUE ? totalItems : skipCount + maxItems;
            int size = maxItems == Integer.MAX_VALUE ? totalItems : maxItems;
            ArrayList<Pair> sortedTags = new ArrayList<Pair>(size);
            for (NodeRef tagNode : currentTagNodes) {
                String tag = (String)((Object)this.nodeService.getProperty(tagNode, ContentModel.PROP_NAME));
                sortedTags.add(new Pair((Object)tagNode, (Object)tag));
            }
            Collections.sort(sortedTags, new Comparator<Pair<NodeRef, String>>(){

                @Override
                public int compare(Pair<NodeRef, String> o1, Pair<NodeRef, String> o2) {
                    String tag1 = (String)o1.getSecond();
                    String tag2 = (String)o2.getSecond();
                    return collator.compare(tag1, tag2);
                }
            });
            final ArrayList<Pair> result = new ArrayList<Pair>(size);
            Iterator it = sortedTags.iterator();
            int count = 0;
            while (count < end && it.hasNext()) {
                Pair tagPair = (Pair)it.next();
                if (count >= skipCount) {
                    result.add(tagPair);
                }
                ++count;
            }
            currentTagNodes = null;
            final boolean hasMoreItems = end < totalItems;
            return new PagingResults<Pair<NodeRef, String>>(){

                public List<Pair<NodeRef, String>> getPage() {
                    return result;
                }

                public boolean hasMoreItems() {
                    return hasMoreItems;
                }

                public Pair<Integer, Integer> getTotalResultCount() {
                    Integer total = totalItems;
                    return new Pair((Object)total, (Object)total);
                }

                public String getQueryExecutionId() {
                    return null;
                }
            };
        }
        return new EmptyPagingResults();
    }

    @Override
    public PagingResults<Pair<NodeRef, String>> getTags(StoreRef storeRef, PagingRequest pagingRequest) {
        return this.getTags(storeRef, pagingRequest, null, null);
    }

    @Override
    public PagingResults<Pair<NodeRef, String>> getTags(StoreRef storeRef, PagingRequest pagingRequest, Collection<String> exactNamesFilter, Collection<String> alikeNamesFilter) {
        ParameterCheck.mandatory((String)"storeRef", (Object)storeRef);
        PagingResults<ChildAssociationRef> rootCategories = this.categoryService.getRootCategories(storeRef, ContentModel.ASPECT_TAGGABLE, pagingRequest, true, exactNamesFilter, alikeNamesFilter);
        return this.mapPagingResult(rootCategories, childAssociation -> new Pair((Object)childAssociation.getChildRef(), (Object)childAssociation.getQName().getLocalName()));
    }

    @Override
    public Map<NodeRef, Long> getTags(StoreRef storeRef, List<String> parameterIncludes, Pair<String, Boolean> sorting, Collection<String> exactNamesFilter, Collection<String> alikeNamesFilter) {
        ParameterCheck.mandatory((String)"storeRef", (Object)storeRef);
        Collection<ChildAssociationRef> rootCategories = this.categoryService.getRootCategories(storeRef, ContentModel.ASPECT_TAGGABLE, exactNamesFilter, alikeNamesFilter);
        Map<String, Long> tagsMap = new TreeMap<String, Long>();
        for (ChildAssociationRef childAssociation : rootCategories) {
            tagsMap.put(childAssociation.getQName().getLocalName(), 0L);
        }
        Map<Object, Object> tagsByCountMap = new HashMap();
        if (parameterIncludes.contains(PARAM_INCLUDE_COUNT)) {
            tagsByCountMap = this.calculateCount(storeRef);
            for (Map.Entry entry : tagsMap.entrySet()) {
                entry.setValue(Optional.ofNullable((Long)tagsByCountMap.get(entry.getKey())).orElse(0L));
            }
        }
        if (sorting != null) {
            if (((String)sorting.getFirst()).equals("tag")) {
                if (!((Boolean)sorting.getSecond()).booleanValue()) {
                    Stream stream = tagsMap.entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByKey()));
                    tagsMap = stream.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
                } else {
                    Stream stream = tagsMap.entrySet().stream().sorted(Map.Entry.comparingByKey());
                    tagsMap = stream.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
                }
            } else if (((String)sorting.getFirst()).equals(PARAM_INCLUDE_COUNT)) {
                if (tagsByCountMap.isEmpty()) {
                    throw new IllegalArgumentException("Tag count should be included when ordering by count");
                }
                if (!((Boolean)sorting.getSecond()).booleanValue()) {
                    Stream stream = tagsMap.entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByValue()));
                    tagsMap = stream.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
                } else {
                    Stream stream = tagsMap.entrySet().stream().sorted(Map.Entry.comparingByValue());
                    tagsMap = stream.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
                }
            }
        }
        LinkedHashMap<NodeRef, Long> linkedHashMap = new LinkedHashMap<NodeRef, Long>();
        for (Map.Entry entry : tagsMap.entrySet()) {
            linkedHashMap.put(this.getTagNodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, (String)entry.getKey()), (Long)entry.getValue());
        }
        return linkedHashMap;
    }

    @Override
    public List<String> getTags(NodeRef nodeRef) {
        List currentTagNodes;
        ArrayList<String> result = new ArrayList<String>(10);
        if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_TAGGABLE) && (currentTagNodes = (List)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_TAGS))) != null) {
            for (NodeRef currentTagNode : currentTagNodes) {
                String tag = (String)((Object)this.nodeService.getProperty(currentTagNode, ContentModel.PROP_NAME));
                result.add(tag);
            }
        }
        return result;
    }

    @Override
    public void setTags(NodeRef nodeRef, List<String> tags) {
        this.updateTagBehaviour.disable();
        this.createTagBehaviour.disable();
        try {
            ArrayList<NodeRef> tagNodeRefs = new ArrayList<NodeRef>(tags.size());
            if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_TAGGABLE)) {
                this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_TAGGABLE, null);
            }
            List<String> oldTags = this.getTags(nodeRef);
            for (String tag : tags) {
                tag = tag.toLowerCase();
                NodeRef newTagNodeRef = this.getTagNodeRef(nodeRef.getStoreRef(), tag, true);
                if (tagNodeRefs.contains(newTagNodeRef)) continue;
                tagNodeRefs.add(newTagNodeRef);
                if (!oldTags.contains(tag)) {
                    this.queueTagUpdate(nodeRef, tag, true);
                    continue;
                }
                oldTags.remove(tag);
            }
            for (String oldTag : oldTags) {
                this.queueTagUpdate(nodeRef, oldTag, false);
            }
            this.nodeService.setProperty(nodeRef, ContentModel.PROP_TAGS, (Serializable)tagNodeRefs);
        }
        finally {
            this.updateTagBehaviour.enable();
            this.createTagBehaviour.enable();
        }
    }

    @Override
    public void clearTags(NodeRef nodeRef) {
        this.setTags(nodeRef, Collections.emptyList());
    }

    @Override
    public boolean isTagScope(NodeRef nodeRef) {
        return this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_TAGSCOPE);
    }

    @Override
    public void addTagScope(NodeRef nodeRef) {
        if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_TAGSCOPE)) {
            this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_TAGSCOPE, null);
            this.refreshTagScope(nodeRef, false);
        }
    }

    @Override
    public void refreshTagScope(NodeRef nodeRef, boolean async) {
        if (this.nodeService.exists(nodeRef) && this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_TAGSCOPE)) {
            Action action = this.actionService.createAction("refresh-tagscope");
            this.actionService.executeAction(action, nodeRef, false, async);
        }
    }

    @Override
    public void removeTagScope(NodeRef nodeRef) {
        if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_TAGSCOPE)) {
            this.nodeService.removeAspect(nodeRef, ContentModel.ASPECT_TAGSCOPE);
        }
    }

    @Override
    public TagScope findTagScope(NodeRef nodeRef) {
        TagScopeImpl tagScope = null;
        if (this.nodeService.exists(nodeRef)) {
            ArrayList<NodeRef> tagScopeNodeRefs = new ArrayList<NodeRef>(3);
            this.getTagScopes(nodeRef, tagScopeNodeRefs, true);
            if (tagScopeNodeRefs.size() != 0) {
                tagScope = new TagScopeImpl((NodeRef)tagScopeNodeRefs.get(0), this.getTagDetails((NodeRef)tagScopeNodeRefs.get(0)));
            }
        }
        return tagScope;
    }

    private List<TagDetails> getTagDetails(NodeRef nodeRef) {
        List<TagDetails> tagDetails = new ArrayList<TagDetails>(13);
        ContentReader reader = this.contentService.getReader(nodeRef, ContentModel.PROP_TAGSCOPE_CACHE);
        if (reader != null) {
            tagDetails = TaggingServiceImpl.readTagDetails(reader.getContentInputStream());
        }
        return tagDetails;
    }

    @Override
    public List<TagScope> findAllTagScopes(NodeRef nodeRef) {
        List result = null;
        if (this.nodeService.exists(nodeRef)) {
            ArrayList<NodeRef> tagScopeNodeRefs = new ArrayList<NodeRef>(3);
            this.getTagScopes(nodeRef, tagScopeNodeRefs);
            if (tagScopeNodeRefs.size() != 0) {
                result = new ArrayList(tagScopeNodeRefs.size());
                for (NodeRef tagScopeNodeRef : tagScopeNodeRefs) {
                    result.add(new TagScopeImpl(tagScopeNodeRef, this.getTagDetails(tagScopeNodeRef)));
                }
            } else {
                result = Collections.emptyList();
            }
        }
        return result;
    }

    private void getTagScopes(NodeRef nodeRef, List<NodeRef> tagScopes) {
        this.getTagScopes(nodeRef, tagScopes, false);
    }

    private void getTagScopes(final NodeRef nodeRef, List<NodeRef> tagScopes, boolean firstOnly) {
        NodeRef parent;
        Boolean hasAspect = (Boolean)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Boolean>(){

            public Boolean doWork() throws Exception {
                return TaggingServiceImpl.this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_TAGSCOPE);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        if (Boolean.TRUE.equals(hasAspect)) {
            tagScopes.add(nodeRef);
            if (firstOnly) {
                return;
            }
        }
        if ((parent = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                NodeRef result = null;
                ChildAssociationRef assoc = TaggingServiceImpl.this.nodeService.getPrimaryParent(nodeRef);
                if (assoc != null) {
                    result = assoc.getParentRef();
                }
                return result;
            }
        }, (String)AuthenticationUtil.getSystemUserName())) != null) {
            this.getTagScopes(parent, tagScopes, firstOnly);
        }
    }

    @Override
    public List<NodeRef> findTaggedNodes(StoreRef storeRef, String tag) {
        tag = tag.toLowerCase();
        try (ResultSet resultSet = null;){
            List nodeRefs;
            resultSet = this.searchService.query(storeRef, "lucene", "+PATH:\"/cm:taggable/cm:" + ISO9075.encode((String)tag) + "/member\"");
            List list = nodeRefs = resultSet.getNodeRefs();
            return list;
        }
    }

    @Override
    public List<NodeRef> findTaggedNodes(StoreRef storeRef, String tag, NodeRef nodeRef) {
        tag = tag.toLowerCase();
        Path nodePath = this.nodeService.getPath(nodeRef);
        String pathString = nodePath.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        try (ResultSet resultSet = null;){
            List nodeRefs;
            resultSet = this.searchService.query(storeRef, "lucene", "+PATH:\"" + pathString + "//*\" +PATH:\"/cm:taggable/cm:" + ISO9075.encode((String)tag) + "/member\"");
            List list = nodeRefs = resultSet.getNodeRefs();
            return list;
        }
    }

    static List<TagDetails> readTagDetails(InputStream is) {
        ArrayList<TagDetails> result;
        block20: {
            result = new ArrayList<TagDetails>(25);
            BufferedReader reader = null;
            try {
                try {
                    reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    String nextLine = reader.readLine();
                    while (nextLine != null) {
                        block18: {
                            String[] values = nextLine.split("\\|");
                            if (values.length == 1) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("No count for tag " + values[0]));
                                }
                            } else if (values.length > 1) {
                                try {
                                    result.add(new TagDetailsImpl(values[0], Integer.parseInt(values[1])));
                                    if (values.length > 2 && logger.isDebugEnabled()) {
                                        logger.debug((Object)("Ignoring extra guff for tag: " + values[0]));
                                    }
                                }
                                catch (NumberFormatException numberFormatException) {
                                    if (!logger.isDebugEnabled()) break block18;
                                    logger.debug((Object)("Invalid tag count for " + values[0] + "<" + values[1] + ">"));
                                }
                            }
                        }
                        nextLine = reader.readLine();
                    }
                }
                catch (Exception exception) {
                    logger.warn((Object)"Unable to read tag details", (Throwable)exception);
                    try {
                        reader.close();
                    }
                    catch (Exception exception2) {}
                    break block20;
                }
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
        return result;
    }

    static String tagDetailsToString(List<TagDetails> tagDetails) {
        StringBuffer result = new StringBuffer(255);
        boolean bFirst = true;
        for (TagDetails details : tagDetails) {
            if (!bFirst) {
                result.append(NEXT_TAG_DELIMITER);
            } else {
                bFirst = false;
            }
            result.append(details.getName());
            result.append(TAG_DETAILS_DELIMITER);
            result.append(details.getCount());
        }
        return result.toString();
    }

    private void updateTagScope(NodeRef nodeRef, Map<String, Boolean> updates) {
        ArrayList<NodeRef> tagScopeNodeRefs = new ArrayList<NodeRef>(3);
        this.getTagScopes(nodeRef, tagScopeNodeRefs);
        if (tagScopeNodeRefs.size() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No tag scopes found for " + String.valueOf(nodeRef) + " so no scope updates needed"));
            }
            return;
        }
        HashMap<String, Integer> changes = new HashMap<String, Integer>(updates.size());
        for (String tag : updates.keySet()) {
            int val = -1;
            if (updates.get(tag).booleanValue()) {
                val = 1;
            }
            changes.put(tag, val);
        }
        for (NodeRef tagScopeNode : tagScopeNodeRefs) {
            HashMap<String, Serializable> auditValues = new HashMap<String, Serializable>();
            auditValues.put(TAGGING_AUDIT_KEY_TAGS, changes);
            auditValues.put(TAGGING_AUDIT_KEY_NODEREF, (Serializable)((Object)tagScopeNode.toString()));
            this.auditComponent.recordAuditValues(TAGGING_AUDIT_ROOT_PATH, auditValues);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Queueing async tag scope updates to tag scopes " + String.valueOf(tagScopeNodeRefs) + " of " + String.valueOf(changes)));
        }
        Action action = this.actionService.createAction("update-tagscope");
        action.setParameterValue("tag_scopes", tagScopeNodeRefs);
        this.actionService.executeAction(action, null, false, true);
    }

    private void queueTagUpdate(NodeRef nodeRef, String tag, boolean add) {
        HashMap<String, Boolean> nodeDetails;
        HashMap updates = (HashMap)AlfrescoTransactionSupport.getResource((Object)TAG_UPDATES);
        if (updates == null) {
            updates = new HashMap(10);
            AlfrescoTransactionSupport.bindResource((Object)TAG_UPDATES, updates);
            AlfrescoTransactionSupport.bindListener(this);
        }
        if ((nodeDetails = (HashMap<String, Boolean>)updates.get(nodeRef)) == null) {
            nodeDetails = new HashMap<String, Boolean>(10);
            nodeDetails.put(tag, add);
            updates.put(nodeRef, nodeDetails);
        } else {
            Boolean currentValue = (Boolean)nodeDetails.get(tag);
            if (currentValue == null) {
                nodeDetails.put(tag, add);
                updates.put(nodeRef, nodeDetails);
            } else if (currentValue != add) {
                nodeDetails.remove(tag);
            }
        }
    }

    @Override
    public void afterCommit() {
    }

    @Override
    public void afterRollback() {
    }

    @Override
    public void beforeCommit(boolean readOnly) {
        Map updates = (Map)AlfrescoTransactionSupport.getResource((Object)TAG_UPDATES);
        if (updates != null) {
            for (NodeRef nodeRef : updates.keySet()) {
                Map tagUpdates = (Map)updates.get(nodeRef);
                if (tagUpdates == null || tagUpdates.size() == 0 || !this.nodeServiceInternal.exists(nodeRef)) continue;
                this.updateTagScope(nodeRef, tagUpdates);
            }
        }
    }

    @Override
    public void beforeCompletion() {
    }

    @Override
    public void flush() {
    }

    public void afterCheckOut(NodeRef workingCopy) {
        if (this.nodeService.exists(workingCopy) && this.nodeService.hasAspect(workingCopy, ContentModel.ASPECT_TAGGABLE) && this.nodeService.hasAspect(workingCopy, ContentModel.ASPECT_WORKING_COPY)) {
            this.updateAllScopeTags(workingCopy, Boolean.FALSE);
        }
    }

    @Override
    public List<Pair<String, Integer>> findTaggedNodesAndCountByTagName(StoreRef storeRef) {
        String queryTaggeble = "ASPECT:\"" + String.valueOf(ContentModel.ASPECT_TAGGABLE) + "\"-ASPECT:\"" + String.valueOf(ContentModel.ASPECT_WORKING_COPY) + "\"";
        SearchParameters sp = new SearchParameters();
        sp.setQuery(queryTaggeble);
        sp.setLanguage("lucene");
        sp.addStore(storeRef);
        sp.addFieldFacet(new SearchParameters.FieldFacet("TAG"));
        try (ResultSet resultSet = null;){
            resultSet = this.searchService.query(sp);
            List list = resultSet.getFieldFacet("TAG");
            return list;
        }
    }

    @Override
    public long findCountByTagName(StoreRef storeRef, String name) {
        String query = "TAG:\"" + name + "\"-ASPECT:\"" + String.valueOf(ContentModel.ASPECT_WORKING_COPY) + "\"";
        SearchParameters sp = new SearchParameters();
        sp.setQuery(query);
        sp.setLanguage("lucene");
        sp.addStore(storeRef);
        try (ResultSet resultSet = null;){
            resultSet = this.searchService.query(sp);
            long l = resultSet.getNumberFound();
            return l;
        }
    }

    @Override
    public List<Pair<String, NodeRef>> createTags(StoreRef storeRef, List<String> tagNames) {
        this.updateTagBehaviour.disable();
        this.createTagBehaviour.disable();
        try {
            List<Pair<String, NodeRef>> list = tagNames.stream().map(String::toLowerCase).peek(tagName -> this.categoryService.getRootCategories(storeRef, ContentModel.ASPECT_TAGGABLE, (String)tagName, false).stream().filter(association -> Objects.nonNull(association.getChildRef())).findAny().ifPresent(association -> {
                throw new DuplicateChildNodeNameException(association.getParentRef(), association.getTypeQName(), (String)tagName, null);
            })).map(tagName -> new Pair(tagName, (Object)this.getTagNodeRef(storeRef, (String)tagName, true))).collect(Collectors.toList());
            return list;
        }
        finally {
            this.updateTagBehaviour.enable();
            this.createTagBehaviour.enable();
        }
    }

    private <T, R> PagingResults<R> mapPagingResult(final PagingResults<T> pagingResults, final Function<T, R> mapper) {
        return new PagingResults<R>(){

            public List<R> getPage() {
                return pagingResults.getPage().stream().map(mapper).collect(Collectors.toList());
            }

            public boolean hasMoreItems() {
                return pagingResults.hasMoreItems();
            }

            public Pair<Integer, Integer> getTotalResultCount() {
                return pagingResults.getTotalResultCount();
            }

            public String getQueryExecutionId() {
                return pagingResults.getQueryExecutionId();
            }
        };
    }
}

