/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search;

import java.util.HashSet;
import java.util.Locale;
import junit.framework.TestCase;
import org.alfresco.repo.search.MLAnalysisMode;

public class MLAnaysisModeExpansionTest
extends TestCase {
    public MLAnaysisModeExpansionTest() {
    }

    public MLAnaysisModeExpansionTest(String arg0) {
        super(arg0);
    }

    public void testIdentity() {
        Locale locale = Locale.UK;
        HashSet locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.LOCALE_ONLY, (Locale)locale, (boolean)false));
        MLAnaysisModeExpansionTest.assertEquals((int)1, (int)locales.size());
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(locale));
    }

    public void testIdentityAndAll() {
        Locale locale = Locale.UK;
        HashSet locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.LOCALE_AND_ALL, (Locale)locale, (boolean)false));
        MLAnaysisModeExpansionTest.assertEquals((int)2, (int)locales.size());
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(locale));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("", "", "")));
    }

    public void testAll() {
        Locale locale = Locale.UK;
        HashSet locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.ALL_ONLY, (Locale)locale, (boolean)false));
        MLAnaysisModeExpansionTest.assertEquals((int)1, (int)locales.size());
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("", "", "")));
    }

    public void testContaining() {
        Locale locale = Locale.UK;
        HashSet locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.LOCALE_AND_ALL_CONTAINING_LOCALES, (Locale)locale, (boolean)false));
        MLAnaysisModeExpansionTest.assertEquals((int)2, (int)locales.size());
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "GB", "")));
    }

    public void testContainingAndAll() {
        Locale locale = Locale.UK;
        HashSet locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.LOCALE_AND_ALL_CONTAINING_LOCALES_AND_ALL, (Locale)locale, (boolean)false));
        MLAnaysisModeExpansionTest.assertEquals((int)3, (int)locales.size());
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("", "", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "GB", "")));
    }

    public void testContained() {
        HashSet locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.LOCALE_AND_ALL_CONTAINED_LOCALES, (Locale)new Locale("en", "", ""), (boolean)false));
        MLAnaysisModeExpansionTest.assertTrue((locales.size() >= 9 ? 1 : 0) != 0);
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "AU", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "GB", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "US", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "ZA", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "CA", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "IE", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "NZ", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "IN", "")));
    }

    public void testLang() {
        HashSet locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.LOCALE_AND_ALL_CONTAINED_LOCALES, (Locale)new Locale("en", "GB", ""), (boolean)false));
        MLAnaysisModeExpansionTest.assertTrue((locales.size() >= 1 ? 1 : 0) != 0);
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "GB", "")));
        locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.ALL_LANGUAGES, (Locale)new Locale("en", "GB", ""), (boolean)false));
        MLAnaysisModeExpansionTest.assertTrue((locales.size() >= 9 ? 1 : 0) != 0);
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "AU", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "GB", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "US", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "ZA", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "CA", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "IE", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "NZ", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "IN", "")));
        locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.ALL_LANGUAGES_AND_ALL, (Locale)new Locale("en", "GB", ""), (boolean)false));
        MLAnaysisModeExpansionTest.assertTrue((locales.size() >= 10 ? 1 : 0) != 0);
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("", "", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "AU", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "GB", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "US", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "ZA", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "CA", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "IE", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "NZ", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "IN", "")));
    }

    public void testExactLang() {
        HashSet locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.LOCALE_AND_ALL_CONTAINED_LOCALES, (Locale)new Locale("en", "GB", ""), (boolean)false));
        MLAnaysisModeExpansionTest.assertTrue((locales.size() >= 1 ? 1 : 0) != 0);
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "GB", "")));
        locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.EXACT_LANGUAGE, (Locale)new Locale("en", "GB", ""), (boolean)false));
        MLAnaysisModeExpansionTest.assertEquals((int)1, (int)locales.size());
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "", "")));
        locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.EXACT_LANGUAGE_AND_ALL, (Locale)new Locale("en", "GB", ""), (boolean)false));
        MLAnaysisModeExpansionTest.assertEquals((int)2, (int)locales.size());
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("", "", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "", "")));
    }

    public void testCountry() {
        HashSet locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.LOCALE_AND_ALL_CONTAINED_LOCALES, (Locale)new Locale("en", "GB", ""), (boolean)false));
        MLAnaysisModeExpansionTest.assertTrue((locales.size() >= 1 ? 1 : 0) != 0);
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "GB", "")));
        locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.ALL_COUNTRIES, (Locale)new Locale("en", "", ""), (boolean)false));
        MLAnaysisModeExpansionTest.assertTrue((locales.size() >= 9 ? 1 : 0) != 0);
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "AU", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "GB", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "US", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "ZA", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "CA", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "IE", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "NZ", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "IN", "")));
        locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.ALL_COUNTRIES, (Locale)new Locale("en", "GB", ""), (boolean)false));
        MLAnaysisModeExpansionTest.assertTrue((locales.size() >= 1 ? 1 : 0) != 0);
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "GB", "")));
        locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.ALL_COUNTRIES_AND_ALL, (Locale)new Locale("en", "", ""), (boolean)false));
        MLAnaysisModeExpansionTest.assertTrue((locales.size() >= 10 ? 1 : 0) != 0);
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("", "", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "AU", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "GB", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "US", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "ZA", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "CA", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "IE", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "NZ", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "IN", "")));
        locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.ALL_COUNTRIES_AND_ALL, (Locale)new Locale("en", "GB", ""), (boolean)false));
        MLAnaysisModeExpansionTest.assertTrue((locales.size() >= 2 ? 1 : 0) != 0);
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("", "", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "GB", "")));
    }

    public void testExactCountry() {
        HashSet locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.LOCALE_AND_ALL_CONTAINED_LOCALES, (Locale)new Locale("en", "GB", ""), (boolean)false));
        MLAnaysisModeExpansionTest.assertTrue((locales.size() >= 1 ? 1 : 0) != 0);
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "GB", "")));
        locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.EXACT_COUNRTY, (Locale)new Locale("en", "GB", ""), (boolean)false));
        MLAnaysisModeExpansionTest.assertEquals((int)1, (int)locales.size());
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "GB", "")));
        locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.EXACT_COUNRTY, (Locale)new Locale("en", "", ""), (boolean)false));
        MLAnaysisModeExpansionTest.assertTrue((locales.size() >= 9 ? 1 : 0) != 0);
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "AU", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "GB", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "US", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "ZA", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "CA", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "IE", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "NZ", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "IN", "")));
        locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.EXACT_COUNTRY_AND_ALL, (Locale)new Locale("en", "GB", ""), (boolean)false));
        MLAnaysisModeExpansionTest.assertEquals((int)2, (int)locales.size());
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("", "", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "GB", "")));
        locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.EXACT_COUNTRY_AND_ALL, (Locale)new Locale("en", "", ""), (boolean)false));
        MLAnaysisModeExpansionTest.assertTrue((locales.size() >= 10 ? 1 : 0) != 0);
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("", "", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "AU", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "GB", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "US", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "ZA", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "CA", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "IE", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "NZ", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "IN", "")));
    }

    public void testIdentityWC() {
        Locale locale = Locale.UK;
        HashSet locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.LOCALE_ONLY, (Locale)locale, (boolean)true));
        MLAnaysisModeExpansionTest.assertEquals((int)1, (int)locales.size());
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(locale));
    }

    public void testIdentityAndAllWC() {
        Locale locale = Locale.UK;
        HashSet locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.LOCALE_AND_ALL, (Locale)locale, (boolean)true));
        MLAnaysisModeExpansionTest.assertEquals((int)3, (int)locales.size());
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(locale));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("", "", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("*", "", "")));
    }

    public void testAllWC() {
        Locale locale = Locale.UK;
        HashSet locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.ALL_ONLY, (Locale)locale, (boolean)true));
        MLAnaysisModeExpansionTest.assertEquals((int)2, (int)locales.size());
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("", "", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("*", "", "")));
    }

    public void testContainingWC() {
        Locale locale = Locale.UK;
        HashSet locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.LOCALE_AND_ALL_CONTAINING_LOCALES, (Locale)locale, (boolean)true));
        MLAnaysisModeExpansionTest.assertEquals((int)2, (int)locales.size());
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "GB", "")));
    }

    public void testContainingAndAllWC() {
        Locale locale = Locale.UK;
        HashSet locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.LOCALE_AND_ALL_CONTAINING_LOCALES_AND_ALL, (Locale)locale, (boolean)true));
        MLAnaysisModeExpansionTest.assertEquals((int)4, (int)locales.size());
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("", "", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("*", "", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "GB", "")));
    }

    public void testContainedWC() {
        HashSet locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.LOCALE_AND_ALL_CONTAINED_LOCALES, (Locale)new Locale("en", "", ""), (boolean)true));
        MLAnaysisModeExpansionTest.assertEquals((int)2, (int)locales.size());
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "*", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "", "")));
    }

    public void testLangWC() {
        HashSet locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.LOCALE_AND_ALL_CONTAINED_LOCALES, (Locale)new Locale("en", "GB", ""), (boolean)true));
        MLAnaysisModeExpansionTest.assertEquals((int)2, (int)locales.size());
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "GB", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "GB", "*")));
        locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.ALL_LANGUAGES, (Locale)new Locale("en", "GB", ""), (boolean)true));
        MLAnaysisModeExpansionTest.assertEquals((int)2, (int)locales.size());
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "*", "")));
        locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.ALL_LANGUAGES_AND_ALL, (Locale)new Locale("en", "GB", ""), (boolean)true));
        MLAnaysisModeExpansionTest.assertEquals((int)4, (int)locales.size());
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("", "", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("*", "", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "*", "")));
    }

    public void testExactLangWC() {
        HashSet locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.LOCALE_AND_ALL_CONTAINED_LOCALES, (Locale)new Locale("en", "GB", ""), (boolean)true));
        MLAnaysisModeExpansionTest.assertEquals((int)2, (int)locales.size());
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "GB", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "GB", "*")));
        locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.EXACT_LANGUAGE, (Locale)new Locale("en", "GB", ""), (boolean)true));
        MLAnaysisModeExpansionTest.assertEquals((int)1, (int)locales.size());
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "", "")));
        locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.EXACT_LANGUAGE_AND_ALL, (Locale)new Locale("en", "GB", ""), (boolean)true));
        MLAnaysisModeExpansionTest.assertEquals((int)3, (int)locales.size());
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("", "", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("*", "", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "", "")));
    }

    public void testCountryWC() {
        HashSet locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.LOCALE_AND_ALL_CONTAINED_LOCALES, (Locale)new Locale("en", "GB", ""), (boolean)true));
        MLAnaysisModeExpansionTest.assertEquals((int)2, (int)locales.size());
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "GB", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "GB", "*")));
        locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.ALL_COUNTRIES, (Locale)new Locale("en", "", ""), (boolean)true));
        MLAnaysisModeExpansionTest.assertEquals((int)2, (int)locales.size());
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "*", "")));
        locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.ALL_COUNTRIES, (Locale)new Locale("en", "GB", ""), (boolean)true));
        MLAnaysisModeExpansionTest.assertEquals((int)2, (int)locales.size());
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "GB", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "GB", "*")));
        locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.ALL_COUNTRIES_AND_ALL, (Locale)new Locale("en", "", ""), (boolean)true));
        MLAnaysisModeExpansionTest.assertEquals((int)4, (int)locales.size());
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("", "", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("*", "", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "*", "")));
        locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.ALL_COUNTRIES_AND_ALL, (Locale)new Locale("en", "GB", ""), (boolean)true));
        MLAnaysisModeExpansionTest.assertEquals((int)4, (int)locales.size());
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("", "", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("*", "", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "GB", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "GB", "*")));
    }

    public void testExactCountryWC() {
        HashSet locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.LOCALE_AND_ALL_CONTAINED_LOCALES, (Locale)new Locale("en", "GB", ""), (boolean)true));
        MLAnaysisModeExpansionTest.assertEquals((int)2, (int)locales.size());
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "GB", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "GB", "*")));
        locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.EXACT_COUNRTY, (Locale)new Locale("en", "GB", ""), (boolean)true));
        MLAnaysisModeExpansionTest.assertEquals((int)1, (int)locales.size());
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "GB", "")));
        locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.EXACT_COUNRTY, (Locale)new Locale("en", "", ""), (boolean)true));
        MLAnaysisModeExpansionTest.assertEquals((int)2, (int)locales.size());
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "*", "")));
        locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.EXACT_COUNTRY_AND_ALL, (Locale)new Locale("en", "GB", ""), (boolean)true));
        MLAnaysisModeExpansionTest.assertEquals((int)3, (int)locales.size());
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("", "", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("*", "", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "GB", "")));
        locales = new HashSet();
        locales.addAll(MLAnalysisMode.getLocales((MLAnalysisMode)MLAnalysisMode.EXACT_COUNTRY_AND_ALL, (Locale)new Locale("en", "", ""), (boolean)true));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("", "", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("*", "", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "", "")));
        MLAnaysisModeExpansionTest.assertTrue((boolean)locales.contains(new Locale("en", "*", "")));
    }
}

