/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.management.subsystems;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.dictionary.DictionaryRepositoryBootstrappedEvent;
import org.alfresco.repo.domain.schema.SchemaAvailableEvent;
import org.alfresco.repo.management.subsystems.PropertyBackedBean;
import org.alfresco.repo.management.subsystems.PropertyBackedBeanEvent;
import org.alfresco.repo.management.subsystems.PropertyBackedBeanRegisteredEvent;
import org.alfresco.repo.management.subsystems.PropertyBackedBeanRegistry;
import org.alfresco.repo.management.subsystems.PropertyBackedBeanRemovePropertiesEvent;
import org.alfresco.repo.management.subsystems.PropertyBackedBeanSetPropertiesEvent;
import org.alfresco.repo.management.subsystems.PropertyBackedBeanSetPropertyEvent;
import org.alfresco.repo.management.subsystems.PropertyBackedBeanStartedEvent;
import org.alfresco.repo.management.subsystems.PropertyBackedBeanStoppedEvent;
import org.alfresco.repo.management.subsystems.PropertyBackedBeanUnregisteredEvent;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.TransactionListener;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public class DefaultPropertyBackedBeanRegistry
implements PropertyBackedBeanRegistry,
ApplicationListener,
TransactionListener {
    private boolean isSchemaAvailable;
    private boolean wasDictionaryBootstrapped = false;
    private List<PropertyBackedBeanEvent> deferredEvents = new LinkedList<PropertyBackedBeanEvent>();
    private List<PropertyBackedBeanEvent> afterTransactionEvents = new LinkedList<PropertyBackedBeanEvent>();
    private List<ApplicationListener> listeners = new LinkedList<ApplicationListener>();

    @Override
    public void addListener(ApplicationListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void register(PropertyBackedBean bean) {
        this.broadcastEvent(new PropertyBackedBeanRegisteredEvent(bean));
    }

    @Override
    public void deregister(PropertyBackedBean bean, boolean isPermanent) {
        this.broadcastEvent(new PropertyBackedBeanUnregisteredEvent(bean, isPermanent));
    }

    @Override
    public void broadcastStart(PropertyBackedBean bean) {
        this.broadcastEvent(new PropertyBackedBeanStartedEvent(bean));
    }

    @Override
    public void broadcastStop(PropertyBackedBean bean) {
        this.broadcastEvent(new PropertyBackedBeanStoppedEvent(bean));
    }

    @Override
    public void broadcastSetProperty(PropertyBackedBean bean, String name, String value) {
        this.broadcastEvent(new PropertyBackedBeanSetPropertyEvent(bean, name, value));
    }

    @Override
    public void broadcastSetProperties(PropertyBackedBean bean, Map<String, String> properties) {
        this.broadcastEvent(new PropertyBackedBeanSetPropertiesEvent(bean, properties));
    }

    @Override
    public void broadcastRemoveProperties(PropertyBackedBean bean, Collection<String> properties) {
        this.broadcastEvent(new PropertyBackedBeanRemovePropertiesEvent(bean, properties));
    }

    private void broadcastEvent(PropertyBackedBeanEvent event) {
        if (this.isSchemaAvailable && this.wasDictionaryBootstrapped) {
            if (AlfrescoTransactionSupport.getTransactionId() != null && (event instanceof PropertyBackedBeanStartedEvent || event instanceof PropertyBackedBeanStoppedEvent)) {
                this.afterTransactionEvents.add(event);
                AlfrescoTransactionSupport.bindListener(this);
            } else {
                for (ApplicationListener listener : this.listeners) {
                    listener.onApplicationEvent((ApplicationEvent)event);
                }
            }
        } else {
            this.deferredEvents.add(event);
        }
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof SchemaAvailableEvent) {
            this.isSchemaAvailable = true;
            if (this.wasDictionaryBootstrapped && this.isSchemaAvailable) {
                for (PropertyBackedBeanEvent event1 : this.deferredEvents) {
                    this.broadcastEvent(event1);
                }
                this.deferredEvents.clear();
            }
        }
        if (event instanceof DictionaryRepositoryBootstrappedEvent) {
            this.wasDictionaryBootstrapped = true;
            if (this.wasDictionaryBootstrapped && this.isSchemaAvailable) {
                for (PropertyBackedBeanEvent event1 : this.deferredEvents) {
                    this.broadcastEvent(event1);
                }
                this.deferredEvents.clear();
            }
        }
    }

    @Override
    public void beforeCommit(boolean readOnly) {
    }

    @Override
    public void afterCommit() {
        for (ApplicationEvent applicationEvent : this.afterTransactionEvents) {
            for (ApplicationListener listener : this.listeners) {
                listener.onApplicationEvent(applicationEvent);
            }
        }
        this.afterTransactionEvents.clear();
    }

    @Override
    public void beforeCompletion() {
    }

    @Override
    public void afterRollback() {
    }

    @Override
    public void flush() {
    }
}

