/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer.reportd;

import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import org.alfresco.repo.transfer.TransferDestinationReportWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.springframework.extensions.surf.util.ISO8601DateFormat;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLTransferDestinationReportWriter
implements TransferDestinationReportWriter {
    private XMLWriter writer;
    final AttributesImpl EMPTY_ATTRIBUTES = new AttributesImpl();
    final String PREFIX = "report";

    @Override
    public void startTransferReport(String encoding, Writer writer) {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setNewLineAfterDeclaration(false);
        format.setIndentSize(3);
        format.setEncoding(encoding);
        try {
            this.writer = new XMLWriter(writer, format);
            this.writer.startDocument();
            this.writer.startPrefixMapping("report", "http://www.alfresco.org/model/transferDestinationReport/1.0");
            this.writer.startElement("http://www.alfresco.org/model/transferDestinationReport/1.0", "transferDestinationReport", "report:transferDestinationReport", (Attributes)this.EMPTY_ATTRIBUTES);
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
    }

    @Override
    public void endTransferReport() {
        try {
            this.writer.endElement("http://www.alfresco.org/model/transferDestinationReport/1.0", "transferDestinationReport", "report:transferDestinationReport");
            this.writer.endPrefixMapping("report");
            this.writer.endDocument();
            this.writer.flush();
            this.writer.close();
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void writeChangeState(String state) {
        try {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("http://www.alfresco.org/model/transferDestinationReport/1.0", "state", "state", "String", state);
            attributes.addAttribute("http://www.alfresco.org/model/transferReport/1.0", "date", "date", "dateTime", ISO8601DateFormat.format((Date)new Date()));
            this.writer.startElement("http://www.alfresco.org/model/transferDestinationReport/1.0", "state", "report:state", (Attributes)attributes);
            this.writer.endElement("http://www.alfresco.org/model/transferDestinationReport/1.0", "state", "report:state");
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
    }

    @Override
    public void writeException(Throwable e) {
        try {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("http://www.alfresco.org/model/transferDestinationReport/1.0", "type", "type", "String", e.getClass().getName());
            attributes.addAttribute("http://www.alfresco.org/model/transferDestinationReport/1.0", "message", "message", "String", e.getMessage());
            this.writer.startElement("http://www.alfresco.org/model/transferDestinationReport/1.0", "exception", "report:exception", (Attributes)attributes);
            this.writer.endElement("http://www.alfresco.org/model/transferDestinationReport/1.0", "exception", "report:exception");
        }
        catch (SAXException sAXException) {}
    }

    @Override
    public void writeComment(String comment) {
        try {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("http://www.alfresco.org/model/transferReport/1.0", "date", "date", "dateTime", ISO8601DateFormat.format((Date)new Date()));
            this.writer.startElement("http://www.alfresco.org/model/transferDestinationReport/1.0", "comment", "report:comment", (Attributes)attributes);
            this.writer.characters(comment.toCharArray(), 0, comment.length());
            this.writer.endElement("http://www.alfresco.org/model/transferDestinationReport/1.0", "comment", "report:comment");
        }
        catch (SAXException sAXException) {}
    }

    @Override
    public void writeCreated(NodeRef sourceNodeRef, NodeRef newNode, NodeRef newParentNodeRef, String newPath) {
        try {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("http://www.alfresco.org/model/transferReport/1.0", "date", "date", "dateTime", ISO8601DateFormat.format((Date)new Date()));
            attributes.addAttribute("http://www.alfresco.org/model/transferReport/1.0", "sourceNodeRef", "sourceNodeRef", "string", sourceNodeRef.toString());
            attributes.addAttribute("http://www.alfresco.org/model/transferReport/1.0", "destinationNodeRef", "destinationNodeRef", "string", newNode.toString());
            attributes.addAttribute("http://www.alfresco.org/model/transferReport/1.0", "parentNodeRef", "parentNodeRef", "string", newParentNodeRef.toString());
            this.writer.startElement("http://www.alfresco.org/model/transferDestinationReport/1.0", "created", "report:created", (Attributes)attributes);
            this.writeDestinationPath(newPath);
            this.writer.endElement("http://www.alfresco.org/model/transferDestinationReport/1.0", "created", "report:created");
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
    }

    @Override
    public void writeDeleted(NodeRef sourceNodeRef, NodeRef deletedNode, String oldPath) {
        try {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("http://www.alfresco.org/model/transferReport/1.0", "date", "date", "dateTime", ISO8601DateFormat.format((Date)new Date()));
            attributes.addAttribute("http://www.alfresco.org/model/transferReport/1.0", "sourceNodeRef", "sourceNodeRef", "string", sourceNodeRef.toString());
            attributes.addAttribute("http://www.alfresco.org/model/transferReport/1.0", "destinationNodeRef", "destinationNodeRef", "string", deletedNode.toString());
            this.writer.startElement("http://www.alfresco.org/model/transferDestinationReport/1.0", "deleted", "report:deleted", (Attributes)attributes);
            this.writeDestinationPath(oldPath);
            this.writer.endElement("http://www.alfresco.org/model/transferDestinationReport/1.0", "deleted", "report:deleted");
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
    }

    @Override
    public void writeMoved(NodeRef sourceNodeRef, NodeRef updatedNode, String oldPath, NodeRef newParentNodeRef, String newPath) {
        try {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("http://www.alfresco.org/model/transferReport/1.0", "date", "date", "dateTime", ISO8601DateFormat.format((Date)new Date()));
            attributes.addAttribute("http://www.alfresco.org/model/transferReport/1.0", "sourceNodeRef", "sourceNodeRef", "string", sourceNodeRef.toString());
            attributes.addAttribute("http://www.alfresco.org/model/transferReport/1.0", "destinationNodeRef", "destinationNodeRef", "string", updatedNode.toString());
            attributes.addAttribute("http://www.alfresco.org/model/transferReport/1.0", "newParentNodeRef", "newParentNodeRef", "string", newParentNodeRef.toString());
            this.writer.startElement("http://www.alfresco.org/model/transferDestinationReport/1.0", "moved", "report:moved", (Attributes)attributes);
            this.writeDestinationPath(newPath);
            this.writeOldPath(oldPath);
            this.writer.endElement("http://www.alfresco.org/model/transferDestinationReport/1.0", "moved", "report:moved");
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
    }

    @Override
    public void writeUpdated(NodeRef sourceNodeRef, NodeRef updatedNode, String updatedPath) {
        try {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("http://www.alfresco.org/model/transferReport/1.0", "date", "date", "dateTime", ISO8601DateFormat.format((Date)new Date()));
            attributes.addAttribute("http://www.alfresco.org/model/transferReport/1.0", "sourceNodeRef", "sourceNodeRef", "string", sourceNodeRef.toString());
            attributes.addAttribute("http://www.alfresco.org/model/transferReport/1.0", "destinationNodeRef", "destinationNodeRef", "string", updatedNode.toString());
            this.writer.startElement("http://www.alfresco.org/model/transferDestinationReport/1.0", "updated", "report:updated", (Attributes)attributes);
            this.writeDestinationPath(updatedPath);
            this.writer.endElement("http://www.alfresco.org/model/transferDestinationReport/1.0", "updated", "report:updated");
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
    }

    public void writeOldPath(String path) {
        try {
            AttributesImpl attributes = new AttributesImpl();
            this.writer.startElement("http://www.alfresco.org/model/transferDestinationReport/1.0", "oldPath", "report:oldPath", (Attributes)attributes);
            this.writer.characters(path.toCharArray(), 0, path.length());
            this.writer.endElement("http://www.alfresco.org/model/transferDestinationReport/1.0", "oldPath", "report:oldPath");
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
    }

    public void writeDestinationPath(String path) {
        try {
            AttributesImpl attributes = new AttributesImpl();
            this.writer.startElement("http://www.alfresco.org/model/transferDestinationReport/1.0", "destinationPath", "report:destinationPath", (Attributes)attributes);
            this.writer.characters(path.toCharArray(), 0, path.length());
            this.writer.endElement("http://www.alfresco.org/model/transferDestinationReport/1.0", "destinationPath", "report:destinationPath");
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
    }
}

