/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.service.cmr.admin.RepoAdminService;
import org.alfresco.service.cmr.admin.RepoUsage;
import org.alfresco.util.ScriptPagingDetails;

public class ModelUtil {
    private static final String SHARE = "Share";
    private static final String TEAM = "Team";
    public static final String PAGING_MAX_ITEMS = "maxItems";
    public static final String PAGING_SKIP_COUNT = "skipCount";
    public static final String PAGING_TOTAL_ITEMS = "totalItems";
    public static final String PAGING_TOTAL_ITEMS_RANGE_END = "totalItemsRangeEnd";
    public static final String PAGING_CONFIDENCE = "confidence";

    public static String getProductName(RepoAdminService repoAdminService) {
        String productName = SHARE;
        if (repoAdminService != null && repoAdminService.getRestrictions().getLicenseMode().equals((Object)RepoUsage.LicenseMode.TEAM)) {
            productName = TEAM;
        }
        return productName;
    }

    public static Map<String, Object> buildPaging(int totalItems, int maxItems, int skipCount, ScriptPagingDetails.ItemsSizeConfidence confidence, int totalItemsRangeEnd) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        if (confidence == null) {
            confidence = ScriptPagingDetails.ItemsSizeConfidence.EXACT;
        }
        model.put(PAGING_MAX_ITEMS, maxItems);
        model.put(PAGING_SKIP_COUNT, skipCount);
        model.put(PAGING_TOTAL_ITEMS, totalItems);
        model.put(PAGING_TOTAL_ITEMS_RANGE_END, totalItemsRangeEnd);
        model.put(PAGING_CONFIDENCE, (Object)confidence);
        return model;
    }

    public static Map<String, Object> buildPaging(int totalItems, int maxItems, int skipCount) {
        return ModelUtil.buildPaging(totalItems, maxItems, skipCount, null, -1);
    }

    public static Map<String, Object> buildPaging(ScriptPagingDetails paging) {
        return ModelUtil.buildPaging(paging.getTotalItems(), paging.getMaxItems(), paging.getSkipCount(), paging.getConfidence(), paging.getTotalItemsRangeMax());
    }

    public static <T> List<T> page(Collection<T> objects, int maxItems, int skipCount) {
        return ModelUtil.page(objects, new ScriptPagingDetails(maxItems, skipCount));
    }

    public static <T> List<T> page(Collection<T> objects, ScriptPagingDetails paging) {
        int endPoint;
        int maxItems = paging.getMaxItems();
        int skipCount = paging.getSkipCount();
        paging.setTotalItems(objects.size());
        ArrayList<T> result = new ArrayList<T>();
        int totalItems = objects.size();
        if (maxItems < 1 || maxItems > totalItems) {
            maxItems = totalItems;
        }
        if (skipCount < 0) {
            skipCount = 0;
        }
        if ((endPoint = skipCount + maxItems) > totalItems) {
            endPoint = totalItems;
        }
        int pos = 0;
        for (T entry : objects) {
            if (pos >= skipCount) {
                if (pos >= endPoint) break;
                result.add(entry);
            }
            ++pos;
        }
        return result;
    }

    public static <T> T[] page(T[] objects, int maxItems, int skipCount) {
        int size;
        int endPoint;
        int totalItems = objects.length;
        if (maxItems < 1 || maxItems > totalItems) {
            maxItems = totalItems;
        }
        if (skipCount < 0) {
            skipCount = 0;
        }
        if ((endPoint = skipCount + maxItems) > totalItems) {
            endPoint = totalItems;
        }
        int n = size = skipCount > endPoint ? 0 : endPoint - skipCount;
        if (size == totalItems) {
            return objects;
        }
        T[] result = Arrays.copyOfRange(objects, skipCount, endPoint);
        return result;
    }
}

