/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.evaluator;

import java.io.Serializable;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionConditionImpl;
import org.alfresco.repo.action.evaluator.IsSubTypeEvaluator;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;
import org.junit.Before;
import org.junit.Test;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class IsSubTypeEvaluatorTest
extends BaseSpringTest {
    private NodeService nodeService;
    private StoreRef testStoreRef;
    private NodeRef rootNodeRef;
    private NodeRef nodeRef;
    private IsSubTypeEvaluator evaluator;
    private static final String ID = GUID.generate();

    @Before
    public void before() throws Exception {
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.testStoreRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.testStoreRef);
        this.nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testnode"), ContentModel.TYPE_CONTENT).getChildRef();
        this.evaluator = (IsSubTypeEvaluator)this.applicationContext.getBean("is-subtype");
    }

    @Test
    public void testMandatoryParamsMissing() {
        ActionConditionImpl condition = new ActionConditionImpl(ID, "is-subtype", null);
        try {
            this.evaluator.evaluate((ActionCondition)condition, this.nodeRef);
            IsSubTypeEvaluatorTest.fail((String)"The fact that a mandatory parameter has not been set should have been detected.");
        }
        catch (Throwable throwable) {}
    }

    @Test
    public void testPass() {
        ActionConditionImpl condition = new ActionConditionImpl(ID, "is-subtype", null);
        condition.setParameterValue("type", (Serializable)ContentModel.TYPE_CONTENT);
        IsSubTypeEvaluatorTest.assertTrue((boolean)this.evaluator.evaluate((ActionCondition)condition, this.nodeRef));
        condition.setParameterValue("type", (Serializable)ContentModel.TYPE_CMOBJECT);
        IsSubTypeEvaluatorTest.assertTrue((boolean)this.evaluator.evaluate((ActionCondition)condition, this.nodeRef));
    }

    @Test
    public void testFail() {
        ActionConditionImpl condition = new ActionConditionImpl(ID, "is-subtype", null);
        condition.setParameterValue("type", (Serializable)ContentModel.TYPE_FOLDER);
        IsSubTypeEvaluatorTest.assertFalse((boolean)this.evaluator.evaluate((ActionCondition)condition, this.nodeRef));
    }
}

