/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.RepoModelDefinition;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.NamespaceDAO;
import org.alfresco.repo.i18n.MessageService;
import org.alfresco.repo.node.db.DbNodeServiceImpl;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.admin.RepoAdminService;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.testing.category.LuceneTests;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

@Category(value={OwnJVMTestsCategory.class, LuceneTests.class})
public class RepoAdminServiceImplTest
extends TestCase {
    private static Log logger = LogFactory.getLog(RepoAdminServiceImplTest.class);
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private RepoAdminService repoAdminService;
    private DictionaryService dictionaryService;
    private TransactionService transactionService;
    private NodeService nodeService;
    private ContentService contentService;
    private SearchService searchService;
    private NamespaceService namespaceService;
    private BehaviourFilter behaviourFilter;
    private DictionaryDAO dictionaryDAO;
    private MessageService messageService;
    final String modelPrefix = "model-";
    static final String MKR = "{MKR}";
    public static final String MODEL_MKR_XML = "<model name='ratest-{MKR}:testModel{MKR}' xmlns='http://www.alfresco.org/model/dictionary/1.0'>   <description>Test model {MKR}</description>   <author>Alfresco</author>   <published>2005-05-30</published>   <version>1.0</version>   <imports>      <import uri='http://www.alfresco.org/model/dictionary/1.0' prefix='d'/>      <import uri='http://www.alfresco.org/model/content/1.0' prefix='cm'/>   </imports>   <namespaces>      <namespace uri='http://www.alfresco.org/test/testmodel{MKR}/1.0' prefix='ratest-{MKR}'/>   </namespaces>   <types>      <type name='ratest-{MKR}:base'>        <title>Base</title>        <description>The Base Type</description>        <parent>cm:content</parent>        <properties>           <property name='ratest-{MKR}:prop1'>              <type>d:text</type>           </property>        </properties>      </type>   </types></model>";

    protected void setUp() throws Exception {
        super.setUp();
        this.repoAdminService = (RepoAdminService)ctx.getBean("RepoAdminService");
        this.dictionaryService = (DictionaryService)ctx.getBean("DictionaryService");
        this.transactionService = (TransactionService)ctx.getBean("TransactionService");
        this.nodeService = (NodeService)ctx.getBean("NodeService");
        this.contentService = (ContentService)ctx.getBean("ContentService");
        this.searchService = (SearchService)ctx.getBean("SearchService");
        this.namespaceService = (NamespaceService)ctx.getBean("NamespaceService");
        this.behaviourFilter = (BehaviourFilter)ctx.getBean("policyBehaviourFilter");
        this.dictionaryDAO = (DictionaryDAO)ctx.getBean("dictionaryDAO");
        this.messageService = (MessageService)ctx.getBean("MessageService");
        DbNodeServiceImpl dbNodeService = (DbNodeServiceImpl)ctx.getBean("dbNodeService");
        dbNodeService.setEnableTimestampPropagation(false);
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSetup() throws Exception {
    }

    public void testConsequentDeploy() throws Exception {
        String[] modelFileNames;
        String[] stringArray = modelFileNames = new String[]{"model-MNT-8930-1.xml", "model-MNT-8930-2.xml"};
        int n = modelFileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String modelFileName = stringArray[n2];
            if (this.isModelDeployed(modelFileName)) {
                this.repoAdminService.undeployModel(modelFileName);
            }
            ++n2;
        }
        String model = MODEL_MKR_XML.replace(MKR, "MNT-8930-1");
        ByteArrayInputStream modelStream = new ByteArrayInputStream(model.getBytes("UTF-8"));
        this.repoAdminService.deployModel((InputStream)modelStream, "model-MNT-8930-1.xml");
        QName typeName = QName.createQName((String)"{http://www.alfresco.org/test/testmodelMNT-8930-1/1.0}base");
        this.dictionaryService.getProperty(typeName);
        NamespaceDAO namespaceDAO = (NamespaceDAO)ctx.getBean("namespaceDAO");
        String uri = namespaceDAO.getNamespaceURI("ratest-MNT-8930-1");
        RepoAdminServiceImplTest.assertNotNull((Object)uri);
        class AnotherDeployThread
        extends Thread {
            private String errorStackTrace = null;
            private final /* synthetic */ NamespaceDAO val$namespaceDAO;

            AnotherDeployThread(NamespaceDAO namespaceDAO) {
                this.val$namespaceDAO = namespaceDAO;
            }

            public String getErrorStackTrace() {
                return this.errorStackTrace;
            }

            @Override
            public void run() {
                try {
                    AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
                    String model2 = RepoAdminServiceImplTest.MODEL_MKR_XML.replace(RepoAdminServiceImplTest.MKR, "MNT-8930-2");
                    ByteArrayInputStream modelStream = new ByteArrayInputStream(model2.getBytes("UTF-8"));
                    RepoAdminServiceImplTest.this.repoAdminService.deployModel((InputStream)modelStream, "model-MNT-8930-2.xml");
                    RepoAdminServiceImplTest.assertTrue((boolean)RepoAdminServiceImplTest.this.isModelDeployed("model-MNT-8930-2.xml"));
                    RepoAdminServiceImplTest.assertNotNull((Object)this.val$namespaceDAO.getNamespaceURI("ratest-MNT-8930-2"));
                }
                catch (Throwable t) {
                    StringWriter sw = new StringWriter();
                    t.printStackTrace(new PrintWriter(sw));
                    this.errorStackTrace = sw.toString();
                    logger.error((Object)"Failed to run AnotherDeployThread");
                }
            }
        }
        AnotherDeployThread anotherDeploy = new AnotherDeployThread(namespaceDAO);
        anotherDeploy.start();
        anotherDeploy.join();
        if (anotherDeploy.getErrorStackTrace() != null) {
            RepoAdminServiceImplTest.fail((String)anotherDeploy.getErrorStackTrace());
        }
        uri = namespaceDAO.getNamespaceURI("ratest-MNT-8930-2");
        RepoAdminServiceImplTest.assertNotNull((Object)uri);
    }

    public void xtestRepeat() throws Exception {
        int cnt = 10;
        int i = 1;
        while (i <= cnt) {
            System.out.println("Itr: " + i + " out of " + cnt);
            this.testSimpleDynamicModelViaNodeService();
            this.testSimpleDynamicModelViaRepoAdminService();
            this.testConcurrentDynamicModelCreate();
            this.testConcurrentDynamicModelDelete();
            ++i;
        }
    }

    public void testSimpleDynamicModelViaNodeService() throws Exception {
        QName typeName = QName.createQName((String)"{http://www.alfresco.org/test/testmodelA/1.0}base");
        QName modelName = QName.createQName((String)"{http://www.alfresco.org/test/testmodelA/1.0}testModelA");
        if (this.isModelDeployed("model-A.xml")) {
            this.repoAdminService.undeployModel("model-A.xml");
        }
        StoreRef storeRef = StoreRef.STORE_REF_WORKSPACE_SPACESSTORE;
        NodeRef rootNodeRef = this.nodeService.getRootNode(storeRef);
        RepoAdminServiceImplTest.assertNull((Object)this.dictionaryService.getClass(typeName));
        int defaultModelCnt = this.dictionaryService.getAllModels().size();
        String model = MODEL_MKR_XML.replace(MKR, "A");
        ByteArrayInputStream modelStream = new ByteArrayInputStream(model.getBytes("UTF-8"));
        List nodeRefs = this.searchService.selectNodes(rootNodeRef, "/app:company_home/app:dictionary/app:models", null, (NamespacePrefixResolver)this.namespaceService, false);
        RepoAdminServiceImplTest.assertEquals((int)1, (int)nodeRefs.size());
        NodeRef modelsNodeRef = (NodeRef)nodeRefs.get(0);
        HashMap<QName, String> contentProps = new HashMap<QName, String>();
        contentProps.put(ContentModel.PROP_NAME, "model-A.xml");
        NodeRef model1 = this.nodeService.createNode(modelsNodeRef, ContentModel.ASSOC_CONTAINS, modelName, ContentModel.TYPE_DICTIONARY_MODEL, contentProps).getChildRef();
        HashMap<QName, String> titledProps = new HashMap<QName, String>();
        titledProps.put(ContentModel.PROP_TITLE, "model-A.xml");
        titledProps.put(ContentModel.PROP_DESCRIPTION, "model-A.xml");
        this.nodeService.addAspect(model1, ContentModel.ASPECT_TITLED, titledProps);
        ContentWriter writer = this.contentService.getWriter(model1, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("text/xml");
        writer.setEncoding("UTF-8");
        writer.putContent((InputStream)modelStream);
        ((InputStream)modelStream).close();
        this.nodeService.setProperty(model1, ContentModel.PROP_MODEL_ACTIVE, (Serializable)Boolean.TRUE);
        RepoAdminServiceImplTest.assertEquals((int)(defaultModelCnt + 1), (int)this.dictionaryService.getAllModels().size());
        ClassDefinition myType = this.dictionaryService.getClass(typeName);
        RepoAdminServiceImplTest.assertNotNull((Object)myType);
        RepoAdminServiceImplTest.assertEquals((Object)modelName, (Object)myType.getModel().getName());
        NodeRef node1 = this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"node1"), typeName, null).getChildRef();
        try {
            this.nodeService.deleteNode(model1);
            RepoAdminServiceImplTest.fail();
        }
        catch (AlfrescoRuntimeException are) {
            RepoAdminServiceImplTest.assertTrue((String)("Incorrect exception message: " + are.getMessage()), (boolean)are.getMessage().contains(" is in use and cannot be deleted or deactivated."));
        }
        this.nodeService.deleteNode(node1);
        RepoAdminServiceImplTest.assertFalse((boolean)this.nodeService.exists(node1));
        NodeRef archiveRootNode = this.nodeService.getStoreArchiveNode(storeRef);
        NodeRef archiveNode1 = new NodeRef(archiveRootNode.getStoreRef(), node1.getId());
        RepoAdminServiceImplTest.assertTrue((boolean)this.nodeService.exists(archiveNode1));
        try {
            this.nodeService.deleteNode(model1);
            RepoAdminServiceImplTest.fail();
        }
        catch (AlfrescoRuntimeException are) {
            RepoAdminServiceImplTest.assertTrue((boolean)are.getMessage().contains("is in use and cannot be deleted or deactivated."));
        }
        this.nodeService.deleteNode(archiveNode1);
        RepoAdminServiceImplTest.assertFalse((boolean)this.nodeService.exists(archiveNode1));
        this.nodeService.deleteNode(model1);
        RepoAdminServiceImplTest.assertEquals((int)defaultModelCnt, (int)this.dictionaryService.getAllModels().size());
        RepoAdminServiceImplTest.assertNull((Object)this.dictionaryService.getClass(typeName));
        NodeRef archiveModel1 = new NodeRef(archiveRootNode.getStoreRef(), model1.getId());
        this.nodeService.restoreNode(archiveModel1, null, null, null);
        RepoAdminServiceImplTest.assertEquals((int)(defaultModelCnt + 1), (int)this.dictionaryService.getAllModels().size());
        RepoAdminServiceImplTest.assertNotNull((Object)this.dictionaryService.getClass(typeName));
        this.nodeService.deleteNode(model1);
        this.nodeService.deleteNode(archiveModel1);
    }

    public void testSimpleDynamicModelViaRepoAdminService() throws Exception {
        QName typeName = QName.createQName((String)"{http://www.alfresco.org/test/testmodelB/1.0}base");
        QName modelName = QName.createQName((String)"{http://www.alfresco.org/test/testmodelB/1.0}testModelB");
        try {
            if (this.isModelDeployed("model-B.xml")) {
                this.repoAdminService.undeployModel("model-B.xml");
            }
            RepoAdminServiceImplTest.assertFalse((boolean)this.isModelDeployed("model-B.xml"));
            RepoAdminServiceImplTest.assertNull((Object)this.dictionaryService.getClass(typeName));
            int defaultModelCnt = this.dictionaryService.getAllModels().size();
            String model = MODEL_MKR_XML.replace(MKR, "B");
            ByteArrayInputStream modelStream = new ByteArrayInputStream(model.getBytes("UTF-8"));
            this.repoAdminService.deployModel((InputStream)modelStream, "model-B.xml");
            RepoAdminServiceImplTest.assertTrue((boolean)this.isModelDeployed("model-B.xml"));
            RepoAdminServiceImplTest.assertEquals((int)(defaultModelCnt + 1), (int)this.dictionaryService.getAllModels().size());
            ClassDefinition myType = this.dictionaryService.getClass(typeName);
            RepoAdminServiceImplTest.assertNotNull((Object)myType);
            RepoAdminServiceImplTest.assertEquals((Object)modelName, (Object)myType.getModel().getName());
            modelStream = new ByteArrayInputStream(model.getBytes("UTF-8"));
            this.repoAdminService.deployModel((InputStream)modelStream, "model-B.xml");
            this.repoAdminService.deactivateModel("model-B.xml");
            RepoAdminServiceImplTest.assertTrue((boolean)this.isModelDeployed("model-B.xml"));
            RepoAdminServiceImplTest.assertEquals((int)defaultModelCnt, (int)this.dictionaryService.getAllModels().size());
            RepoAdminServiceImplTest.assertNull((Object)this.dictionaryService.getClass(typeName));
            try {
                this.repoAdminService.deactivateModel("model-B.xml");
                RepoAdminServiceImplTest.fail();
            }
            catch (AlfrescoRuntimeException are) {
                RepoAdminServiceImplTest.assertTrue((boolean)are.getMessage().contains("Model deactivation failed"));
                RepoAdminServiceImplTest.assertTrue((boolean)are.getCause().getMessage().contains("is already deactivated"));
            }
            this.repoAdminService.activateModel("model-B.xml");
            RepoAdminServiceImplTest.assertTrue((boolean)this.isModelDeployed("model-B.xml"));
            RepoAdminServiceImplTest.assertEquals((int)(defaultModelCnt + 1), (int)this.dictionaryService.getAllModels().size());
            myType = this.dictionaryService.getClass(typeName);
            RepoAdminServiceImplTest.assertNotNull((Object)myType);
            RepoAdminServiceImplTest.assertEquals((Object)modelName, (Object)myType.getModel().getName());
            try {
                this.repoAdminService.activateModel("model-B.xml");
                RepoAdminServiceImplTest.fail();
            }
            catch (AlfrescoRuntimeException are) {
                RepoAdminServiceImplTest.assertTrue((boolean)are.getMessage().contains("Model activation failed"));
                RepoAdminServiceImplTest.assertTrue((boolean)are.getCause().getMessage().contains("is already activated"));
            }
            StoreRef storeRef = StoreRef.STORE_REF_WORKSPACE_SPACESSTORE;
            NodeRef rootNodeRef = this.nodeService.getRootNode(storeRef);
            NodeRef node1 = this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"node1"), typeName, null).getChildRef();
            try {
                this.repoAdminService.undeployModel("model-B.xml");
                RepoAdminServiceImplTest.fail();
            }
            catch (AlfrescoRuntimeException are) {
                RepoAdminServiceImplTest.assertTrue((boolean)are.getMessage().contains("Model undeployment failed"));
                RepoAdminServiceImplTest.assertTrue((boolean)are.getCause().getMessage().contains("is in use and cannot be deleted or deactivated."));
            }
            this.nodeService.deleteNode(node1);
            RepoAdminServiceImplTest.assertFalse((boolean)this.nodeService.exists(node1));
            NodeRef archiveRootNode = this.nodeService.getStoreArchiveNode(storeRef);
            NodeRef archiveNode1 = new NodeRef(archiveRootNode.getStoreRef(), node1.getId());
            RepoAdminServiceImplTest.assertTrue((boolean)this.nodeService.exists(archiveNode1));
            try {
                this.repoAdminService.undeployModel("model-B.xml");
                RepoAdminServiceImplTest.fail();
            }
            catch (AlfrescoRuntimeException are) {
                RepoAdminServiceImplTest.assertTrue((boolean)are.getMessage().contains("Model undeployment failed"));
                RepoAdminServiceImplTest.assertTrue((boolean)are.getCause().getMessage().contains("is in use and cannot be deleted or deactivated."));
            }
            this.nodeService.deleteNode(archiveNode1);
            RepoAdminServiceImplTest.assertFalse((boolean)this.nodeService.exists(archiveNode1));
            this.repoAdminService.undeployModel("model-B.xml");
            RepoAdminServiceImplTest.assertFalse((boolean)this.isModelDeployed("model-B.xml"));
            RepoAdminServiceImplTest.assertEquals((int)defaultModelCnt, (int)this.dictionaryService.getAllModels().size());
            RepoAdminServiceImplTest.assertNull((Object)this.dictionaryService.getClass(typeName));
            try {
                this.repoAdminService.undeployModel("model-B.xml");
                RepoAdminServiceImplTest.fail();
            }
            catch (AlfrescoRuntimeException are) {
                RepoAdminServiceImplTest.assertTrue((boolean)are.getMessage().contains("Model undeployment failed"));
                RepoAdminServiceImplTest.assertTrue((boolean)are.getCause().getMessage().contains("Could not find custom model"));
            }
        }
        finally {
            if (this.isModelDeployed("model-B.xml")) {
                this.repoAdminService.undeployModel("model-B.xml");
            }
            RepoAdminServiceImplTest.assertNull((Object)this.dictionaryService.getClass(typeName));
        }
    }

    public void testCreateAndDeleteModel() throws Exception {
        QName typeName = QName.createQName((String)"{http://www.alfresco.org/test/testmodelC/1.0}base");
        final QName modelName = QName.createQName((String)"{http://www.alfresco.org/test/testmodelC/1.0}testModelC");
        if (this.isModelDeployed("model-C.xml")) {
            this.repoAdminService.undeployModel("model-C.xml");
        }
        StoreRef storeRef = StoreRef.STORE_REF_WORKSPACE_SPACESSTORE;
        NodeRef rootNodeRef = this.nodeService.getRootNode(storeRef);
        RepoAdminServiceImplTest.assertNull((Object)this.dictionaryService.getClass(typeName));
        int defaultModelCnt = this.dictionaryService.getAllModels().size();
        String model = MODEL_MKR_XML.replace(MKR, "C");
        ByteArrayInputStream modelStream = new ByteArrayInputStream(model.getBytes("UTF-8"));
        List nodeRefs = this.searchService.selectNodes(rootNodeRef, "/app:company_home/app:dictionary/app:models", null, (NamespacePrefixResolver)this.namespaceService, false);
        RepoAdminServiceImplTest.assertEquals((int)1, (int)nodeRefs.size());
        NodeRef modelsNodeRef = (NodeRef)nodeRefs.get(0);
        HashMap<QName, String> contentProps = new HashMap<QName, String>();
        contentProps.put(ContentModel.PROP_NAME, "model-C.xml");
        final NodeRef model1 = this.nodeService.createNode(modelsNodeRef, ContentModel.ASSOC_CONTAINS, modelName, ContentModel.TYPE_DICTIONARY_MODEL, contentProps).getChildRef();
        HashMap<QName, String> titledProps = new HashMap<QName, String>();
        titledProps.put(ContentModel.PROP_TITLE, "model-C.xml");
        titledProps.put(ContentModel.PROP_DESCRIPTION, "model-C.xml");
        this.nodeService.addAspect(model1, ContentModel.ASPECT_TITLED, titledProps);
        ContentWriter writer = this.contentService.getWriter(model1, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("text/xml");
        writer.setEncoding("UTF-8");
        writer.putContent((InputStream)modelStream);
        ((InputStream)modelStream).close();
        this.nodeService.setProperty(model1, ContentModel.PROP_MODEL_ACTIVE, (Serializable)Boolean.TRUE);
        RepoAdminServiceImplTest.assertEquals((int)(defaultModelCnt + 1), (int)this.dictionaryService.getAllModels().size());
        ClassDefinition myType = this.dictionaryService.getClass(typeName);
        RepoAdminServiceImplTest.assertNotNull((Object)myType);
        RepoAdminServiceImplTest.assertEquals((Object)modelName, (Object)myType.getModel().getName());
        NodeRef node1 = this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"node1"), typeName, null).getChildRef();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                try {
                    RepoAdminServiceImplTest.this.behaviourFilter.disableBehaviour(ContentModel.TYPE_DICTIONARY_MODEL);
                    RepoAdminServiceImplTest.this.dictionaryDAO.removeModel(modelName);
                    RepoAdminServiceImplTest.this.nodeService.deleteNode(model1);
                }
                finally {
                    RepoAdminServiceImplTest.this.behaviourFilter.enableBehaviour(ContentModel.TYPE_DICTIONARY_MODEL);
                }
                return null;
            }
        });
        RepoAdminServiceImplTest.assertFalse((boolean)this.nodeService.exists(model1));
        this.nodeService.getProperties(node1);
        this.nodeService.deleteNode(node1);
        RepoAdminServiceImplTest.assertFalse((boolean)this.nodeService.exists(node1));
    }

    private boolean isModelDeployed(String modelFileName) {
        for (RepoModelDefinition modelDef : this.repoAdminService.getModels()) {
            if (!modelDef.getRepoName().equals(modelFileName)) continue;
            return true;
        }
        return false;
    }

    private void undeployModels(int modelCnt) {
        int i = 1;
        while (i <= modelCnt) {
            if (this.isModelDeployed("model-" + i)) {
                this.repoAdminService.undeployModel("model-" + i);
            }
            ++i;
        }
    }

    private void deployModels(int modelCnt) throws UnsupportedEncodingException {
        int i = 1;
        while (i <= modelCnt) {
            if (!this.isModelDeployed("model-" + i)) {
                String model = MODEL_MKR_XML.replace(MKR, "" + i);
                ByteArrayInputStream modelStream = new ByteArrayInputStream(model.getBytes("UTF-8"));
                this.repoAdminService.deployModel((InputStream)modelStream, "model-" + i);
                logger.info((Object)("[" + i + "] Deployed - test model: model-" + i));
            } else {
                logger.warn((Object)("[" + i + "] Already deployed - test model: model-" + i));
            }
            ++i;
        }
    }

    public void testConcurrentDynamicModelCreate() throws Exception {
        this.undeployModels(2);
        int deployedModelCount = this.repoAdminService.getModels().size();
        logger.info((Object)("Before deploy: deployed custom model count: " + deployedModelCount));
        int dictModelCount = this.getModelCount();
        logger.info((Object)("Before deploy: dictionary model count: " + dictModelCount));
        this.runConcurrentOps(2, 1);
        int newDeployedModelCount = this.repoAdminService.getModels().size();
        logger.info((Object)("After deploy: deployed custom model count: " + newDeployedModelCount));
        RepoAdminServiceImplTest.assertEquals((int)(deployedModelCount + 2), (int)newDeployedModelCount);
        int i = 1;
        while (i <= 2) {
            RepoAdminServiceImplTest.assertTrue((boolean)this.isModelDeployed("model-" + i));
            ++i;
        }
        int newDictModelCount = this.getModelCount();
        logger.info((Object)("After deploy: dictionary model count: " + newDictModelCount));
        RepoAdminServiceImplTest.assertEquals((int)(dictModelCount + 2), (int)newDictModelCount);
        this.undeployModels(2);
        newDeployedModelCount = this.repoAdminService.getModels().size();
        logger.info((Object)("After undeploy: deployed custom model count: " + newDeployedModelCount));
        RepoAdminServiceImplTest.assertEquals((int)deployedModelCount, (int)newDeployedModelCount);
        newDictModelCount = this.getModelCount();
        logger.info((Object)("After undeploy: dictionary model count: " + newDictModelCount));
        RepoAdminServiceImplTest.assertEquals((int)dictModelCount, (int)newDictModelCount);
    }

    public void testConcurrentDynamicModelDelete() throws Exception {
        this.undeployModels(2);
        int deployedModelCount = this.repoAdminService.getModels().size();
        logger.info((Object)("Existing deployed custom model count: " + deployedModelCount));
        int dictModelCount = this.getModelCount();
        logger.info((Object)("Existing dictionary model count: " + dictModelCount));
        this.deployModels(2);
        RepoAdminServiceImplTest.assertEquals((String)"assert A: deployed model count not equal to the repoAdminService", (int)(deployedModelCount + 2), (int)this.repoAdminService.getModels().size());
        int i = 1;
        while (i <= 2) {
            RepoAdminServiceImplTest.assertTrue((boolean)this.isModelDeployed("model-" + i));
            ++i;
        }
        RepoAdminServiceImplTest.assertEquals((int)(dictModelCount + 2), (int)this.getModelCount());
        this.runConcurrentOps(2, 2);
        RepoAdminServiceImplTest.assertEquals((String)"assert after concurrent undeploy", (int)deployedModelCount, (int)this.repoAdminService.getModels().size());
        i = 1;
        while (i <= 2) {
            RepoAdminServiceImplTest.assertFalse((boolean)this.isModelDeployed("model-" + i));
            ++i;
        }
        RepoAdminServiceImplTest.assertEquals((int)dictModelCount, (int)this.getModelCount());
    }

    private int getModelCount() {
        return this.dictionaryService.getAllModels().size();
    }

    private void runConcurrentOps(int threadCnt, int opType) throws InterruptedException {
        Thread[] threads = new Thread[threadCnt];
        Tester[] testers = new Tester[threadCnt];
        int i = 0;
        while (i < threadCnt) {
            Tester tester;
            testers[i] = tester = new Tester(i + 1, opType);
            threads[i] = new Thread(tester);
            threads[i].start();
            ++i;
        }
        i = 0;
        while (i < threadCnt) {
            threads[i].join();
            if (testers[i].getErrorStackTrace() != null) {
                RepoAdminServiceImplTest.fail((String)testers[i].getErrorStackTrace());
            }
            ++i;
        }
    }

    public void testDeployMessageBundleFromClasspath() throws Exception {
        String bundleBaseName = "mycustommessages";
        String resourceClasspath = "alfresco/extension/messages/" + bundleBaseName;
        if (this.repoAdminService.getMessageBundles().contains(bundleBaseName)) {
            this.repoAdminService.undeployMessageBundle(bundleBaseName);
        }
        RepoAdminServiceImplTest.assertFalse((String)"The custom bundle should not be deployed", (boolean)this.repoAdminService.getMessageBundles().contains(bundleBaseName));
        this.repoAdminService.deployMessageBundle(resourceClasspath);
        this.repoAdminService.reloadMessageBundle(bundleBaseName);
        RepoAdminServiceImplTest.assertTrue((String)"The custom bundle should be deployed", (boolean)this.repoAdminService.getMessageBundles().contains(bundleBaseName));
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        this.assertMessageValue("Cannot retrieve default message value", "This is a custom message", "mycustommessages.key1", Locale.getDefault());
        this.assertMessageValue("Cannot retrieve french message value", "Ceci est un message personnalis\\u00e9", "mycustommessages.key1", Locale.FRANCE);
        this.assertMessageValue("Cannot retrieve german message value", "Dies ist eine benutzerdefinierte Nachricht", "mycustommessages.key1", Locale.GERMANY);
        try {
            this.repoAdminService.deployMessageBundle("alfresco/extension/messages/inexistentbundle");
            RepoAdminServiceImplTest.fail((String)"Bundle was not supposed to be deployed");
        }
        catch (Exception exception) {}
    }

    public void testDeployMessageBundleFromRepo() throws Exception {
        NodeRef rootNodeRef = this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        List nodeRefs = this.searchService.selectNodes(rootNodeRef, "/app:company_home/app:dictionary/app:messages", null, (NamespacePrefixResolver)this.namespaceService, false);
        RepoAdminServiceImplTest.assertEquals((int)1, (int)nodeRefs.size());
        NodeRef messagesNodeRef = (NodeRef)nodeRefs.get(0);
        this.clearRepoBundles(messagesNodeRef);
        RepoAdminServiceImplTest.assertEquals((int)0, (int)this.repoAdminService.getMessageBundles().size());
        NodeRef messageNode_default = this.createMessagesNodeWithSingleKey(messagesNodeRef, "repoBundle", "repoBundle.key1", null, "Value 1");
        this.createMessagesNodeWithSingleKey(messagesNodeRef, "repoBundle", "repoBundle.key1", Locale.FRANCE.toString(), "Value FR");
        this.createMessagesNodeWithSingleKey(messagesNodeRef, "repoBundle", "repoBundle.key1", Locale.GERMANY.toString(), "Value DE");
        this.repoAdminService.reloadMessageBundle("repoBundle");
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        this.assertMessageValue("Cannot retrieve default message value", "Value 1", "repoBundle.key1", Locale.getDefault());
        this.assertMessageValue("Cannot retrieve french message value", "Value FR", "repoBundle.key1", Locale.FRANCE);
        this.assertMessageValue("Cannot retrieve german message value", "Value DE", "repoBundle.key1", Locale.GERMANY);
        this.putContentInMessageNode(messageNode_default, "repoBundle.key1", "New Value 1");
        this.assertMessageValue("Unexpected change of message value", "Value 1", "repoBundle.key1", Locale.getDefault());
        this.repoAdminService.reloadMessageBundle("repoBundle");
        this.assertMessageValue("Change of message value not reflected", "New Value 1", "repoBundle.key1", Locale.getDefault());
    }

    private NodeRef createMessagesNodeWithSingleKey(NodeRef parentNode, String bundleName, String key, String locale, String localeValue) {
        String msg_extension = ".properties";
        String filename = bundleName + msg_extension;
        String messageValue = localeValue;
        if (locale != null) {
            filename = bundleName + "_" + locale + msg_extension;
        }
        NodeRef messageNode = this.nodeService.createNode(parentNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)filename), ContentModel.TYPE_CONTENT, Collections.singletonMap(ContentModel.PROP_NAME, filename)).getChildRef();
        this.putContentInMessageNode(messageNode, key, messageValue);
        return messageNode;
    }

    private void putContentInMessageNode(NodeRef nodeRef, String key, String value) {
        ContentWriter contentWriter = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        contentWriter.setEncoding("UTF-8");
        contentWriter.setMimetype("text/plain");
        String messagesString = key + "=" + value;
        contentWriter.putContent(messagesString);
    }

    private void clearRepoBundles(NodeRef parentNode) {
        List repoBundles = this.repoAdminService.getMessageBundles();
        for (String repoBundle : repoBundles) {
            this.repoAdminService.undeployMessageBundle(repoBundle);
        }
        List messageNodes = this.nodeService.getChildAssocs(parentNode);
        for (ChildAssociationRef messageChildRef : messageNodes) {
            NodeRef messageNode = messageChildRef.getChildRef();
            this.nodeService.deleteNode(messageNode);
        }
    }

    private void assertMessageValue(final String errorMessage, final String expectedValue, final String key, final Locale locale) {
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                RepoAdminServiceImplTest.assertEquals((String)errorMessage, (String)expectedValue, (String)RepoAdminServiceImplTest.this.messageService.getMessage(key, locale));
                return null;
            }
        });
    }

    private class Tester
    implements Runnable {
        private int i;
        private int opType;
        private String errorStackTrace = null;

        public Tester(int i, int opType) {
            this.i = i;
            this.opType = opType;
        }

        public String getErrorStackTrace() {
            return this.errorStackTrace;
        }

        @Override
        public void run() {
            try {
                AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
                RepoAdminServiceImplTest.this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                    public Object execute() throws Throwable {
                        if (Tester.this.opType == 1) {
                            String model = RepoAdminServiceImplTest.MODEL_MKR_XML.replace(RepoAdminServiceImplTest.MKR, "" + Tester.this.i);
                            ByteArrayInputStream modelStream = new ByteArrayInputStream(model.getBytes("UTF-8"));
                            ((Tester)Tester.this).RepoAdminServiceImplTest.this.repoAdminService.deployModel((InputStream)modelStream, "model-" + Tester.this.i);
                            logger.info((Object)("[" + Tester.this.i + "] Deploying - test model: model-" + Tester.this.i));
                        } else if (Tester.this.opType == 2) {
                            ((Tester)Tester.this).RepoAdminServiceImplTest.this.repoAdminService.undeployModel("model-" + Tester.this.i);
                            logger.info((Object)("[" + Tester.this.i + "] Undeployed - test model: model-" + Tester.this.i));
                        }
                        return null;
                    }
                });
            }
            catch (Throwable t) {
                StringWriter sw = new StringWriter();
                t.printStackTrace(new PrintWriter(sw));
                this.errorStackTrace = sw.toString();
                logger.error((Object)("[" + this.i + "] Failed to " + (this.opType == 1 ? "deploy" : "undeploy") + " test model: " + String.valueOf(t)));
            }
        }
    }
}

