/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.alfresco.repo.content.transform.AdminUiTransformerDebug;
import org.alfresco.repo.content.transform.LogEntries;
import org.alfresco.repo.content.transform.TransformerConfigMBeanImpl;
import org.alfresco.repo.content.transform.TransformerDebugLog;
import org.alfresco.repo.content.transform.TransformerLog;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class TransformerConfigMBeanImplTest {
    @Mock
    private AdminUiTransformerDebug transformerDebug;
    @Mock
    private MimetypeService mimetypeService;
    private TransformerLog transformerLog = new TransformerLog(){

        public String[] getEntries(int n) {
            return TransformerConfigMBeanImplTest.this.logEntries.toArray(new String[TransformerConfigMBeanImplTest.this.logEntries.size()]);
        }
    };
    private TransformerDebugLog transformerDebugLog = new TransformerDebugLog(){

        public String[] getEntries(int n) {
            return TransformerConfigMBeanImplTest.this.logEntries.toArray(new String[TransformerConfigMBeanImplTest.this.logEntries.size()]);
        }
    };
    private final List<String> logEntries = new ArrayList<String>();
    private TransformerConfigMBeanImpl mbean;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.mbean = new TransformerConfigMBeanImpl();
        this.mbean.setTransformerDebug(this.transformerDebug);
        this.mbean.setMimetypeService(this.mimetypeService);
        this.mbean.setTransformerLog((LogEntries)this.transformerLog);
        this.mbean.setTransformerDebugLog((LogEntries)this.transformerDebugLog);
        TransformerConfigMBeanImplTest.mockMimetypes(this.mimetypeService, "application/pdf", "pdf", "image/png", "png", "text/plain", "txt");
    }

    public static void mockMimetypes(MimetypeService mimetypeService, String ... mimetypesAndExtensions) {
        if (mimetypesAndExtensions.length % 2 != 0) {
            throw new IllegalStateException("There should be an extension for every mimetype");
        }
        HashSet<String> allMimetypes = new HashSet<String>();
        int i = 0;
        while (i < mimetypesAndExtensions.length) {
            allMimetypes.add(mimetypesAndExtensions[i]);
            Mockito.when((Object)mimetypeService.getExtension(mimetypesAndExtensions[i])).thenReturn((Object)mimetypesAndExtensions[i + 1]);
            Mockito.when((Object)mimetypeService.getMimetype(mimetypesAndExtensions[i + 1])).thenReturn((Object)mimetypesAndExtensions[i]);
            i += 2;
        }
        Mockito.when((Object)mimetypeService.getMimetypes()).thenReturn(new ArrayList(allMimetypes));
    }

    @Test
    public void getExtensionsAndMimetypesTest() {
        Mockito.when((Object)this.mimetypeService.getMimetypes(null)).thenReturn(Arrays.asList("application/pdf", "image/png"));
        Mockito.when((Object)this.mimetypeService.getExtension("application/pdf")).thenReturn((Object)"pdf");
        Mockito.when((Object)this.mimetypeService.getExtension("image/png")).thenReturn((Object)"png");
        Object[] actual = this.mbean.getExtensionsAndMimetypes();
        Object[] expected = new String[]{"pdf - application/pdf", "png - image/png"};
        Assert.assertArrayEquals((Object[])expected, (Object[])actual);
    }

    @Test
    public void getTransformationsByExtensionTest() {
        this.setupForGetTransformationsByExtension();
        Assert.assertEquals((Object)"One result", (Object)this.mbean.getTransformationsByExtension("pdf", "png"));
    }

    @Test
    public void getTransformationsByExtensionUpperCaseTest() {
        this.setupForGetTransformationsByExtension();
        Assert.assertEquals((Object)"One result", (Object)this.mbean.getTransformationsByExtension("PDF", "PNG"));
    }

    @Test
    public void getTransformationsByExtensionNullSourceTest() {
        this.setupForGetTransformationsByExtension();
        Assert.assertEquals((Object)"Lots of results to png", (Object)this.mbean.getTransformationsByExtension(null, "PNG"));
    }

    @Test
    public void getTransformationsByExtensionNullTargetTest() {
        this.setupForGetTransformationsByExtension();
        Assert.assertEquals((Object)"Lots of results from pdf", (Object)this.mbean.getTransformationsByExtension("pdf", null));
    }

    private void setupForGetTransformationsByExtension() {
        Mockito.when((Object)this.transformerDebug.transformationsByExtension("pdf", "png", true)).thenReturn((Object)"One result");
        Mockito.when((Object)this.transformerDebug.transformationsByExtension(null, "png", true)).thenReturn((Object)"Lots of results to png");
        Mockito.when((Object)this.transformerDebug.transformationsByExtension("pdf", null, true)).thenReturn((Object)"Lots of results from pdf");
    }

    @Test
    public void getTransformationLogTest() {
        this.logEntries.add("test message 1");
        this.logEntries.add("test message 2");
        Assert.assertArrayEquals((Object[])new String[]{"test message 1", "test message 2"}, (Object[])this.mbean.getTransformationLog(5));
    }

    @Test
    public void getTransformationLogZeroTest() {
        Assert.assertArrayEquals((Object[])new String[]{"No transformations to report"}, (Object[])this.mbean.getTransformationLog(5));
    }

    @Test
    public void getTransformationDebugLogTest() {
        this.logEntries.add("test message 1");
        this.logEntries.add("test message 2");
        Assert.assertArrayEquals((Object[])new String[]{"test message 1", "test message 2"}, (Object[])this.mbean.getTransformationDebugLog(5));
    }

    @Test
    public void getTransformationDebugLogZeroTest() {
        Assert.assertArrayEquals((Object[])new String[]{"No transformations to report"}, (Object[])this.mbean.getTransformationDebugLog(5));
    }

    @Test
    public void testTransformAnyTransformerTest() {
        Mockito.when((Object)this.transformerDebug.testTransform("pdf", "png")).thenReturn((Object)"debug output");
        Assert.assertEquals((Object)"debug output", (Object)this.mbean.testTransform("pdf", "png"));
    }

    @Test
    public void testTransformAnyTransformerBadExtensionTest() {
        Mockito.when((Object)this.transformerDebug.testTransform("bad", "png")).thenThrow(new Throwable[]{new IllegalArgumentException("Unknown source extension: bad")});
        Assert.assertEquals((Object)"Unknown source extension: bad", (Object)this.mbean.testTransform("bad", "png"));
    }
}

