/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.integrity;

import java.util.HashSet;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.repo.node.integrity.AbstractIntegrityEvent;
import org.alfresco.repo.node.integrity.IntegrityEvent;
import org.alfresco.repo.node.integrity.IntegrityRecord;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;

public class IntegrityEventTest
extends TestCase {
    private static final String NAMESPACE = "http://test";
    private NodeRef nodeRef;
    private QName typeQName;
    private QName qname;
    private IntegrityEvent event;

    public void setUp() throws Exception {
        this.nodeRef = new NodeRef("workspace://protocol/ID123");
        this.typeQName = QName.createQName((String)NAMESPACE, (String)"SomeTypeQName");
        this.qname = QName.createQName((String)NAMESPACE, (String)"qname");
        this.event = new TestIntegrityEvent(null, null, this.nodeRef, this.typeQName, this.qname);
    }

    public void testSetFunctionality() throws Exception {
        HashSet<Object> set = new HashSet<Object>(5);
        boolean added = set.add(this.event);
        IntegrityEventTest.assertTrue((boolean)added);
        added = set.add((Object)new TestIntegrityEvent(null, null, this.nodeRef, this.typeQName, this.qname));
        IntegrityEventTest.assertFalse((boolean)added);
    }

    private static class TestIntegrityEvent
    extends AbstractIntegrityEvent {
        public TestIntegrityEvent(NodeService nodeService, DictionaryService dictionaryService, NodeRef nodeRef, QName typeQName, QName qname) {
            super(nodeService, dictionaryService, nodeRef, typeQName, qname);
        }

        public void checkIntegrity(List<IntegrityRecord> eventResults) {
            throw new UnsupportedOperationException();
        }
    }
}

