/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationServiceImpl;
import org.alfresco.repo.security.authentication.ProtectedUser;
import org.alfresco.repo.security.authentication.TicketComponent;
import org.alfresco.service.cmr.security.PersonService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class AuthenticationServiceImplTest {
    private AuthenticationComponent authenticationComponent = (AuthenticationComponent)Mockito.mock(AuthenticationComponent.class);
    private SimpleCache<String, ProtectedUser> cache;
    private TicketComponent ticketComponent = (TicketComponent)Mockito.mock(TicketComponent.class);
    private AuthenticationServiceImpl authService;
    private AuthenticationServiceImpl authService2;
    private PersonService personService = (PersonService)Mockito.mock(PersonService.class);
    private static final String USERNAME = "username";
    private static final String USERNAME_CASE_SENSITIVE = "uSeRnAmE";
    private static final char[] PASSWORD = "password".toCharArray();

    @Before
    public void beforeTest() {
        this.authService = new AuthenticationServiceImpl();
        this.authService.setAuthenticationComponent(this.authenticationComponent);
        this.authService.setTicketComponent(this.ticketComponent);
        this.cache = new MockCache<String, ProtectedUser>();
        this.authService.setProtectedUsersCache(this.cache);
        this.authService.setPersonService(this.personService);
        this.authService2 = new AuthenticationServiceImpl();
        this.authService2.setAuthenticationComponent(this.authenticationComponent);
        this.authService2.setTicketComponent(this.ticketComponent);
        this.authService2.setProtectedUsersCache(this.cache);
    }

    @Test
    public void testProtectedUserBadPassword() {
        int limit = 3;
        int attempts = limit + 3;
        this.authService.setProtectionPeriodSeconds(99999);
        this.authService.setProtectionLimit(limit);
        this.authService.setProtectionEnabled(true);
        AuthenticationException spoofedAE = new AuthenticationException("Bad password");
        ((AuthenticationComponent)Mockito.doThrow((Throwable[])new Throwable[]{spoofedAE}).when((Object)this.authenticationComponent)).authenticate(USERNAME, PASSWORD);
        int i = 0;
        while (i < attempts) {
            try {
                this.authService.authenticate(USERNAME, PASSWORD);
                Assert.fail((String)("The " + AuthenticationException.class.getName() + " should have been thrown."));
            }
            catch (AuthenticationException ae) {
                if (i < limit) {
                    Assert.assertTrue((String)"Expected failure from AuthenticationComponent", (ae == spoofedAE ? 1 : 0) != 0);
                }
                Assert.assertFalse((String)"Expected failure from protection code", (ae == spoofedAE ? 1 : 0) != 0);
            }
            ++i;
        }
        ((AuthenticationComponent)Mockito.verify((Object)this.authenticationComponent, (VerificationMode)Mockito.times((int)limit))).authenticate(USERNAME, PASSWORD);
        Assert.assertTrue((String)"The user should be protected.", (boolean)this.authService.isUserProtected(USERNAME));
        String protectedUserKey = this.authService.getProtectedUserKey(USERNAME);
        Assert.assertEquals((String)"The number of recorded logins did not match.", (long)attempts, (long)((ProtectedUser)this.cache.get((Serializable)((Object)protectedUserKey))).getNumLogins());
        ((AuthenticationComponent)Mockito.doNothing().when((Object)this.authenticationComponent)).authenticate(USERNAME, PASSWORD);
        try {
            this.authService.authenticate(USERNAME, PASSWORD);
            Assert.fail((String)("The " + AuthenticationException.class.getName() + " should have been thrown."));
        }
        catch (AuthenticationException authenticationException) {}
        ((AuthenticationComponent)Mockito.verify((Object)this.authenticationComponent, (VerificationMode)Mockito.times((int)limit))).authenticate(USERNAME, PASSWORD);
        Assert.assertEquals((String)"The number of recorded logins did not match.", (long)(attempts + 1), (long)((ProtectedUser)this.cache.get((Serializable)((Object)protectedUserKey))).getNumLogins());
    }

    @Test
    public void testProtectedUserIfUserNamesAreNotCaseSensitive() {
        int limit = 3;
        int attempts = limit + 1;
        this.authService.setProtectionPeriodSeconds(999);
        this.authService.setProtectionLimit(limit);
        this.authService.setProtectionEnabled(true);
        AuthenticationException spoofedAE = new AuthenticationException("Bad password");
        ((AuthenticationComponent)Mockito.doThrow((Throwable[])new Throwable[]{spoofedAE}).when((Object)this.authenticationComponent)).authenticate(USERNAME_CASE_SENSITIVE, PASSWORD);
        int i = 0;
        while (i < attempts) {
            try {
                this.authService.authenticate(USERNAME_CASE_SENSITIVE, PASSWORD);
                Assert.fail((String)("The " + AuthenticationException.class.getName() + " should have been thrown."));
            }
            catch (AuthenticationException ae) {
                if (i < limit) {
                    Assert.assertTrue((String)"Expected failure from AuthenticationComponent", (ae == spoofedAE ? 1 : 0) != 0);
                }
                Assert.assertFalse((String)"Expected failure from protection code", (ae == spoofedAE ? 1 : 0) != 0);
            }
            ++i;
        }
        ((AuthenticationComponent)Mockito.verify((Object)this.authenticationComponent, (VerificationMode)Mockito.times((int)0))).authenticate(USERNAME, PASSWORD);
        Assert.assertTrue((String)"The user should be protected.", (boolean)this.authService.isUserProtected(USERNAME));
        ((AuthenticationComponent)Mockito.verify((Object)this.authenticationComponent, (VerificationMode)Mockito.times((int)limit))).authenticate(USERNAME_CASE_SENSITIVE, PASSWORD);
        Assert.assertTrue((String)"The user should be protected.", (boolean)this.authService.isUserProtected(USERNAME_CASE_SENSITIVE));
    }

    @Test
    public void testProtectedUserIfUserNamesAreCaseSensitive() {
        int limit = 3;
        int attempts = limit + 1;
        this.authService.setProtectionPeriodSeconds(999);
        this.authService.setProtectionLimit(limit);
        this.authService.setProtectionEnabled(true);
        Mockito.when((Object)this.personService.getUserNamesAreCaseSensitive()).thenReturn((Object)true);
        AuthenticationException spoofedAE = new AuthenticationException("Bad password");
        ((AuthenticationComponent)Mockito.doThrow((Throwable[])new Throwable[]{spoofedAE}).when((Object)this.authenticationComponent)).authenticate(USERNAME, PASSWORD);
        int i = 0;
        while (i < attempts) {
            try {
                this.authService.authenticate(USERNAME, PASSWORD);
                Assert.fail((String)("The " + AuthenticationException.class.getName() + " should have been thrown."));
            }
            catch (AuthenticationException ae) {
                if (i < limit) {
                    Assert.assertTrue((String)"Expected failure from AuthenticationComponent", (ae == spoofedAE ? 1 : 0) != 0);
                }
                Assert.assertFalse((String)"Expected failure from protection code", (ae == spoofedAE ? 1 : 0) != 0);
            }
            ++i;
        }
        ((AuthenticationComponent)Mockito.verify((Object)this.authenticationComponent, (VerificationMode)Mockito.times((int)limit))).authenticate(USERNAME, PASSWORD);
        Assert.assertTrue((String)"The user should be protected.", (boolean)this.authService.isUserProtected(USERNAME));
        ((AuthenticationComponent)Mockito.verify((Object)this.authenticationComponent, (VerificationMode)Mockito.times((int)0))).authenticate(USERNAME_CASE_SENSITIVE, PASSWORD);
        Assert.assertFalse((String)"The user should not be protected.", (boolean)this.authService.isUserProtected(USERNAME_CASE_SENSITIVE));
    }

    @Test
    public void testProtectedUserCanLoginAfterProtection() throws Exception {
        int timeLimit = 1;
        int attempts = 2;
        this.authService.setProtectionPeriodSeconds(timeLimit);
        this.authService.setProtectionLimit(attempts);
        this.authService.setProtectionEnabled(true);
        ((AuthenticationComponent)Mockito.doThrow((Throwable[])new Throwable[]{new AuthenticationException("Bad password")}).when((Object)this.authenticationComponent)).authenticate(USERNAME, PASSWORD);
        int i = 0;
        while (i < attempts) {
            try {
                this.authService.authenticate(USERNAME, PASSWORD);
                Assert.fail((String)("An " + AuthenticationException.class.getName() + " should be thrown."));
            }
            catch (AuthenticationException authenticationException) {}
            ++i;
        }
        Assert.assertTrue((String)"The user should be protected.", (boolean)this.authService.isUserProtected(USERNAME));
        String protectedUserKey = this.authService.getProtectedUserKey(USERNAME);
        Assert.assertEquals((String)"The number of recorded logins did not match.", (long)attempts, (long)((ProtectedUser)this.cache.get((Serializable)((Object)protectedUserKey))).getNumLogins());
        Thread.sleep(timeLimit * 1000 + 1);
        Assert.assertFalse((String)"The user should not be protected any more.", (boolean)this.authService.isUserProtected(USERNAME));
        Assert.assertEquals((String)"The number of recorded logins should stay the same after protection period ends.", (long)attempts, (long)((ProtectedUser)this.cache.get((Serializable)((Object)protectedUserKey))).getNumLogins());
        ((AuthenticationComponent)Mockito.doNothing().when((Object)this.authenticationComponent)).authenticate(USERNAME, PASSWORD);
        try {
            this.authService.authenticate(USERNAME, PASSWORD);
        }
        catch (AuthenticationException authenticationException) {
            Assert.fail((String)("An " + AuthenticationException.class.getName() + " should not be thrown."));
        }
        Assert.assertNull((String)"The user should be removed from the cache after successful login.", (Object)this.cache.get((Serializable)((Object)protectedUserKey)));
    }

    @Test
    public void testAuthChainWorksIfFirstAuthFails() throws Exception {
        int n;
        int timeLimit = 1;
        int attempts = 2;
        this.authService.setProtectionPeriodSeconds(timeLimit);
        this.authService.setProtectionLimit(attempts);
        this.authService.setProtectionEnabled(true);
        this.authService2.setProtectionPeriodSeconds(timeLimit);
        this.authService2.setProtectionLimit(attempts);
        this.authService2.setProtectionEnabled(true);
        AuthenticationServiceImpl[] authenticationChain = new AuthenticationServiceImpl[]{this.authService, this.authService2};
        ((AuthenticationComponent)Mockito.doThrow((Throwable[])new Throwable[]{new AuthenticationException("Bad password")}).when((Object)this.authenticationComponent)).authenticate(USERNAME, PASSWORD);
        int i = 0;
        while (i < attempts) {
            AuthenticationServiceImpl[] authenticationServiceImplArray = authenticationChain;
            int n2 = authenticationChain.length;
            n = 0;
            while (n < n2) {
                AuthenticationServiceImpl authentication = authenticationServiceImplArray[n];
                try {
                    authentication.authenticate(USERNAME, PASSWORD);
                    Assert.fail((String)("An " + AuthenticationException.class.getName() + " should be thrown."));
                }
                catch (AuthenticationException authenticationException) {}
                ++n;
            }
            ++i;
        }
        AuthenticationServiceImpl[] authenticationServiceImplArray = authenticationChain;
        n = authenticationChain.length;
        int n3 = 0;
        while (n3 < n) {
            AuthenticationServiceImpl authentication = authenticationServiceImplArray[n3];
            Assert.assertTrue((String)"The user should be protected.", (boolean)authentication.isUserProtected(USERNAME));
            ++n3;
        }
        Thread.sleep(timeLimit * 1000 + 1);
        authenticationServiceImplArray = authenticationChain;
        n = authenticationChain.length;
        n3 = 0;
        while (n3 < n) {
            AuthenticationServiceImpl authentication = authenticationServiceImplArray[n3];
            Assert.assertFalse((String)"The user should not be protected any more.", (boolean)authentication.isUserProtected(USERNAME));
            ++n3;
        }
        try {
            authenticationChain[0].authenticate(USERNAME, PASSWORD);
            Assert.fail((String)("An " + AuthenticationException.class.getName() + " should be thrown."));
        }
        catch (AuthenticationException authenticationException) {}
        ((AuthenticationComponent)Mockito.doNothing().when((Object)this.authenticationComponent)).authenticate(USERNAME, PASSWORD);
        try {
            authenticationChain[1].authenticate(USERNAME, PASSWORD);
        }
        catch (AuthenticationException authenticationException) {
            Assert.fail((String)("An " + AuthenticationException.class.getName() + " should not be thrown."));
        }
        TestCase.assertNotNull((String)"The user should not be removed from the cache for the corresponding authorization service after a failed login.", (Object)this.cache.get((Serializable)((Object)authenticationChain[0].getProtectedUserKey(USERNAME))));
        Assert.assertNull((String)"The user should be removed from the cache for the corresponding authorization service after successful login.", (Object)this.cache.get((Serializable)((Object)authenticationChain[1].getProtectedUserKey(USERNAME))));
    }

    @Test
    public void testProtectionDisabledBadPassword() {
        int limit = 3;
        int attempts = limit + 2;
        this.authService.setProtectionPeriodSeconds(99999);
        this.authService.setProtectionLimit(limit);
        this.authService.setProtectionEnabled(false);
        AuthenticationException spoofedAE = new AuthenticationException("Bad password");
        ((AuthenticationComponent)Mockito.doThrow((Throwable[])new Throwable[]{spoofedAE}).when((Object)this.authenticationComponent)).authenticate(USERNAME, PASSWORD);
        int i = 0;
        while (i < attempts) {
            try {
                this.authService.authenticate(USERNAME, PASSWORD);
                Assert.fail((String)("The " + AuthenticationException.class.getName() + " should have been thrown."));
            }
            catch (AuthenticationException ae) {
                Assert.assertTrue((String)"Expected failure from AuthenticationComponent", (ae == spoofedAE ? 1 : 0) != 0);
            }
            ++i;
        }
        ((AuthenticationComponent)Mockito.verify((Object)this.authenticationComponent, (VerificationMode)Mockito.times((int)attempts))).authenticate(USERNAME, PASSWORD);
        Assert.assertNull((String)"The user should not be in the cache.", (Object)this.cache.get((Serializable)((Object)USERNAME)));
    }

    private class MockCache<K extends Serializable, V>
    implements SimpleCache<K, V> {
        private Map<K, V> internalCache = new HashMap();

        MockCache() {
        }

        public boolean contains(K key) {
            return this.internalCache.containsKey(key);
        }

        public Collection<K> getKeys() {
            return this.internalCache.keySet();
        }

        public V get(K key) {
            return this.internalCache.get(key);
        }

        public void put(K key, V value) {
            this.internalCache.put(key, value);
        }

        public void remove(K key) {
            this.internalCache.remove(key);
        }

        public void clear() {
            this.internalCache.clear();
        }
    }
}

