/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.identityservice;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.jwk.gen.RSAKeyGenerator;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceConfig;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceFacadeFactoryBean;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.http.HttpStatus;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.BadJwtException;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.web.client.RestOperations;

public class IdentityServiceFacadeFactoryBeanTest {
    private static final String EXPECTED_ISSUER = "expected-issuer";
    private static final String EXPECTED_AUDIENCE = "expected-audience";
    public final IdentityServiceConfig config = (IdentityServiceConfig)Mockito.mock(IdentityServiceConfig.class);
    public final RestOperations restOperations = (RestOperations)Mockito.mock(RestOperations.class);
    public final ResponseEntity responseEntity = (ResponseEntity)Mockito.mock(ResponseEntity.class);
    public final ClientRegistration.ProviderDetails providerDetails = (ClientRegistration.ProviderDetails)Mockito.mock(ClientRegistration.ProviderDetails.class);

    @Test
    public void shouldCreateJwtDecoderWithoutIDSWhenPublicKeyIsProvided() {
        Mockito.when((Object)this.config.getRealmKey()).thenReturn((Object)"MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAve3MabX/rp3LbE7/zNqKxuid8WT7y4qSXsNaiPvl/OVbNWW/cu5td1VndItYhH6/gL7Z5W/r4MOeTlz/fOdXfjrRJou2f3UiPQwLV9RdOH3oS4/BUe+sviD8Q3eRfWBWWz3yw8f2YNtD4bMztIMMjqthvwdEEb9S9jbxxD0o71Bsrz/FwPi7HhSDA+Z/p01Hct8m4wx13ZlKRd4YjyC12FBmi9MSgsrFuWzyQHhHTeBDoALpfuiut3rhVxUtFmVTpy6p9vil7C5J5pok4MXPH0dJCyDNQz05ww5+fD+tfksIEpFeokRpN226F+P21oQVFUWwYIaXaFlG/hfvwmnlfQIDAQAB");
        Mockito.when((Object)this.config.isClientIdValidationDisabled()).thenReturn((Object)true);
        Mockito.when((Object)this.providerDetails.getIssuerUri()).thenReturn((Object)"https://my.issuer");
        IdentityServiceFacadeFactoryBean.JwtDecoderProvider provider = new IdentityServiceFacadeFactoryBean.JwtDecoderProvider(this.config);
        JwtDecoder decoder = provider.createJwtDecoder(null, this.providerDetails);
        Jwt decodedToken = decoder.decode("eyJhbGciOiJSUzI1NiJ9.eyJleHAiOjIxNDc0ODM2NDcsImp0aSI6IjEyMzQiLCJpc3MiOiJodHRwczovL215Lmlzc3VlciIsInN1YiI6ImFiYzEyMyIsInR5cCI6IkJlYXJlciIsInByZWZlcnJlZF91c2VybmFtZSI6InBpb3RyZWsifQ.k_KaOrLLh3QsT8mKphkcz2vKpulgxp92UoEDccpHJ1mxE3Pa3gFXPKTj4goUBKXieGPZRMvBDhfWNxMvRYZPiQr2NXJKapkh0bTd0qoaSWz9ICe9Nu3eg7_VA_nwUVPz_35wwmrxgVk0_kpUYQN_VtaO7ZgFE2sJzFjbkVls5aqfAMnEjEgQl837hqZvmlW2ZRWebtxXfQxAjtp0gcTg-xtAHKIINYo_1_uAtt_H9L8KqFaioxrVAEDDIlcKnb-Ks3Y62CrZauaGUJeN_aNj2gdOpdkhvCw79yJyZSGZ7okjGbidCNSAf7Bo2Y6h3dP1Gga7kRmD648ftZESrNvbyg");
        Assertions.assertThat((Object)decodedToken).isNotNull();
        Map claims = decodedToken.getClaims();
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)claims).isNotNull()).isNotEmpty()).containsEntry((Object)"preferred_username", (Object)"piotrek");
    }

    @Test
    public void shouldAcceptAndDecodeAtJwtToken() throws JOSEException {
        Mockito.when((Object)this.config.isClientIdValidationDisabled()).thenReturn((Object)true);
        Mockito.when((Object)this.config.getSignatureAlgorithms()).thenReturn(Set.of(SignatureAlgorithm.PS256, SignatureAlgorithm.ES512));
        Mockito.when((Object)this.config.getPublicKeyCacheTtl()).thenReturn((Object)5);
        Mockito.when((Object)this.restOperations.exchange((RequestEntity)ArgumentMatchers.any(), (Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)this.responseEntity);
        RSAKey rsaKey = IdentityServiceFacadeFactoryBeanTest.getRsaKey();
        RSAKey rsaPublicJWK = rsaKey.toPublicJWK();
        Mockito.when((Object)this.responseEntity.getStatusCode()).thenReturn((Object)HttpStatus.OK);
        Mockito.when((Object)this.responseEntity.getBody()).thenReturn((Object)String.format("{\"keys\": [%s]}", rsaPublicJWK.toJSONString()));
        SignedJWT signedJWT = IdentityServiceFacadeFactoryBeanTest.getSignedJWT(rsaKey, "at+jwt", "userA", "https://my.issuer");
        signedJWT.sign((JWSSigner)new RSASSASigner(rsaKey));
        Mockito.when((Object)this.providerDetails.getIssuerUri()).thenReturn((Object)"https://my.issuer");
        Mockito.when((Object)this.providerDetails.getJwkSetUri()).thenReturn((Object)"https://my.jwkSetUri");
        IdentityServiceFacadeFactoryBean.JwtDecoderProvider provider = new IdentityServiceFacadeFactoryBean.JwtDecoderProvider(this.config);
        JwtDecoder decoder = provider.createJwtDecoder(this.restOperations, this.providerDetails);
        Jwt decodedToken = decoder.decode(signedJWT.serialize());
        Assertions.assertThat((Object)decodedToken).isNotNull();
        Map claims = decodedToken.getClaims();
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)claims).isNotNull()).isNotEmpty()).containsEntry((Object)"preferred_username", (Object)"userA");
    }

    @Test
    public void shouldFailWithNotMatchingAlgorithm() throws JOSEException {
        Mockito.when((Object)this.config.isClientIdValidationDisabled()).thenReturn((Object)true);
        Mockito.when((Object)this.config.getSignatureAlgorithms()).thenReturn(Set.of(SignatureAlgorithm.RS256));
        Mockito.when((Object)this.restOperations.exchange((RequestEntity)ArgumentMatchers.any(), (Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)this.responseEntity);
        RSAKey rsaKey = IdentityServiceFacadeFactoryBeanTest.getRsaKey();
        RSAKey rsaPublicJWK = rsaKey.toPublicJWK();
        Mockito.when((Object)this.responseEntity.getStatusCode()).thenReturn((Object)HttpStatus.OK);
        Mockito.when((Object)this.responseEntity.getBody()).thenReturn((Object)String.format("{\"keys\": [%s]}", rsaPublicJWK.toJSONString()));
        SignedJWT signedJWT = IdentityServiceFacadeFactoryBeanTest.getSignedJWT(rsaKey, "at+jwt", "userA", "https://my.issuer");
        signedJWT.sign((JWSSigner)new RSASSASigner(rsaKey));
        Mockito.when((Object)this.providerDetails.getIssuerUri()).thenReturn((Object)"https://my.issuer");
        Mockito.when((Object)this.providerDetails.getJwkSetUri()).thenReturn((Object)"https://my.jwkSetUri");
        IdentityServiceFacadeFactoryBean.JwtDecoderProvider provider = new IdentityServiceFacadeFactoryBean.JwtDecoderProvider(this.config);
        JwtDecoder decoder = provider.createJwtDecoder(this.restOperations, this.providerDetails);
        Assert.assertThrows(BadJwtException.class, () -> {
            Jwt jwt = decoder.decode(signedJWT.serialize());
        });
    }

    @Test
    public void shouldFailWithNotAllowedJOSEHeaderTyp() throws JOSEException {
        Mockito.when((Object)this.config.isClientIdValidationDisabled()).thenReturn((Object)true);
        Mockito.when((Object)this.config.getSignatureAlgorithms()).thenReturn(Set.of(SignatureAlgorithm.PS256));
        Mockito.when((Object)this.config.getPublicKeyCacheTtl()).thenReturn((Object)5);
        Mockito.when((Object)this.restOperations.exchange((RequestEntity)ArgumentMatchers.any(), (Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)this.responseEntity);
        RSAKey rsaKey = IdentityServiceFacadeFactoryBeanTest.getRsaKey();
        RSAKey rsaPublicJWK = rsaKey.toPublicJWK();
        Mockito.when((Object)this.responseEntity.getStatusCode()).thenReturn((Object)HttpStatus.OK);
        Mockito.when((Object)this.responseEntity.getBody()).thenReturn((Object)String.format("{\"keys\": [%s]}", rsaPublicJWK.toJSONString()));
        SignedJWT signedJWT = IdentityServiceFacadeFactoryBeanTest.getSignedJWT(rsaKey, "not-allowed-type", "userA", "https://my.issuer");
        signedJWT.sign((JWSSigner)new RSASSASigner(rsaKey));
        Mockito.when((Object)this.providerDetails.getIssuerUri()).thenReturn((Object)"https://my.issuer");
        Mockito.when((Object)this.providerDetails.getJwkSetUri()).thenReturn((Object)"https://my.jwkSetUri");
        IdentityServiceFacadeFactoryBean.JwtDecoderProvider provider = new IdentityServiceFacadeFactoryBean.JwtDecoderProvider(this.config);
        JwtDecoder decoder = provider.createJwtDecoder(this.restOperations, this.providerDetails);
        Assert.assertThrows(BadJwtException.class, () -> {
            Jwt jwt = decoder.decode(signedJWT.serialize());
        });
    }

    @Test
    public void shouldFailWithNotMatchingIssuerURIs() {
        IdentityServiceFacadeFactoryBean.JwtIssuerValidator issuerValidator = new IdentityServiceFacadeFactoryBean.JwtIssuerValidator(EXPECTED_ISSUER);
        OAuth2TokenValidatorResult validationResult = issuerValidator.validate(this.tokenWithIssuer("different-issuer"));
        Assertions.assertThat((Object)validationResult).isNotNull();
        Assertions.assertThat((boolean)validationResult.hasErrors()).isTrue();
        Assertions.assertThat((Collection)validationResult.getErrors()).hasSize(1);
        OAuth2Error error = (OAuth2Error)validationResult.getErrors().iterator().next();
        Assertions.assertThat((Object)error).isNotNull();
        Assertions.assertThat((String)error.getDescription()).contains(new CharSequence[]{EXPECTED_ISSUER, "different-issuer"});
    }

    @Test
    public void shouldFailWithNullIssuerURI() {
        IdentityServiceFacadeFactoryBean.JwtIssuerValidator issuerValidator = new IdentityServiceFacadeFactoryBean.JwtIssuerValidator(EXPECTED_ISSUER);
        OAuth2TokenValidatorResult validationResult = issuerValidator.validate(this.tokenWithIssuer(null));
        Assertions.assertThat((Object)validationResult).isNotNull();
        Assertions.assertThat((boolean)validationResult.hasErrors()).isTrue();
        Assertions.assertThat((Collection)validationResult.getErrors()).hasSize(1);
        OAuth2Error error = (OAuth2Error)validationResult.getErrors().iterator().next();
        Assertions.assertThat((Object)error).isNotNull();
        Assertions.assertThat((String)error.getDescription()).contains(new CharSequence[]{EXPECTED_ISSUER, "null"});
    }

    @Test
    public void shouldSucceedWithMatchingIssuerURI() {
        IdentityServiceFacadeFactoryBean.JwtIssuerValidator issuerValidator = new IdentityServiceFacadeFactoryBean.JwtIssuerValidator(EXPECTED_ISSUER);
        OAuth2TokenValidatorResult validationResult = issuerValidator.validate(this.tokenWithIssuer(EXPECTED_ISSUER));
        Assertions.assertThat((Object)validationResult).isNotNull();
        Assertions.assertThat((boolean)validationResult.hasErrors()).isFalse();
        Assertions.assertThat((Collection)validationResult.getErrors()).isEmpty();
    }

    @Test
    public void shouldFailWithNotMatchingAudienceList() {
        IdentityServiceFacadeFactoryBean.JwtAudienceValidator audienceValidator = new IdentityServiceFacadeFactoryBean.JwtAudienceValidator(EXPECTED_AUDIENCE);
        OAuth2TokenValidatorResult validationResult = audienceValidator.validate(this.tokenWithAudience(List.of("different-audience")));
        Assertions.assertThat((Object)validationResult).isNotNull();
        Assertions.assertThat((boolean)validationResult.hasErrors()).isTrue();
        Assertions.assertThat((Collection)validationResult.getErrors()).hasSize(1);
        OAuth2Error error = (OAuth2Error)validationResult.getErrors().iterator().next();
        Assertions.assertThat((Object)error).isNotNull();
        Assertions.assertThat((String)error.getDescription()).contains(new CharSequence[]{EXPECTED_AUDIENCE});
    }

    @Test
    public void shouldFailWithNullAudience() {
        IdentityServiceFacadeFactoryBean.JwtAudienceValidator audienceValidator = new IdentityServiceFacadeFactoryBean.JwtAudienceValidator(EXPECTED_AUDIENCE);
        OAuth2TokenValidatorResult validationResult = audienceValidator.validate(this.tokenWithAudience(null));
        Assertions.assertThat((Object)validationResult).isNotNull();
        Assertions.assertThat((boolean)validationResult.hasErrors()).isTrue();
        Assertions.assertThat((Collection)validationResult.getErrors()).hasSize(1);
        OAuth2Error error = (OAuth2Error)validationResult.getErrors().iterator().next();
        Assertions.assertThat((Object)error).isNotNull();
        Assertions.assertThat((String)error.getDescription()).contains(new CharSequence[]{EXPECTED_AUDIENCE});
    }

    @Test
    public void shouldSucceedWithMatchingAudienceList() {
        IdentityServiceFacadeFactoryBean.JwtAudienceValidator audienceValidator = new IdentityServiceFacadeFactoryBean.JwtAudienceValidator(EXPECTED_AUDIENCE);
        OAuth2TokenValidatorResult validationResult = audienceValidator.validate(this.tokenWithAudience(List.of(EXPECTED_AUDIENCE)));
        Assertions.assertThat((Object)validationResult).isNotNull();
        Assertions.assertThat((boolean)validationResult.hasErrors()).isFalse();
        Assertions.assertThat((Collection)validationResult.getErrors()).isEmpty();
    }

    @Test
    public void shouldSucceedWithMatchingSingleAudience() {
        IdentityServiceFacadeFactoryBean.JwtAudienceValidator audienceValidator = new IdentityServiceFacadeFactoryBean.JwtAudienceValidator(EXPECTED_AUDIENCE);
        Jwt token = Jwt.withTokenValue((String)UUID.randomUUID().toString()).claim("aud", (Object)EXPECTED_AUDIENCE).header("JUST", (Object)"FOR TESTING").build();
        OAuth2TokenValidatorResult validationResult = audienceValidator.validate(token);
        Assertions.assertThat((Object)validationResult).isNotNull();
        Assertions.assertThat((boolean)validationResult.hasErrors()).isFalse();
        Assertions.assertThat((Collection)validationResult.getErrors()).isEmpty();
    }

    private static RSAKey getRsaKey() throws JOSEException {
        return (RSAKey)new RSAKeyGenerator(2048).keyUse(KeyUse.SIGNATURE).algorithm(new Algorithm("PS256")).keyID("kid").generate();
    }

    private static SignedJWT getSignedJWT(RSAKey rsaKey, String type, String usernameClaim, String issuer) {
        JWTClaimsSet claimsSet = new JWTClaimsSet.Builder().issuer(issuer).claim("preferred_username", (Object)usernameClaim).build();
        return new SignedJWT(new JWSHeader.Builder(JWSAlgorithm.PS256).type(new JOSEObjectType(type)).keyID(rsaKey.getKeyID()).build(), claimsSet);
    }

    private Jwt tokenWithIssuer(String issuer) {
        return Jwt.withTokenValue((String)UUID.randomUUID().toString()).issuer(issuer).header("JUST", (Object)"FOR TESTING").build();
    }

    private Jwt tokenWithAudience(Collection<String> audience) {
        return Jwt.withTokenValue((String)UUID.randomUUID().toString()).audience(audience).header("JUST", (Object)"FOR TESTING").build();
    }
}

