/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer.script;

import java.util.HashMap;
import java.util.HashSet;
import org.alfresco.repo.jscript.ClasspathScriptLocation;
import org.alfresco.repo.transfer.TransferTargetImpl;
import org.alfresco.repo.transfer.script.ScriptTransferService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.ScriptLocation;
import org.alfresco.service.cmr.repository.ScriptService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.transfer.TransferDefinition;
import org.alfresco.service.cmr.transfer.TransferException;
import org.alfresco.service.cmr.transfer.TransferService;
import org.alfresco.test_category.BaseSpringTestsCategory;
import org.alfresco.util.BaseAlfrescoSpringTest;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.transaction.annotation.Transactional;

@Category(value={BaseSpringTestsCategory.class})
@Transactional
public class ScriptTransferServiceTest
extends BaseAlfrescoSpringTest {
    private ScriptService scriptService;
    private ScriptTransferService scriptTransferService;

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.scriptService = (ScriptService)this.applicationContext.getBean("ScriptService");
        this.scriptTransferService = (ScriptTransferService)this.applicationContext.getBean("transferServiceScript");
    }

    @Test
    public void testJSAPI() throws Exception {
        TransferTargetImpl dummyTarget = new TransferTargetImpl();
        dummyTarget.setName("dummyTarget");
        dummyTarget.setNodeRef(new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "4"));
        HashSet<TransferTargetImpl> dummyTargets = new HashSet<TransferTargetImpl>();
        dummyTargets.add(dummyTarget);
        TransferService mockedTransferService = (TransferService)Mockito.mock(TransferService.class);
        this.scriptTransferService.setTransferService(mockedTransferService);
        Mockito.when((Object)mockedTransferService.transfer(ArgumentMatchers.anyString(), (TransferDefinition)ArgumentMatchers.isA(TransferDefinition.class))).thenReturn((Object)new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "123"));
        Mockito.when((Object)mockedTransferService.transfer((String)ArgumentMatchers.eq((Object)"exception"), (TransferDefinition)ArgumentMatchers.isA(TransferDefinition.class))).thenThrow(new Throwable[]{new TransferException("mocked transfer exception")});
        Mockito.when((Object)mockedTransferService.getTransferTarget(ArgumentMatchers.anyString())).thenReturn((Object)dummyTarget);
        Mockito.when((Object)mockedTransferService.getTransferTargets(ArgumentMatchers.anyString())).thenReturn(dummyTargets);
        Mockito.when((Object)mockedTransferService.getTransferTargets()).thenReturn(dummyTargets);
        HashMap model = new HashMap(1);
        ClasspathScriptLocation location = new ClasspathScriptLocation("org/alfresco/repo/transfer/script/test_transferService.js");
        this.scriptService.executeScript((ScriptLocation)location, model);
    }
}

