/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.store;

import java.lang.constant.Constable;
import java.util.Arrays;
import java.util.HashMap;
import junit.framework.TestCase;
import org.alfresco.repo.virtual.ref.ClasspathResource;
import org.alfresco.repo.virtual.ref.Encodings;
import org.alfresco.repo.virtual.ref.Protocols;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.ref.Resource;
import org.alfresco.repo.virtual.store.ReferenceComparator;
import org.alfresco.repo.virtual.store.VirtualStore;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.junit.Test;
import org.mockito.Mockito;

public class ReferenceComparatorTest
extends TestCase {
    private static QName PROP_BOOLEAN_1 = QName.createQName((String)"tst:bool1");
    private static QName PROP_BOOLEAN_2 = QName.createQName((String)"tst:bool2");
    private static QName PROP_INTEGER_1 = QName.createQName((String)"tst:int1");
    private static QName PROP_INTEGER_2 = QName.createQName((String)"tst:int2");
    private static final Reference TEST_REFERENCE_1 = new Reference(Encodings.PLAIN.encoding, Protocols.VIRTUAL.protocol, (Resource)new ClasspathResource("/some/class/path.js"));
    private static final Reference TEST_REFERENCE_2 = new Reference(Encodings.PLAIN.encoding, Protocols.VIRTUAL.protocol, (Resource)new ClasspathResource("/some/other/class/path.js"));
    private static final Reference TEST_REFERENCE_3 = new Reference(Encodings.PLAIN.encoding, Protocols.VIRTUAL.protocol, (Resource)new ClasspathResource("/and/an/other/class/path.js"));
    private VirtualStore testPropertiesStore = null;

    protected void setUp() throws Exception {
        this.testPropertiesStore = (VirtualStore)Mockito.mock(VirtualStore.class);
        HashMap<QName, Constable> ref1Props = new HashMap<QName, Constable>();
        ref1Props.put(PROP_INTEGER_1, Integer.valueOf(1));
        ref1Props.put(PROP_INTEGER_2, Integer.valueOf(2));
        ref1Props.put(PROP_BOOLEAN_1, Boolean.valueOf(true));
        ref1Props.put(PROP_BOOLEAN_2, Boolean.valueOf(false));
        Mockito.when((Object)this.testPropertiesStore.getProperties(TEST_REFERENCE_1)).thenReturn(ref1Props);
        HashMap<QName, Constable> ref2Props = new HashMap<QName, Constable>();
        ref2Props.put(PROP_INTEGER_1, Integer.valueOf(1));
        ref2Props.put(PROP_INTEGER_2, Integer.valueOf(3));
        ref2Props.put(PROP_BOOLEAN_1, Boolean.valueOf(false));
        ref2Props.put(PROP_BOOLEAN_2, Boolean.valueOf(true));
        Mockito.when((Object)this.testPropertiesStore.getProperties(TEST_REFERENCE_2)).thenReturn(ref2Props);
        HashMap<QName, Constable> ref3Props = new HashMap<QName, Constable>();
        ref3Props.put(PROP_INTEGER_1, Integer.valueOf(4));
        ref3Props.put(PROP_INTEGER_2, Integer.valueOf(5));
        ref3Props.put(PROP_BOOLEAN_1, Boolean.valueOf(true));
        ref3Props.put(PROP_BOOLEAN_2, Boolean.valueOf(false));
        Mockito.when((Object)this.testPropertiesStore.getProperties(TEST_REFERENCE_3)).thenReturn(ref3Props);
    }

    @Test
    public void testCompare1() throws Exception {
        ReferenceComparator c = new ReferenceComparator(this.testPropertiesStore, Arrays.asList(new Pair((Object)PROP_INTEGER_1, (Object)true), new Pair((Object)PROP_BOOLEAN_1, (Object)true)));
        ReferenceComparatorTest.assertEquals((int)0, (int)c.compare(TEST_REFERENCE_1, TEST_REFERENCE_1));
        ReferenceComparatorTest.assertEquals((int)1, (int)c.compare(TEST_REFERENCE_1, TEST_REFERENCE_2));
        ReferenceComparatorTest.assertEquals((int)-1, (int)c.compare(TEST_REFERENCE_2, TEST_REFERENCE_1));
        ReferenceComparatorTest.assertEquals((int)-1, (int)c.compare(TEST_REFERENCE_1, TEST_REFERENCE_3));
    }
}

