/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.store;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.repo.virtual.VirtualizationIntegrationTest;
import org.alfresco.repo.virtual.config.NodeRefExpression;
import org.alfresco.repo.virtual.ref.ClasspathResource;
import org.alfresco.repo.virtual.ref.Protocols;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.ref.RepositoryLocation;
import org.alfresco.repo.virtual.ref.RepositoryResource;
import org.alfresco.repo.virtual.ref.Resource;
import org.alfresco.repo.virtual.ref.ResourceParameter;
import org.alfresco.repo.virtual.ref.ResourceProcessingError;
import org.alfresco.repo.virtual.ref.ResourceProcessor;
import org.alfresco.repo.virtual.store.TypeVirtualizationMethod;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TypeVirtualizationMethodIntegrationTest
extends VirtualizationIntegrationTest {
    private static final QName TEST_FOLDER_TYPE = SiteModel.TYPE_SITE;
    private static final QName TEST_ASPECT = SiteModel.ASPECT_SITE_CONTAINER;
    private TypeVirtualizationMethod typeVirtualizationMethod;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.typeVirtualizationMethod = (TypeVirtualizationMethod)this.ctx.getBean("typeVirtualizationMethod", TypeVirtualizationMethod.class);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.typeVirtualizationMethod.setQnameFilters(this.virtualizationConfigTestBootstrap.getTypeTemplatesQNameFilter());
    }

    @Test
    public void testFiltering() throws Exception {
        this.typeVirtualizationMethod.setQnameFilters("st:site");
        ChildAssociationRef typedNodeAssocRef = this.createTypedNode(this.testRootFolder.getNodeRef(), "TypeVirtualized", TEST_FOLDER_TYPE);
        NodeRef virtuaChildRef = typedNodeAssocRef.getChildRef();
        Assert.assertFalse((boolean)this.typeVirtualizationMethod.canVirtualize(this.environment, virtuaChildRef));
        this.addTypeTemplate(TEST_FOLDER_TYPE, "/org/alfresco/repo/virtual/template/testTemplate1.js");
        Assert.assertTrue((boolean)this.typeVirtualizationMethod.canVirtualize(this.environment, virtuaChildRef));
        Assert.assertTrue((boolean)this.typeVirtualizationMethod.canVirtualize(this.environment, virtuaChildRef));
        this.typeVirtualizationMethod.setQnameFilters("alf:site");
        Assert.assertFalse((boolean)this.typeVirtualizationMethod.canVirtualize(this.environment, virtuaChildRef));
        this.typeVirtualizationMethod.setQnameFilters("st:*");
        Assert.assertTrue((boolean)this.typeVirtualizationMethod.canVirtualize(this.environment, virtuaChildRef));
        this.typeVirtualizationMethod.setQnameFilters("alf:site");
        Assert.assertFalse((boolean)this.typeVirtualizationMethod.canVirtualize(this.environment, virtuaChildRef));
        this.typeVirtualizationMethod.setQnameFilters("*");
        Assert.assertTrue((boolean)this.typeVirtualizationMethod.canVirtualize(this.environment, virtuaChildRef));
        this.typeVirtualizationMethod.setQnameFilters("none");
        Assert.assertFalse((boolean)this.typeVirtualizationMethod.canVirtualize(this.environment, virtuaChildRef));
    }

    @Test
    public void testVirtualizeCmFolder_recusive() throws Exception {
        ChildAssociationRef templateContentChildRef = this.addTypeTemplate(ContentModel.TYPE_FOLDER, "/org/alfresco/repo/virtual/template/testTemplate1.js");
        this.virtualize(templateContentChildRef.getChildRef(), ContentModel.TYPE_FOLDER, new QName[0]);
    }

    @Test
    public void testCanVirtualize() throws Exception {
        ChildAssociationRef typedNodeAssocRef = this.createTypedNode(this.testRootFolder.getNodeRef(), "TypeVirtualized", TEST_FOLDER_TYPE);
        NodeRef typeNode = typedNodeAssocRef.getChildRef();
        Assert.assertFalse((boolean)this.typeVirtualizationMethod.canVirtualize(this.environment, typeNode));
        this.addTypeTemplate(TEST_FOLDER_TYPE, "/org/alfresco/repo/virtual/template/testTemplate1.js");
        Assert.assertTrue((boolean)this.typeVirtualizationMethod.canVirtualize(this.environment, typeNode));
    }

    @Test
    public void testCanVirtualizeAspect() throws Exception {
        ChildAssociationRef aspectNodeAssocRef = this.createTypedNode(this.testRootFolder.getNodeRef(), "TypeVirtualized", ContentModel.TYPE_FOLDER);
        NodeRef aspectNode = aspectNodeAssocRef.getChildRef();
        this.nodeService.addAspect(aspectNode, TEST_ASPECT, Collections.emptyMap());
        Assert.assertFalse((boolean)this.typeVirtualizationMethod.canVirtualize(this.environment, aspectNode));
        this.addTypeTemplate(TEST_ASPECT, "/org/alfresco/repo/virtual/template/testTemplate1.js");
        Assert.assertTrue((boolean)this.typeVirtualizationMethod.canVirtualize(this.environment, aspectNode));
    }

    @Test
    public void testVirtualizeAspect() throws Exception {
        ChildAssociationRef templateContentChildRef = this.addTypeTemplate(TEST_ASPECT, "/org/alfresco/repo/virtual/template/testTemplate1.js");
        this.virtualize(templateContentChildRef.getChildRef(), ContentModel.TYPE_FOLDER, TEST_ASPECT);
    }

    @Test
    public void testVirtualizeType() throws Exception {
        ChildAssociationRef templateContentChildRef = this.addTypeTemplate(TEST_FOLDER_TYPE, "/org/alfresco/repo/virtual/template/testTemplate1.js");
        this.virtualize(templateContentChildRef.getChildRef(), TEST_FOLDER_TYPE, new QName[0]);
    }

    private void virtualize(NodeRef expectedTemplateNodeRef, QName fodlerType, QName ... aspects) throws Exception {
        ChildAssociationRef typedNodeAssocRef = this.createTypedNode(this.testRootFolder.getNodeRef(), "TypeVirtualized", fodlerType);
        NodeRef typeNode = typedNodeAssocRef.getChildRef();
        QName[] qNameArray = aspects;
        int n = aspects.length;
        int n2 = 0;
        while (n2 < n) {
            QName aspect = qNameArray[n2];
            this.nodeService.addAspect(typeNode, aspect, Collections.emptyMap());
            ++n2;
        }
        Assert.assertTrue((boolean)this.typeVirtualizationMethod.canVirtualize(this.environment, typeNode));
        Reference theVirtualizedNode = this.typeVirtualizationMethod.virtualize(this.environment, typeNode);
        Assert.assertEquals((Object)Protocols.VANILLA.protocol, (Object)theVirtualizedNode.getProtocol());
        List parameters = theVirtualizedNode.getParameters();
        ResourceParameter vanillaResourceParameter = (ResourceParameter)parameters.get(2);
        Resource vanillaResource = (Resource)vanillaResourceParameter.getValue();
        NodeRef resourceNodeRef = (NodeRef)vanillaResource.processWith((ResourceProcessor)new ResourceProcessor<NodeRef>(){

            public NodeRef process(Resource resource) throws ResourceProcessingError {
                Assert.fail((String)"Inavlid resource type");
                return null;
            }

            public NodeRef process(ClasspathResource classpath) throws ResourceProcessingError {
                Assert.fail((String)"Inavlid resource type");
                return null;
            }

            public NodeRef process(RepositoryResource repository) throws ResourceProcessingError {
                RepositoryLocation location = repository.getLocation();
                return location.asNodeRef(TypeVirtualizationMethodIntegrationTest.this.environment);
            }
        });
        Assert.assertEquals((Object)expectedTemplateNodeRef, (Object)resourceNodeRef);
    }

    private synchronized ChildAssociationRef addTypeTemplate(QName theType, String cp) {
        NodeRefExpression templatesLocationExpr = this.virtualizationConfigTestBootstrap.getTypeTemplatesPath();
        NodeRef templatesLocation = templatesLocationExpr.resolve();
        Assert.assertNotNull((Object)templatesLocation);
        String prefixedType = theType.toPrefixString(this.environment.getNamespacePrefixResolver());
        Object contentName = prefixedType;
        contentName = ((String)contentName).replaceAll(":", "_") + ".json";
        InputStream testTemplsteJsonIS = this.getClass().getResourceAsStream(cp);
        ChildAssociationRef templateContentChildRef = this.createContent(templatesLocation, (String)contentName, testTemplsteJsonIS, "application/json", "UTF-8", ContentModel.TYPE_CONTENT);
        this.typeVirtualizationMethod.setQnameFilters(prefixedType);
        return templateContentChildRef;
    }
}

