/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.RetryingTransactionHelperTestCase;
import org.springframework.context.ApplicationContext;

public abstract class BaseAlfrescoTestCase
extends RetryingTransactionHelperTestCase {
    protected ApplicationContext ctx;
    protected ServiceRegistry serviceRegistry;
    protected NodeService nodeService;
    protected ContentService contentService;
    protected AuthenticationComponent authenticationComponent;
    protected StoreRef storeRef;
    protected NodeRef rootNodeRef;
    protected ActionService actionService;
    protected TransactionService transactionService;
    protected RetryingTransactionHelper retryingTransactionHelper;

    protected void setUpContext() {
        this.ctx = ApplicationContextHelper.getApplicationContext();
    }

    protected boolean useSpacesStore() {
        return false;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.setUpContext();
        this.serviceRegistry = (ServiceRegistry)this.ctx.getBean("ServiceRegistry");
        this.nodeService = this.serviceRegistry.getNodeService();
        this.contentService = this.serviceRegistry.getContentService();
        this.authenticationComponent = (AuthenticationComponent)this.ctx.getBean("authenticationComponent");
        this.actionService = (ActionService)this.ctx.getBean("actionService");
        this.transactionService = this.serviceRegistry.getTransactionService();
        this.retryingTransactionHelper = (RetryingTransactionHelper)this.ctx.getBean("retryingTransactionHelper");
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
                BaseAlfrescoTestCase.this.storeRef = !BaseAlfrescoTestCase.this.useSpacesStore() ? BaseAlfrescoTestCase.this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis()) : StoreRef.STORE_REF_WORKSPACE_SPACESSTORE;
                BaseAlfrescoTestCase.this.rootNodeRef = BaseAlfrescoTestCase.this.nodeService.getRootNode(BaseAlfrescoTestCase.this.storeRef);
                return null;
            }
        });
    }

    @Override
    public RetryingTransactionHelper getRetryingTransactionHelper() {
        return this.retryingTransactionHelper;
    }

    protected void tearDown() throws Exception {
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
                if (!BaseAlfrescoTestCase.this.useSpacesStore()) {
                    BaseAlfrescoTestCase.this.nodeService.deleteStore(BaseAlfrescoTestCase.this.storeRef);
                }
                return null;
            }
        });
        super.tearDown();
    }
}

