/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp.test.exportdb;

import java.util.Iterator;
import org.alfresco.util.schemacomp.ExportDb;
import org.alfresco.util.schemacomp.model.Column;
import org.alfresco.util.schemacomp.model.DbObject;
import org.alfresco.util.schemacomp.model.ForeignKey;
import org.alfresco.util.schemacomp.model.Index;
import org.alfresco.util.schemacomp.model.PrimaryKey;
import org.alfresco.util.schemacomp.model.Schema;
import org.alfresco.util.schemacomp.model.Table;
import org.alfresco.util.schemacomp.test.exportdb.AbstractExportTester;
import org.junit.Assert;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class MySQLDialectExportTester
extends AbstractExportTester {
    public MySQLDialectExportTester(ExportDb exporter, PlatformTransactionManager tx, JdbcTemplate jdbcTemplate) {
        super(exporter, tx, jdbcTemplate);
    }

    @Override
    protected void doExportTest() throws Exception {
        Schema schema = this.getSchema();
        Table exampleTable = null;
        Table otherTable = null;
        for (DbObject dbo : schema) {
            if (dbo.getName().equals("export_test_example")) {
                exampleTable = (Table)dbo;
            }
            if (!dbo.getName().equals("export_test_other")) continue;
            otherTable = (Table)dbo;
        }
        this.checkExampleTable(schema, exampleTable);
        this.checkOtherTable(schema, otherTable);
    }

    private void checkOtherTable(Schema schema, Table otherTable) {
        Assert.assertNotNull((String)"Couldn't find table export_test_other", (Object)otherTable);
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)schema, (Object)otherTable.getParent());
        Iterator colIt = otherTable.getColumns().iterator();
        Column col = (Column)colIt.next();
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)otherTable, (Object)col.getParent());
        Assert.assertEquals((Object)"id", (Object)col.getName());
        Assert.assertEquals((Object)"bigint", (Object)col.getType());
        Assert.assertEquals((Object)false, (Object)col.isNullable());
        Assert.assertEquals((long)1L, (long)col.getOrder());
        Assert.assertEquals((Object)false, (Object)col.isAutoIncrement());
        col = (Column)colIt.next();
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)otherTable, (Object)col.getParent());
        Assert.assertEquals((Object)"version", (Object)col.getName());
        Assert.assertEquals((Object)"bigint", (Object)col.getType());
        Assert.assertEquals((Object)false, (Object)col.isNullable());
        Assert.assertEquals((long)2L, (long)col.getOrder());
        col = (Column)colIt.next();
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)otherTable, (Object)col.getParent());
        Assert.assertEquals((Object)"ex_id", (Object)col.getName());
        Assert.assertEquals((Object)"bigint", (Object)col.getType());
        Assert.assertEquals((Object)false, (Object)col.isNullable());
        Assert.assertEquals((long)3L, (long)col.getOrder());
        col = (Column)colIt.next();
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)otherTable, (Object)col.getParent());
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)otherTable, (Object)col.getParent());
        Assert.assertEquals((Object)"local_name", (Object)col.getName());
        Assert.assertEquals((Object)"varchar(200)", (Object)col.getType());
        Assert.assertEquals((Object)false, (Object)col.isNullable());
        Assert.assertEquals((long)4L, (long)col.getOrder());
        Assert.assertEquals((long)2L, (long)otherTable.getIndexes().size());
        Iterator indexIt = otherTable.getIndexes().iterator();
        Index index = (Index)indexIt.next();
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)otherTable, (Object)index.getParent());
        Assert.assertEquals((Object)"export_test_idx_other_1", (Object)index.getName());
        Assert.assertEquals((Object)true, (Object)index.isUnique());
        Assert.assertEquals((long)2L, (long)index.getColumnNames().size());
        Assert.assertEquals((Object)"ex_id", index.getColumnNames().get(0));
        Assert.assertEquals((Object)"local_name", index.getColumnNames().get(1));
        index = (Index)indexIt.next();
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)otherTable, (Object)index.getParent());
        Assert.assertEquals((Object)"export_test_idx_other_2", (Object)index.getName());
        Assert.assertEquals((long)1L, (long)index.getColumnNames().size());
        Assert.assertEquals((Object)"ex_id", index.getColumnNames().get(0));
        PrimaryKey pk = otherTable.getPrimaryKey();
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)otherTable, (Object)pk.getParent());
        Assert.assertEquals((Object)"id", pk.getColumnNames().get(0));
        Assert.assertEquals((long)1L, (long)((Integer)pk.getColumnOrders().get(0)).intValue());
        Assert.assertEquals((long)1L, (long)otherTable.getForeignKeys().size());
        ForeignKey fk = (ForeignKey)otherTable.getForeignKeys().get(0);
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)otherTable, (Object)fk.getParent());
        Assert.assertEquals((Object)"export_test_fk_example", (Object)fk.getName());
        Assert.assertEquals((Object)"ex_id", (Object)fk.getLocalColumn());
        Assert.assertEquals((Object)"export_test_example", (Object)fk.getTargetTable());
        Assert.assertEquals((Object)"id", (Object)fk.getTargetColumn());
    }

    private void checkExampleTable(Schema schema, Table exampleTable) {
        Assert.assertNotNull((String)"Couldn't find export_test_example", (Object)exampleTable);
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)schema, (Object)exampleTable.getParent());
        Assert.assertEquals((Object)"export_test_example", (Object)exampleTable.getName());
        Iterator colIt = exampleTable.getColumns().iterator();
        Column col = (Column)colIt.next();
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)exampleTable, (Object)col.getParent());
        Assert.assertEquals((Object)"id", (Object)col.getName());
        Assert.assertEquals((Object)"bigint", (Object)col.getType());
        Assert.assertEquals((Object)false, (Object)col.isNullable());
        Assert.assertEquals((long)1L, (long)col.getOrder());
        Assert.assertEquals((Object)true, (Object)col.isAutoIncrement());
        col = (Column)colIt.next();
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)exampleTable, (Object)col.getParent());
        Assert.assertEquals((Object)"description", (Object)col.getName());
        Assert.assertEquals((Object)"text", (Object)col.getType());
        Assert.assertEquals((Object)true, (Object)col.isNullable());
        Assert.assertEquals((long)2L, (long)col.getOrder());
        col = (Column)colIt.next();
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)exampleTable, (Object)col.getParent());
        Assert.assertEquals((Object)"fixes_from_schema", (Object)col.getName());
        Assert.assertEquals((Object)"int", (Object)col.getType());
        Assert.assertEquals((Object)true, (Object)col.isNullable());
        Assert.assertEquals((long)3L, (long)col.getOrder());
        col = (Column)colIt.next();
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)exampleTable, (Object)col.getParent());
        Assert.assertEquals((Object)"fixes_to_schema", (Object)col.getName());
        Assert.assertEquals((Object)"int", (Object)col.getType());
        Assert.assertEquals((Object)true, (Object)col.isNullable());
        Assert.assertEquals((long)4L, (long)col.getOrder());
        col = (Column)colIt.next();
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)exampleTable, (Object)col.getParent());
        Assert.assertEquals((Object)"applied_to_schema", (Object)col.getName());
        Assert.assertEquals((Object)"int", (Object)col.getType());
        Assert.assertEquals((Object)true, (Object)col.isNullable());
        Assert.assertEquals((long)5L, (long)col.getOrder());
        col = (Column)colIt.next();
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)exampleTable, (Object)col.getParent());
        Assert.assertEquals((Object)"target_schema", (Object)col.getName());
        Assert.assertEquals((Object)"int", (Object)col.getType());
        Assert.assertEquals((Object)true, (Object)col.isNullable());
        Assert.assertEquals((long)6L, (long)col.getOrder());
        col = (Column)colIt.next();
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)exampleTable, (Object)col.getParent());
        Assert.assertEquals((Object)"applied_on_date", (Object)col.getName());
        Assert.assertEquals((Object)"datetime", (Object)col.getType());
        Assert.assertEquals((Object)true, (Object)col.isNullable());
        Assert.assertEquals((long)7L, (long)col.getOrder());
        col = (Column)colIt.next();
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)exampleTable, (Object)col.getParent());
        Assert.assertEquals((Object)"applied_to_server", (Object)col.getName());
        Assert.assertEquals((Object)"varchar(64)", (Object)col.getType());
        Assert.assertEquals((Object)true, (Object)col.isNullable());
        Assert.assertEquals((long)8L, (long)col.getOrder());
        col = (Column)colIt.next();
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)exampleTable, (Object)col.getParent());
        Assert.assertEquals((Object)"was_executed", (Object)col.getName());
        Assert.assertEquals((Object)"bit", (Object)col.getType());
        Assert.assertEquals((Object)true, (Object)col.isNullable());
        Assert.assertEquals((long)9L, (long)col.getOrder());
        col = (Column)colIt.next();
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)exampleTable, (Object)col.getParent());
        Assert.assertEquals((Object)"succeeded", (Object)col.getName());
        Assert.assertEquals((Object)"bit", (Object)col.getType());
        Assert.assertEquals((Object)true, (Object)col.isNullable());
        Assert.assertEquals((long)10L, (long)col.getOrder());
        col = (Column)colIt.next();
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)exampleTable, (Object)col.getParent());
        Assert.assertEquals((Object)"report", (Object)col.getName());
        Assert.assertEquals((Object)"text", (Object)col.getType());
        Assert.assertEquals((Object)true, (Object)col.isNullable());
        Assert.assertEquals((long)11L, (long)col.getOrder());
        PrimaryKey pk = exampleTable.getPrimaryKey();
        Assert.assertSame((String)"Incorrect parent or no parent set", (Object)exampleTable, (Object)pk.getParent());
        Assert.assertEquals((Object)"id", pk.getColumnNames().get(0));
        Assert.assertEquals((long)1L, (long)((Integer)pk.getColumnOrders().get(0)).intValue());
    }

    @Override
    protected void doDatabaseSetup() {
        final String[] createStatements = new String[]{"DROP TABLE IF EXISTS export_test_other CASCADE", "DROP TABLE IF EXISTS export_test_example CASCADE", "CREATE TABLE export_test_example             (                 id BIGINT NOT NULL AUTO_INCREMENT,                 description TEXT,                 fixes_from_schema INTEGER,                 fixes_to_schema INTEGER,                 applied_to_schema INTEGER,                 target_schema INTEGER,                 applied_on_date DATETIME,                 applied_to_server VARCHAR(64),                 was_executed BIT,                 succeeded BIT,                 report TEXT,                 PRIMARY KEY (id)             ) ENGINE=InnoDB", "CREATE TABLE export_test_other            (                id BIGINT NOT NULL,                version BIGINT NOT NULL,                ex_id BIGINT NOT NULL,                local_name VARCHAR(200) NOT NULL,                CONSTRAINT export_test_fk_example FOREIGN KEY (ex_id) REFERENCES export_test_example (id),                PRIMARY KEY (id)            ) ENGINE=InnoDB", "CREATE UNIQUE INDEX export_test_idx_other_1 ON export_test_other (ex_id, local_name)", "CREATE INDEX export_test_idx_other_2 ON export_test_other (ex_id)"};
        TransactionTemplate tt = new TransactionTemplate(this.tx);
        tt.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                String[] stringArray = createStatements;
                int n = createStatements.length;
                int n2 = 0;
                while (n2 < n) {
                    String sql = stringArray[n2];
                    MySQLDialectExportTester.this.jdbcTemplate.update(sql);
                    ++n2;
                }
            }
        });
    }
}

