/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.activities.script;

import java.util.List;
import org.alfresco.repo.jscript.BaseScopableProcessorExtension;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.activities.ActivityService;
import org.alfresco.service.cmr.activities.FeedControl;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.sync.repo.Client;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public final class Activity
extends BaseScopableProcessorExtension {
    private ActivityService activityService;
    private TenantService tenantService;

    public void setActivityService(ActivityService activityService) {
        this.activityService = activityService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void postActivity(String activityType, String siteId, String appTool, String jsonActivityData) {
        this.activityService.postActivity(activityType, siteId, appTool, jsonActivityData, Client.asType((Client.ClientType)Client.ClientType.webclient));
    }

    public void postActivity(String activityType, String siteId, String appTool, NodeRef nodeRef) {
        this.activityService.postActivity(activityType, siteId, appTool, nodeRef);
    }

    public void postActivity(String activityType, String siteId, String appTool, NodeRef nodeRef, String beforeName) {
        this.activityService.postActivity(activityType, siteId, appTool, nodeRef, beforeName);
    }

    public void postActivity(String activityType, String siteId, String appTool, NodeRef nodeRef, String name, QName typeQName, NodeRef parentNodeRef) {
        this.activityService.postActivity(activityType, siteId, appTool, nodeRef, name, typeQName, parentNodeRef);
    }

    public Scriptable getFeedControls() {
        List<FeedControl> feedControls = this.activityService.getFeedControls();
        Object[] results = new Object[feedControls.size()];
        int i = 0;
        for (FeedControl fc : feedControls) {
            results[i] = new FeedControl(this.tenantService.getBaseName(fc.getSiteId()), fc.getAppToolId());
            ++i;
        }
        return Context.getCurrentContext().newArray(this.getScope(), results);
    }

    public void setFeedControl(String siteId, String appToolId) {
        this.activityService.setFeedControl(new FeedControl(this.getTenantSpecificSiteId(siteId), appToolId));
    }

    public void unsetFeedControl(String siteId, String appToolId) {
        this.activityService.unsetFeedControl(new FeedControl(this.getTenantSpecificSiteId(siteId), appToolId));
    }

    private String getTenantSpecificSiteId(String siteId) {
        return this.tenantService.getName(siteId);
    }
}

