/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import java.io.Serializable;
import java.util.ArrayList;
import org.alfresco.repo.virtual.ref.Encoding;
import org.alfresco.repo.virtual.ref.Encodings;
import org.alfresco.repo.virtual.ref.Parameter;
import org.alfresco.repo.virtual.ref.ProtocolMethod;
import org.alfresco.repo.virtual.ref.ProtocolMethodException;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.ref.Resource;
import org.alfresco.repo.virtual.ref.ResourceParameter;
import org.alfresco.repo.virtual.ref.StringParameter;
import org.alfresco.service.cmr.repository.NodeRef;

public class Protocol
implements Serializable {
    private static final long serialVersionUID = -6969613804420028905L;
    public final String name;
    protected static final Encoding DEFAULT_ENCODING = Encodings.HASH.encoding;

    public Protocol(String name) {
        this.name = name;
    }

    public Parameter getParameter(Reference reference, int index) {
        return reference.getParameters().get(index);
    }

    public Reference replaceParameter(Reference reference, int index, String stringParameter) {
        return this.replaceParameter(reference, index, new StringParameter(stringParameter));
    }

    public Reference replaceParameter(Reference reference, int index, Parameter parameter) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(reference.getParameters());
        parameters.set(index, parameter);
        return new Reference(reference.getEncoding(), reference.getProtocol(), reference.getResource(), parameters);
    }

    public Reference addParameter(Reference reference, Resource resource) {
        return this.addParameter(reference, new ResourceParameter(resource));
    }

    public Reference addParameter(Reference reference, Parameter parameter) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(reference.getParameters());
        parameters.add(parameter);
        return new Reference(reference.getEncoding(), reference.getProtocol(), reference.getResource(), parameters);
    }

    public <R> R dispatch(ProtocolMethod<R> method, Reference reference) throws ProtocolMethodException {
        return method.execute(this, reference);
    }

    public String toString() {
        return this.name;
    }

    public Reference propagateNodeRefMutations(NodeRef mutatedNodeRef, Reference reference) {
        return reference;
    }
}

