/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import org.alfresco.repo.cache.DefaultSimpleCache;
import org.alfresco.repo.cache.SimpleCache;
import org.springframework.beans.factory.BeanNameAware;

public final class SerializingSimpleCache<K extends Serializable, V extends Serializable>
implements SimpleCache<K, V>,
BeanNameAware {
    private SimpleCache<K, V> cache;

    public SerializingSimpleCache(int maxItems, String cacheName) {
        this.cache = new DefaultSimpleCache(maxItems, cacheName);
    }

    public SerializingSimpleCache() {
        this.cache = new DefaultSimpleCache();
    }

    private V serialize(V value) {
        if (value == null) {
            return null;
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(value);
            byte[] bytes = bos.toByteArray();
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bis);
            Serializable ret = (Serializable)ois.readObject();
            bos.close();
            oos.close();
            bis.close();
            ois.close();
            return (V)ret;
        }
        catch (Exception e) {
            throw new RuntimeException("Failure to serialize/deserialize object: " + String.valueOf(value), e);
        }
    }

    public boolean contains(K key) {
        return this.cache.contains(key);
    }

    public Collection<K> getKeys() {
        return this.cache.getKeys();
    }

    public V get(K key) {
        Serializable ret = (Serializable)this.cache.get(key);
        return (V)this.serialize(ret);
    }

    public void put(K key, V value) {
        value = this.serialize(value);
        this.cache.put(key, value);
    }

    public void remove(K key) {
        this.cache.remove(key);
    }

    public void clear() {
        this.cache.clear();
    }

    public void setBeanName(String cacheName) {
    }
}

