/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.external;

import jakarta.servlet.http.HttpServletRequest;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import org.alfresco.repo.management.subsystems.AbstractChainedSubsystemTest;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.repo.management.subsystems.DefaultChildApplicationContextManager;
import org.alfresco.repo.security.authentication.external.RemoteUserMapper;
import org.alfresco.util.ApplicationContextHelper;
import org.mockito.Mockito;
import org.springframework.context.ApplicationContext;

public class DefaultRemoteUserMapperTest
extends AbstractChainedSubsystemTest {
    ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    DefaultChildApplicationContextManager childApplicationContextManager;
    ChildApplicationContextFactory childApplicationContextFactory;

    protected void setUp() throws Exception {
        this.childApplicationContextManager = (DefaultChildApplicationContextManager)this.ctx.getBean("Authentication");
        this.childApplicationContextManager.stop();
        this.childApplicationContextManager.setProperty("chain", "external1:external");
        this.childApplicationContextFactory = this.getChildApplicationContextFactory(this.childApplicationContextManager, "external1");
    }

    protected void tearDown() throws Exception {
        this.childApplicationContextManager.destroy();
        this.childApplicationContextManager = null;
        this.childApplicationContextFactory = null;
    }

    public void testUnproxiedHeader() throws Exception {
        this.childApplicationContextFactory.stop();
        this.childApplicationContextFactory.setProperty("external.authentication.proxyUserName", "");
        HttpServletRequest mockRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)mockRequest.getHeader("X-Alfresco-Remote-User")).thenReturn((Object)"AdMiN");
        DefaultRemoteUserMapperTest.assertEquals((String)"admin", (String)((RemoteUserMapper)this.childApplicationContextFactory.getApplicationContext().getBean("remoteUserMapper")).getRemoteUser(mockRequest));
        Mockito.when((Object)mockRequest.getHeader("X-Alfresco-Remote-User")).thenReturn(null);
        DefaultRemoteUserMapperTest.assertNull((Object)((RemoteUserMapper)this.childApplicationContextFactory.getApplicationContext().getBean("remoteUserMapper")).getRemoteUser(mockRequest));
        Mockito.when((Object)mockRequest.getRemoteUser()).thenReturn((Object)"ADMIN");
        DefaultRemoteUserMapperTest.assertEquals((String)"admin", (String)((RemoteUserMapper)this.childApplicationContextFactory.getApplicationContext().getBean("remoteUserMapper")).getRemoteUser(mockRequest));
    }

    public void testProxiedHeader() throws Exception {
        this.childApplicationContextFactory.stop();
        this.childApplicationContextFactory.setProperty("external.authentication.proxyUserName", "bob");
        HttpServletRequest mockRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)mockRequest.getScheme()).thenReturn((Object)"http");
        Mockito.when((Object)mockRequest.getRemoteUser()).thenReturn((Object)"bob");
        Mockito.when((Object)mockRequest.getHeader("X-Alfresco-Remote-User")).thenReturn((Object)"AdMiN");
        DefaultRemoteUserMapperTest.assertEquals((String)"admin", (String)((RemoteUserMapper)this.childApplicationContextFactory.getApplicationContext().getBean("remoteUserMapper")).getRemoteUser(mockRequest));
        this.childApplicationContextFactory.stop();
        this.childApplicationContextFactory.setProperty("external.authentication.userIdPattern", "abc-(.*)-999");
        Mockito.when((Object)mockRequest.getHeader("X-Alfresco-Remote-User")).thenReturn((Object)"abc-AdMiN-999");
        DefaultRemoteUserMapperTest.assertEquals((String)"admin", (String)((RemoteUserMapper)this.childApplicationContextFactory.getApplicationContext().getBean("remoteUserMapper")).getRemoteUser(mockRequest));
        Mockito.when((Object)mockRequest.getHeader("X-Alfresco-Remote-User")).thenReturn((Object)"abc-AdMiN-998");
        DefaultRemoteUserMapperTest.assertNull((Object)((RemoteUserMapper)this.childApplicationContextFactory.getApplicationContext().getBean("remoteUserMapper")).getRemoteUser(mockRequest));
        Mockito.when((Object)mockRequest.getRemoteUser()).thenReturn(null);
        DefaultRemoteUserMapperTest.assertNull((Object)((RemoteUserMapper)this.childApplicationContextFactory.getApplicationContext().getBean("remoteUserMapper")).getRemoteUser(mockRequest));
    }

    public void testRemoteUserFromCert() throws Exception {
        this.childApplicationContextFactory.stop();
        this.childApplicationContextFactory.setProperty("external.authentication.proxyUserName", "CN=alfresco-system");
        this.childApplicationContextFactory.setProperty("external.authentication.proxyHeader", "X-Alfresco-Remote-User");
        X509Certificate cert = (X509Certificate)Mockito.mock(X509Certificate.class);
        X500Principal principal = new X500Principal("CN=alfresco-system");
        Mockito.when((Object)cert.getSubjectX500Principal()).thenReturn((Object)principal);
        X509Certificate[] certs = new X509Certificate[]{cert};
        HttpServletRequest mockRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)mockRequest.getRemoteUser()).thenReturn(null);
        Mockito.when((Object)mockRequest.getScheme()).thenReturn((Object)"https");
        Mockito.when((Object)mockRequest.getAttribute("jakarta.servlet.request.X509Certificate")).thenReturn((Object)certs);
        Mockito.when((Object)mockRequest.getHeader("X-Alfresco-Remote-User")).thenReturn((Object)"admin");
        DefaultRemoteUserMapperTest.assertEquals((String)"admin", (String)((RemoteUserMapper)this.childApplicationContextFactory.getApplicationContext().getBean("remoteUserMapper")).getRemoteUser(mockRequest));
        Mockito.when((Object)mockRequest.getRemoteUser()).thenReturn(null);
        Mockito.when((Object)mockRequest.getScheme()).thenReturn((Object)"https");
        Mockito.when((Object)mockRequest.getAttribute("jakarta.servlet.request.X509Certificate")).thenReturn((Object)certs);
        Mockito.when((Object)mockRequest.getHeader("X-Alfresco-Remote-User")).thenReturn(null);
        DefaultRemoteUserMapperTest.assertEquals((String)"CN=alfresco-system", (String)((RemoteUserMapper)this.childApplicationContextFactory.getApplicationContext().getBean("remoteUserMapper")).getRemoteUser(mockRequest));
        Mockito.when((Object)mockRequest.getRemoteUser()).thenReturn(null);
        Mockito.when((Object)mockRequest.getScheme()).thenReturn((Object)"http");
        Mockito.when((Object)mockRequest.getAttribute("jakarta.servlet.request.X509Certificate")).thenReturn(null);
        Mockito.when((Object)mockRequest.getHeader("X-Alfresco-Remote-User")).thenReturn((Object)"admin");
        DefaultRemoteUserMapperTest.assertNull((Object)((RemoteUserMapper)this.childApplicationContextFactory.getApplicationContext().getBean("remoteUserMapper")).getRemoteUser(mockRequest));
    }
}

