/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;

public class AddFeaturesActionExecuter
extends ActionExecuterAbstractBase {
    public static final String NAME = "add-features";
    public static final String PARAM_ASPECT_NAME = "aspect-name";
    public static final String PARAM_CONSTRAINT = "ac-aspects";
    private NodeService nodeService;
    private TransactionService transactionService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    @Override
    protected boolean getAdhocPropertiesAllowed() {
        return true;
    }

    @Override
    public void executeImpl(final Action ruleAction, final NodeRef actionedUponNodeRef) {
        if (this.nodeService.exists(actionedUponNodeRef)) {
            this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                @Override
                public Void execute() throws Throwable {
                    HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
                    QName aspectQName = null;
                    if (!AddFeaturesActionExecuter.this.nodeService.exists(actionedUponNodeRef)) {
                        return null;
                    }
                    Map<String, Serializable> paramValues = ruleAction.getParameterValues();
                    AddFeaturesActionExecuter.this.removeActionContextParameter(paramValues);
                    for (Map.Entry<String, Serializable> entry : paramValues.entrySet()) {
                        if (entry.getKey().equals(AddFeaturesActionExecuter.PARAM_ASPECT_NAME)) {
                            aspectQName = (QName)entry.getValue();
                            continue;
                        }
                        QName propertyQName = QName.createQName((String)entry.getKey());
                        Serializable propertyValue = entry.getValue();
                        properties.put(propertyQName, propertyValue);
                    }
                    AddFeaturesActionExecuter.this.nodeService.addAspect(actionedUponNodeRef, aspectQName, properties);
                    return null;
                }
            });
        }
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_ASPECT_NAME, DataTypeDefinition.QNAME, true, this.getParamDisplayLabel(PARAM_ASPECT_NAME), false, PARAM_CONSTRAINT));
    }

    private void removeActionContextParameter(Map<String, Serializable> paramValues) {
        paramValues.remove("actionContext");
    }
}

