/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.attributes;

import java.util.Properties;
import org.alfresco.repo.domain.propval.PropertyValueDAO;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.security.sync.ChainingUserRegistrySynchronizer;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropTablesCleaner {
    private static final String PROPERTY_PROP_TABLE_CLEANER_ALG = "system.prop_table_cleaner.algorithm";
    private static final String PROP_TABLE_CLEANER_ALG_V2 = "V2";
    private static final String PROP_TABLE_CLEANER_ALG_V3 = "V3";
    private PropertyValueDAO propertyValueDAO;
    private JobLockService jobLockService;
    private Properties globalProperties;
    private static final long LOCK_TTL = 360000L;
    private static final QName LOCK_QNAME = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)PropTablesCleaner.class.getName());
    private static Log logger = LogFactory.getLog(PropTablesCleaner.class);

    public void setPropertyValueDAO(PropertyValueDAO propertyValueDAO) {
        this.propertyValueDAO = propertyValueDAO;
    }

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    public void setGlobalProperties(Properties globalProperties) {
        this.globalProperties = globalProperties;
    }

    public void checkProperties() {
        PropertyCheck.mandatory((Object)this, (String)"jobLockService", (Object)this.jobLockService);
        PropertyCheck.mandatory((Object)this, (String)"propertyValueDAO", (Object)this.propertyValueDAO);
        PropertyCheck.mandatory((Object)this, (String)"globalProperties", (Object)this.globalProperties);
    }

    public void execute() {
        block28: {
            this.checkProperties();
            String propCleanUplockToken = null;
            String ldapSyncLockTocken = null;
            try {
                try {
                    propCleanUplockToken = this.jobLockService.getLock(LOCK_QNAME, 360000L);
                    ldapSyncLockTocken = this.jobLockService.getLock(ChainingUserRegistrySynchronizer.LOCK_QNAME, 360000L);
                    if (PROP_TABLE_CLEANER_ALG_V2.equalsIgnoreCase(this.getAlgorithm())) {
                        this.propertyValueDAO.cleanupUnusedValuesV2();
                    } else if (PROP_TABLE_CLEANER_ALG_V3.equalsIgnoreCase(this.getAlgorithm())) {
                        this.propertyValueDAO.cleanupUnusedValuesV3();
                    } else {
                        this.propertyValueDAO.cleanupUnusedValues();
                    }
                }
                catch (LockAcquisitionException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Skipping prop tables cleaning (could not get lock): " + e.getMessage()));
                    }
                    if (propCleanUplockToken != null) {
                        try {
                            this.jobLockService.releaseLock(propCleanUplockToken, LOCK_QNAME);
                        }
                        catch (LockAcquisitionException lockAcquisitionException) {}
                    }
                    if (ldapSyncLockTocken != null) {
                        try {
                            this.jobLockService.releaseLock(ldapSyncLockTocken, ChainingUserRegistrySynchronizer.LOCK_QNAME);
                        }
                        catch (LockAcquisitionException lockAcquisitionException) {}
                    }
                    break block28;
                }
            }
            catch (Throwable throwable) {
                if (propCleanUplockToken != null) {
                    try {
                        this.jobLockService.releaseLock(propCleanUplockToken, LOCK_QNAME);
                    }
                    catch (LockAcquisitionException lockAcquisitionException) {}
                }
                if (ldapSyncLockTocken != null) {
                    try {
                        this.jobLockService.releaseLock(ldapSyncLockTocken, ChainingUserRegistrySynchronizer.LOCK_QNAME);
                    }
                    catch (LockAcquisitionException lockAcquisitionException) {}
                }
                throw throwable;
            }
            if (propCleanUplockToken != null) {
                try {
                    this.jobLockService.releaseLock(propCleanUplockToken, LOCK_QNAME);
                }
                catch (LockAcquisitionException lockAcquisitionException) {}
            }
            if (ldapSyncLockTocken != null) {
                try {
                    this.jobLockService.releaseLock(ldapSyncLockTocken, ChainingUserRegistrySynchronizer.LOCK_QNAME);
                }
                catch (LockAcquisitionException lockAcquisitionException) {}
            }
        }
    }

    private String getAlgorithm() {
        return this.globalProperties.getProperty(PROPERTY_PROP_TABLE_CLEANER_ALG);
    }
}

