/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.management.subsystems;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.repo.management.subsystems.InvalidPropertyValueException;
import org.alfresco.repo.management.subsystems.PropertyBackedBean;
import org.alfresco.repo.management.subsystems.PropertyBackedBeanRegistry;
import org.alfresco.repo.management.subsystems.PropertyBackedBeanStartedEvent;
import org.alfresco.repo.management.subsystems.PropertyBackedBeanState;
import org.alfresco.repo.management.subsystems.PropertyBackedBeanStoppedEvent;
import org.alfresco.repo.management.subsystems.SubsystemEarlyPropertyChecker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.util.PropertyPlaceholderHelper;

public abstract class AbstractPropertyBackedBean
implements PropertyBackedBean,
ApplicationContextAware,
ApplicationListener<ApplicationEvent>,
InitializingBean,
DisposableBean,
BeanNameAware {
    private boolean saveSetProperty = false;
    protected static final String DEFAULT_INSTANCE_NAME = "default";
    private ApplicationContext parent;
    private PropertyBackedBeanRegistry registry;
    private String category;
    private String beanName;
    private List<String> instancePath = Collections.singletonList("default");
    private List<String> id;
    private boolean autoStart;
    private Properties propertyDefaults;
    private Properties encryptedPropertyDefaults;
    private DefaultResolver defaultResolver = new DefaultResolver();
    protected RuntimeState runtimeState = RuntimeState.UNINITIALIZED;
    private PropertyBackedBeanState state;
    protected ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Map<String, SubsystemEarlyPropertyChecker> earlyPropertyCheckers;
    private ThreadLocal<Boolean> nestedCall = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private ThreadLocal<Boolean> localSetProperties = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private static Log logger = LogFactory.getLog(AbstractPropertyBackedBean.class);

    public void setEarlyPropertyCheckers(Map<String, SubsystemEarlyPropertyChecker> earlyPropertyCheckers) {
        this.earlyPropertyCheckers = earlyPropertyCheckers;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.parent = applicationContext;
    }

    public void setRegistry(PropertyBackedBeanRegistry registry) {
        this.registry = registry;
    }

    protected PropertyBackedBeanRegistry getRegistry() {
        return this.registry;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setInstancePath(List<String> instancePath) {
        this.instancePath = instancePath;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public void setPropertyDefaults(Properties propertyDefaults) {
        this.propertyDefaults = propertyDefaults;
    }

    public void setEncryptedPropertyDefaults(Properties propertyDefaults) {
        this.encryptedPropertyDefaults = propertyDefaults;
    }

    protected Properties getPropertyDefaults() {
        return this.propertyDefaults;
    }

    protected Properties getEncryptedPropertyDefaults() {
        return this.encryptedPropertyDefaults;
    }

    protected String resolveDefault(String name) {
        String value;
        Properties props = new Properties();
        if (this.propertyDefaults != null) {
            for (Object key : this.propertyDefaults.keySet()) {
                props.setProperty((String)key, this.propertyDefaults.getProperty((String)key));
            }
        }
        if (this.encryptedPropertyDefaults != null) {
            for (Object key : this.encryptedPropertyDefaults.keySet()) {
                props.setProperty((String)key, this.encryptedPropertyDefaults.getProperty((String)key));
            }
        }
        if ((value = props.getProperty(name)) != null) {
            value = this.defaultResolver.resolveValue(value);
        }
        return value;
    }

    protected ApplicationContext getParent() {
        return this.parent;
    }

    protected PropertyBackedBeanState getState(boolean start) {
        if (start) {
            this.start(true, false);
        }
        return this.state;
    }

    public void setSaveSetProperty(boolean saveSetProperty) {
        this.saveSetProperty = saveSetProperty;
    }

    public String performEarlyPropertyChecks(Map<String, String> properties) {
        if (properties != null && !properties.isEmpty() && this.earlyPropertyCheckers != null) {
            ArrayList<InvalidPropertyValueException> exceptions = new ArrayList<InvalidPropertyValueException>();
            for (String property : properties.keySet()) {
                if (!this.earlyPropertyCheckers.containsKey(property)) continue;
                try {
                    SubsystemEarlyPropertyChecker propertyChecker = this.earlyPropertyCheckers.get(property);
                    if (propertyChecker == null) continue;
                    if (propertyChecker.getPairedPropertyName() != null && properties.containsKey(propertyChecker.getPairedPropertyName())) {
                        propertyChecker.checkPropertyValue(property, properties.get(property), properties.get(propertyChecker.getPairedPropertyName()));
                        continue;
                    }
                    propertyChecker.checkPropertyValue(property, properties.get(property), null);
                }
                catch (InvalidPropertyValueException ipve) {
                    exceptions.add(ipve);
                }
            }
            if (exceptions.size() > 0) {
                Object allExceptionsMessages = "";
                for (InvalidPropertyValueException ipve : exceptions) {
                    if (!((String)allExceptionsMessages).equals("")) {
                        allExceptionsMessages = (String)allExceptionsMessages + " | ";
                    }
                    allExceptionsMessages = (String)allExceptionsMessages + ipve.getLocalizedMessage();
                }
                return allExceptionsMessages;
            }
        }
        return "";
    }

    public void afterPropertiesSet() throws Exception {
        if (this.category == null) {
            if (this.beanName == null) {
                throw new IllegalStateException("Category not provided");
            }
            this.category = this.beanName;
        }
        List<String> path = this.getInstancePath();
        this.id = new ArrayList<String>(path.size() + 1);
        this.id.add(this.category);
        this.id.addAll(this.getInstancePath());
        this.init();
    }

    public final void init() {
        this.lock.writeLock().lock();
        try {
            this.doInit();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected void doInit() {
        boolean hadWriteLock = this.lock.isWriteLockedByCurrentThread();
        if (this.runtimeState == RuntimeState.UNINITIALIZED) {
            if (!hadWriteLock) {
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
            }
            try {
                try {
                    if (this.runtimeState == RuntimeState.UNINITIALIZED) {
                        logger.debug((Object)"doInit() createInitialState");
                        this.state = this.createInitialState();
                        logger.debug((Object)("doInit() applyDefaultOverrides " + String.valueOf(this.state)));
                        this.applyDefaultOverrides(this.state);
                        this.runtimeState = RuntimeState.STOPPED;
                        logger.debug((Object)"doInit() register");
                        this.registry.register(this);
                        logger.debug((Object)"doInit() done");
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                logger.debug((Object)("doInit() state=" + String.valueOf((Object)this.runtimeState)));
                if (!hadWriteLock) {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            }
        }
    }

    @Override
    public final void revert() {
        this.lock.writeLock().lock();
        try {
            this.stop(true);
            this.destroy(true);
            this.doInit();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected abstract PropertyBackedBeanState createInitialState() throws IOException;

    protected void applyDefaultOverrides(PropertyBackedBeanState state) throws IOException {
        for (String name : state.getPropertyNames()) {
            String override = this.resolveDefault(name);
            if (override == null) continue;
            state.setProperty(name, override);
        }
    }

    @Override
    public List<String> getId() {
        return this.id;
    }

    protected String getCategory() {
        return this.category;
    }

    protected List<String> getInstancePath() {
        return this.instancePath;
    }

    public final void destroy() {
        this.lock.writeLock().lock();
        try {
            this.destroy(false);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected void destroy(boolean isPermanent) {
        if (this.runtimeState != RuntimeState.UNINITIALIZED) {
            boolean hadWriteLock = this.lock.isWriteLockedByCurrentThread();
            if (!hadWriteLock) {
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
            }
            try {
                if (this.runtimeState != RuntimeState.UNINITIALIZED) {
                    logger.debug((Object)("destroy() stop state=" + String.valueOf((Object)this.runtimeState)));
                    this.stop(false);
                    logger.debug((Object)("destroy() deregister " + isPermanent));
                    this.registry.deregister(this, isPermanent);
                    this.state = null;
                    this.runtimeState = RuntimeState.UNINITIALIZED;
                    logger.debug((Object)"destroy() done");
                }
            }
            finally {
                logger.debug((Object)("destroy() state=" + String.valueOf((Object)this.runtimeState)));
                if (!hadWriteLock) {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            }
        }
    }

    @Override
    public boolean isUpdateable(String name) {
        return true;
    }

    @Override
    public String getDescription(String name) {
        return this.isUpdateable(name) ? "Editable Property " + name : "Read-only Property " + name;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (this.autoStart && event instanceof ContextRefreshedEvent && event.getSource() == this.parent) {
            this.lock.writeLock().lock();
            try {
                try {
                    this.start(false, false);
                }
                catch (Exception e) {
                    logger.error((Object)"Error auto-starting subsystem", (Throwable)e);
                    this.lock.writeLock().unlock();
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        } else {
            if (event instanceof PropertyBackedBeanStartedEvent) {
                this.lock.writeLock().lock();
                try {
                    switch (this.runtimeState) {
                        case STOPPED: 
                        case PENDING_BROADCAST_START: {
                            this.destroy(false);
                        }
                        case UNINITIALIZED: {
                            this.start(false, false);
                        }
                    }
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
            if (event instanceof PropertyBackedBeanStoppedEvent) {
                this.lock.writeLock().lock();
                try {
                    this.destroy(false);
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
        }
    }

    @Override
    public String getProperty(String name) {
        this.lock.readLock().lock();
        try {
            this.doInit();
            String string = this.state.getProperty(name);
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Set<String> getPropertyNames() {
        this.lock.readLock().lock();
        try {
            this.doInit();
            Set<String> set = this.state.getPropertyNames();
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void setPropertyInternal(String name, String value) {
        this.stop(false);
        this.doInit();
        this.state.setProperty(name, value);
    }

    /*
     * Unable to fully structure code
     */
    private void setPropertiesInternal(Map<String, String> properties) {
        block5: {
            this.stop(false);
            this.doInit();
            previousValues = new HashMap<String, String>(properties.size() * 2);
            try {
                for (Map.Entry<String, String> entry : properties.entrySet()) {
                    property = entry.getKey();
                    previousValue = this.state.getProperty(property);
                    this.state.setProperty(property, entry.getValue());
                    previousValues.put(property, previousValue);
                }
                this.start(false, true);
                break block5;
            }
            catch (Exception e) {
                ** for (entry : previousValues.entrySet())
            }
lbl-1000:
            // 1 sources

            {
                this.state.setProperty((String)entry.getKey(), (String)entry.getValue());
                continue;
            }
lbl18:
            // 1 sources

            this.start(true, false);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalStateException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setProperty(String name, String value) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("setProperty(" + name + "," + value + ")"));
        }
        if (!this.nestedCall.get().booleanValue()) {
            this.nestedCall.set(true);
            this.lock.writeLock().lock();
            try {
                boolean mBeanInfoChange;
                boolean bl = mBeanInfoChange = !this.getPropertyNames().contains(name);
                if (this.saveSetProperty) {
                    logger.debug((Object)"setProperty() broadcastSetProperties");
                    this.registry.broadcastSetProperty(this, name, value);
                }
                if (this.localSetProperties.get().booleanValue()) {
                    if (!mBeanInfoChange) return;
                    logger.debug((Object)"setProperty() destroy");
                    this.start(false, true);
                    return;
                }
                logger.debug((Object)"setProperty() setPropertyInternal");
                this.setPropertyInternal(name, value);
                return;
            }
            finally {
                this.localSetProperties.set(false);
                this.nestedCall.set(false);
                this.lock.writeLock().unlock();
            }
        } else {
            this.localSetProperties.set(true);
            logger.debug((Object)"setProperty() callback setPropertyInternal");
            this.setPropertyInternal(name, value);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setProperties(Map<String, String> properties) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("setProperties(" + String.valueOf(properties) + ")"));
        }
        if (!this.nestedCall.get().booleanValue()) {
            this.nestedCall.set(true);
            boolean hadWriteLock = this.lock.isWriteLockedByCurrentThread();
            if (!hadWriteLock) {
                this.lock.writeLock().lock();
            }
            try {
                boolean mBeanInfoChange;
                boolean bl = mBeanInfoChange = !this.getPropertyNames().containsAll(properties.keySet());
                if (this.saveSetProperty) {
                    logger.debug((Object)"setProperties() broadcastSetProperties");
                    this.registry.broadcastSetProperties(this, properties);
                }
                if (this.localSetProperties.get().booleanValue()) {
                    if (!mBeanInfoChange) return;
                    logger.debug((Object)"setProperties() destroy");
                    this.start(true, false);
                    return;
                }
                logger.debug((Object)"setProperties() setPropertiesInternal");
                this.setPropertiesInternal(properties);
                return;
            }
            finally {
                this.localSetProperties.set(false);
                this.nestedCall.set(false);
                if (!hadWriteLock) {
                    this.lock.writeLock().unlock();
                }
            }
        } else {
            this.localSetProperties.set(true);
            logger.debug((Object)"setProperties() callback setPropertiesInternal");
            this.setPropertiesInternal(properties);
        }
    }

    @Override
    public void removeProperty(String name) {
        this.removeProperties(Collections.singleton(name));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void removeProperties(Collection<String> properties) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("removeProperties(" + String.valueOf(properties) + ")"));
        }
        if (!this.nestedCall.get().booleanValue()) {
            this.nestedCall.set(true);
            boolean hadWriteLock = this.lock.isWriteLockedByCurrentThread();
            if (!hadWriteLock) {
                this.lock.writeLock().lock();
            }
            try {
                boolean mBeanInfoChange;
                boolean bl = mBeanInfoChange = !this.getPropertyNames().containsAll(properties);
                if (this.saveSetProperty) {
                    logger.debug((Object)"removeProperties() broadcastRemoveProperties");
                    this.registry.broadcastRemoveProperties(this, properties);
                }
                if (this.localSetProperties.get().booleanValue()) {
                    if (!mBeanInfoChange) return;
                    logger.debug((Object)"removeProperties() destroy");
                    this.start(true, false);
                    return;
                }
                logger.debug((Object)"removeProperties() removePropertiesInternal");
                this.removePropertiesInternal(properties);
                return;
            }
            finally {
                this.localSetProperties.set(false);
                this.nestedCall.set(false);
                if (!hadWriteLock) {
                    this.lock.writeLock().unlock();
                }
            }
        } else {
            this.localSetProperties.set(true);
            logger.debug((Object)"removeProperties() callback removePropertiesInternal");
            this.removePropertiesInternal(properties);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void removePropertiesInternal(Collection<String> properties) {
        block5: {
            this.stop(false);
            this.doInit();
            previousValues = new HashMap<String, String>(properties.size() * 2);
            try {
                for (String property : properties) {
                    previousValue = this.state.getProperty(property);
                    this.state.removeProperty(property);
                    previousValues.put(property, previousValue);
                }
                this.start(false, true);
                break block5;
            }
            catch (Exception e) {
                ** for (entry : previousValues.entrySet())
            }
lbl-1000:
            // 1 sources

            {
                this.state.setProperty((String)entry.getKey(), (String)entry.getValue());
                continue;
            }
lbl17:
            // 1 sources

            this.start(true, false);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalStateException(e);
        }
    }

    @Override
    public final void start() {
        this.lock.writeLock().lock();
        try {
            this.start(true, false);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void start(boolean broadcastNow, boolean broadcastLater) {
        boolean hadWriteLock = this.lock.isWriteLockedByCurrentThread();
        if (this.runtimeState == RuntimeState.STARTED) return;
        if (!hadWriteLock) {
            this.lock.readLock().unlock();
            this.lock.writeLock().lock();
        }
        try {
            switch (this.runtimeState) {
                case UNINITIALIZED: {
                    this.doInit();
                }
                case STOPPED: {
                    this.state.start();
                    this.runtimeState = broadcastLater ? RuntimeState.PENDING_BROADCAST_START : RuntimeState.STARTED;
                }
                case PENDING_BROADCAST_START: {
                    if (!broadcastNow) return;
                    this.registry.broadcastStart(this);
                    this.runtimeState = RuntimeState.STARTED;
                }
                default: {
                    return;
                }
            }
        }
        finally {
            if (!hadWriteLock) {
                this.lock.readLock().lock();
                this.lock.writeLock().unlock();
            }
        }
    }

    @Override
    public final void stop() {
        this.lock.writeLock().lock();
        try {
            this.stop(true);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected void stop(boolean broadcast) {
        boolean hadWriteLock = this.lock.isWriteLockedByCurrentThread();
        switch (this.runtimeState) {
            case PENDING_BROADCAST_START: 
            case STARTED: {
                if (!hadWriteLock) {
                    this.lock.readLock().unlock();
                    this.lock.writeLock().lock();
                }
                try {
                    switch (this.runtimeState) {
                        case STARTED: {
                            if (broadcast) {
                                this.registry.broadcastStop(this);
                            }
                        }
                        case PENDING_BROADCAST_START: {
                            this.state.stop();
                            this.runtimeState = RuntimeState.STOPPED;
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (!hadWriteLock) {
                        this.lock.readLock().lock();
                        this.lock.writeLock().unlock();
                    }
                    throw throwable;
                }
                if (hadWriteLock) break;
                this.lock.readLock().lock();
                this.lock.writeLock().unlock();
            }
        }
    }

    public class DefaultResolver
    extends PropertyPlaceholderHelper {
        public DefaultResolver() {
            super("${", "}", ":", null, true);
        }

        public String resolveValue(String val) {
            Properties props = new Properties();
            if (AbstractPropertyBackedBean.this.propertyDefaults != null) {
                for (Object key : AbstractPropertyBackedBean.this.propertyDefaults.keySet()) {
                    props.setProperty((String)key, AbstractPropertyBackedBean.this.propertyDefaults.getProperty((String)key));
                }
            }
            if (AbstractPropertyBackedBean.this.encryptedPropertyDefaults != null) {
                for (Object key : AbstractPropertyBackedBean.this.encryptedPropertyDefaults.keySet()) {
                    props.setProperty((String)key, AbstractPropertyBackedBean.this.encryptedPropertyDefaults.getProperty((String)key));
                }
            }
            return this.replacePlaceholders(val, props);
        }
    }

    protected static enum RuntimeState {
        UNINITIALIZED,
        STOPPED,
        PENDING_BROADCAST_START,
        STARTED;

    }
}

