/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.module;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.module.ModuleComponent;
import org.alfresco.repo.module.ModuleVersionNumber;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.module.ModuleService;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.PropertyCheck;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.extensions.surf.util.I18NUtil;

@AlfrescoPublicApi
public abstract class AbstractModuleComponent
implements ModuleComponent,
BeanNameAware {
    private static final String ERR_ALREADY_EXECUTED = "module.err.already_executed";
    private static final String ERR_EXECUTION_FAILED = "module.err.execution_failed";
    protected ServiceRegistry serviceRegistry;
    protected AuthenticationComponent authenticationComponent;
    protected ModuleService moduleService;
    private TenantAdminService tenantAdminService;
    private String moduleId;
    private String name;
    private String description;
    private ModuleVersionNumber sinceVersion = ModuleVersionNumber.VERSION_ZERO;
    private ModuleVersionNumber appliesFromVersion = ModuleVersionNumber.VERSION_ZERO;
    private ModuleVersionNumber appliesToVersion = ModuleVersionNumber.VERSION_BIG;
    private List<ModuleComponent> dependsOn = new ArrayList<ModuleComponent>(0);
    private boolean executeOnceOnly = true;
    private Map<String, Boolean> executed = new HashMap<String, Boolean>(1);

    protected void checkProperties() {
        PropertyCheck.mandatory((Object)this, (String)"serviceRegistry", (Object)this.serviceRegistry);
        PropertyCheck.mandatory((Object)this, (String)"authenticationComponent", (Object)this.authenticationComponent);
        PropertyCheck.mandatory((Object)this, (String)"moduleId", (Object)this.moduleId);
        PropertyCheck.mandatory((Object)this, (String)"name", (Object)this.name);
        PropertyCheck.mandatory((Object)this, (String)"sinceVersion", (Object)this.sinceVersion);
        PropertyCheck.mandatory((Object)this, (String)"appliesFromVersion", (Object)this.appliesFromVersion);
        PropertyCheck.mandatory((Object)this, (String)"appliesToVersion", (Object)this.appliesToVersion);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("ModuleComponent").append("[ module=").append(this.moduleId).append(", name=").append(this.name).append(", since=").append(this.sinceVersion).append(", appliesFrom=").append(this.appliesFromVersion).append(", appliesTo=").append(this.appliesToVersion).append(", onceOnly=").append(this.executeOnceOnly).append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ModuleComponent)) {
            return false;
        }
        ModuleComponent that = (ModuleComponent)obj;
        return EqualsHelper.nullSafeEquals((Object)this.moduleId, (Object)that.getModuleId()) && EqualsHelper.nullSafeEquals((Object)this.name, (Object)that.getName());
    }

    public int hashCode() {
        return this.moduleId.hashCode() + 17 * this.name.hashCode();
    }

    public void setAuthenticationComponent(AuthenticationComponent authenticationComponent) {
        this.authenticationComponent = authenticationComponent;
    }

    public void setModuleService(ModuleService moduleService) {
        this.moduleService = moduleService;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setTenantAdminService(TenantAdminService tenantAdminService) {
        this.tenantAdminService = tenantAdminService;
    }

    @Override
    public String getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setBeanName(String name) {
        this.setName(name);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public ModuleVersionNumber getSinceVersionNumber() {
        return this.sinceVersion;
    }

    public void setSinceVersion(String version) {
        this.sinceVersion = new ModuleVersionNumber(version);
    }

    @Override
    public ModuleVersionNumber getAppliesFromVersionNumber() {
        return this.appliesFromVersion;
    }

    public void setAppliesFromVersion(String version) {
        this.appliesFromVersion = new ModuleVersionNumber(version);
    }

    @Override
    public ModuleVersionNumber getAppliesToVersionNumber() {
        return this.appliesToVersion;
    }

    public void setAppliesToVersion(String version) {
        this.appliesToVersion = new ModuleVersionNumber(version);
    }

    @Override
    public List<ModuleComponent> getDependsOn() {
        return this.dependsOn;
    }

    public void setDependsOn(List<ModuleComponent> dependsOn) {
        this.dependsOn = dependsOn;
    }

    @Override
    public boolean isExecuteOnceOnly() {
        return this.executeOnceOnly;
    }

    public void setExecuteOnceOnly(boolean executeOnceOnly) {
        this.executeOnceOnly = executeOnceOnly;
    }

    public void init() {
        this.description = I18NUtil.getMessage((String)this.description);
        if (this.moduleService != null) {
            this.moduleService.registerComponent(this);
        }
    }

    protected abstract void executeInternal() throws Throwable;

    @Override
    public final synchronized void execute() {
        String tenantDomain = this.tenantAdminService.getCurrentUserDomain();
        if (!this.executed.containsKey(tenantDomain)) {
            this.executed.put(tenantDomain, false);
        }
        if (this.executed.get(tenantDomain).booleanValue()) {
            throw AlfrescoRuntimeException.create((String)ERR_ALREADY_EXECUTED, (Object[])new Object[]{this.moduleId, this.name});
        }
        this.checkProperties();
        try {
            try {
                this.executeInternal();
            }
            catch (Throwable e) {
                throw AlfrescoRuntimeException.create((Throwable)e, (String)ERR_EXECUTION_FAILED, (Object[])new Object[]{this.name, e.getMessage()});
            }
        }
        finally {
            this.executed.put(tenantDomain, true);
        }
    }

    @Override
    public final synchronized void shutdown() {
        String tenantDomain = this.tenantAdminService.getCurrentUserDomain();
        this.executed.put(tenantDomain, false);
    }
}

