/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.search.SearchEngineResultMetadata;
import org.alfresco.service.cmr.search.StatsResultSet;
import org.alfresco.service.cmr.search.StatsResultStat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.util.StringUtils;

public class SolrStatsResult
implements SearchEngineResultMetadata,
StatsResultSet {
    private static final Log logger = LogFactory.getLog(SolrStatsResult.class);
    private Long status;
    private Long queryTime;
    private Long numberFound;
    private Long sum;
    private Long max;
    private Long mean;
    private List<StatsResultStat> stats;
    private boolean nameIsADate;

    public SolrStatsResult(JSONObject json, boolean nameIsADate) {
        try {
            this.nameIsADate = nameIsADate;
            this.stats = new ArrayList<StatsResultStat>();
            this.processJson(json);
        }
        catch (NullPointerException | JSONException e) {
            logger.info((Object)e.getMessage());
        }
    }

    protected void processJson(JSONObject json) throws JSONException {
        JSONObject statsFields;
        JSONArray fieldNames;
        JSONObject statsObj;
        JSONObject responseHeader = json.getJSONObject("responseHeader");
        this.status = responseHeader.getLong("status");
        this.queryTime = responseHeader.getLong("QTime");
        JSONObject response = json.getJSONObject("response");
        this.numberFound = response.getLong("numFound");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("JSON response: " + String.valueOf(json)));
        }
        if (json.has("stats") && (statsObj = json.getJSONObject("stats")).has("stats_fields") && (fieldNames = (statsFields = statsObj.getJSONObject("stats_fields")).names()).length() == 1) {
            JSONObject contentsize = statsFields.getJSONObject(fieldNames.getString(0));
            this.sum = contentsize.getLong("sum");
            this.max = contentsize.getLong("max");
            this.mean = contentsize.getLong("mean");
            if (contentsize.has("facets")) {
                JSONObject facets = contentsize.getJSONObject("facets");
                JSONArray facetNames = facets.names();
                int i = 0;
                while (i < facetNames.length()) {
                    JSONObject facetType = facets.getJSONObject(String.valueOf(facetNames.get(i)));
                    if (facetType != null && facetType.names() != null) {
                        JSONArray facetValues = facetType.names();
                        int j = 0;
                        while (j < facetValues.length()) {
                            String name = String.valueOf(facetValues.get(j));
                            JSONObject facetVal = facetType.getJSONObject(name);
                            this.stats.add(this.processStat(name, facetVal));
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
    }

    private StatsResultStat processStat(String name, JSONObject facetVal) throws JSONException {
        return new StatsResultStat(this.nameIsADate ? SolrStatsResult.formatAsDate(name) : name, Long.valueOf(facetVal.getLong("sum")), Long.valueOf(facetVal.getLong("count")), Long.valueOf(facetVal.getLong("min")), Long.valueOf(facetVal.getLong("max")), Long.valueOf(facetVal.getLong("mean")));
    }

    public static String formatAsDate(String name) {
        block3: {
            if (StringUtils.hasText((String)name)) {
                try {
                    return name.substring(0, 10);
                }
                catch (IllegalArgumentException iae) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug((Object)("Can't parse reponse: " + iae.getMessage()));
                }
            }
        }
        return "";
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SolrStatsResult [status=").append(this.status).append(", queryTime=").append(this.queryTime).append(", numberFound=").append(this.numberFound).append(", sum=").append(this.sum).append(", max=").append(this.max).append(", mean=").append(this.mean).append(", stats=").append(this.stats).append("]");
        return builder.toString();
    }

    public Long getStatus() {
        return this.status;
    }

    @Override
    public Long getQueryTime() {
        return this.queryTime;
    }

    @Override
    public long getNumberFound() {
        return this.numberFound;
    }

    public Long getSum() {
        return this.sum;
    }

    public Long getMax() {
        return this.max;
    }

    public Long getMean() {
        return this.mean;
    }

    public List<StatsResultStat> getStats() {
        return this.stats;
    }
}

