/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.store;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.query.ListBackedPagingResults;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.NodePermissionEntry;
import org.alfresco.repo.security.permissions.PermissionReference;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionalResourceHelper;
import org.alfresco.repo.virtual.ActualEnvironment;
import org.alfresco.repo.virtual.AlfrescoEnviroment;
import org.alfresco.repo.virtual.VirtualContentModel;
import org.alfresco.repo.virtual.VirtualizationException;
import org.alfresco.repo.virtual.page.PageCollationException;
import org.alfresco.repo.virtual.page.PageCollator;
import org.alfresco.repo.virtual.ref.GetActualNodeRefMethod;
import org.alfresco.repo.virtual.ref.GetChildByIdMethod;
import org.alfresco.repo.virtual.ref.GetParentReferenceMethod;
import org.alfresco.repo.virtual.ref.GetReferenceType;
import org.alfresco.repo.virtual.ref.GetTemplatePathMethod;
import org.alfresco.repo.virtual.ref.Protocol;
import org.alfresco.repo.virtual.ref.ProtocolMethodException;
import org.alfresco.repo.virtual.ref.Protocols;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.ref.ReferenceEncodingException;
import org.alfresco.repo.virtual.ref.ReferenceParseException;
import org.alfresco.repo.virtual.store.GetAllSetPermissionsMethod;
import org.alfresco.repo.virtual.store.GetChildAssocsMethod;
import org.alfresco.repo.virtual.store.GetSetPermissionsMethod;
import org.alfresco.repo.virtual.store.HasPermissionMethod;
import org.alfresco.repo.virtual.store.ReferenceComparator;
import org.alfresco.repo.virtual.store.VirtualFolderDefinitionResolver;
import org.alfresco.repo.virtual.store.VirtualStore;
import org.alfresco.repo.virtual.store.VirtualUserPermissions;
import org.alfresco.repo.virtual.store.VirtualizationMethod;
import org.alfresco.repo.virtual.template.ApplyTemplateMethod;
import org.alfresco.repo.virtual.template.BasicConstraint;
import org.alfresco.repo.virtual.template.FilesFoldersConstraint;
import org.alfresco.repo.virtual.template.FilingData;
import org.alfresco.repo.virtual.template.FilingParameters;
import org.alfresco.repo.virtual.template.FilingRule;
import org.alfresco.repo.virtual.template.NamePatternPropertyValueConstraint;
import org.alfresco.repo.virtual.template.NullFilingRule;
import org.alfresco.repo.virtual.template.PropertyValueConstraint;
import org.alfresco.repo.virtual.template.VirtualFolderDefinition;
import org.alfresco.repo.virtual.template.VirtualQuery;
import org.alfresco.repo.virtual.template.VirtualQueryConstraint;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ChildAssocsSlice;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VirtualStoreImpl
implements VirtualStore,
VirtualFolderDefinitionResolver {
    private static Log logger = LogFactory.getLog(VirtualStoreImpl.class);
    private static final String VIRTUAL_FOLDER_DEFINITION = "virtualfolder.definition";
    private List<VirtualizationMethod> virtualizationMethods = null;
    private ActualEnvironment environment;
    private VirtualUserPermissions userPermissions;

    public void setVirtualizationMethods(List<VirtualizationMethod> methdods) {
        this.virtualizationMethods = methdods;
    }

    public void setEnvironment(ActualEnvironment environment) {
        this.environment = environment;
    }

    @Override
    public boolean isVirtual(NodeRef nodeRef) throws VirtualizationException {
        Reference reference = Reference.fromNodeRef(nodeRef);
        if (reference != null) {
            Protocol protocol = Reference.fromNodeRef(nodeRef).getProtocol();
            return Protocols.VIRTUAL.protocol.equals(protocol) || Protocols.VANILLA.protocol.equals(protocol);
        }
        return false;
    }

    @Override
    public boolean canVirtualize(NodeRef nodeRef) throws VirtualizationException {
        String runAsUser = AuthenticationUtil.getRunAsUser();
        if (runAsUser == null) {
            if (logger.isTraceEnabled()) {
                RuntimeException stackTracingException = new RuntimeException("Stack trace.");
                logger.trace((Object)"Virtualization check call in unauthenticated-context - stack trace follows:", (Throwable)stackTracingException);
            }
            return false;
        }
        Reference reference = Reference.fromNodeRef(nodeRef);
        if (reference != null) {
            return true;
        }
        for (VirtualizationMethod vMethod : this.virtualizationMethods) {
            if (!vMethod.canVirtualize(this.environment, nodeRef)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canMaterialize(Reference reference) throws VirtualizationException {
        if (Protocols.NODE.protocol.equals(reference.getProtocol())) {
            return true;
        }
        String templatePath = reference.execute(new GetTemplatePathMethod());
        return templatePath.trim().equals("/");
    }

    private NodeRef nodeProtocolNodeRef(NodeRef nodeRef) throws ProtocolMethodException, ReferenceParseException, ReferenceEncodingException {
        NodeRef theNodeRef = nodeRef;
        Reference ref = Reference.fromNodeRef(theNodeRef);
        if (ref != null && Protocols.NODE.protocol.equals(ref.getProtocol())) {
            theNodeRef = ref.execute(new GetActualNodeRefMethod(this.environment));
        }
        return theNodeRef;
    }

    @Override
    public Reference virtualize(NodeRef nodeRef) throws VirtualizationException {
        Reference reference = null;
        if (this.isVirtual(nodeRef)) {
            reference = Reference.fromNodeRef(nodeRef);
        } else {
            NodeRef theNodeRef = this.nodeProtocolNodeRef(nodeRef);
            for (VirtualizationMethod vMethod : this.virtualizationMethods) {
                if (!vMethod.canVirtualize(this.environment, theNodeRef)) continue;
                reference = vMethod.virtualize(this.environment, theNodeRef);
            }
            if (reference == null && (reference = Reference.fromNodeRef(nodeRef)) == null) {
                throw new VirtualizationException("No virtualization method for " + String.valueOf(nodeRef));
            }
        }
        return reference;
    }

    @Override
    public NodeRef materialize(Reference reference) throws VirtualizationException {
        return reference.execute(new GetActualNodeRefMethod(this.environment));
    }

    @Override
    public Collection<NodeRef> materializeIfPossible(Collection<NodeRef> nodeRefs) throws VirtualizationException {
        LinkedList<NodeRef> nodeRefList = new LinkedList<NodeRef>();
        for (NodeRef nodeRef : nodeRefs) {
            nodeRefList.add(this.materializeIfPossible(nodeRef));
        }
        return nodeRefList;
    }

    @Override
    public NodeRef materializeIfPossible(NodeRef nodeRef) throws VirtualizationException {
        Reference ref = Reference.fromNodeRef(nodeRef);
        if (ref != null && this.canMaterialize(ref)) {
            return this.materialize(ref);
        }
        return nodeRef;
    }

    @Override
    public List<ChildAssociationRef> getChildAssocs(Reference parentReference, QNamePattern typeQNamePattern, QNamePattern qnamePattern, int maxResults, boolean preload) throws InvalidNodeRefException {
        if (!typeQNamePattern.isMatch(ContentModel.ASSOC_CONTAINS)) {
            return Collections.emptyList();
        }
        GetChildAssocsMethod getChildAssocsMethod = new GetChildAssocsMethod(this, this.environment, preload, 0, maxResults, qnamePattern, typeQNamePattern);
        ChildAssocsSlice childAssocsSlice = parentReference.execute(getChildAssocsMethod);
        return childAssocsSlice.childAssocs();
    }

    @Override
    public ChildAssocsSlice getChildAssocs(Reference parentReference, QNamePattern typeQNamePattern, QNamePattern qnamePattern, int skipResults, int maxResults, boolean preload) throws InvalidNodeRefException {
        if (!typeQNamePattern.isMatch(ContentModel.ASSOC_CONTAINS)) {
            return ChildAssocsSlice.EMPTY;
        }
        GetChildAssocsMethod getChildAssocsMethod = new GetChildAssocsMethod(this, this.environment, preload, skipResults, maxResults, qnamePattern, typeQNamePattern);
        return parentReference.execute(getChildAssocsMethod);
    }

    @Override
    public List<ChildAssociationRef> getChildAssocs(Reference parentReference, Set<QName> childNodeTypeQNames) {
        List<ChildAssociationRef> allAssociations = this.getChildAssocs(parentReference, RegexQNamePattern.MATCH_ALL, RegexQNamePattern.MATCH_ALL, Integer.MAX_VALUE, false);
        LinkedList<ChildAssociationRef> associations = new LinkedList<ChildAssociationRef>();
        for (ChildAssociationRef childAssociationRef : allAssociations) {
            QName childType = this.environment.getType(childAssociationRef.getChildRef());
            if (!childNodeTypeQNames.contains(childType)) continue;
            associations.add(childAssociationRef);
        }
        return associations;
    }

    @Override
    public Collection<ChildAssociationRef> getChildAssocsWithoutParentAssocsOfType(Reference parentReference, QName assocTypeQName) {
        return Collections.emptyList();
    }

    @Override
    public List<ChildAssociationRef> getChildAssocsByPropertyValue(Reference parentReference, QName propertyQName, Serializable value) {
        List<ChildAssociationRef> allAssociations = this.getChildAssocs(parentReference, RegexQNamePattern.MATCH_ALL, RegexQNamePattern.MATCH_ALL, Integer.MAX_VALUE, false);
        LinkedList<ChildAssociationRef> associations = new LinkedList<ChildAssociationRef>();
        for (ChildAssociationRef childAssociationRef : allAssociations) {
            Serializable propertyValue = this.environment.getProperty(childAssociationRef.getChildRef(), propertyQName);
            if ((value != null || propertyValue != null) && (value == null || !value.equals(propertyValue))) continue;
            associations.add(childAssociationRef);
        }
        return associations;
    }

    @Override
    public Reference getChildByName(Reference reference, QName assocTypeQName, String childName) throws VirtualizationException {
        VirtualFolderDefinition structure = this.resolveVirtualFolderDefinition(reference);
        VirtualFolderDefinition theChild = structure.findChildByName(childName);
        if (theChild != null) {
            return reference.execute(new GetChildByIdMethod(theChild.getId()));
        }
        VirtualQuery query = structure.getQuery();
        if (query != null) {
            PropertyValueConstraint constraint = new PropertyValueConstraint(new FilesFoldersConstraint(BasicConstraint.INSTANCE, true, true), ContentModel.PROP_NAME, (Serializable)((Object)childName), this.environment.getNamespacePrefixResolver());
            PagingResults<Reference> result = query.perform(this.environment, constraint, null, reference);
            List page = result.getPage();
            return page == null || page.isEmpty() ? null : (Reference)page.get(0);
        }
        return null;
    }

    private List<Reference> createChildReferences(Reference parent, VirtualFolderDefinition structure) throws ProtocolMethodException {
        List<VirtualFolderDefinition> structureChildren = structure.getChildren();
        LinkedList<Reference> childReferences = new LinkedList<Reference>();
        for (VirtualFolderDefinition child : structureChildren) {
            childReferences.add(parent.execute(new GetChildByIdMethod(child.getId())));
        }
        return childReferences;
    }

    @Override
    public VirtualFolderDefinition resolveVirtualFolderDefinition(final Reference reference) throws VirtualizationException {
        ServiceRegistry serviceRegistry = ((AlfrescoEnviroment)this.environment).getServiceRegistry();
        RetryingTransactionHelper transactionHelper = serviceRegistry.getRetryingTransactionHelper();
        return transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<VirtualFolderDefinition>(){

            @Override
            public VirtualFolderDefinition execute() throws Throwable {
                NodeRef key = reference.toNodeRef();
                Map<NodeRef, VirtualFolderDefinition> definitionsCache = TransactionalResourceHelper.getMap(VirtualStoreImpl.VIRTUAL_FOLDER_DEFINITION);
                VirtualFolderDefinition virtualFolderDefinition = (VirtualFolderDefinition)definitionsCache.get(key);
                if (virtualFolderDefinition == null) {
                    virtualFolderDefinition = reference.execute(new ApplyTemplateMethod(VirtualStoreImpl.this.environment));
                    definitionsCache.put(key, virtualFolderDefinition);
                }
                return virtualFolderDefinition;
            }
        }, true, false);
    }

    @Override
    public PagingResults<Reference> list(final Reference ref, boolean actual, boolean virtual, final boolean files, final boolean folders, final String pattern, final Set<QName> searchTypeQNames, final Set<QName> ignoreTypeQNames, final Set<QName> ignoreAspectQNames, final List<Pair<QName, Boolean>> sortProps, PagingRequest pagingRequest) throws VirtualizationException {
        VirtualQuery query;
        VirtualFolderDefinition structure = this.resolveVirtualFolderDefinition(ref);
        List<Object> virtualRefs = null;
        virtualRefs = virtual && folders ? this.createChildReferences(ref, structure) : Collections.emptyList();
        if (actual && (query = structure.getQuery()) != null) {
            PageCollator.PagingResultsSource<Reference> querySourc = new PageCollator.PagingResultsSource<Reference>(){

                @Override
                public PagingResults<Reference> retrieve(PagingRequest pr) throws PageCollationException {
                    try {
                        return query.perform(VirtualStoreImpl.this.environment, files, folders, pattern, searchTypeQNames, ignoreTypeQNames, ignoreAspectQNames, sortProps, pr, ref);
                    }
                    catch (VirtualizationException e) {
                        throw new PageCollationException(e);
                    }
                }
            };
            PageCollator<Reference> collator = new PageCollator<Reference>();
            try {
                return collator.collate(virtualRefs, querySourc, pagingRequest, new ReferenceComparator(this, sortProps));
            }
            catch (PageCollationException e) {
                throw new VirtualizationException(e);
            }
        }
        return new ListBackedPagingResults(virtualRefs);
    }

    @Override
    public PagingResults<Reference> list(Reference ref, boolean actual, boolean virtual, boolean files, boolean folders, String pattern, Set<QName> ignoreTypeQNames, Set<QName> ignoreAspectQNames, List<Pair<QName, Boolean>> sortProps, PagingRequest pagingRequest) throws VirtualizationException {
        return this.list(ref, actual, virtual, files, folders, pattern, Collections.emptySet(), ignoreTypeQNames, ignoreAspectQNames, sortProps, pagingRequest);
    }

    @Override
    public PagingResults<Reference> list(Reference ref, boolean actual, boolean virtual, Set<QName> searchTypeQNames, Set<QName> ignoreTypeQNames, Set<QName> ignoreAspectQNames, List<Pair<QName, Boolean>> sortProps, PagingRequest pagingRequest) throws VirtualizationException {
        return this.list(ref, actual, virtual, true, true, null, searchTypeQNames, Collections.emptySet(), ignoreAspectQNames, sortProps, pagingRequest);
    }

    @Override
    public List<Reference> list(Reference reference) throws VirtualizationException {
        VirtualFolderDefinition structure = this.resolveVirtualFolderDefinition(reference);
        List<Reference> result = this.createChildReferences(reference, structure);
        VirtualQuery query = structure.getQuery();
        if (query != null) {
            PagingResults<Reference> queryNodes = query.perform(this.environment, new FilesFoldersConstraint(BasicConstraint.INSTANCE, true, true), null, reference);
            result.addAll(queryNodes.getPage());
        }
        return result;
    }

    @Override
    public List<Reference> search(Reference reference, String namePattern, boolean fileSearch, boolean folderSearch, boolean includeSubFolders) throws VirtualizationException {
        VirtualQuery query;
        VirtualFolderDefinition structure = this.resolveVirtualFolderDefinition(reference);
        LinkedList<Reference> result = new LinkedList<Reference>();
        List<Reference> childReferences = this.createChildReferences(reference, structure);
        if (folderSearch) {
            result.addAll(childReferences);
        }
        if (includeSubFolders) {
            for (Reference childRef : childReferences) {
                List<Reference> childResults = this.search(childRef, namePattern, fileSearch, folderSearch, includeSubFolders);
                result.addAll(childResults);
            }
        }
        if (fileSearch && (query = structure.getQuery()) != null) {
            VirtualQueryConstraint vqConstraint = null;
            vqConstraint = namePattern == null ? BasicConstraint.INSTANCE : new NamePatternPropertyValueConstraint(new FilesFoldersConstraint(BasicConstraint.INSTANCE, true, true), ContentModel.PROP_NAME, (Serializable)((Object)namePattern), this.environment.getNamespacePrefixResolver());
            PagingResults<Reference> queryNodes = query.perform(this.environment, vqConstraint, null, reference);
            result.addAll(queryNodes.getPage());
        }
        return result;
    }

    @Override
    public Map<QName, Serializable> getProperties(Reference reference) throws VirtualizationException {
        Protocol protocol = reference.getProtocol();
        if (Protocols.VIRTUAL.protocol.equals(protocol) || Protocols.VANILLA.protocol.equals(protocol)) {
            VirtualFolderDefinition folderDefinition = this.resolveVirtualFolderDefinition(reference);
            HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
            properties.put(ContentModel.PROP_NAME, (Serializable)((Object)folderDefinition.getName()));
            StoreRef storeRef = StoreRef.STORE_REF_WORKSPACE_SPACESSTORE;
            properties.put(ContentModel.PROP_STORE_IDENTIFIER, (Serializable)((Object)storeRef.getIdentifier()));
            properties.put(ContentModel.PROP_STORE_PROTOCOL, (Serializable)((Object)storeRef.getProtocol()));
            properties.put(ContentModel.PROP_LOCALE, (Serializable)((Object)Locale.UK.toString()));
            properties.put(ContentModel.PROP_MODIFIED, new Date());
            properties.put(ContentModel.PROP_MODIFIER, (Serializable)((Object)"System"));
            properties.put(ContentModel.PROP_CREATED, new Date());
            properties.put(ContentModel.PROP_CREATOR, (Serializable)((Object)"System"));
            properties.put(ContentModel.PROP_NODE_DBID, Integer.valueOf(0));
            properties.put(ContentModel.PROP_DESCRIPTION, (Serializable)((Object)folderDefinition.getDescription()));
            Map<String, String> nodeProperties = folderDefinition.getProperties();
            if (nodeProperties != null) {
                Set<Map.Entry<String, String>> propertyEntries = nodeProperties.entrySet();
                NamespacePrefixResolver nsPrefixResolver = this.environment.getNamespacePrefixResolver();
                for (Map.Entry<String, String> propertyValueEntry : propertyEntries) {
                    QName propertyQName = QName.createQName((String)propertyValueEntry.getKey(), (NamespacePrefixResolver)nsPrefixResolver);
                    properties.put(propertyQName, (Serializable)((Object)propertyValueEntry.getValue().toString()));
                }
            }
            return properties;
        }
        NodeRef actual = reference.execute(new GetActualNodeRefMethod(this.environment));
        Map<QName, Serializable> properties = this.environment.getProperties(actual);
        properties.put(VirtualContentModel.PROP_ACTUAL_NODE_REF, (Serializable)((Object)actual.toString()));
        return properties;
    }

    @Override
    public QName getType(Reference ref) throws VirtualizationException {
        return ref.execute(new GetReferenceType(this.environment));
    }

    @Override
    public FilingData createFilingData(Reference parentReference, QName assocTypeQName, QName assocQName, QName nodeTypeQName, Map<QName, Serializable> properties) throws VirtualizationException {
        VirtualFolderDefinition structure = this.resolveVirtualFolderDefinition(parentReference);
        FilingRule filingRule = structure.getFilingRule();
        if (filingRule == null) {
            filingRule = new NullFilingRule(this.environment);
        }
        FilingParameters filingParameters = new FilingParameters(parentReference, assocTypeQName, assocQName, nodeTypeQName, properties);
        FilingData filingData = filingRule.createFilingData(filingParameters);
        return filingData;
    }

    @Override
    public AccessStatus hasPermission(Reference reference, String perm) throws VirtualizationException {
        return reference.execute(new HasPermissionMethod(this, this.userPermissions, perm));
    }

    @Override
    public AccessStatus hasPermission(Reference reference, PermissionReference perm) throws VirtualizationException {
        return this.hasPermission(reference, perm.getName());
    }

    public void setUserPermissions(VirtualUserPermissions userPermissions) {
        this.userPermissions = userPermissions;
    }

    public VirtualUserPermissions getUserPermissions() {
        return new VirtualUserPermissions(this.userPermissions);
    }

    @Override
    public NodePermissionEntry getSetPermissions(Reference reference) throws VirtualizationException {
        return reference.execute(new GetSetPermissionsMethod(this, this.userPermissions, "GROUP_EVERYONE"));
    }

    @Override
    public Set<AccessPermission> getAllSetPermissions(Reference reference) {
        return reference.execute(new GetAllSetPermissionsMethod(this, this.userPermissions, "GROUP_EVERYONE"));
    }

    @Override
    public Path getPath(Reference reference) throws VirtualizationException {
        Reference virtualPathElement = reference;
        Reference virtualPathParent = reference.execute(new GetParentReferenceMethod());
        Path virtualPath = new Path();
        while (virtualPathElement != null && virtualPathParent != null) {
            NodeRef parentNodeRef;
            NodeRef parent = parentNodeRef = virtualPathParent.toNodeRef();
            NodeRef virtualPathNodeRef = virtualPathElement.toNodeRef();
            String templatePath = virtualPathElement.execute(new GetTemplatePathMethod()).trim();
            if ("/".equals(templatePath)) break;
            if (templatePath.endsWith("/")) {
                templatePath = templatePath.substring(0, templatePath.length() - 1);
            }
            int lastSeparator = templatePath.lastIndexOf("/");
            String childId = templatePath.substring(lastSeparator + 1);
            VirtualFolderDefinition structure = this.resolveVirtualFolderDefinition(virtualPathParent);
            VirtualFolderDefinition child = structure.findChildById(childId);
            if (child == null) {
                throw new VirtualizationException("Invalid reference: " + reference.encode());
            }
            String childName = child.getName();
            QName childQName = QName.createQName((String)"http://www.alfresco.org/model/content/smartfolder/1.0", (String)childName);
            ChildAssociationRef assocRef = new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, parent, childQName, virtualPathNodeRef, true, -1);
            Path.ChildAssocElement assocRefElement = new Path.ChildAssocElement(assocRef);
            virtualPath.prepend((Path.Element)assocRefElement);
            virtualPathElement = virtualPathParent;
            virtualPathParent = virtualPathParent.execute(new GetParentReferenceMethod());
        }
        return virtualPath;
    }

    @Override
    public NodeRef adhere(Reference reference, int mode) throws VirtualizationException {
        switch (mode) {
            case 1: {
                return this.materialize(reference);
            }
            case 2: {
                VirtualFolderDefinition vfDefinition = this.resolveVirtualFolderDefinition(reference);
                FilingRule filingRule = vfDefinition.getFilingRule();
                if (filingRule.isNullFilingRule()) {
                    return this.materialize(reference);
                }
                return filingRule.filingNodeRefFor(new FilingParameters(reference));
            }
        }
        throw new VirtualizationException("Invalid adherence mode " + mode);
    }
}

