/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.node;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.domain.node.ChildAssocEntity;
import org.alfresco.repo.domain.node.ParentAssocsCache;
import org.alfresco.repo.domain.node.ParentAssocsInfo;
import org.alfresco.util.Pair;
import org.junit.Assert;
import org.junit.Test;

public class ParentAssocsCacheTest {
    @Test
    public void testGetReturnsNullWhenAbsent() {
        ParentAssocsCache cache = new ParentAssocsCache(10, 2, 1);
        Pair key = new Pair((Object)1L, (Object)"store");
        Assert.assertNull((Object)cache.get(key));
    }

    @Test
    public void testGetWithLoaderCachesValue() {
        ParentAssocsCache cache = new ParentAssocsCache(10, 2, 1);
        Pair key = new Pair((Object)2L, (Object)"store");
        ParentAssocsInfo info = this.parentAssocsInfo(10L, true);
        AtomicInteger calls = new AtomicInteger();
        Callable<ParentAssocsInfo> loader = () -> {
            calls.incrementAndGet();
            return info;
        };
        ParentAssocsInfo first = cache.get(key, loader);
        ParentAssocsInfo second = cache.get(key, loader);
        Assert.assertSame((Object)info, (Object)first);
        Assert.assertSame((Object)info, (Object)second);
        Assert.assertSame((Object)info, (Object)cache.get(key));
        Assert.assertEquals((long)1L, (long)calls.get());
    }

    @Test
    public void testGetWrapsExecutionException() {
        ParentAssocsCache cache = new ParentAssocsCache(10, 2, 1);
        Pair key = new Pair((Object)3L, (Object)"store");
        RuntimeException root = new RuntimeException("boom");
        Callable<ParentAssocsInfo> loader = () -> {
            throw root;
        };
        AlfrescoRuntimeException ex = (AlfrescoRuntimeException)Assert.assertThrows(AlfrescoRuntimeException.class, () -> {
            ParentAssocsInfo parentAssocsInfo = cache.get(key, loader);
        });
        Assert.assertNotNull((Object)ex.getCause());
    }

    @Test
    public void testPutAndRemoveReturnOld() {
        ParentAssocsCache cache = new ParentAssocsCache(10, 2, 1);
        Pair key = new Pair((Object)4L, (Object)"store");
        ParentAssocsInfo info = this.parentAssocsInfo(20L, false);
        cache.put(key, info);
        ParentAssocsInfo removed = cache.remove(key);
        Assert.assertSame((Object)info, (Object)removed);
        Assert.assertNull((Object)cache.get(key));
    }

    @Test
    public void testClearInvalidatesAll() {
        ParentAssocsCache cache = new ParentAssocsCache(10, 2, 1);
        Pair key1 = new Pair((Object)5L, (Object)"store");
        Pair key2 = new Pair((Object)6L, (Object)"store");
        cache.put(key1, this.parentAssocsInfo(30L, true));
        cache.put(key2, this.parentAssocsInfo(31L, false));
        cache.clear();
        Assert.assertNull((Object)cache.get(key1));
        Assert.assertNull((Object)cache.get(key2));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConcurrentGetWithLoaderOnlyLoadsOnce() throws Exception {
        ParentAssocsCache cache = new ParentAssocsCache(10, 2, 1);
        Pair key = new Pair((Object)7L, (Object)"store");
        ParentAssocsInfo info = this.parentAssocsInfo(40L, true);
        AtomicInteger calls = new AtomicInteger();
        Callable<ParentAssocsInfo> loader = () -> {
            calls.incrementAndGet();
            return info;
        };
        int threads = 24;
        CountDownLatch start = new CountDownLatch(1);
        ExecutorService executor = Executors.newVirtualThreadPerTaskExecutor();
        try {
            void var10_11;
            ArrayList<Future<ParentAssocsInfo>> futures = new ArrayList<Future<ParentAssocsInfo>>(threads);
            boolean bl = false;
            while (var10_11 < threads) {
                futures.add(executor.submit(() -> {
                    start.await();
                    return cache.get(key, loader);
                }));
                ++var10_11;
            }
            start.countDown();
            for (Future future : futures) {
                Assert.assertSame((Object)info, future.get(5L, TimeUnit.SECONDS));
            }
            Assert.assertEquals((long)1L, (long)calls.get());
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Test
    public void testConcurrentGetDifferentKeysLoadsEachOnce() throws Exception {
        ParentAssocsCache cache = new ParentAssocsCache(50, 2, 1);
        int keys = 16;
        List<Pair> keyList = IntStream.range(0, keys).mapToObj(index -> new Pair((Object)((long)index + 100L), (Object)"store")).toList();
        List<AtomicInteger> counters = IntStream.range(0, keys).mapToObj(index -> new AtomicInteger()).toList();
        CountDownLatch start = new CountDownLatch(1);
        ExecutorService executor = Executors.newVirtualThreadPerTaskExecutor();
        try {
            ArrayList<Future<ParentAssocsInfo>> futures = new ArrayList<Future<ParentAssocsInfo>>(keys);
            int i = 0;
            while (i < keys) {
                int index2 = i;
                Pair key = keyList.get(i);
                ParentAssocsInfo info = this.parentAssocsInfo((long)index2 + 200L, index2 % 2 == 0);
                Callable<ParentAssocsInfo> loader = () -> {
                    ((AtomicInteger)counters.get(index2)).incrementAndGet();
                    return info;
                };
                futures.add(executor.submit(() -> {
                    start.await();
                    return cache.get(key, loader);
                }));
                ++i;
            }
            start.countDown();
            i = 0;
            while (i < keys) {
                ParentAssocsInfo value = (ParentAssocsInfo)((Future)futures.get(i)).get(5L, TimeUnit.SECONDS);
                Assert.assertSame((Object)cache.get(keyList.get(i)), (Object)value);
                ++i;
            }
            Assert.assertTrue((boolean)counters.stream().allMatch(counter -> counter.get() == 1));
        }
        finally {
            executor.shutdownNow();
        }
    }

    private ParentAssocsInfo parentAssocsInfo(Long assocId, boolean isPrimary) {
        return new ParentAssocsInfo(false, false, this.parentAssocEntities(assocId, isPrimary));
    }

    private List<ChildAssocEntity> parentAssocEntities(Long assocId, boolean isPrimary) {
        ChildAssocEntity assoc = new ChildAssocEntity();
        assoc.setId(assocId);
        assoc.setPrimary(Boolean.valueOf(isPrimary));
        return Arrays.asList(assoc);
    }
}

